/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.GlobalProperties;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.LocalTransaction;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class TransactionHandler
extends PacketHandler {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
    private TransactionList translist = null;
    FaultInjection fi = FaultInjection.getInjection();

    public TransactionHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public TransactionList getTransactionList() {
        return this.translist;
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string) {
        this.sendReply(iMQConnection, packet, n, n2, l, string, null);
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string, BrokerException brokerException) {
        this.sendReply(iMQConnection, packet, n, n2, l, string, brokerException, 0L);
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string, BrokerException brokerException, long l2) {
        if (this.fi.FAULT_INJECTION) {
            this.checkFIAfterProcess(packet.getPacketType());
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(n);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQStatus", new Integer(n2));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        if (brokerException != null && brokerException.isRemote()) {
            hashtable.put("JMQRemote", true);
            if (brokerException.getRemoteConsumerUIDs() != null) {
                hashtable.put("JMQRemoteConsumerIDs", brokerException.getRemoteConsumerUIDs());
            }
        }
        if (l2 != 0L) {
            hashtable.put("JMQNextTransactionID", new Long(l2));
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        if (this.fi.FAULT_INJECTION) {
            this.checkFIAfterReply(packet.getPacketType());
        }
    }

    public void sendReplyBody(IMQConnection iMQConnection, Packet packet, int n, int n2, Hashtable hashtable, byte[] byArray) {
        Packet packet2;
        block6: {
            block5: {
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setPacketType(n);
                packet2.setConsumerID(packet.getConsumerID());
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Integer>();
                }
                hashtable.put("JMQStatus", new Integer(n2));
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block5;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block6;
            }
            hashtable.put("JMQReqID", (Integer)((Object)packet.getSysMessageID().toString()));
        }
        packet2.setProperties(hashtable);
        if (byArray != null) {
            packet2.setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage(packet2);
    }

    public long getJMQTransactionID(Hashtable hashtable) {
        if (hashtable != null) {
            Object v = hashtable.get("JMQTransactionID");
            if (v != null && v instanceof Integer) {
                return ((Integer)v).intValue();
            }
            if (v != null) {
                return (Long)v;
            }
        }
        return 0L;
    }

    public static void convertPacketTid(IMQConnection iMQConnection, Packet packet) {
        long l = packet.getTransactionID();
        HashMap hashMap = (HashMap)iMQConnection.getClientData("tidmap");
        if (hashMap == null) {
            return;
        }
        TransactionUID transactionUID = (TransactionUID)hashMap.get(new Long(l));
        if (transactionUID == null) {
            return;
        }
        packet.setTransactionID(transactionUID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handle(IMQConnection var1_1, Packet var2_2) throws BrokerException {
        block80: {
            block81: {
                block79: {
                    var3_3 = 0L;
                    var5_4 = null;
                    var6_5 = null;
                    var7_6 = null;
                    var8_7 = null;
                    var9_8 = false;
                    var10_9 = false;
                    var11_10 = true;
                    var12_11 = var2_2.getIndempotent();
                    var13_12 = false;
                    var14_13 = false;
                    var15_14 = null;
                    var16_15 = null;
                    var17_16 = null;
                    try {
                        var16_15 = var2_2.getProperties();
                        if (var16_15 == null) {
                            var16_15 = new Hashtable<K, V>();
                        }
                    }
                    catch (Exception var18_17) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from transaction message " + var2_2, (Throwable)var18_17);
                        var16_15 = new Hashtable<K, V>();
                    }
                    var18_18 = (Boolean)var16_15.get("JMQStartNextTransaction");
                    var10_9 = var18_18 == null ? false : var18_18;
                    var19_19 = (Boolean)var16_15.get("JMQRedeliver");
                    var9_8 = var19_19 == null ? false : var19_19;
                    var20_20 = (Boolean)var16_15.get("JMQSetRedelivered");
                    var11_10 = var20_20 == null ? true : var20_20;
                    var15_14 = (Boolean)var16_15.get("JMQXAOnePhase");
                    v0 = var14_13 = var15_14 == null ? false : var15_14;
                    if (TransactionHandler.DEBUG) {
                        this.logger.log(4, PacketType.getString((int)var2_2.getPacketType()) + ": " + "TUID=" + var5_4 + ", JMQRedeliver=" + var19_19 + (var15_14 == null ? "" : ", JMQXAOnePhase=" + var14_13));
                    }
                    if ((var21_21 = (ArrayList<E>)var1_1.getClientData("transaction")) == null) {
                        var21_21 = new ArrayList<E>();
                        var1_1.addClientData("transaction", var21_21);
                    }
                    if ((var22_22 = var2_2.getMessageBodyByteBuffer()) != null) {
                        var23_23 = new JMQByteBufferInputStream(var22_22);
                        try {
                            var7_6 = JMQXid.read((DataInput)new DataInputStream((InputStream)var23_23));
                            var10_9 = false;
                        }
                        catch (IOException var24_24) {
                            this.logger.log(32, "B3100", (Object)("Could not decode xid from packet: " + var24_24 + " Ignoring " + PacketType.getString((int)var2_2.getPacketType())));
                            var17_16 = var24_24.getMessage();
                            this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 400, 0L, var17_16);
                            return true;
                        }
                    }
                    if (var16_15 != null) {
                        var8_7 = (Integer)var16_15.get("JMQXAFlags");
                    }
                    var23_23 = null;
                    var24_25 = var1_1;
                    synchronized (var24_25) {
                        var23_23 = (HashMap)var1_1.getClientData("tidmap");
                        if (var23_23 == null) {
                            var23_23 = new HashMap<K, V>();
                            var1_1.addClientData("tidmap", var23_23);
                        }
                    }
                    var3_3 = this.getJMQTransactionID(var16_15);
                    if (this.fi.FAULT_INJECTION) {
                        this.checkFIBeforeProcess(var2_2.getPacketType());
                    }
                    if (var2_2.getPacketType() != 44 || var8_7 != null && !TransactionState.isFlagSet(0, var8_7)) break block79;
                    if (var12_11) {
                        var5_4 = this.translist.getTransaction(var2_2.getSysMessageID().toString());
                        if (var5_4 != null) {
                            var13_12 = true;
                        } else {
                            var5_4 = new TransactionUID();
                        }
                    } else {
                        var5_4 = new TransactionUID();
                    }
                    break block80;
                }
                if (var2_2.getPacketType() != 60) break block81;
                if (var3_3 != 0L) {
                    var5_4 = new TransactionUID(var3_3);
                }
                var7_6 = null;
                break block80;
            }
            if (var3_3 != 0L || var7_6 == null) ** GOTO lbl90
            var5_4 = this.translist.xidToUID(var7_6);
            if (var5_4 != null) {
                var3_3 = var5_4.longValue();
            } else {
                this.logger.log(16, PacketType.getString((int)var2_2.getPacketType()) + ": Ignoring unknown XID=" + var7_6 + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                if (var2_2.getSendAcknowledge()) {
                    var17_16 = "Uknown XID " + var7_6;
                    this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 404, 0L, var17_16);
                }
                return true;
lbl90:
                // 1 sources

                if (var3_3 != 0L) {
                    if (var1_1.getClientProtocolVersion() == 100) {
                        var24_25 = var23_23;
                        synchronized (var24_25) {
                            var5_4 = (TransactionUID)var23_23.get(new Long(var3_3));
                        }
                    } else {
                        var5_4 = new TransactionUID(var3_3);
                    }
                }
            }
            if (var5_4 == null) {
                this.logger.log(8, "InternalError: Transaction ID was not passed by the jms api on a method that reqires an existing transaction ");
                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 500, 0L, "Internal Error: bad MQ protocol, missing TransactionID");
                return true;
            }
            var6_5 = this.translist.retrieveState(var5_4);
            if (var6_5 == null) {
                if (var12_11 && (var2_2.getPacketType() == 48 || var2_2.getPacketType() == 46)) {
                    if (var2_2.getSendAcknowledge()) {
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 200, var5_4.longValue(), var17_16);
                        return true;
                    }
                    if (this.fi.FAULT_INJECTION) {
                        this.checkFIAfterProcess(var2_2.getPacketType());
                        this.checkFIAfterReply(var2_2.getPacketType());
                    }
                } else {
                    var6_5 = this.cacheGetState(var5_4, var1_1);
                    if (var6_5 != null) {
                        this.logger.log(32, "Transaction ID " + var5_4 + " has already been resolved. Ignoring request: " + PacketType.getString((int)var2_2.getPacketType()) + ". Last state of this transaction: " + var6_5.toString() + " broker will " + (var2_2.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                    } else {
                        this.logger.log(BrokerStateHandler.shuttingDown != false ? 4 : 16, Globals.getBrokerResources().getKString(var2_2.getSendAcknowledge() != false ? "B2188" : "B2189", "" + var5_4 + "(" + var3_3 + ")" + (var7_6 == null ? "" : "XID=" + var7_6), PacketType.getString((int)var2_2.getPacketType())) + "\n" + PacketUtil.dumpPacket(var2_2));
                    }
                    if (var2_2.getSendAcknowledge()) {
                        var17_16 = "Unknown transaction " + var5_4;
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, 404, var5_4.longValue(), var17_16);
                    }
                    return true;
                }
            }
        }
        if (TransactionHandler.DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + PacketType.getString((int)var2_2.getPacketType()) + ": " + "TUID=" + var5_4 + " XAFLAGS=" + TransactionState.xaFlagToString(var8_7) + (var15_14 == null ? "" : " JMQXAOnePhase=" + var14_13) + " State=" + var6_5 + " Xid=" + var7_6);
        }
        if (!(var7_6 == null || var6_5 == null || var6_5.getXid() != null && var7_6.equals((Xid)var6_5.getXid()))) {
            this.logger.log(32, "B3100", (Object)("Transaction Xid mismatch. " + PacketType.getString((int)var2_2.getPacketType()) + " Packet has tuid=" + var5_4 + " xid=" + var7_6 + ", transaction table has tuid=" + var5_4 + " xid=" + var6_5.getXid() + ". Using values from table."));
            var7_6 = var6_5.getXid();
        }
        if (var7_6 == null && var6_5 != null && var6_5.getXid() != null && var2_2.getPacketType() != 60) {
            var7_6 = var6_5.getXid();
            this.logger.log(16, "B3100", (Object)("Transaction Xid " + var7_6 + " not found in " + PacketType.getString((int)var2_2.getPacketType()) + " packet for tuid " + var5_4 + ". Will use " + var7_6));
        }
        var24_26 = 200;
        var25_28 = null;
        var26_30 = 0L;
        var28_31 = false;
        var29_32 = (Integer)var16_15.get("JMQAutoRollback");
        var30_33 = (Long)var16_15.get("JMQLifetime");
        var31_34 = (Boolean)var16_15.get("JMQSessionLess");
        if (var29_32 != null) {
            var25_28 = AutoRollbackType.getType(var29_32);
        }
        if (var30_33 != null) {
            var26_30 = var30_33;
        }
        var28_31 = var31_34 != null ? var31_34 : var7_6 != null;
        switch (var2_2.getPacketType()) {
            case 44: {
                try {
                    var32_35 = null;
                    var33_39 = (Long)var16_15.get("JMQSessionID");
                    if (var33_39 != null) {
                        var32_35 = new SessionUID(var33_39);
                    }
                    this.doStart(var5_4, var21_21, var1_1, var25_28, var7_6, var28_31, var26_30, var3_3, var8_7, var2_2.getPacketType(), var13_12, var2_2.getSysMessageID().toString());
                }
                catch (Exception var32_36) {
                    var24_26 = 500;
                    this.logger.logStack(32, "B3100", (Object)(var32_36.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6), (Throwable)var32_36);
                    var17_16 = var32_36.getMessage();
                    if (!(var32_36 instanceof BrokerException)) ** GOTO lbl159
                    var24_26 = ((BrokerException)var32_36).getStatusCode();
                }
lbl159:
                // 3 sources

                this.sendReply(var1_1, var2_2, 45, var24_26, var5_4.longValue(), var17_16);
                break;
            }
            case 58: {
                try {
                    this.doEnd(var2_2.getPacketType(), var7_6, var8_7, var6_5, var5_4);
                }
                catch (Exception var32_37) {
                    var24_26 = 500;
                    var17_16 = var32_37.getMessage();
                    if (!(var32_37 instanceof BrokerException)) ** GOTO lbl170
                    var24_26 = ((BrokerException)var32_37).getStatusCode();
                }
lbl170:
                // 3 sources

                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var24_26, var5_4.longValue(), var17_16);
                break;
            }
            case 56: {
                var32_38 = null;
                try {
                    this.doPrepare(var5_4, var8_7, var6_5, var2_2.getPacketType(), var14_13, null);
                }
                catch (Exception var33_40) {
                    var24_26 = 500;
                    if (!(var33_40 instanceof BrokerDownException) && !(var33_40 instanceof AckEntryNotFoundException) || TransactionHandler.DEBUG_CLUSTER_TXN) {
                        this.logger.logStack(32, var33_40.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6, (Throwable)var33_40);
                    } else {
                        this.logger.log(var33_40 instanceof AckEntryNotFoundException != false ? 16 : 32, var33_40.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6);
                    }
                    var17_16 = var33_40.getMessage();
                    if (!(var33_40 instanceof BrokerException)) ** GOTO lbl188
                    var24_26 = ((BrokerException)var33_40).getStatusCode();
                    var32_38 = (BrokerException)var33_40;
                }
lbl188:
                // 3 sources

                this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var24_26, var5_4.longValue(), var17_16, var32_38);
                break;
            }
            case 60: {
                var33_41 = null;
                if (var5_4 != null) {
                    var33_41 = new Vector();
                    var6_5 = this.translist.retrieveState(var5_4);
                    if (var6_5.getState() == 5) {
                        var33_41.add(var5_4);
                    }
                } else {
                    if (var8_7 == null || !TransactionState.isFlagSet(0x1000000, var8_7)) {
                        var34_42 = new Hashtable<String, Integer>();
                        var34_42.put("JMQQuantity", new Integer(0));
                        this.sendReplyBody(var1_1, var2_2, 61, 200, var34_42, null);
                        break;
                    }
                    var33_41 = this.translist.getTransactions(5);
                }
                var34_43 = var33_41.size();
                var35_44 = 0;
                var36_45 = new ByteArrayOutputStream(var34_43 * JMQXid.size());
                var37_46 = new DataOutputStream(var36_45);
                for (var38_47 = 0; var38_47 < var34_43; ++var38_47) {
                    var39_49 = (TransactionUID)var33_41.get(var38_47);
                    var40_56 = this.translist.retrieveState(var39_49);
                    if (var40_56 == null) {
                        this.logger.log(32, "B3100", (Object)("Could not find state for TUID " + var39_49));
                        continue;
                    }
                    var41_57 = var40_56.getXid();
                    if (var41_57 == null) continue;
                    try {
                        var41_57.write((DataOutput)var37_46);
                        ++var35_44;
                        continue;
                    }
                    catch (Exception var42_60) {
                        this.logger.log(32, "B3100", (Object)("Could not write Xid " + var41_57 + " to message body: " + var42_60.toString()));
                    }
                }
                var38_48 = new Hashtable<String, Number>();
                var38_48.put("JMQQuantity", new Integer(var35_44));
                if (var5_4 != null) {
                    var38_48.put("JMQTransactionID", new Long(var5_4.longValue()));
                }
                this.sendReplyBody(var1_1, var2_2, 61, 200, var38_48, var36_45.toByteArray());
                break;
            }
            case 46: {
                try {
                    if (var8_7 != null && var14_13) {
                        var39_50 = new Integer(var8_7 & -1073741825);
                        this.doCommit(var5_4, var7_6, var39_50, var6_5, var21_21, true, var1_1, var2_2);
                        break;
                    }
                    this.doCommit(var5_4, var7_6, var8_7, var6_5, var21_21, true, var1_1, var2_2, var10_9);
                }
                catch (BrokerException var39_51) {
                    var24_26 = var39_51.getStatusCode();
                    var17_16 = var39_51.getMessage();
                    if (var2_2.getSendAcknowledge()) {
                        this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var24_26, var5_4.longValue(), var17_16, var39_51);
                        break;
                    }
                    if (!this.fi.FAULT_INJECTION) break;
                    this.checkFIAfterProcess(var2_2.getPacketType());
                    this.checkFIAfterReply(var2_2.getPacketType());
                }
                break;
            }
            case 48: {
                try {
                    var39_52 = var9_8;
                    this.redeliverUnacked(var5_4, var39_52, var11_10);
                }
                catch (BrokerException var39_53) {
                    this.logger.logStack(32, "B3100", (Object)("REDELIVER: " + var39_53.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6), (Throwable)var39_53);
                    var17_16 = var39_53.getMessage();
                    var24_26 = var39_53.getStatusCode();
                }
                try {
                    this.doRollback(var5_4, var7_6, var8_7, var6_5, var21_21, var1_1, RollbackReason.APPLICATION);
                }
                catch (BrokerException var39_54) {
                    var17_16 = var39_54.getMessage();
                    var24_26 = var39_54.getStatusCode();
                }
                var39_55 = 0L;
                if (!var10_9) ** GOTO lbl279
                try {
                    var41_58 = new TransactionUID();
                    this.doStart(var41_58, var21_21, var1_1, var25_28, var7_6, var28_31, var26_30, 0L, var8_7, 44, var13_12, var2_2.getSysMessageID().toString());
                    var39_55 = var41_58.longValue();
                }
                catch (Exception var41_59) {
                    var24_26 = 500;
                    this.logger.logStack(32, "B3100", (Object)(var41_59.toString() + ": TUID=" + var5_4 + " Xid=" + var7_6), (Throwable)var41_59);
                    var17_16 = var41_59.getMessage();
                    if (!(var41_59 instanceof BrokerException)) ** GOTO lbl279
                    var24_26 = ((BrokerException)var41_59).getStatusCode();
                }
lbl279:
                // 4 sources

                if (var2_2.getSendAcknowledge()) {
                    this.sendReply(var1_1, var2_2, var2_2.getPacketType() + 1, var24_26, var5_4.longValue(), var17_16, null, var39_55);
                    break;
                }
                if (!this.fi.FAULT_INJECTION) break;
                this.checkFIAfterProcess(var2_2.getPacketType());
                this.checkFIAfterReply(var2_2.getPacketType());
                break;
            }
        }
        return true;
    }

    public void checkFIBeforeProcess(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.1", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.1", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.1", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.1", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.1", null, 2, false);
            }
        }
    }

    public void checkFIAfterProcess(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.2", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.2", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.2", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.2", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.2", null, 2, false);
            }
        }
    }

    public void checkFIAfterDB(int n) {
        switch (n) {
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.4", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.4", null, 2, false);
            }
        }
    }

    public void checkFIAfterReply(int n) {
        switch (n) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.3", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.3", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.3", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.3", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.3", null, 2, false);
            }
        }
    }

    private void cacheSetState(TransactionUID transactionUID, TransactionState transactionState, IMQConnection iMQConnection) {
        if (GlobalProperties.getGlobalProperties().TRANSACTION_DEBUG) {
            if (iMQConnection == null) {
                return;
            }
            CacheHashMap cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache");
            if (cacheHashMap == null) {
                cacheHashMap = new CacheHashMap(4);
                iMQConnection.addClientData("txncache", cacheHashMap);
            }
            cacheHashMap.put((Object)transactionUID, (Object)transactionState);
        }
    }

    private TransactionState cacheGetState(TransactionUID transactionUID, IMQConnection iMQConnection) {
        CacheHashMap cacheHashMap;
        TransactionState transactionState = null;
        if (GlobalProperties.getGlobalProperties().TRANSACTION_DEBUG && (cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache")) != null) {
            transactionState = (TransactionState)cacheHashMap.get((Object)transactionUID);
        }
        return transactionState;
    }

    public void doCommit(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, boolean bl, IMQConnection iMQConnection, Packet packet) throws BrokerException {
        this.doCommit(transactionUID, jMQXid, n, transactionState, list, bl, iMQConnection, packet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommit(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, boolean bl, IMQConnection iMQConnection, Packet packet, boolean bl2) throws BrokerException {
        int n2 = 200;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var13_13 = null;
        List list2 = null;
        int n3 = 0;
        list2 = this.translist.retrieveSentMessages(transactionUID);
        hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        this.cacheSetState(transactionUID, transactionState, iMQConnection);
        if (list != null) {
            list.remove(transactionUID);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Collection<ConsumerUID> collection;
            Serializable serializable;
            Object object5;
            int n4;
            Object object6;
            Globals.getStore().txnLogSharedLock.lock();
            TransactionWork transactionWork = null;
            if (Globals.isNewTxnLogEnabled()) {
                transactionWork = this.getTransactionWork2(list2, hashMap, hashMap2);
            }
            try {
                int n5 = jMQXid == null ? 6 : transactionState.nextState(46, n);
                object6 = this.doRemoteCommit(transactionUID, n, transactionState, n5, packet, transactionWork);
                if (Globals.isNewTxnLogEnabled()) {
                    if (transactionState.getState() == 5) {
                        n3 = 1;
                        if (this.retrieveConsumedRemoteMessages(transactionUID, true) != null) {
                            n3 = 3;
                        }
                        this.logTxnCompletion(transactionUID, 6, n3);
                    } else if (object6 != null && ((BaseTransaction)object6).getState() == 5) {
                        n3 = ((BaseTransaction)object6).getType();
                        this.logTxnCompletion(transactionUID, 6, n3);
                    } else {
                        n3 = 1;
                        LocalTransaction localTransaction = new LocalTransaction(transactionUID, 6, jMQXid, transactionWork);
                        this.logTxn(localTransaction);
                    }
                }
                if (this.fi.FAULT_INJECTION) {
                    this.fi.checkFaultAndThrowBrokerException("txn.commit.1_1", null);
                }
                transactionState = this.translist.updateState(transactionUID, n5, true);
                if (this.fi.FAULT_INJECTION) {
                    this.checkFIAfterDB(46);
                    this.fi.checkFaultAndExit("txn.commit.1_5", null, 2, false);
                }
                this.startTxnAndSendReply(iMQConnection, packet, n2, bl2, list, jMQXid, transactionUID, n, bl);
            }
            catch (BrokerException brokerException) {
                this.logger.logStack(brokerException instanceof AckEntryNotFoundException ? 16 : 32, brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, (Throwable)brokerException);
                throw brokerException;
            }
            try {
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyTransactionCommit(transactionUID);
                }
            }
            catch (Exception exception) {
                this.logger.log(16, "JMX agent notify transaction committed failed:" + exception.getMessage());
            }
            int n6 = 0;
            object6 = null;
            for (n4 = 0; list2 != null && n4 < list2.size(); ++n4) {
                SysMessageID sysMessageID = (SysMessageID)list2.get(n4);
                object5 = Destination.get(sysMessageID);
                if (object5 == null) {
                    this.logger.log(32, "B3100", (Object)("transacted message removed too early " + sysMessageID));
                    continue;
                }
                try {
                    if (Globals.txnLogEnabled()) {
                        if (object6 == null) {
                            object6 = new ArrayList();
                        }
                        n6 = (int)((long)n6 + ((PacketReference)object5).getSize());
                        ((ArrayList)object6).add(((PacketReference)object5).getPacket().getBytes());
                    }
                    serializable = Destination.getDestination(((PacketReference)object5).getDestinationUID());
                    if (this.fi.FAULT_INJECTION) {
                        this.fi.checkFaultAndExit("txn.commit.1_6", null, 2, false);
                    }
                    collection = ((Destination)serializable).routeNewMessage((PacketReference)object5);
                    ((Destination)serializable).forwardMessage((Set)collection, (PacketReference)object5);
                    continue;
                }
                catch (Exception exception) {
                    this.logger.logStack(BrokerStateHandler.shuttingDown ? 4 : 32, "B3100", (Object)("unable to route/send transaction message " + sysMessageID), (Throwable)exception);
                }
            }
            n4 = 1;
            int n7 = 0;
            object5 = null;
            serializable = null;
            collection = null;
            HashMap hashMap3 = new HashMap();
            if (hashMap != null && hashMap.size() > 0) {
                for (Map.Entry object7 : hashMap.entrySet()) {
                    object4 = (SysMessageID)object7.getKey();
                    if (object4 == null || (object3 = Destination.get((SysMessageID)object4)) == null || ((PacketReference)object3).isDestroyed() || ((PacketReference)object3).isInvalid()) continue;
                    object2 = Destination.getDestination(((PacketReference)object3).getDestinationUID());
                    object = (List)object7.getValue();
                    for (int i = 0; i < object.size(); ++i) {
                        ConsumerUID consumerUID = (ConsumerUID)object.get(i);
                        ConsumerUID consumerUID2 = (ConsumerUID)hashMap2.get(consumerUID);
                        if (consumerUID2 == null) {
                            consumerUID2 = consumerUID;
                        }
                        try {
                            Session session = Session.getSession(consumerUID);
                            if (session != null) {
                                PacketReference packetReference = null;
                                if (this.fi.FAULT_INJECTION && this.fi.checkFault("txn.commit.1_7_1", null)) {
                                    Globals.getConnectionManager().getConnection(session.getConnectionUID()).destroyConnection(true, 6, "Fault injection of closing connection");
                                }
                                if ((packetReference = session.ackMessage(consumerUID, (SysMessageID)object4, transactionUID, hashMap3, true)) != null) {
                                    if (this.fi.FAULT_INJECTION) {
                                        this.fi.checkFaultAndExit("txn.commit.1_7", null, 2, false);
                                    }
                                    ((Destination)object2).removeMessage(((PacketReference)object3).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                } else {
                                    session = Session.getSession(consumerUID);
                                }
                            }
                            if (session == null) {
                                try {
                                    if (((PacketReference)object3).acknowledged(consumerUID, consumerUID2, true, true, transactionUID, hashMap3, true)) {
                                        ((Destination)object2).removeMessage(((PacketReference)object3).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                    }
                                }
                                catch (BrokerException brokerException) {
                                    this.logger.log(16, "Internal error", (Throwable)brokerException);
                                }
                            }
                            if (!Globals.txnLogEnabled()) continue;
                            if (object5 == null) {
                                object5 = new ArrayList();
                                serializable = new ArrayList();
                                collection = new ArrayList();
                            }
                            if (!((Destination)object2).isQueue() && !consumerUID2.shouldStore()) continue;
                            ++n7;
                            ((ArrayList)object5).add(((Destination)object2).getUniqueName());
                            ((ArrayList)serializable).add(object4);
                            ((ArrayList)collection).add(consumerUID2);
                            continue;
                        }
                        catch (Exception exception) {
                            n4 = 0;
                            this.logger.logStack(32, "B3100", (Object)("-------------------------------------------Processing Acknowledgement during committ [" + object4 + ":" + consumerUID + ":" + (Object)((Object)iMQConnection.getConnectionUID()) + "]\nReference is " + (object3 == null ? null : ((PacketReference)object3).getSysMessageID()) + "\n" + PacketUtil.dumpPacket(packet) + "--------------------------------------------"), (Throwable)exception);
                        }
                    }
                }
            }
            if (Globals.isNewTxnLogEnabled()) {
                this.loggedCommitWrittenToMessageStore(transactionUID, n3);
            }
            this.translist.removeTransaction(transactionUID, n4 == 0 || hashMap.size() > 0 && BrokerStateHandler.shuttingDown);
            if (list == null) {
                this.logger.log(16, "B2178", (Object)transactionUID, (Object)(jMQXid == null ? "null" : jMQXid.toString()));
            }
            try {
                Object object8;
                if (n6 > 0 && n7 > 0) {
                    object8 = new ByteArrayOutputStream(n6 + n7 * 72 + 16);
                    DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object8);
                    dataOutputStream.writeLong(transactionUID.longValue());
                    dataOutputStream.writeInt(((ArrayList)object6).size());
                    object4 = ((ArrayList)object6).iterator();
                    while (object4.hasNext()) {
                        dataOutputStream.write((byte[])object4.next());
                    }
                    dataOutputStream.writeInt(n7);
                    for (int i = 0; i < n7; ++i) {
                        object2 = (String)((ArrayList)object5).get(i);
                        dataOutputStream.writeUTF((String)object2);
                        object = (SysMessageID)((ArrayList)serializable).get(i);
                        object.writeID((DataOutput)dataOutputStream);
                        ConsumerUID consumerUID = (ConsumerUID)((ArrayList)collection).get(i);
                        dataOutputStream.writeLong(consumerUID.longValue());
                    }
                    dataOutputStream.close();
                    ((ByteArrayOutputStream)object8).close();
                    Globals.getStore().logTxn(4, ((ByteArrayOutputStream)object8).toByteArray());
                } else if (n6 > 0) {
                    object8 = ByteBuffer.allocate(n6 + 12);
                    ((ByteBuffer)object8).putLong(transactionUID.longValue());
                    ((ByteBuffer)object8).putInt(((ArrayList)object6).size());
                    Iterator iterator = ((ArrayList)object6).iterator();
                    while (iterator.hasNext()) {
                        ((ByteBuffer)object8).put((byte[])iterator.next());
                    }
                    Globals.getStore().logTxn(1, ((ByteBuffer)object8).array());
                } else if (n7 > 0) {
                    object8 = new ByteArrayOutputStream(n7 * 72 + 12);
                    DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object8);
                    dataOutputStream.writeLong(transactionUID.longValue());
                    dataOutputStream.writeInt(n7);
                    for (int i = 0; i < n7; ++i) {
                        object3 = (String)((ArrayList)object5).get(i);
                        dataOutputStream.writeUTF((String)object3);
                        object2 = (SysMessageID)((ArrayList)serializable).get(i);
                        object2.writeID((DataOutput)dataOutputStream);
                        object = (ConsumerUID)((ArrayList)collection).get(i);
                        dataOutputStream.writeLong(object.longValue());
                    }
                    dataOutputStream.close();
                    ((ByteArrayOutputStream)object8).close();
                    Globals.getStore().logTxn(2, ((ByteArrayOutputStream)object8).toByteArray());
                }
            }
            catch (IOException iOException) {
                this.logger.logStack(32, "B3100", (Object)"Got exception while writing to transaction log", (Throwable)iOException);
                throw new BrokerException("Internal Error: Got exception while writing to transaction log", iOException);
            }
            Object var37_53 = null;
            Globals.getStore().txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var37_54 = null;
            Globals.getStore().txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    TransactionWork getTransactionWork2(List list, HashMap hashMap, HashMap hashMap2) {
        Object object;
        PacketReference packetReference;
        TransactionWork transactionWork = new TransactionWork();
        for (int i = 0; list != null && i < list.size(); ++i) {
            SysMessageID object2 = (SysMessageID)list.get(i);
            packetReference = Destination.get(object2);
            if (packetReference == null) {
                this.logger.log(32, "B3100", (Object)("transacted message removed too early " + object2));
                continue;
            }
            try {
                if (!packetReference.isPersistent()) continue;
                object = new TransactionWorkMessage();
                ((TransactionWorkMessage)object).setMessage(packetReference.getPacket());
                transactionWork.addMesage((TransactionWorkMessage)object);
                continue;
            }
            catch (Exception exception) {
                this.logger.logStack(BrokerStateHandler.shuttingDown ? 4 : 32, "B3100", (Object)("unable to log transaction message " + object2), (Throwable)exception);
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            for (Map.Entry entry : hashMap.entrySet()) {
                PacketReference packetReference2;
                packetReference = (SysMessageID)entry.getKey();
                object = (List)entry.getValue();
                if (packetReference == null || (packetReference2 = Destination.get((SysMessageID)packetReference)) == null || packetReference2.isDestroyed() || packetReference2.isInvalid()) continue;
                Destination destination = Destination.getDestination(packetReference2.getDestinationUID());
                for (int i = 0; i < object.size(); ++i) {
                    ConsumerUID consumerUID = (ConsumerUID)object.get(i);
                    ConsumerUID consumerUID2 = (ConsumerUID)hashMap2.get(consumerUID);
                    if (consumerUID2 == null) {
                        consumerUID2 = consumerUID;
                    }
                    try {
                        if (!destination.isQueue() && !consumerUID2.shouldStore() || !packetReference2.isPersistent()) continue;
                        TransactionWorkMessageAck transactionWorkMessageAck = new TransactionWorkMessageAck();
                        transactionWorkMessageAck.setConsumerID(consumerUID2);
                        transactionWorkMessageAck.setDest(destination.getUniqueName());
                        transactionWorkMessageAck.setSysMessageID((SysMessageID)packetReference);
                        transactionWork.addMessageAcknowledgement(transactionWorkMessageAck);
                        continue;
                    }
                    catch (Exception exception) {
                        this.logger.logStack(32, "B3100", (Object)(" unable to log transaction message acknowledgement " + packetReference + ":" + consumerUID), (Throwable)exception);
                    }
                }
            }
        }
        return transactionWork;
    }

    void startTxnAndSendReply(IMQConnection iMQConnection, Packet packet, int n, boolean bl, List list, JMQXid jMQXid, TransactionUID transactionUID, Integer n2, boolean bl2) {
        String string;
        long l;
        block4: {
            l = 0L;
            string = null;
            if (bl) {
                try {
                    TransactionUID transactionUID2 = new TransactionUID();
                    this.doStart(transactionUID2, list, iMQConnection, AutoRollbackType.NOT_PREPARED, jMQXid, false, 0L, 0L, n2, 44, false, packet.getSysMessageID().toString());
                    l = transactionUID2.longValue();
                }
                catch (Exception exception) {
                    n = 500;
                    this.logger.logStack(32, "B3100", (Object)(exception.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid), (Throwable)exception);
                    string = exception.getMessage();
                    if (!(exception instanceof BrokerException)) break block4;
                    n = ((BrokerException)exception).getStatusCode();
                }
            }
        }
        if (bl2) {
            this.sendReply(iMQConnection, packet, 47, n, transactionUID.longValue(), string, null, l);
        }
    }

    private void logTxn(BaseTransaction baseTransaction) throws BrokerException {
        Globals.getStore().logTxn(baseTransaction);
    }

    private void logTxnCompletion(TransactionUID transactionUID, int n, int n2) throws BrokerException {
        Globals.getStore().logTxnCompletion(transactionUID, n, n2);
    }

    private void loggedCommitWrittenToMessageStore(TransactionUID transactionUID, int n) throws BrokerException {
        Globals.getStore().loggedCommitWrittenToMessageStore(transactionUID, n);
    }

    public void doRollback(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, IMQConnection iMQConnection, RollbackReason rollbackReason) throws BrokerException {
        Map map;
        Object object;
        DestinationUID destinationUID;
        Object object3;
        Object[] objectArray;
        int n2;
        int n3 = transactionState.getState();
        try {
            if (jMQXid == null) {
                n2 = 7;
            } else {
                if ((rollbackReason == RollbackReason.ADMIN || rollbackReason == RollbackReason.CONNECTION_CLEANUP) && transactionState.getState() == 1) {
                    transactionState = this.translist.updateState(transactionUID, 2, 1, true);
                    objectArray = new String[]{rollbackReason.toString(), transactionUID.toString() + "[" + TransactionState.toString(n3) + "]", jMQXid == null ? "null" : jMQXid.toString()};
                    if (rollbackReason != RollbackReason.ADMIN && (DEBUG || DEBUG_CLUSTER_TXN || this.logger.getLevel() <= 4)) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2176", objectArray));
                    }
                }
                n2 = transactionState.nextState(48, n);
            }
        }
        catch (BrokerException brokerException) {
            if (brokerException.getStatusCode() == 409) {
                this.logger.log(32, brokerException.toString());
            } else {
                this.logger.log(32, "B3100", (Object)(brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid));
            }
            throw brokerException;
        }
        transactionState = this.translist.updateState(transactionUID, n2, true);
        if (this.fi.FAULT_INJECTION) {
            this.checkFIAfterDB(48);
        }
        objectArray = new ArrayList(this.translist.retrieveSentMessages(transactionUID));
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            PacketReference object22;
            object3 = (SysMessageID)objectArray.get(i);
            if (DEBUG) {
                this.logger.log(4, "Removing " + object3 + " because of rollback");
            }
            if ((object22 = Destination.get((SysMessageID)object3)) == null) continue;
            destinationUID = object22.getDestinationUID();
            object = Destination.getDestination(destinationUID);
            ((Destination)object).removeMessage((SysMessageID)object3, RemoveReason.ROLLBACK);
        }
        if (list != null) {
            list.remove(transactionUID);
        }
        if ((map = this.translist.getOrphanAck(transactionUID)) != null) {
            for (Map.Entry entry : map.entrySet()) {
                destinationUID = (SysMessageID)entry.getKey();
                object = Destination.get((SysMessageID)destinationUID, false);
                if (object == null) {
                    this.logger.log(4, transactionUID + ":Unknown orphan " + destinationUID);
                    continue;
                }
                Map map2 = (Map)entry.getValue();
                if (map2 == null) continue;
                for (Map.Entry entry2 : map2.entrySet()) {
                    ConsumerUID consumerUID = (ConsumerUID)entry2.getKey();
                    if (((PacketReference)object).isLocal()) {
                        ((PacketReference)object).getDestination().forwardOrphanMessage((PacketReference)object, consumerUID);
                        continue;
                    }
                    List list2 = (List)entry2.getValue();
                    if (list2 == null) continue;
                    for (ConsumerUID consumerUID2 : list2) {
                        Serializable serializable;
                        try {
                            if (((PacketReference)object).acknowledged(consumerUID2, consumerUID, !consumerUID2.isNoAck() && !consumerUID2.isDupsOK(), false, transactionUID, null, false)) {
                                serializable = ((PacketReference)object).getDestination();
                                serializable.removeRemoteMessage((SysMessageID)destinationUID, RemoveReason.ACKNOWLEDGED, (PacketReference)object);
                            }
                        }
                        catch (Exception exception) {
                            this.logger.logStack(DEBUG_CLUSTER_TXN ? 16 : 4, "Unable to cleanup orphaned remote message [" + consumerUID2 + "," + consumerUID + "," + destinationUID + "]" + " on rollback transaction " + transactionUID, (Throwable)exception);
                        }
                        serializable = this.translist.getAckBrokerAddress(transactionUID, (SysMessageID)destinationUID, consumerUID2);
                        try {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("RB_RELEASE_MSG_ORPHAN", transactionUID.toString());
                            Globals.getClusterBroadcast().acknowledgeMessage((BrokerAddress)serializable, (SysMessageID)destinationUID, consumerUID2, 5, hashMap, false);
                        }
                        catch (BrokerException brokerException) {
                            Globals.getLogger().log(16, "Unable to notify " + serializable + " for orphaned remote message " + "[" + consumerUID2 + ", " + consumerUID + ", " + ", " + destinationUID + "]" + " in rollback transaction " + transactionUID);
                        }
                    }
                }
            }
        }
        this.translist.removeTransactionAck(transactionUID, true);
        object3 = Globals.getAgent();
        if (object3 != null) {
            ((Agent)object3).notifyTransactionRollback(transactionUID);
        }
        try {
            transactionState.setState(n2);
            this.cacheSetState(transactionUID, transactionState, iMQConnection);
            this.doRemoteRollback(transactionUID, n2);
            this.translist.removeTransactionID(transactionUID);
            if (rollbackReason == RollbackReason.ADMIN || rollbackReason == RollbackReason.CONNECTION_CLEANUP) {
                Object[] objectArray2 = new String[]{rollbackReason.toString(), transactionUID.toString() + "[" + TransactionState.toString(n3) + "]", jMQXid == null ? "null" : jMQXid.toString()};
                if (rollbackReason == RollbackReason.CONNECTION_CLEANUP) {
                    if (DEBUG || DEBUG_CLUSTER_TXN || this.logger.getLevel() <= 4) {
                        this.logger.log(8, Globals.getBrokerResources().getKString("B2177", objectArray2));
                    }
                } else {
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2177", objectArray2));
                }
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(32, "B3100", (Object)"exception removing transaction", (Throwable)brokerException);
            throw brokerException;
        }
    }

    public void redeliverUnacked(TransactionUID transactionUID, boolean bl, boolean bl2) throws BrokerException {
        Serializable serializable;
        Object object;
        Object object2;
        SequencedCollection sequencedCollection;
        Object object3;
        ConsumerUID consumerUID;
        Map.Entry entry2;
        Object var4_4 = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var7_7 = null;
        hashMap = this.translist.retrieveConsumedMessages(transactionUID, true);
        hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        if (DEBUG) {
            this.logger.log(8, "redeliverUnacked:tid=" + transactionUID + ", consumed#=" + hashMap.size());
        }
        HashMap hashMap3 = new HashMap();
        if (hashMap != null && hashMap.size() > 0) {
            for (Map.Entry entry2 : hashMap.entrySet()) {
                consumerUID = (SysMessageID)entry2.getKey();
                if (consumerUID == null) continue;
                object3 = Destination.get((SysMessageID)consumerUID, false);
                if (object3 == null || ((PacketReference)object3).isDestroyed() || ((PacketReference)object3).isInvalid()) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "redeliverUnacked:tid=" + transactionUID + ": ref=" + object3 + " already deleted");
                    continue;
                }
                sequencedCollection = (List)entry2.getValue();
                for (int i = 0; i < sequencedCollection.size(); ++i) {
                    object2 = (ConsumerUID)sequencedCollection.get(i);
                    object = (ConsumerUID)hashMap2.get(object2);
                    if (object == null) {
                        object = object2;
                    }
                    if ((serializable = (TreeSet<Object>)hashMap3.get(object2)) == null) {
                        serializable = new TreeSet<Object>(new RefCompare());
                        hashMap3.put(object2, serializable);
                    }
                    try {
                        if (bl2) {
                            ((PacketReference)object3).consumed((ConsumerUID)object, false, false);
                        } else {
                            ((PacketReference)object3).removeDelivered((ConsumerUID)object, true);
                        }
                    }
                    catch (IOException iOException) {
                        this.logger.log(16, "Internal error", (Throwable)iOException);
                    }
                    serializable.add(object3);
                }
            }
        }
        if (DEBUG) {
            this.logger.log(8, "redeliverUnacked:tid=" + transactionUID + ", sendMap#=" + hashMap3.size());
        }
        Iterator iterator = hashMap3.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = iterator.next();
            consumerUID = (ConsumerUID)entry2.getKey();
            object3 = Consumer.getConsumer(consumerUID);
            if (object3 == null) {
                if (!DEBUG) continue;
                this.logger.log(8, transactionUID + ":Can not redeliver messages to " + consumerUID + " consumer is gone");
                continue;
            }
            sequencedCollection = (SortedSet)entry2.getValue();
            if (DEBUG) {
                this.logger.log(8, transactionUID + ":Redelivering " + sequencedCollection.size() + " msgs to " + consumerUID);
            }
            if (!bl) {
                iterator.remove();
                continue;
            }
            if (((Consumer)object3).routeMessages(sequencedCollection, true)) {
                if (DEBUG) {
                    this.logger.log(8, "Sucessfully routed msgs to " + object3);
                }
                iterator.remove();
                continue;
            }
            if (!DEBUG) continue;
            this.logger.log(8, "Could not route messages to " + object3);
        }
        if (DEBUG) {
            this.logger.log(8, transactionUID + ":after redeliver, " + hashMap3.size() + " inactive consumers remaining");
        }
        iterator = hashMap3.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = iterator.next();
            consumerUID = (ConsumerUID)entry2.getKey();
            object3 = (ConsumerUID)hashMap2.get(consumerUID);
            sequencedCollection = (SortedSet)entry2.getValue();
            Iterator iterator2 = sequencedCollection.iterator();
            while (iterator2.hasNext()) {
                object2 = (PacketReference)iterator2.next();
                object = ((PacketReference)object2).getSysMessageID();
                if (((PacketReference)object2).isLocal()) continue;
                this.translist.removeOrphanAck(transactionUID, (SysMessageID)object, (ConsumerUID)object3, consumerUID);
                try {
                    if (((PacketReference)object2).acknowledged(consumerUID, (ConsumerUID)object3, !consumerUID.isNoAck() && !consumerUID.isDupsOK(), false, transactionUID, null, false)) {
                        serializable = ((PacketReference)object2).getDestination();
                        ((Destination)serializable).removeRemoteMessage((SysMessageID)object, RemoveReason.ACKNOWLEDGED, (PacketReference)object2);
                    }
                }
                catch (Exception exception) {
                    this.logger.logStack(DEBUG_CLUSTER_TXN ? 16 : 4, "Unable to cleanup remote message [" + consumerUID + "," + object3 + "," + object + "]" + " on rollback transaction " + transactionUID + " for inactive consumer.", (Throwable)exception);
                }
                serializable = this.translist.getAckBrokerAddress(transactionUID, (SysMessageID)object, consumerUID);
                try {
                    HashMap<String, String> hashMap4 = new HashMap<String, String>();
                    hashMap4.put("RB_RELEASE_MSG_INACTIVE", transactionUID.toString());
                    Globals.getClusterBroadcast().acknowledgeMessage((BrokerAddress)serializable, (SysMessageID)object, consumerUID, 5, hashMap4, false);
                }
                catch (BrokerException brokerException) {
                    Globals.getLogger().log(16, "Unable to notify " + serializable + " for remote message " + "[" + consumerUID + ", " + object3 + ", " + ", " + object + "]" + " in rollback transaction " + transactionUID + " for inactive consumer.");
                }
                iterator2.remove();
            }
            if (object3 == null || consumerUID == object3) {
                iterator.remove();
                continue;
            }
            if (sequencedCollection.isEmpty()) {
                if (!DEBUG) continue;
                this.logger.log(8, "Internal Error:  empty set");
                continue;
            }
            if (object3 == PacketReference.getQueueUID()) {
                object2 = (PacketReference)sequencedCollection.first();
                if (object2 == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  null reterence");
                    continue;
                }
                try {
                    if (bl2) {
                        ((PacketReference)object2).consumed((ConsumerUID)object3, false, false);
                    } else {
                        ((PacketReference)object2).removeDelivered((ConsumerUID)object3, false);
                    }
                }
                catch (IOException iOException) {
                    this.logger.log(16, "Internal error", (Throwable)iOException);
                }
                object = ((PacketReference)object2).getDestination();
                if (object == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Internal Error:  unknown destination for reference: " + object2);
                    continue;
                }
                try {
                    ((Destination)object).forwardOrphanMessages(sequencedCollection, (ConsumerUID)object3);
                    iterator.remove();
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error: Unable to re-queue message  to queue " + object, (Throwable)exception);
                }
                continue;
            }
            object2 = Consumer.getConsumer((ConsumerUID)object3);
            if (object2 == null) {
                if (!DEBUG) continue;
                this.logger.log(8, "Internal Error:  unknown consumer " + object3);
                continue;
            }
            if (sequencedCollection == null || sequencedCollection.isEmpty() || !((Consumer)object2).routeMessages(sequencedCollection, true)) continue;
            iterator.remove();
        }
        if (DEBUG && hashMap3.size() > 0) {
            this.logger.log(8, transactionUID + ":after all processing, " + hashMap3.size() + " inactive consumers remaining");
        }
    }

    public void doPrepare(TransactionUID transactionUID, Integer n, TransactionState transactionState, int n2) throws BrokerException {
        this.doPrepare(transactionUID, n, transactionState, n2, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseTransaction doPrepare(TransactionUID transactionUID, Integer n, TransactionState transactionState, int n2, boolean bl, TransactionWork transactionWork) throws BrokerException {
        BaseTransaction baseTransaction = null;
        boolean bl2 = true;
        if (Globals.isNewTxnLogEnabled()) {
            bl2 = false;
            if (transactionWork == null) {
                List list = this.translist.retrieveSentMessages(transactionUID);
                HashMap hashMap = this.translist.retrieveConsumedMessages(transactionUID);
                HashMap hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
                transactionWork = this.getTransactionWork2(list, hashMap, hashMap2);
            }
        }
        boolean bl3 = false;
        int n3 = transactionState.nextState(n2, n);
        try {
            TransactionState transactionState2 = new TransactionState(transactionState);
            transactionState2.setState(n3);
            baseTransaction = this.doRemotePrepare(transactionUID, transactionState, transactionState2, transactionWork);
            if (baseTransaction == null && Globals.isNewTxnLogEnabled()) {
                baseTransaction = new LocalTransaction();
                baseTransaction.setTransactionWork(transactionWork);
                baseTransaction.setTransactionState(transactionState2);
                baseTransaction.getTransactionDetails().setTid(transactionUID);
                baseTransaction.getTransactionDetails().setXid(transactionState.getXid());
                baseTransaction.getTransactionDetails().setState(5);
                this.logTxn(baseTransaction);
            }
            this.translist.updateState(transactionUID, n3, bl, bl2);
            bl3 = true;
            try {
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyTransactionPrepare(transactionUID);
                }
            }
            catch (Throwable throwable) {
                this.logger.log(16, "XXXI18N - JMX agent notify transaction prepared failed: " + throwable.getMessage());
            }
            Object var14_17 = null;
            if (bl3) return baseTransaction;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (bl3) throw throwable;
            this.translist.updateState(transactionUID, 2, bl, 5, bl2);
            throw throwable;
        }
        this.translist.updateState(transactionUID, 2, bl, 5, bl2);
        return baseTransaction;
    }

    private ClusterTransaction doRemotePrepare(TransactionUID transactionUID, TransactionState transactionState, TransactionState transactionState2, TransactionWork transactionWork) throws BrokerException {
        ArrayList[] arrayListArray;
        if (transactionState2.getState() != 5) {
            throw new BrokerException("Unexpected state " + transactionState2 + " for transactionID:" + transactionUID);
        }
        HashMap hashMap = this.retrieveConsumedRemoteMessages(transactionUID, false);
        if (hashMap == null) {
            return null;
        }
        if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
            return null;
        }
        TransactionBroker[] transactionBrokerArray = hashMap.keySet().toArray(new TransactionBroker[0]);
        boolean bl = true;
        ClusterTransaction clusterTransaction = null;
        if (Globals.isNewTxnLogEnabled()) {
            clusterTransaction = new ClusterTransaction(transactionUID, transactionState2, transactionWork, transactionBrokerArray);
            this.translist.logClusterTransaction(transactionUID, transactionState2, transactionBrokerArray, true, bl, clusterTransaction);
        } else {
            this.translist.logClusterTransaction(transactionUID, transactionState2, transactionBrokerArray, true, bl);
        }
        if (DEBUG_CLUSTER_TXN) {
            arrayListArray = new StringBuffer();
            arrayListArray.append("Preparing transaction " + transactionUID + ", brokers");
            for (int i = 0; i < transactionBrokerArray.length; ++i) {
                arrayListArray.append("\n\t" + transactionBrokerArray[i]);
            }
            this.logger.log(8, arrayListArray.toString());
        }
        arrayListArray = null;
        TransactionBroker transactionBroker = null;
        for (int i = 0; i < transactionBrokerArray.length; ++i) {
            transactionBroker = transactionBrokerArray[i];
            if (transactionBroker.getBrokerAddress() == Globals.getMyAddress()) continue;
            arrayListArray = (ArrayList[])hashMap.get(transactionBroker);
            try {
                Globals.getClusterBroadcast().acknowledgeMessage2P(transactionBroker.getBrokerAddress(), arrayListArray[0].toArray(new SysMessageID[0]), arrayListArray[1].toArray(new ConsumerUID[0]), 8, null, new Long(transactionUID.longValue()), true);
                continue;
            }
            catch (BrokerException brokerException) {
                Serializable serializable;
                ConsumerUID consumerUID;
                SysMessageID sysMessageID;
                int n;
                if (!(brokerException instanceof BrokerDownException) && !(brokerException instanceof AckEntryNotFoundException)) {
                    throw brokerException;
                }
                HashMap hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
                ArrayList<String> arrayList = new ArrayList<String>();
                StringBuffer stringBuffer = new StringBuffer();
                String string = null;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (n = 0; n < arrayListArray[0].size(); ++n) {
                    sysMessageID = (SysMessageID)arrayListArray[0].get(n);
                    consumerUID = (ConsumerUID)arrayListArray[1].get(n);
                    ConsumerUID consumerUID2 = (ConsumerUID)hashMap2.get(consumerUID);
                    if (consumerUID2 == null || consumerUID2.equals(consumerUID)) continue;
                    if (brokerException.isRemote() && !arrayList.contains(string = String.valueOf(consumerUID.longValue()))) {
                        arrayList.add(string);
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        serializable = Consumer.getConsumer(consumerUID);
                        if (serializable != null) {
                            ((Consumer)serializable).recreationRequested();
                        } else {
                            this.logger.log(16, "Consumer " + consumerUID + " not found in processing remote exception on preparing transaction " + transactionUID);
                        }
                    }
                    stringBuffer2.append("\n\t[" + sysMessageID + ":" + consumerUID + "]");
                }
                if (brokerException.isRemote()) {
                    brokerException.setRemoteConsumerUIDs(stringBuffer.toString());
                    if (DEBUG_CLUSTER_TXN) {
                        this.logger.log(8, "doRemotePrepare: JMQRemote Exception:remoteConsumerUIDs=" + stringBuffer + ", remote broker " + transactionBroker);
                    }
                }
                try {
                    this.translist.updateState(transactionUID, 2, false, 5, true);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "Unable to update transaction " + transactionUID + " state to FAILED on PREPARE failure from " + transactionBroker + ": " + exception.getMessage() + stringBuffer2.toString(), (Throwable)exception);
                    throw brokerException;
                }
                if (brokerException instanceof AckEntryNotFoundException) {
                    arrayListArray = ((AckEntryNotFoundException)brokerException).getAckEntries();
                }
                for (n = 0; n < arrayListArray[0].size(); ++n) {
                    sysMessageID = (SysMessageID)arrayListArray[0].get(n);
                    consumerUID = (ConsumerUID)arrayListArray[1].get(n);
                    boolean bl2 = true;
                    if (brokerException instanceof BrokerDownException && ((serializable = (ConsumerUID)hashMap2.get(consumerUID)) == null || serializable.equals(consumerUID))) {
                        if (DEBUG_CLUSTER_TXN) {
                            this.logger.log(8, "doRemotePrepare: no remove txnack " + sysMessageID + ", " + consumerUID + " for BrokerDownException from " + transactionBroker);
                        }
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    try {
                        this.translist.removeAcknowledgement(transactionUID, sysMessageID, consumerUID);
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "doRemotePrepare: removed txnack " + sysMessageID + ", " + consumerUID + " for BrokerDownException from " + transactionBroker);
                        continue;
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "Unable to remove transaction " + transactionUID + " ack [" + sysMessageID + ":" + consumerUID + "] on PREPARE failure from " + transactionBroker + ": " + exception.getMessage(), (Throwable)exception);
                    }
                }
                this.logger.log(8, "Preparing transaction + " + transactionUID + " failed from " + transactionBroker + ": " + brokerException.getMessage() + stringBuffer2.toString());
                throw brokerException;
            }
        }
        return clusterTransaction;
    }

    private void doRemoteRollback(TransactionUID transactionUID, int n) throws BrokerException {
        block13: {
            if (n != 7) {
                throw new BrokerException("Unexpected state " + n + " for transactionUID:" + transactionUID);
            }
            if (!this.translist.hasRemoteBroker(transactionUID)) {
                return;
            }
            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                return;
            }
            try {
                int n2;
                Serializable serializable;
                TransactionBroker[] transactionBrokerArray = this.translist.getClusterTransactionBrokers(transactionUID);
                if (DEBUG_CLUSTER_TXN) {
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append("Rollback transaction " + transactionUID + ", remote brokers");
                    for (n2 = 0; n2 < transactionBrokerArray.length; ++n2) {
                        ((StringBuffer)serializable).append("\n\t" + transactionBrokerArray[n2]);
                    }
                    this.logger.log(8, ((StringBuffer)serializable).toString());
                }
                serializable = null;
                for (n2 = 0; n2 < transactionBrokerArray.length; ++n2) {
                    if (transactionBrokerArray[n2].getBrokerAddress() == Globals.getMyAddress()) continue;
                    serializable = transactionBrokerArray[n2].getCurrentBrokerAddress();
                    if (serializable == Globals.getMyAddress()) {
                        if (DEBUG_CLUSTER_TXN) {
                            this.logger.log(8, "Transaction remote broker current address " + transactionBrokerArray[n2].toString() + " is my address, TUID=" + transactionUID);
                        }
                    } else if (DEBUG_CLUSTER_TXN) {
                        this.logger.log(8, "Transaction remote broker current address " + serializable + ", TUID=" + transactionUID);
                    }
                    if (serializable != null) {
                        Globals.getClusterBroadcast().acknowledgeMessage2P((BrokerAddress)serializable, null, null, 9, null, new Long(transactionUID.longValue()), false);
                        continue;
                    }
                    throw new BrokerDownException("Failed to rollback transaction " + transactionUID + " to broker " + transactionBrokerArray[n2].toString(), 410);
                }
            }
            catch (Exception exception) {
                this.logger.log(16, "notify rollback transaction" + transactionUID + " failed:" + exception.getMessage());
                if (!DEBUG_CLUSTER_TXN) break block13;
                this.logger.logStack(16, "Notifying rollback transaction " + transactionUID + " failed:" + exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private BaseTransaction doRemoteCommit(TransactionUID transactionUID, Integer n, TransactionState transactionState, int n2, Packet packet, TransactionWork transactionWork) throws BrokerException {
        if (n2 != 6) {
            throw new BrokerException("Unexpected next state: " + n2 + " for transaction " + transactionUID);
        }
        BaseTransaction baseTransaction = null;
        if (transactionState.getState() != 5 && this.retrieveConsumedRemoteMessages(transactionUID, true) != null) {
            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                return null;
            }
            Packet packet2 = new Packet();
            try {
                packet2.fill(packet);
            }
            catch (IOException iOException) {
                this.logger.logStack(8, "Internal Exception processing packet ", (Throwable)iOException);
                throw new BrokerException(iOException.getMessage(), iOException);
            }
            packet2.setPacketType(56);
            if (transactionState.getState() == 1 && transactionState.getXid() == null) {
                transactionState.setState(4);
                n = new Integer(0);
            }
            baseTransaction = this.doPrepare(transactionUID, n, transactionState, packet2.getPacketType(), true, transactionWork);
        }
        return baseTransaction;
    }

    private HashMap retrieveConsumedRemoteMessages(TransactionUID transactionUID, boolean bl) throws BrokerException {
        HashMap hashMap = this.translist.retrieveConsumedMessages(transactionUID);
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        Iterator iterator = hashMap.keySet().iterator();
        HashMap<Serializable, ArrayList[]> hashMap2 = new HashMap<Serializable, ArrayList[]>();
        ArrayList[] arrayListArray = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            int n;
            List list;
            Serializable serializable;
            Serializable serializable2;
            SysMessageID sysMessageID = (SysMessageID)iterator.next();
            if (sysMessageID == null) continue;
            PacketReference packetReference = Destination.get(sysMessageID, false);
            if (this.checkRefRequeued(transactionUID, packetReference, sysMessageID)) {
                serializable2 = new BrokerException(Globals.getBrokerResources().getKString("B4298", sysMessageID) + ", TUID=" + transactionUID, 410);
                ((BrokerException)serializable2).setRemote(true);
                serializable = new StringBuffer();
                list = (List)hashMap.get(sysMessageID);
                for (n = 0; n < list.size(); ++n) {
                    ((StringBuffer)serializable).append(String.valueOf(((ConsumerUID)list.get(n)).longValue()));
                    ((StringBuffer)serializable).append(" ");
                }
                ((BrokerException)serializable2).setRemoteConsumerUIDs(((StringBuffer)serializable).toString());
                throw serializable2;
            }
            if (packetReference == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4297", sysMessageID) + ", TUID=" + transactionUID, 409);
            }
            serializable2 = packetReference.getAddress();
            if (serializable2 == null) {
                serializable2 = Globals.getMyAddress();
            }
            if (serializable2 != Globals.getMyAddress() && !bl2) {
                bl2 = true;
                if (bl) {
                    return new HashMap();
                }
            }
            if ((arrayListArray = (ArrayList[])hashMap2.get(serializable = new TransactionBroker((BrokerAddress)serializable2))) == null) {
                arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                hashMap2.put(serializable, arrayListArray);
            }
            list = (List)hashMap.get(sysMessageID);
            for (n = 0; n < list.size(); ++n) {
                arrayListArray[0].add(sysMessageID);
                arrayListArray[1].add(list.get(n));
            }
        }
        if (!bl2) {
            return null;
        }
        return hashMap2;
    }

    private boolean checkRefRequeued(TransactionUID transactionUID, PacketReference packetReference, SysMessageID sysMessageID) throws BrokerException {
        HashMap hashMap = this.translist.retrieveAckBrokerAddresses(transactionUID);
        BrokerAddress brokerAddress = (BrokerAddress)hashMap.get(sysMessageID);
        if (packetReference == null && Destination.isLocked(sysMessageID)) {
            this.logger.log(16, "Message " + sysMessageID + (brokerAddress == null ? "" : " (" + brokerAddress + ")") + " is in takeover, TUID=" + transactionUID);
            return true;
        }
        if (packetReference == null) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B4297", sysMessageID) + " " + (brokerAddress == null ? "" : " (" + brokerAddress + ")") + ", TUID=" + transactionUID);
            return false;
        }
        if (packetReference.isOverrided()) {
            return true;
        }
        BrokerAddress brokerAddress2 = packetReference.getAddress();
        if (brokerAddress == null && brokerAddress2 == null) {
            return false;
        }
        if (brokerAddress == null && brokerAddress2 != null || brokerAddress != null && brokerAddress2 == null) {
            return true;
        }
        if (!brokerAddress.equals(brokerAddress2)) {
            return true;
        }
        UID uID = brokerAddress.getBrokerSessionUID();
        UID uID2 = brokerAddress2.getBrokerSessionUID();
        if (uID == null || uID2 == null) {
            return false;
        }
        return !uID.equals((Object)uID2);
    }

    public void doStart(TransactionUID transactionUID, List list, IMQConnection iMQConnection, AutoRollbackType autoRollbackType, JMQXid jMQXid, boolean bl, long l, long l2, Integer n, int n2, boolean bl2, String string) throws BrokerException {
        HashMap hashMap = (HashMap)iMQConnection.getClientData("tidmap");
        int n3 = 0;
        String string2 = null;
        TransactionState transactionState = null;
        transactionState = this.translist.retrieveState(transactionUID);
        if (autoRollbackType == AutoRollbackType.NEVER || l > 0L) {
            n3 = 501;
            string2 = "AutoRollbackType of NEVER not supported";
            throw new BrokerException(string2, n3);
        }
        if (jMQXid != null && !bl) {
            n3 = 501;
            string2 = "XA transactions only supported on sessionless connections";
            throw new BrokerException(string2, n3);
        }
        if (jMQXid == null && bl) {
            n3 = 500;
            string2 = "non-XA transactions only supported on  non-sessionless connections";
            throw new BrokerException(string2, n3);
        }
        if (!bl2) {
            if (n != null && !TransactionState.isFlagSet(0, n)) {
                int n4 = transactionState.nextState(n2, n);
                this.translist.updateState(transactionUID, n4, true);
            } else {
                try {
                    if (iMQConnection.getClientProtocolVersion() == 100) {
                        hashMap.put(new Long(l2), transactionUID);
                    }
                    if (jMQXid != null && autoRollbackType == null) {
                        autoRollbackType = TransactionList.AUTO_ROLLBACK ? AutoRollbackType.ALL : AutoRollbackType.NOT_PREPARED;
                    }
                    transactionState = new TransactionState(autoRollbackType, l, bl);
                    transactionState.setState(1);
                    transactionState.setUser(iMQConnection.getUserName());
                    transactionState.setCreator(string);
                    transactionState.setClientID((String)iMQConnection.getClientData("client id"));
                    transactionState.setXid(jMQXid);
                    if (iMQConnection instanceof IMQConnection) {
                        transactionState.setConnectionString(iMQConnection.userReadableString());
                        transactionState.setConnectionUID(iMQConnection.getConnectionUID());
                    }
                    this.translist.addTransactionID(transactionUID, transactionState);
                    list.add(transactionUID);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, "Exception starting new transaction: " + brokerException.toString(), (Throwable)brokerException);
                    throw brokerException;
                }
            }
        }
    }

    public void doEnd(int n, JMQXid jMQXid, Integer n2, TransactionState transactionState, TransactionUID transactionUID) throws BrokerException {
        String string = null;
        boolean bl = false;
        try {
            int n3;
            try {
                n3 = transactionState.nextState(n, n2);
            }
            catch (BrokerException brokerException) {
                if (brokerException.getStatusCode() == 304) {
                    bl = true;
                    this.logger.log(16, brokerException.getMessage() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
                }
                throw brokerException;
            }
            if (Globals.isMinimizeWrites() || Globals.isNewTxnLogEnabled()) {
                this.translist.updateState(transactionUID, n3, false);
            } else {
                this.translist.updateState(transactionUID, n3, true);
            }
        }
        catch (Exception exception) {
            int n4 = 500;
            if (!bl) {
                this.logger.logStack(32, exception.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid, (Throwable)exception);
            }
            string = exception.getMessage();
            if (exception instanceof BrokerException) {
                n4 = ((BrokerException)exception).getStatusCode();
            }
            throw new BrokerException(string, n4);
        }
    }
}

