/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnAckList;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.PHashMapMMF;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TidList {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String TXN_USE_MEMORY_MAPPED_FILE_PROP = "imq.persist.file.transaction.memorymappedfile.enabled";
    static final String TXN_UPDATE_OPTIMIZATION_PROP = "imq.persist.file.transaction.memorymappedfile.updateoptimization.enabled";
    static final String TXN_FILE_SIZE_PROP = "imq.persist.file.transaction.file.size";
    static final boolean DEFAULT_TXN_USE_MEMORY_MAPPED_FILE = true;
    static final boolean DEFAULT_TXN_UPDATE_OPTIMIZATION = true;
    static final long DEFAULT_TXN_FILE_SIZE = 1024L;
    static final int CLIENT_DATA_SIZE = 17;
    static final String BASENAME = "txn";
    private PHashMap tidMap = null;
    private boolean useMemoryMappedFile = true;
    private boolean updateOptimization = true;
    private File backingFile = null;
    private TxnAckList txnAckList = null;
    private LoadException loadException = null;

    TidList(File file, boolean bl) throws BrokerException {
        SizeString sizeString = this.config.getSizeProperty(TXN_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.useMemoryMappedFile = this.config.getBooleanProperty(TXN_USE_MEMORY_MAPPED_FILE_PROP, true);
            boolean bl2 = this.updateOptimization = this.useMemoryMappedFile && this.config.getBooleanProperty(TXN_UPDATE_OPTIMIZATION_PROP, true);
            if (this.useMemoryMappedFile) {
                this.tidMap = new PHashMapMMF(this.backingFile, sizeString.getBytes(), 1024, false, bl);
                if (this.updateOptimization) {
                    ((PHashMapMMF)this.tidMap).intClientData(17);
                }
            } else {
                this.tidMap = new PHashMap(this.backingFile, sizeString.getBytes(), 1024, false, bl);
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4032", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4032"), iOException);
        }
        try {
            Map.Entry entry2;
            Object object;
            this.tidMap.load();
            boolean bl3 = false;
            Set set = this.tidMap.entrySet();
            Iterator iterator = set.iterator();
            if (iterator.hasNext() && (object = (entry2 = (Map.Entry)iterator.next()).getValue()) instanceof TransactionState) {
                bl3 = true;
            }
            if (bl3) {
                this.loadClientDataOldFormat();
                for (Map.Entry entry2 : set) {
                    object = entry2.getKey();
                    Object v = entry2.getValue();
                    this.tidMap.put(object, (Object)new TransactionInfo((TransactionState)v));
                }
            } else {
                this.loadClientData();
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4032", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4032"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4032", (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4032"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            PHashMapLoadException pHashMapLoadException2;
            while (pHashMapLoadException2 != null) {
                this.logger.log(16, "B4197", (Throwable)pHashMapLoadException2);
                LoadException loadException = new LoadException(pHashMapLoadException2.getMessage(), pHashMapLoadException2.getCause());
                loadException.setKey(pHashMapLoadException2.getKey());
                loadException.setValue(pHashMapLoadException2.getValue());
                loadException.setKeyCause(pHashMapLoadException2.getKeyCause());
                loadException.setValueCause(pHashMapLoadException2.getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                pHashMapLoadException2 = pHashMapLoadException2.getNextException();
            }
        }
        VRFileWarning vRFileWarning = this.tidMap.getWarning();
        if (vRFileWarning != null) {
            this.logger.log(16, "possible loss of transaction data", (Throwable)vRFileWarning);
        }
        if (bl && Store.getDEBUG()) {
            this.logger.log(1, "TidList initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "TidList: loaded " + this.tidMap.size() + " transactions");
        }
        this.txnAckList = new TxnAckList(file, bl);
    }

    TidList(FileStore fileStore, File file, File file2) throws BrokerException {
        Object object;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (object != null) {
                this.logger.log(16, "B4202", (Throwable)object);
                LoadException loadException = new LoadException(object.getMessage(), object.getCause());
                loadException.setKey(object.getKey());
                loadException.setValue(object.getValue());
                loadException.setKeyCause(object.getKeyCause());
                loadException.setValueCause(object.getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                object = object.getNextException();
            }
        }
        object = pHashMap.getWarning();
        if (object != null) {
            this.logger.log(16, "possible loss of transaction data in old store", (Throwable)object);
        }
        try {
            this.useMemoryMappedFile = this.config.getBooleanProperty(TXN_USE_MEMORY_MAPPED_FILE_PROP, true);
            boolean bl = this.updateOptimization = this.useMemoryMappedFile && this.config.getBooleanProperty(TXN_UPDATE_OPTIMIZATION_PROP, true);
            if (this.useMemoryMappedFile) {
                this.tidMap = new PHashMapMMF(this.backingFile, file3.length(), 1024, false, false);
                if (this.updateOptimization) {
                    ((PHashMapMMF)this.tidMap).intClientData(17);
                }
            } else {
                this.tidMap = new PHashMap(this.backingFile, file3.length(), 1024, false, false);
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), iOException);
        }
        try {
            this.tidMap.load();
            this.loadClientData();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)classNotFoundException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), classNotFoundException);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), iOException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this.logger.log(32, "B4157", (Object)file3, (Object)this.backingFile, (Throwable)pHashMapLoadException);
            throw new BrokerException(this.br.getString("B4157", file3, this.backingFile), pHashMapLoadException);
        }
        object = this.tidMap.getWarning();
        if (object != null) {
            this.logger.log(16, "possible loss of transaction data", (Throwable)object);
        }
        for (Map.Entry entry : pHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.tidMap.put(k, (Object)new TransactionInfo((TransactionState)v));
        }
        pHashMap.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "TidList: upgraded " + this.tidMap.size() + " transactions");
        }
        if (fileStore.upgradeNoBackup() && !file3.delete()) {
            this.logger.log(32, "B1044", (Object)file3);
        }
        this.txnAckList = new TxnAckList(file, file2, fileStore.upgradeNoBackup());
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    LoadException getLoadTransactionAckException() {
        return this.txnAckList.getLoadException();
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TidList: closing, " + this.tidMap.size() + " persisted transactions");
        }
        this.tidMap.close();
        this.txnAckList.close(bl);
    }

    void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        try {
            Object object = this.tidMap.putIfAbsent((Object)transactionUID, (Object)new TransactionInfo(new TransactionState(transactionState)));
            if (object != null) {
                this.logger.log(32, "B3015", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3015", transactionUID));
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", transactionUID), runtimeException);
        }
    }

    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        TransactionInfo transactionInfo = null;
        try {
            transactionInfo = new TransactionInfo(new TransactionState(transactionState), null, transactionBrokerArray, 2);
            Object object = this.tidMap.putIfAbsent((Object)transactionUID, (Object)transactionInfo);
            if (object != null) {
                this.logger.log(32, "B3015", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3015", transactionUID));
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = transactionInfo != null ? transactionUID + " " + transactionInfo.toString() : transactionUID.toString();
            this.logger.log(32, "B4019", (Object)string, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", string), runtimeException);
        }
    }

    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        TransactionInfo transactionInfo = null;
        boolean bl2 = false;
        try {
            if (this.tidMap.containsKey((Object)transactionUID)) {
                this.logger.log(32, "B3015", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3015", transactionUID));
            }
            if (transactionAcknowledgementArray != null && transactionAcknowledgementArray.length > 0) {
                this.txnAckList.storeAcks(transactionUID, transactionAcknowledgementArray, bl);
                bl2 = true;
            }
            transactionInfo = new TransactionInfo(new TransactionState(transactionState), brokerAddress, null, 3);
            this.tidMap.put((Object)transactionUID, (Object)transactionInfo);
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = transactionInfo != null ? transactionUID + " " + transactionInfo.toString() : transactionUID.toString();
            this.logger.log(32, "B4019", (Object)string, (Throwable)runtimeException);
            try {
                if (bl2) {
                    this.txnAckList.removeAcks(transactionUID, bl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new BrokerException(this.br.getString("B4019", string), runtimeException);
        }
    }

    void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        try {
            this.tidMap.put((Object)transactionUID, (Object)transactionInfo);
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", transactionUID), runtimeException);
        }
    }

    void removeTransaction(TransactionUID transactionUID, boolean bl) throws BrokerException {
        try {
            Object object = this.tidMap.remove((Object)transactionUID);
            if (object == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4138", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4138", transactionUID), runtimeException);
        }
    }

    void updateTransactionState(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
            if (transactionInfo == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState.getState() != n) {
                transactionState.setState(n);
                if (this.updateOptimization) {
                    byte[] byArray = this.generateClientData(transactionUID, transactionInfo);
                    PHashMapMMF pHashMapMMF = (PHashMapMMF)this.tidMap;
                    pHashMapMMF.putClientData((Object)transactionUID, byArray);
                } else {
                    this.tidMap.put((Object)transactionUID, (Object)transactionInfo);
                }
            } else {
                bl = false;
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (Exception exception) {
            this.logger.log(32, "B4137", (Object)transactionUID, (Throwable)exception);
            throw new BrokerException(this.br.getString("B4137", transactionUID), exception);
        }
    }

    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
            if (transactionInfo == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            transactionInfo.setType(2);
            transactionInfo.setTransactionBrokers(transactionBrokerArray);
            this.tidMap.put((Object)transactionUID, (Object)transactionInfo);
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4019", transactionUID), runtimeException);
        }
    }

    void updateTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        try {
            TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
            if (transactionInfo == null) {
                this.logger.log(32, "B3016", (Object)transactionUID);
                throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
            }
            TransactionState transactionState = transactionInfo.getTransactionState();
            if (transactionState.getState() != n) {
                Object[] objectArray = new Object[]{transactionBroker, transactionUID, TransactionState.toString(n), TransactionState.toString(transactionState.getState())};
                throw new BrokerException(this.br.getKString("B3219", objectArray), 409);
            }
            transactionInfo.updateBrokerState(transactionBroker);
            if (this.updateOptimization) {
                byte[] byArray = this.generateClientData(transactionUID, transactionInfo);
                PHashMapMMF pHashMapMMF = (PHashMapMMF)this.tidMap;
                pHashMapMMF.putClientData((Object)transactionUID, byArray);
            } else {
                this.tidMap.put((Object)transactionUID, (Object)transactionInfo);
            }
            if (bl) {
                this.sync(transactionUID);
            }
        }
        catch (Exception exception) {
            this.logger.log(32, "B4019", (Object)transactionUID, (Throwable)exception);
            throw new BrokerException(this.br.getString("B4019", transactionUID), exception);
        }
    }

    TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        return new TransactionState(transactionInfo.getTransactionState());
    }

    int getTransactionStateValue(TransactionUID transactionUID) throws BrokerException {
        TransactionState transactionState;
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
        if (transactionInfo != null && (transactionState = transactionInfo.getTransactionState()) != null) {
            return transactionState.getState();
        }
        return -1;
    }

    TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        return (TransactionInfo)transactionInfo.clone();
    }

    BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        return transactionInfo.getTransactionHomeBroker();
    }

    TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        TransactionInfo transactionInfo = (TransactionInfo)this.tidMap.get((Object)transactionUID);
        if (transactionInfo == null) {
            this.logger.log(32, "B3016", (Object)transactionUID);
            throw new BrokerException(this.br.getString("B3016", transactionUID), 404);
        }
        TransactionBroker[] transactionBrokerArray = transactionInfo.getTransactionBrokers();
        if (transactionBrokerArray != null) {
            transactionBrokerArray = (TransactionBroker[])transactionBrokerArray.clone();
        }
        return transactionBrokerArray;
    }

    HashMap getAllTransactionStates() throws IOException {
        HashMap hashMap = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo transactionInfo = (TransactionInfo)entry.getValue();
            int n = transactionInfo.getType();
            if (n != 1 && n != 2) continue;
            hashMap.put(entry.getKey(), new TransactionState(transactionInfo.getTransactionState()));
        }
        return hashMap;
    }

    HashMap getAllRemoteTransactionStates() throws IOException {
        HashMap hashMap = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo transactionInfo = (TransactionInfo)entry.getValue();
            int n = transactionInfo.getType();
            if (n != 3) continue;
            hashMap.put(entry.getKey(), new TransactionState(transactionInfo.getTransactionState()));
        }
        return hashMap;
    }

    Collection getAllTransactions() {
        return this.tidMap.keySet();
    }

    void clearAll(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TidList.clearAll() called");
        }
        try {
            this.tidMap.clear();
            if (bl) {
                this.sync(null);
            }
        }
        catch (BrokerException brokerException) {
            this.logger.log(32, this.br.getString("B4020", this.backingFile), (Throwable)brokerException);
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, this.br.getString("B4020", this.backingFile), (Throwable)runtimeException);
        }
        this.txnAckList.clearAll(bl);
    }

    void clear(int n, boolean bl) throws BrokerException {
        Externalizable externalizable;
        TransactionUID[] transactionUIDArray;
        boolean bl2 = false;
        Exception exception = null;
        Iterator iterator = this.tidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            block10: {
                try {
                    transactionUIDArray = (TransactionUID[])iterator.next();
                    TransactionUID transactionUID = (TransactionUID)transactionUIDArray.getKey();
                    externalizable = (TransactionState)transactionUIDArray.getValue();
                    if (((TransactionState)externalizable).getState() == n) break block10;
                    iterator.remove();
                    try {
                        this.txnAckList.removeAcks(transactionUID, bl);
                    }
                    catch (BrokerException brokerException) {
                        bl2 = true;
                        exception = brokerException;
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    bl2 = true;
                    exception = runtimeException;
                    this.logger.log(32, "B4139", (Object)new Integer(n), (Throwable)runtimeException);
                }
            }
            if (!bl) continue;
            this.sync(null);
        }
        if (!bl2) {
            transactionUIDArray = this.txnAckList.getAllTids();
            for (int i = 0; i < transactionUIDArray.length; ++i) {
                externalizable = (TransactionInfo)this.tidMap.get((Object)transactionUIDArray[i]);
                if (externalizable != null && ((TransactionInfo)externalizable).getTransactionStateValue() == n) continue;
                try {
                    this.txnAckList.removeAcks(transactionUIDArray[i], bl);
                    continue;
                }
                catch (BrokerException brokerException) {
                    bl2 = true;
                    exception = brokerException;
                    break;
                }
            }
        }
        if (bl2) {
            this.clearAll(bl);
            throw new BrokerException(this.br.getString("B4139", new Integer(n)), exception);
        }
    }

    void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (!this.tidMap.containsKey((Object)transactionUID)) {
            this.logger.log(32, "B3016", (Object)transactionUID.toString());
            throw new BrokerException(this.br.getString("B3016", transactionUID.toString()));
        }
        this.txnAckList.storeAck(transactionUID, transactionAcknowledgement, bl);
    }

    void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        this.txnAckList.removeAcks(transactionUID, bl);
    }

    TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        return this.txnAckList.getAcks(transactionUID);
    }

    HashMap getAllTransactionAcks() {
        return this.txnAckList.getAllAcks();
    }

    public int getNumberOfTxnAcks() {
        return this.txnAckList.getNumberOfTxnAcks();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Transactions", String.valueOf(this.tidMap.size()));
        hashtable.putAll(this.txnAckList.getDebugState());
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nTransaction IDs");
        printStream.println("---------------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("number of transaction ids: " + this.tidMap.size());
        this.txnAckList.printInfo(printStream);
    }

    private void loadClientData() throws PHashMapLoadException {
        if (!this.updateOptimization) {
            return;
        }
        PHashMapLoadException pHashMapLoadException = null;
        Iterator iterator = this.tidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Throwable throwable = null;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            TransactionInfo transactionInfo = (TransactionInfo)entry.getValue();
            byte[] byArray = null;
            try {
                byArray = ((PHashMapMMF)this.tidMap).getClientData(k);
                if (byArray != null && byArray.length > 0) {
                    byte by = byArray[0];
                    transactionInfo.getTransactionState().setState(by);
                    TransactionBroker[] transactionBrokerArray = transactionInfo.getTransactionBrokers();
                    if (transactionBrokerArray != null) {
                        int n = transactionBrokerArray.length;
                        for (int i = 0; i < n; ++i) {
                            TransactionBroker transactionBroker = transactionBrokerArray[i];
                            boolean bl = byArray[i + 1] == 1;
                            transactionBroker.setCompleted(bl);
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable == null) continue;
            PHashMapLoadException pHashMapLoadException2 = new PHashMapLoadException("Failed to load client data [cData=" + byArray + "]");
            pHashMapLoadException2.setKey(k);
            pHashMapLoadException2.setValue((Object)transactionInfo);
            pHashMapLoadException2.setNextException(pHashMapLoadException);
            pHashMapLoadException2.initCause(throwable);
            pHashMapLoadException = pHashMapLoadException2;
        }
        if (pHashMapLoadException != null) {
            throw pHashMapLoadException;
        }
    }

    private void loadClientDataOldFormat() throws PHashMapLoadException {
        if (!this.updateOptimization) {
            return;
        }
        PHashMapLoadException pHashMapLoadException = null;
        Iterator iterator = this.tidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Throwable throwable = null;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            TransactionState transactionState = (TransactionState)entry.getValue();
            byte[] byArray = null;
            try {
                byArray = ((PHashMapMMF)this.tidMap).getClientData(k);
                if (byArray != null && byArray.length > 0) {
                    byte by = byArray[0];
                    transactionState.setState(by);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable == null) continue;
            PHashMapLoadException pHashMapLoadException2 = new PHashMapLoadException("Failed to load client data [cData=" + byArray + "]");
            pHashMapLoadException2.setKey(k);
            pHashMapLoadException2.setValue((Object)transactionState);
            pHashMapLoadException2.setNextException(pHashMapLoadException);
            pHashMapLoadException2.initCause(throwable);
            pHashMapLoadException = pHashMapLoadException2;
        }
        if (pHashMapLoadException != null) {
            throw pHashMapLoadException;
        }
    }

    private byte[] generateClientData(TransactionUID transactionUID, TransactionInfo transactionInfo) throws BrokerException {
        int n;
        byte[] byArray = new byte[17];
        byArray[0] = (byte)transactionInfo.getTransactionStateValue();
        TransactionBroker[] transactionBrokerArray = transactionInfo.getTransactionBrokers();
        int n2 = n = transactionBrokerArray != null ? transactionBrokerArray.length : 0;
        if (n > 16) {
            throw new BrokerException("Internal Error: transaction broker list size of " + n + " is larger than the reserved client data byte limit of " + 16 + " for transaction " + transactionUID);
        }
        for (int i = 1; i < 17; ++i) {
            int n3 = i - 1;
            byArray[i] = n3 < n ? (byte)(transactionBrokerArray[n3].isCompleted() ? 1 : 0) : (byte)0;
        }
        return byArray;
    }

    void sync(Object object) throws BrokerException {
        try {
            this.tidMap.force(object);
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.backingFile, iOException);
        }
    }

    void syncTransactionAck(TransactionUID transactionUID) throws BrokerException {
        this.txnAckList.sync(transactionUID);
    }
}

