/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionEvent;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;

public abstract class TransactionEvent {
    public static TransactionEvent createFromBytes(byte[] byArray) throws IOException, BrokerException {
        TransactionEvent transactionEvent = null;
        byte by = byArray[0];
        byte by2 = byArray[1];
        transactionEvent = TransactionEvent.create(by, by2);
        transactionEvent.readFromBytes(byArray);
        return transactionEvent;
    }

    static TransactionEvent create(byte by, byte by2) {
        TransactionEvent transactionEvent = null;
        switch (by) {
            case 1: {
                transactionEvent = LocalTransactionEvent.create(by2);
                break;
            }
            case 3: {
                transactionEvent = ClusterTransactionEvent.create(by2);
                break;
            }
            case 2: {
                transactionEvent = RemoteTransactionEvent.create(by2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return transactionEvent;
    }

    abstract int getType();

    abstract void readFromBytes(byte[] var1) throws IOException, BrokerException;

    abstract byte[] writeToBytes() throws IOException, BrokerException;
}

