/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class LockFile {
    private static LockFile currentLockFile = null;
    private String hostname = null;
    private String instance = null;
    private String filePath = null;
    private int port = 0;
    private boolean isMyLock = false;

    private LockFile() {
    }

    private LockFile(String string, String string2, int n) {
        this.hostname = string2;
        this.instance = string;
        this.port = n;
    }

    public static synchronized void clearLock() {
        currentLockFile = null;
    }

    public static synchronized LockFile getLock(String string, String string2, String string3, int n) throws IOException {
        LockFile lockFile = null;
        File file = new File(LockFile.getLockFilePath(string, string2));
        if (file.createNewFile()) {
            lockFile = new LockFile(string2, string3, n);
            lockFile.filePath = file.getCanonicalPath();
            lockFile.isMyLock = true;
            lockFile.writeLockFile(file);
            file.deleteOnExit();
            currentLockFile = lockFile;
            return lockFile;
        }
        lockFile = LockFile.loadLockFile(file);
        lockFile.filePath = file.getCanonicalPath();
        if (n == lockFile.getPort() && LockFile.equivalentHostNames(string3, lockFile.getHost(), false) && string2.equals(lockFile.getInstance())) {
            file.deleteOnExit();
            lockFile.isMyLock = true;
            currentLockFile = lockFile;
            return lockFile;
        }
        if (n == lockFile.getPort() && LockFile.isSameIP(string3, lockFile.getHost()) && string2.equals(lockFile.getInstance())) {
            lockFile.updateHostname(string3);
            file.deleteOnExit();
            lockFile.isMyLock = true;
            currentLockFile = lockFile;
            return lockFile;
        }
        Socket socket = null;
        try {
            socket = new Socket(lockFile.hostname, lockFile.port);
            lockFile.isMyLock = false;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                throw new IOException(Globals.getBrokerResources().getString("B4106"));
            }
            return LockFile.getLock(string, string2, string3, n);
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        currentLockFile = lockFile;
        return lockFile;
    }

    public static boolean isSameIP(String string, String string2) {
        boolean bl = false;
        try {
            String string3 = InetAddress.getByName(string).getHostAddress();
            String string4 = InetAddress.getByName(string2).getHostAddress();
            if (string3.equals(string4)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static String getLockFilePath(String string, String string2) {
        return string + File.separator + "instances" + File.separator + string2 + File.separator + "lock";
    }

    public boolean isMyLock() {
        return this.isMyLock;
    }

    public String getHost() {
        return this.hostname;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.instance + " " + this.hostname + ":" + this.port + " (" + this.isMyLock + ")";
    }

    public void updatePort(int n) throws IOException {
        File file = new File(this.filePath);
        int n2 = this.port;
        this.port = n;
        try {
            this.writeLockFile(file);
        }
        catch (IOException iOException) {
            this.port = n2;
            throw iOException;
        }
    }

    public void updateHostname(String string) throws IOException {
        File file = new File(this.filePath);
        String string2 = this.hostname;
        this.hostname = string;
        try {
            this.writeLockFile(file);
        }
        catch (IOException iOException) {
            this.hostname = string2;
            throw iOException;
        }
    }

    private static synchronized LockFile loadLockFile(File file) throws IOException {
        byte[] byArray = new byte[128];
        LockFile lockFile = new LockFile();
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        String string = new String(byArray, "UTF8");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " :\t\n\r\f");
        lockFile.instance = stringTokenizer.nextToken();
        lockFile.hostname = stringTokenizer.nextToken();
        lockFile.port = Integer.parseInt(stringTokenizer.nextToken());
        fileInputStream.close();
        return lockFile;
    }

    public synchronized void writeLockFile(File file) throws IOException {
        String string = this.instance + ":" + this.hostname + ":" + this.port + "\n";
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string.getBytes("UTF8"));
        fileOutputStream.close();
    }

    public static LockFile getCurrentLockFile() {
        return currentLockFile;
    }

    public static boolean equivalentHostNames(String string, String string2, boolean bl) {
        if (bl) {
            return string.equals(string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            if (stringTokenizer.nextToken().equals(stringTokenizer2.nextToken())) continue;
            return false;
        }
        return true;
    }
}

