/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.PooledConnection;
import com.sun.messaging.bridge.service.jms.PooledConnectionImpl;
import com.sun.messaging.bridge.service.jms.PooledXAConnectionImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;

public class PooledConnectionFactory
implements Runnable {
    public static final String POOL_IDLE_TIMEOUT = "pool-idle-timeout";
    private Logger _logger = null;
    private Object _cf = null;
    private int _maxRetries = 0;
    private int _retryInterval = 0;
    private ScheduledExecutorService _scheduler = null;
    private ScheduledFuture _future = null;
    private int _idleTimeout = 0;
    private ConcurrentLinkedQueue<PooledConnection> _idleConns = null;
    private ConcurrentLinkedQueue<PooledConnection> _outConns = null;
    private final EventNotifier _notifier = new EventNotifier();
    private boolean _closed = false;
    private String _username = null;
    private String _password = null;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public PooledConnectionFactory(Object object, Properties properties, Logger logger) throws Exception {
        this._logger = logger;
        this._cf = object;
        String string = properties.getProperty("username");
        if (string != null) {
            this._username = string.trim();
            this._password = properties.getProperty("password");
        }
        if ((string = properties.getProperty("idle-timeout-in-seconds", "1800")) != null) {
            this._idleTimeout = Integer.valueOf(string);
        }
        if (this._idleTimeout < 0) {
            this._idleTimeout = 0;
        }
        if ((string = properties.getProperty("connect-attempts", "-1")) != null) {
            this._maxRetries = Integer.valueOf(string);
        }
        if ((string = properties.getProperty("connect-attempt-interval-in-seconds", "5")) != null) {
            this._retryInterval = Integer.valueOf(string);
        }
        if (this._retryInterval < 0) {
            this._retryInterval = 0;
        }
        this._idleConns = new ConcurrentLinkedQueue();
        this._outConns = new ConcurrentLinkedQueue();
        this._scheduler = Executors.newSingleThreadScheduledExecutor();
        if (this._idleTimeout > 0) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1044", this._idleTimeout, this.toString()));
            this._future = this._scheduler.scheduleAtFixedRate(this, this._idleTimeout, this._idleTimeout, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Connection connection, String string, Object object, boolean bl) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Obtaining pooled connection from pooled connection factory " + this);
        }
        if (this._closed) {
            if (connection == null) {
                throw new JMSException(_jbr.getKString("BSJ4027", this.toString()));
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Unable to close connection in pooled connection factory " + this);
            }
            throw new JMSException(_jbr.getKString("BSJ4027", this.toString()));
        }
        PooledConnection pooledConnection = null;
        if (connection != null) {
            pooledConnection = connection instanceof XAConnection ? new PooledXAConnectionImpl((XAConnection)connection) : new PooledConnectionImpl(connection);
            this._idleConns.offer(pooledConnection);
        }
        while (true) {
            if ((pooledConnection = this._idleConns.poll()) == null) {
                if (this._closed) {
                    throw new JMSException(_jbr.getKString("BSJ4027", this.toString()));
                }
                Connection connection2 = null;
                EventListener eventListener = new EventListener();
                try {
                    this._notifier.addEventListener(EventListener.EventType.CONN_CLOSE, eventListener);
                    connection2 = JMSBridge.openConnection(this._cf, this._maxRetries, this._retryInterval, this._username, this._password, string, object, eventListener, this._logger, bl);
                }
                finally {
                    this._notifier.removeEventListener(eventListener);
                }
                pooledConnection = connection2 instanceof XAConnection ? new PooledXAConnectionImpl((XAConnection)connection2) : new PooledConnectionImpl(connection2);
            }
            if (!this._closed && pooledConnection.isValid()) {
                pooledConnection.idleEnd();
                this._outConns.offer(pooledConnection);
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Obtained pooled connection " + pooledConnection + " from pooled connection factory " + this);
                }
                return (Connection)pooledConnection;
            }
            try {
                if (this._closed) {
                    this._logger.log(Level.INFO, "Closing connection " + pooledConnection + " for pooled connection factory " + this + " is closed");
                } else if (!pooledConnection.isValid()) {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1045", pooledConnection.toString(), this.toString()));
                }
                ((Connection)pooledConnection).close();
                continue;
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Unable to close connection " + pooledConnection + " in pooled connection factory " + this + ": " + exception.getMessage());
                continue;
            }
            break;
        }
    }

    public void returnConnection(Connection connection) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Returning pooled connection " + connection + " to pooled connection factory " + this);
        }
        if (!(connection instanceof PooledConnection)) {
            throw new IllegalArgumentException("Connection " + connection + " is not a pooled connection, can't return to pooled connection factory " + this);
        }
        if (!this._outConns.contains(connection)) {
            throw new IllegalStateException("Connection " + connection + " is not a in-use in pooled connection factory " + this);
        }
        this._outConns.remove((PooledConnection)connection);
        ((PooledConnection)connection).idleStart();
        this._idleConns.offer((PooledConnection)connection);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Returned pooled connection " + connection + " to pooled connection factory " + this);
        }
    }

    public void close() {
        this._closed = true;
        this._logger.log(Level.INFO, _jbr.getString("BSJ1046", this.toString()));
        this._notifier.notifyEvent(EventListener.EventType.CONN_CLOSE, this);
        if (this._outConns.size() > 0) {
            this._logger.log(Level.WARNING, _jbr.getString("BSJ2018", this.toString()));
        }
        if (this._future != null) {
            this._scheduler.shutdownNow();
            try {
                this._scheduler.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.run();
    }

    public void run() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Check idle timeout in pooled connection factory " + this);
        }
        ArrayList<PooledConnection> arrayList = new ArrayList<PooledConnection>();
        PooledConnection pooledConnection = this._idleConns.peek();
        arrayList.add(pooledConnection);
        while (pooledConnection != null) {
            long l = pooledConnection.getIdleStartTime();
            if (l <= 0L && pooledConnection.isValid() && !this._closed) continue;
            pooledConnection = this._idleConns.poll();
            if (pooledConnection == null) {
                return;
            }
            if (!pooledConnection.isValid() || System.currentTimeMillis() - l > (long)this._idleTimeout || this._closed) {
                this._logger.log(Level.INFO, pooledConnection.isValid() ? _jbr.getString("BSJ1047", pooledConnection.toString(), this.toString()) : _jbr.getString("BSJ1045", pooledConnection.toString(), this.toString()));
                try {
                    ((Connection)pooledConnection).close();
                }
                catch (Exception exception) {
                    this._logger.log(Level.WARNING, "Failed to close " + (this._closed ? "" : (pooledConnection.isValid() ? "idle timed out connection " : "invalid connection ")) + pooledConnection + " in pooled connection factory " + this);
                    pooledConnection.invalid();
                    this._idleConns.offer(pooledConnection);
                }
            } else {
                this._idleConns.offer(pooledConnection);
            }
            pooledConnection = this._idleConns.peek();
            if (arrayList.contains(pooledConnection)) break;
            arrayList.add(pooledConnection);
        }
    }

    public Object getCF() {
        return this._cf;
    }

    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public int getRetryInterval() {
        return this._retryInterval;
    }

    public int getNumIdleConns() {
        return this._idleConns.size();
    }

    public int getNumInUseConns() {
        return this._outConns.size();
    }

    public String toString() {
        return this._cf + "[" + this._outConns.size() + ", " + this._idleConns.size() + "]";
    }
}

