/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.BytesField;
import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.apps.console.util.SpecialValueField;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class BrokerDestPropsDialog
extends AdminDialog
implements ActionListener,
ListSelectionListener,
BrokerConstants {
    private static final int UNLIMITED_VALUE_0 = 0;
    private static final int UNLIMITED_VALUE_NEG1 = -1;
    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private static String[] columnNames;
    private JTabbedPane tabbedPane;
    private JPanel basicPanel;
    private JPanel durPanel;
    private JLabel destNameValue;
    private JLabel destTypeValue;
    private JLabel destStateValue;
    private JLabel curNumProducers;
    private LabelledComponent curNumProducersLabelC;
    private JLabel curNumActive;
    private LabelledComponent curNumActiveLabelC;
    private JLabel curNumFailover;
    private LabelledComponent curNumFailoverLabelC;
    private JLabel curNumMesgsValue;
    private JLabel curNumMesgBytesValue;
    private IntegerField activeConsumerIF;
    private LabelledComponent activeConsumerLabelC;
    private SpecialValueField activeConsumerSF;
    private IntegerField failoverConsumerIF;
    private LabelledComponent failoverConsumerLabelC;
    private SpecialValueField failoverConsumerSF;
    private IntegerField maxProducerIF;
    private LabelledComponent maxProducerLabelC;
    private SpecialValueField maxProducerSF;
    private BytesField mesgSizeLimitBF;
    private LabelledComponent mesgSizeLimitLabelC;
    private SpecialValueField mesgSizeLimitSF;
    IntegerField mesgLimitIF;
    SpecialValueField mesgLimitSF;
    private LabelledComponent mesgLimitLabelC;
    BytesField maxSizePerMsgBF;
    SpecialValueField maxSizePerMsgSF;
    private PropsTableModel model;
    private JTable table;
    private JScrollPane scrollPane;
    private JButton deleteButton;
    private JButton purgeButton;
    private JComboBox limitBehaviorCb;
    private JCheckBox useDMQCkb;
    private DestinationInfo destInfo;
    private Vector durables;
    private int selectedRow = -1;
    private String selectedDurName = null;
    private String selectedClientID = null;
    private boolean resetScrollbarPolicy = true;

    public BrokerDestPropsDialog(Frame frame) {
        super(frame, acr.getString("A1408"), 81);
        this.setHelpId("broker_destination_properties");
    }

    public void doClose() {
        this.hide();
        this.reset();
    }

    public void doApply() {
    }

    public void doReset() {
    }

    public void doClear() {
    }

    public void doCancel() {
        this.hide();
    }

    public void doOK() {
        BrokerAdminEvent brokerAdminEvent = new BrokerAdminEvent(this, 7);
        DestinationInfo destinationInfo = this.getUpdateDestinationInfo();
        brokerAdminEvent.setDestinationInfo(destinationInfo);
        brokerAdminEvent.setOKAction(true);
        this.fireAdminEventDispatched(brokerAdminEvent);
    }

    private DestinationInfo getUpdateDestinationInfo() {
        boolean bl;
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        long l = -1L;
        int n5 = -1;
        long l2 = -1L;
        DestinationInfo destinationInfo = new DestinationInfo();
        if (DestType.isQueue(this.destInfo.type)) {
            n2 = this.activeConsumerSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.activeConsumerIF.getText());
            if (n2 != this.destInfo.maxActiveConsumers) {
                destinationInfo.setMaxActiveConsumers(n2);
            }
            if ((n3 = this.failoverConsumerSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.failoverConsumerIF.getText())) != this.destInfo.maxFailoverConsumers) {
                destinationInfo.setMaxFailoverConsumers(n3);
            }
        }
        if ((n4 = this.maxProducerSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.maxProducerIF.getText())) != this.destInfo.maxProducers) {
            destinationInfo.setMaxProducers(n4);
        }
        if ((l = this.mesgSizeLimitSF.isSpecialValueSet() ? -1L : this.mesgSizeLimitBF.getValue()) != this.destInfo.maxMessageBytes) {
            destinationInfo.setMaxMessageBytes(l);
        }
        if ((n5 = this.mesgLimitSF.isSpecialValueSet() ? -1 : Integer.parseInt(this.mesgLimitIF.getText())) != this.destInfo.maxMessages) {
            destinationInfo.setMaxMessages(n5);
        }
        if ((l2 = this.maxSizePerMsgSF.isSpecialValueSet() ? -1L : this.maxSizePerMsgBF.getValue()) != this.destInfo.maxMessageSize) {
            destinationInfo.setMaxMessageSize(l2);
        }
        if ((n = this.getLimitBehavValue((String)this.limitBehaviorCb.getSelectedItem())) != this.destInfo.destLimitBehavior) {
            destinationInfo.setLimitBehavior(n);
        }
        if ((bl = this.useDMQCkb.isSelected()) != this.destInfo.useDMQ()) {
            destinationInfo.setUseDMQ(bl);
        }
        return destinationInfo;
    }

    public JPanel createWorkPanel() {
        JPanel jPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(acr.getString("A1503"), this.makeBasicTab());
        this.tabbedPane.addTab(acr.getString("A1504"), this.makeDurTab());
        jPanel.add(this.tabbedPane);
        return jPanel;
    }

    private JPanel makeBasicTab() {
        LabelledComponent labelledComponent;
        int n = 0;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        LabelledComponent[] labelledComponentArray = new LabelledComponent[3];
        this.destNameValue = new JLabel();
        labelledComponentArray[0] = labelledComponent = new LabelledComponent(acr.getString("A1424"), this.destNameValue);
        this.destTypeValue = new JLabel();
        labelledComponentArray[1] = labelledComponent = new LabelledComponent(acr.getString("A1425"), this.destTypeValue);
        this.destStateValue = new JLabel();
        labelledComponentArray[2] = labelledComponent = new LabelledComponent(acr.getString("A1463") + ":", this.destStateValue);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        LabelValuePanel labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 3);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        JSeparator jSeparator = new JSeparator();
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        labelledComponentArray = new LabelledComponent[5];
        this.curNumMesgsValue = new JLabel();
        labelledComponent = new LabelledComponent(acr.getString("A1435"), this.curNumMesgsValue);
        labelledComponentArray[n++] = labelledComponent;
        this.curNumMesgBytesValue = new JLabel();
        labelledComponent = new LabelledComponent(acr.getString("A1436"), (JComponent)this.curNumMesgBytesValue, acr.getString("A1221"));
        labelledComponentArray[n++] = labelledComponent;
        this.curNumProducers = new JLabel();
        this.curNumProducersLabelC = new LabelledComponent(acr.getString("A1467"), this.curNumProducers);
        labelledComponentArray[n++] = this.curNumProducersLabelC;
        this.curNumActive = new JLabel();
        this.curNumActiveLabelC = new LabelledComponent(acr.getString("A1464"), this.curNumActive);
        labelledComponentArray[n++] = this.curNumActiveLabelC;
        this.curNumFailover = new JLabel();
        this.curNumFailoverLabelC = new LabelledComponent(acr.getString("A1465"), this.curNumFailover);
        labelledComponentArray[n++] = this.curNumFailoverLabelC;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 5);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jSeparator = new JSeparator();
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        n = 0;
        labelledComponentArray = new LabelledComponent[6];
        this.mesgLimitIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.mesgLimitSF = new SpecialValueField(this.mesgLimitIF, acr.getString("A1433"));
        this.mesgLimitLabelC = new LabelledComponent(acr.getString("A1431"), (JComponent)this.mesgLimitSF, 0);
        labelledComponentArray[n++] = this.mesgLimitLabelC;
        this.mesgSizeLimitBF = new BytesField(0L, Long.MAX_VALUE, 11);
        this.mesgSizeLimitSF = new SpecialValueField(this.mesgSizeLimitBF, acr.getString("A1433"));
        this.mesgSizeLimitLabelC = new LabelledComponent(acr.getString("A1430"), (JComponent)this.mesgSizeLimitSF, 0);
        labelledComponentArray[n++] = this.mesgSizeLimitLabelC;
        this.maxSizePerMsgBF = new BytesField(0L, Long.MAX_VALUE, 11);
        this.maxSizePerMsgSF = new SpecialValueField(this.maxSizePerMsgBF, acr.getString("A1433"));
        labelledComponent = new LabelledComponent(acr.getString("A1432"), (JComponent)this.maxSizePerMsgSF, 0);
        labelledComponentArray[n++] = labelledComponent;
        this.maxProducerIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.maxProducerSF = new SpecialValueField(this.maxProducerIF, acr.getString("A1433"));
        this.maxProducerLabelC = new LabelledComponent(acr.getString("A1466"), (JComponent)this.maxProducerSF, 0);
        labelledComponentArray[n++] = this.maxProducerLabelC;
        this.activeConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.activeConsumerSF = new SpecialValueField(this.activeConsumerIF, acr.getString("A1433"));
        this.activeConsumerLabelC = new LabelledComponent(acr.getString("A1459"), (JComponent)this.activeConsumerSF, 0);
        labelledComponentArray[n++] = this.activeConsumerLabelC;
        this.failoverConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 11);
        this.failoverConsumerSF = new SpecialValueField(this.failoverConsumerIF, acr.getString("A1433"));
        this.failoverConsumerLabelC = new LabelledComponent(acr.getString("A1460"), (JComponent)this.failoverConsumerSF, 0);
        labelledComponentArray[n++] = this.failoverConsumerLabelC;
        labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jSeparator = new JSeparator();
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        n = 0;
        labelledComponentArray = new LabelledComponent[2];
        this.limitBehaviorCb = new JComboBox<String>(BKR_LIMIT_BEHAV_VALID_VALUES);
        labelledComponent = new LabelledComponent(acr.getString("A1469"), this.limitBehaviorCb);
        labelledComponentArray[n++] = labelledComponent;
        this.useDMQCkb = new JCheckBox();
        labelledComponent = new LabelledComponent(acr.getString("A1470"), this.useDMQCkb);
        labelledComponentArray[n++] = labelledComponent;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 2);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        return jPanel;
    }

    private JPanel makeDurTab() {
        int n;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < columnNames.length; ++n) {
            JLabel jLabel = new JLabel(columnNames[n]);
            n3 = jLabel.getPreferredSize().width;
            if (n3 <= n4) continue;
            n4 = n3;
        }
        n2 = n4 * columnNames.length;
        this.model = new PropsTableModel();
        this.table = new JTable(this.model);
        n = this.table.getColumnModel().getTotalColumnWidth();
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.table, 22, 30);
        this.table.setPreferredScrollableViewportSize(new Dimension(n2, 21 * this.table.getRowHeight()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.scrollPane, gridBagConstraints);
        jPanel.add(this.scrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this.deleteButton = new JButton(acr.getString("A1133"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this);
        jPanel2.add(this.deleteButton);
        this.purgeButton = new JButton(acr.getString("A1114"));
        this.purgeButton.setEnabled(false);
        this.purgeButton.addActionListener(this);
        jPanel2.add(this.purgeButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void show(DestinationInfo destinationInfo, Vector vector) {
        int n;
        this.destInfo = destinationInfo;
        this.durables = vector;
        this.reset();
        if (DestType.isQueue(destinationInfo.type)) {
            this.tabbedPane.setEnabledAt(1, false);
            this.setActiveConsumersEnabled(true);
            this.setFailoverConsumersEnabled(true);
            this.curNumFailoverLabelC.setEnabled(true);
            this.curNumFailover.setEnabled(true);
            n = destinationInfo.maxActiveConsumers;
            if (n != -1) {
                this.activeConsumerIF.setText(String.valueOf(n));
            }
            this.checkUnlimitedNeg1(this.activeConsumerSF, n);
            n = destinationInfo.maxFailoverConsumers;
            if (n != -1) {
                this.failoverConsumerIF.setText(String.valueOf(n));
            }
            this.checkUnlimitedNeg1(this.failoverConsumerSF, n);
            this.curNumActiveLabelC.setLabelText(acr.getString("A1464"));
            this.curNumActive.setText(String.valueOf(destinationInfo.naConsumers));
        } else if (DestType.isTopic(destinationInfo.type)) {
            this.tabbedPane.setEnabledAt(1, true);
            this.setActiveConsumersEnabled(false);
            this.setFailoverConsumersEnabled(false);
            this.curNumFailoverLabelC.setEnabled(false);
            this.curNumFailover.setEnabled(false);
            this.curNumActiveLabelC.setLabelText(acr.getString("A1468"));
            this.curNumActive.setText(String.valueOf(destinationInfo.nConsumers));
        }
        this.destNameValue.setText(destinationInfo.name);
        this.destTypeValue.setText(BrokerAdminUtil.getDestinationType(destinationInfo.type));
        this.destStateValue.setText(BrokerAdminUtil.getDestinationState(destinationInfo.destState));
        this.curNumProducers.setText(String.valueOf(destinationInfo.nProducers));
        this.curNumFailover.setText(String.valueOf(destinationInfo.nfConsumers));
        this.curNumMesgsValue.setText(String.valueOf(destinationInfo.nMessages));
        this.curNumMesgBytesValue.setText(String.valueOf(destinationInfo.nMessageBytes));
        n = destinationInfo.maxProducers;
        if (n != -1) {
            this.maxProducerIF.setText(String.valueOf(n));
        }
        this.checkUnlimitedNeg1(this.maxProducerSF, n);
        long l = destinationInfo.maxMessageBytes;
        if (l != -1L) {
            this.mesgSizeLimitBF.setText(String.valueOf(l));
        }
        this.checkBothUnlimited(this.mesgSizeLimitSF, l);
        n = destinationInfo.maxMessages;
        if (n != -1) {
            this.mesgLimitIF.setText(String.valueOf(n));
        }
        this.checkBothUnlimited(this.mesgLimitSF, n);
        l = destinationInfo.maxMessageSize;
        if (l != -1L) {
            this.maxSizePerMsgBF.setText(String.valueOf(l));
        }
        this.checkBothUnlimited(this.maxSizePerMsgSF, l);
        String string = DestLimitBehavior.getString(destinationInfo.destLimitBehavior);
        this.limitBehaviorCb.setSelectedItem(string);
        if (destinationInfo.useDMQ()) {
            this.useDMQCkb.setSelected(true);
        } else {
            this.useDMQCkb.setSelected(false);
        }
        if (DestType.isTopic(destinationInfo.type)) {
            this.model.fireTableDataChanged();
            this.clearSelection();
        }
        if (this.resetScrollbarPolicy) {
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.resetScrollbarPolicy = false;
        }
        Dimension dimension = this.table.getPreferredScrollableViewportSize();
        int n2 = dimension.width;
        int n3 = this.table.getColumnModel().getTotalColumnWidth();
        if (n2 < n3) {
            dimension.width = n3;
            this.table.setPreferredScrollableViewportSize(dimension);
        }
        super.show();
    }

    public void refresh(Vector vector) {
        this.durables = vector;
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.clearSelection();
    }

    private void setActiveConsumersEnabled(boolean bl) {
        this.activeConsumerLabelC.setEnabled(bl);
        this.activeConsumerSF.setSpecialValueSet(bl);
        this.activeConsumerIF.setEnabled(bl);
    }

    private void setFailoverConsumersEnabled(boolean bl) {
        this.failoverConsumerLabelC.setEnabled(bl);
        this.failoverConsumerSF.setSpecialValueSet(bl);
        this.failoverConsumerIF.setEnabled(bl);
    }

    private void reset() {
        this.destNameValue.setText("");
        this.destTypeValue.setText("");
        this.destStateValue.setText("");
        this.curNumActive.setText("");
        this.curNumFailover.setText("");
        this.curNumMesgsValue.setText("");
        this.curNumMesgBytesValue.setText("");
        this.activeConsumerSF.setEnabled(true);
        this.activeConsumerSF.setSpecialValueSet(true);
        this.activeConsumerIF.setText("0");
        this.failoverConsumerSF.setEnabled(true);
        this.failoverConsumerSF.setSpecialValueSet(true);
        this.failoverConsumerIF.setText("0");
        this.mesgSizeLimitSF.setEnabled(true);
        this.mesgSizeLimitSF.setSpecialValueSet(true);
        this.mesgSizeLimitBF.setText("0");
        this.mesgSizeLimitBF.setUnit(0);
        this.mesgLimitSF.setEnabled(true);
        this.mesgLimitSF.setSpecialValueSet(true);
        this.mesgLimitIF.setText("0");
        this.maxSizePerMsgSF.setEnabled(true);
        this.maxSizePerMsgSF.setSpecialValueSet(true);
        this.maxSizePerMsgBF.setText("0");
        this.maxSizePerMsgBF.setUnit(0);
        this.limitBehaviorCb.setSelectedItem(BKR_LIMIT_BEHAV_VALID_VALUES[0]);
        this.useDMQCkb.setSelected(true);
        this.clearSelection();
        this.deleteButton.setEnabled(false);
        this.purgeButton.setEnabled(false);
        this.tabbedPane.setSelectedIndex(0);
    }

    private void clearSelection() {
        if (this.table != null) {
            this.table.clearSelection();
        }
        this.deleteButton.setEnabled(false);
        this.purgeButton.setEnabled(false);
        this.selectedRow = -1;
        this.selectedDurName = null;
        this.selectedClientID = null;
    }

    private void doDelete() {
        if (this.selectedRow > -1 && this.selectedDurName != null && this.selectedClientID != null) {
            BrokerAdminEvent brokerAdminEvent = new BrokerAdminEvent(this, 5);
            brokerAdminEvent.setDurableName(this.selectedDurName);
            brokerAdminEvent.setClientID(this.selectedClientID);
            brokerAdminEvent.setOKAction(false);
            this.fireAdminEventDispatched(brokerAdminEvent);
        }
    }

    private void doPurge() {
        if (this.selectedRow > -1 && this.selectedDurName != null && this.selectedClientID != null) {
            BrokerAdminEvent brokerAdminEvent = new BrokerAdminEvent(this, 10);
            brokerAdminEvent.setDurableName(this.selectedDurName);
            brokerAdminEvent.setClientID(this.selectedClientID);
            brokerAdminEvent.setOKAction(false);
            this.fireAdminEventDispatched(brokerAdminEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deleteButton) {
            this.doDelete();
        } else if (object == this.purgeButton) {
            this.doPurge();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void checkUnlimited0(SpecialValueField specialValueField, long l) {
        if (this.valueIsUnlimited0(l)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private void checkUnlimitedNeg1(SpecialValueField specialValueField, long l) {
        if (this.valueIsUnlimitedNeg1(l)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private void checkBothUnlimited(SpecialValueField specialValueField, long l) {
        if (this.valueIsUnlimited0(l) || this.valueIsUnlimitedNeg1(l)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private boolean valueIsUnlimited0(long l) {
        return l == 0L;
    }

    private boolean valueIsUnlimitedNeg1(long l) {
        return l == -1L;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (bl) {
            if (listSelectionModel.isSelectionEmpty()) {
                this.deleteButton.setEnabled(false);
                this.purgeButton.setEnabled(false);
            } else {
                this.selectedRow = listSelectionModel.getMinSelectionIndex();
                this.selectedDurName = (String)this.model.getValueAt(this.selectedRow, 0);
                this.selectedClientID = (String)this.model.getValueAt(this.selectedRow, 1);
                this.deleteButton.setEnabled(true);
                this.purgeButton.setEnabled(true);
            }
        }
    }

    private int getLimitBehavValue(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if (string.equals(LIMIT_BEHAV_FLOW_CONTROL)) {
            n = 0;
        } else if (string.equals(LIMIT_BEHAV_RM_OLDEST)) {
            n = 1;
        } else if (string.equals(LIMIT_BEHAV_REJECT_NEWEST)) {
            n = 2;
        } else if (string.equals(LIMIT_BEHAV_RM_LOW_PRIORITY)) {
            n = 3;
        }
        return n;
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[0] = ar.getString("A1430");
        stringArray2[1] = ar.getString("A1431");
        stringArray2[2] = ar.getString("A1432");
        stringArray2[3] = ar.getString("A1433");
        columnNames = stringArray2;
    }

    class PropsTableModel
    extends AbstractTableModel {
        PropsTableModel() {
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            if (BrokerDestPropsDialog.this.durables == null) {
                return 0;
            }
            return BrokerDestPropsDialog.this.durables.size();
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (BrokerDestPropsDialog.this.durables == null) {
                return "";
            }
            int n3 = 0;
            Enumeration enumeration = BrokerDestPropsDialog.this.durables.elements();
            while (enumeration.hasMoreElements()) {
                DurableInfo durableInfo = (DurableInfo)enumeration.nextElement();
                if (n2 == 0 && n3 == n) {
                    return durableInfo.name == null ? "" : durableInfo.name;
                }
                if (n2 == 1 && n3 == n) {
                    return durableInfo.clientID == null ? "" : durableInfo.clientID;
                }
                if (n2 == 2 && n3 == n) {
                    return new Integer(durableInfo.nMessages).toString();
                }
                if (n2 == 3 && n3 == n) {
                    if (durableInfo.isActive) {
                        AdminResources adminResources = ar;
                        ar;
                        return adminResources.getString("A1510");
                    }
                    AdminResources adminResources = ar;
                    ar;
                    return adminResources.getString("A1511");
                }
                ++n3;
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

