/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.apps.objmgr.CmdPreviewer;
import com.sun.messaging.jmq.admin.apps.objmgr.CmdRunner;
import com.sun.messaging.jmq.admin.apps.objmgr.HelpPrinter;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrException;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrOptionParser;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrOptions;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrProperties;
import com.sun.messaging.jmq.admin.apps.objmgr.Utils;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.options.BadNameValueArgException;
import com.sun.messaging.jmq.util.options.InvalidBasePropNameException;
import com.sun.messaging.jmq.util.options.InvalidHardCodedValueException;
import com.sun.messaging.jmq.util.options.MissingArgException;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class ObjMgr
implements ObjMgrOptions {
    public static final String FIRST_VERSION = "2.0";
    public static final String VERSION = "2.0";
    private static final String PROP_NAME_VERSION = "version";
    private static AdminResources ar = Globals.getAdminResources();

    public static void main(String[] stringArray) {
        ObjMgrOptions objMgrOptions;
        Object object;
        int n = 0;
        if (ObjMgr.silentModeOptionSpecified(stringArray)) {
            Globals.setSilentMode(true);
        }
        if (ObjMgr.shortHelpOptionSpecified(stringArray)) {
            object = new HelpPrinter();
            ((HelpPrinter)object).printShortHelp(0);
        } else if (ObjMgr.longHelpOptionSpecified(stringArray)) {
            object = new HelpPrinter();
            ((HelpPrinter)object).printLongHelp();
        }
        if (ObjMgr.versionOptionSpecified(stringArray)) {
            ObjMgr.printBanner();
            ObjMgr.printVersion();
            System.exit(0);
        }
        object = null;
        try {
            object = ObjMgrOptionParser.parseArgs(stringArray);
        }
        catch (OptionException optionException) {
            ObjMgr.handleArgsParsingExceptions(optionException);
        }
        String string = ((ObjMgrProperties)object).getInputFileName();
        if (string != null && !string.equals("")) {
            Object object2;
            objMgrOptions = new ObjMgrProperties();
            try {
                object2 = new FileInputStream(string);
                ((Properties)((Object)objMgrOptions)).load((InputStream)object2);
            }
            catch (IOException iOException) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3080"), false);
                System.err.println(iOException);
                System.exit(1);
            }
            object2 = ObjMgr.getFileVersion((ObjMgrProperties)objMgrOptions);
            if (object2 != null) {
                try {
                    ObjMgr.checkVersion(string, (String)object2, "2.0", "2.0");
                }
                catch (ObjMgrException objMgrException) {
                    Globals.stdErrPrintln(ar.getString("A1001"), objMgrException.getMessage(), false);
                    System.exit(1);
                }
            }
            Enumeration<?> enumeration = ((Properties)object).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (string3 == null || (string2 = ((Properties)object).getProperty(string3)) == null || string3.equals("inputFile")) continue;
                ((Properties)((Object)objMgrOptions)).put(string3, string2);
            }
            object = objMgrOptions;
        }
        object = ObjMgr.trimPropValues((ObjMgrProperties)object);
        try {
            ObjMgr.checkOptions((ObjMgrProperties)object);
        }
        catch (ObjMgrException objMgrException) {
            ObjMgr.handleCheckOptionsExceptions(objMgrException);
        }
        if (((ObjMgrProperties)object).previewModeSet()) {
            objMgrOptions = new CmdPreviewer((ObjMgrProperties)object);
            ((CmdPreviewer)objMgrOptions).previewCommands();
            System.exit(0);
        }
        objMgrOptions = new CmdRunner((ObjMgrProperties)object);
        n = ((CmdRunner)objMgrOptions).runCommands();
        System.exit(n);
    }

    private static void checkOptions(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getCommand();
        if (string == null) {
            ObjMgrException objMgrException = new ObjMgrException(0);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
        if (ObjMgr.readOnlyOptionSpecified(objMgrProperties)) {
            ObjMgr.checkReadOnly(objMgrProperties);
        }
        if (string.equals("add")) {
            ObjMgr.checkAdd(objMgrProperties);
        } else if (string.equals("delete")) {
            ObjMgr.checkDelete(objMgrProperties);
        } else if (string.equals("query")) {
            ObjMgr.checkQuery(objMgrProperties);
        } else if (string.equals("list")) {
            ObjMgr.checkList(objMgrProperties);
        } else if (string.equals("update")) {
            ObjMgr.checkUpdate(objMgrProperties);
        } else {
            ObjMgrException objMgrException = new ObjMgrException(1);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkAdd(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getObjType();
        if (string == null) {
            ObjMgrException objMgrException = new ObjMgrException(2);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
        if (Utils.isDestObjType(string)) {
            ObjMgr.checkAddDestination(objMgrProperties);
        } else if (Utils.isFactoryObjType(string)) {
            ObjMgr.checkAddFactory(objMgrProperties);
        } else {
            ObjMgrException objMgrException = new ObjMgrException(3);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkAddDestination(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getLookupName();
        if (string == null) {
            ObjMgrException objMgrException = new ObjMgrException(4);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkAddFactory(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getLookupName();
        if (string == null) {
            ObjMgrException objMgrException = new ObjMgrException(4);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkDelete(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getLookupName();
        if (string == null) {
            ObjMgrException objMgrException = new ObjMgrException(4);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkQuery(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getLookupName();
        if (string == null) {
            ObjMgrException objMgrException = new ObjMgrException(4);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkList(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getObjType();
        if (string != null && !Utils.isValidObjType(string)) {
            ObjMgrException objMgrException = new ObjMgrException(3);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkUpdate(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getObjType();
        if (string != null && !Utils.isValidObjType(string)) {
            ObjMgrException objMgrException = new ObjMgrException(3);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void checkReadOnly(ObjMgrProperties objMgrProperties) throws ObjMgrException {
        String string = objMgrProperties.getProperty("obj.readOnly");
        if (string.equalsIgnoreCase("t") || string.equalsIgnoreCase(Boolean.TRUE.toString())) {
            string = Boolean.TRUE.toString();
            objMgrProperties.put("obj.readOnly", Boolean.TRUE.toString());
        } else if (string.equalsIgnoreCase("f") || string.equalsIgnoreCase(Boolean.FALSE.toString())) {
            string = Boolean.FALSE.toString();
            objMgrProperties.put("obj.readOnly", Boolean.FALSE.toString());
        }
        if (!string.equalsIgnoreCase(Boolean.TRUE.toString()) && !string.equalsIgnoreCase(Boolean.FALSE.toString())) {
            ObjMgrException objMgrException = new ObjMgrException(6);
            objMgrException.setProperties(objMgrProperties);
            throw objMgrException;
        }
    }

    private static void printBanner() {
        Version version = new Version(false);
        Globals.stdOutPrintln(version.getBanner(false));
    }

    private static boolean shortHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-h") && !stringArray[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-H") && !stringArray[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean readOnlyOptionSpecified(ObjMgrProperties objMgrProperties) {
        String string = objMgrProperties.getProperty("obj.readOnly");
        return string != null;
    }

    private static boolean versionOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-v") && !stringArray[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static void printVersion() {
        Version version = new Version(false);
        Globals.stdOutPrintln(version.getVersion());
        Globals.stdOutPrintln(ar.getString("A1065") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
        Globals.stdOutPrintln(ar.getString("A1066") + System.getProperty("java.class.path"));
    }

    private static void handleArgsParsingExceptions(OptionException optionException) {
        String string = optionException.getOption();
        if (optionException instanceof UnrecognizedOptionException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3001", string, "imqobjmgr"), true);
        } else if (optionException instanceof InvalidBasePropNameException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3002", string), true);
        } else if (optionException instanceof InvalidHardCodedValueException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3003", string), true);
        } else if (optionException instanceof MissingArgException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3004", string, "imqobjmgr"), true);
        } else if (optionException instanceof BadNameValueArgException) {
            BadNameValueArgException badNameValueArgException = (BadNameValueArgException)optionException;
            String string2 = badNameValueArgException.getArg();
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3005", string2, string), true);
        } else {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3000"), true);
        }
    }

    private static void handleCheckOptionsExceptions(ObjMgrException objMgrException) {
        ObjMgrProperties objMgrProperties = objMgrException.getProperties();
        int n = objMgrException.getType();
        switch (n) {
            case 0: {
                ObjMgr.printBanner();
                HelpPrinter helpPrinter = new HelpPrinter();
                helpPrinter.printShortHelp(1);
                break;
            }
            case 1: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3021", objMgrProperties.getCommand()), true);
                break;
            }
            case 2: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3023", "-t"), true);
                break;
            }
            case 3: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3024", objMgrProperties.getObjType()), true);
                break;
            }
            case 6: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3027", objMgrProperties.getProperty("obj.readOnly")), true);
                break;
            }
            case 4: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3025", "-l"), true);
                break;
            }
            case 5: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3026", "-o"), true);
                break;
            }
            default: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3020"), true);
            }
        }
    }

    private static ObjMgrProperties trimPropValues(ObjMgrProperties objMgrProperties) {
        Enumeration<?> enumeration = objMgrProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = objMgrProperties.getProperty(string);
            if (string2 == null || (string2 = string2.trim()) == null) continue;
            objMgrProperties.put(string, string2);
        }
        return objMgrProperties;
    }

    private static String getFileVersion(ObjMgrProperties objMgrProperties) {
        String string = objMgrProperties.getProperty(PROP_NAME_VERSION);
        return string;
    }

    private static void checkVersion(String string, String string2, String string3, String string4) throws ObjMgrException {
        double d;
        double d2;
        double d3;
        try {
            d3 = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            double d4 = 0.0;
            ObjMgrException objMgrException = new ObjMgrException(ar.getKString("A3151", string3));
            throw objMgrException;
        }
        try {
            d2 = Double.parseDouble(string4);
        }
        catch (NumberFormatException numberFormatException) {
            double d5 = 0.0;
            ObjMgrException objMgrException = new ObjMgrException(ar.getKString("A3151", string4));
            throw objMgrException;
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[4];
            double d6 = 0.0;
            objectArray[0] = string;
            objectArray[1] = PROP_NAME_VERSION;
            objectArray[2] = string2;
            objectArray[3] = string3;
            String string5 = ar.getKString("A3152", objectArray);
            ObjMgrException objMgrException = new ObjMgrException(string5);
            throw objMgrException;
        }
        if (d < d2) {
            Object[] objectArray = new Object[]{string, PROP_NAME_VERSION, string2, string3};
            String string6 = ar.getKString("A3153", objectArray);
            ObjMgrException objMgrException = new ObjMgrException(string6);
            throw objMgrException;
        }
        if (d > d3) {
            Object[] objectArray = new Object[]{string, PROP_NAME_VERSION, string2, string3};
            String string7 = ar.getKString("A3153", objectArray);
            ObjMgrException objMgrException = new ObjMgrException(string7);
            throw objMgrException;
        }
    }
}

