/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionWork {
    List<TransactionWorkMessage> sentMessages = new ArrayList<TransactionWorkMessage>();
    List<TransactionWorkMessageAck> messageAcknowledgments;

    public void addMesage(TransactionWorkMessage transactionWorkMessage) {
        if (this.sentMessages == null) {
            this.sentMessages = new ArrayList<TransactionWorkMessage>();
        }
        this.sentMessages.add(transactionWorkMessage);
    }

    public void addMessageAcknowledgement(TransactionWorkMessageAck transactionWorkMessageAck) {
        if (this.messageAcknowledgments == null) {
            this.messageAcknowledgments = new ArrayList<TransactionWorkMessageAck>();
        }
        this.messageAcknowledgments.add(transactionWorkMessageAck);
    }

    public List<TransactionWorkMessage> getSentMessages() {
        return this.sentMessages;
    }

    public void setMessages(List<TransactionWorkMessage> list) {
        this.sentMessages = list;
    }

    public List<TransactionWorkMessageAck> getMessageAcknowledgments() {
        return this.messageAcknowledgments;
    }

    public void setMessageAcknowledgments(List<TransactionWorkMessageAck> list) {
        this.messageAcknowledgments = list;
    }

    public int numSentMessages() {
        if (this.sentMessages == null) {
            return 0;
        }
        return this.sentMessages.size();
    }

    public int numMessageAcknowledgments() {
        if (this.messageAcknowledgments == null) {
            return 0;
        }
        return this.messageAcknowledgments.size();
    }

    public void readWork(DataInputStream dataInputStream) throws IOException, BrokerException {
        Object object;
        int n;
        int n2 = dataInputStream.readInt();
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + "readWork numSentMessages=" + n2);
        }
        ArrayList<TransactionWorkMessage> arrayList = new ArrayList<TransactionWorkMessage>(n2);
        for (n = 0; n < n2; ++n) {
            object = new TransactionWorkMessage();
            ((TransactionWorkMessage)object).readWork(dataInputStream);
            arrayList.add((TransactionWorkMessage)object);
        }
        this.setMessages(arrayList);
        n = dataInputStream.readInt();
        object = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            TransactionWorkMessageAck transactionWorkMessageAck = new TransactionWorkMessageAck();
            transactionWorkMessageAck.readWork(dataInputStream);
            object.add(transactionWorkMessageAck);
        }
        this.setMessageAcknowledgments((List<TransactionWorkMessageAck>)object);
    }

    public void writeWork(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.numSentMessages());
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + "writeWork numSentMessages=" + this.numSentMessages());
        }
        if (this.numSentMessages() > 0) {
            for (TransactionWorkMessage object : this.getSentMessages()) {
                object.writeWork(dataOutputStream);
            }
        }
        dataOutputStream.writeInt(this.numMessageAcknowledgments());
        if (this.numMessageAcknowledgments() > 0) {
            for (TransactionWorkMessageAck transactionWorkMessageAck : this.getMessageAcknowledgments()) {
                transactionWorkMessageAck.writeWork(dataOutputStream);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" num messages ").append(this.numSentMessages());
        stringBuffer.append(" num acks ").append(this.numMessageAcknowledgments());
        String string = super.toString() + new String(stringBuffer);
        return string;
    }

    String getPrefix() {
        return "TransactionWork: " + Thread.currentThread().getName();
    }
}

