/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class GetBrokerPropsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetBrokerPropsHandler.getDEBUG();

    public GetBrokerPropsHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        ClusteredBroker clusteredBroker;
        int n = 200;
        String string = null;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + hashtable);
        }
        Properties properties = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        properties.putAll((Map<?, ?>)version.getProps());
        try {
            this.addLicenseInfo(properties);
        }
        catch (Exception exception) {
            this.logger.log(16, "B4257", (Throwable)exception);
        }
        properties.put("imq.system.current_count", String.valueOf(Destination.totalCount()));
        properties.put("imq.system.current_size", String.valueOf(Destination.totalBytes()));
        properties.put("imq.dmq.current_count", String.valueOf(Destination.getDMQ().size()));
        properties.put("imq.dmq.current_size", String.valueOf(Destination.getDMQ().byteSize()));
        if (Globals.getBrokerID() != null) {
            properties.put("imq.brokerid", Globals.getBrokerID());
        }
        if (Globals.getClusterID() != null) {
            properties.put("imq.cluster.clusterid", Globals.getClusterID());
        }
        properties.put("imq.embedded", Boolean.toString(Broker.isInProcess()));
        ClusterManager clusterManager = Globals.getClusterManager();
        String string2 = null;
        Iterator iterator = clusterManager.getConfigBrokers();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            clusteredBroker = (ClusteredBroker)iterator.next();
            hashSet.add(clusteredBroker.getBrokerURL().toString());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (string2 == null) {
                string2 = iterator.next().toString();
                continue;
            }
            string2 = string2 + "," + iterator.next().toString();
        }
        if (string2 == null) {
            string2 = "";
        }
        properties.put("imq.cluster.brokerlist", string2);
        string2 = null;
        hashSet = new HashSet();
        iterator = clusterManager.getActiveBrokers();
        while (iterator.hasNext()) {
            clusteredBroker = (ClusteredBroker)iterator.next();
            hashSet.add(clusteredBroker.getBrokerURL().toString());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (string2 == null) {
                string2 = iterator.next().toString();
                continue;
            }
            string2 = string2 + "," + iterator.next().toString();
        }
        if (string2 == null) {
            string2 = "";
        }
        properties.put("imq.cluster.brokerlist.active", string2);
        clusteredBroker = new Packet(iMQConnection.useDirectBuffers());
        clusteredBroker.setPacketType(5);
        GetBrokerPropsHandler.setProperties((Packet)clusteredBroker, 55, n, string);
        this.setBodyObject((Packet)clusteredBroker, properties);
        this.parent.sendReply(iMQConnection, packet, (Packet)clusteredBroker);
        return true;
    }

    private void addLicenseInfo(Properties properties) throws BrokerException {
        LicenseBase licenseBase = null;
        licenseBase = Globals.getCurrentLicense(null);
        properties.put("imq.license.description", licenseBase.getProperty("description"));
    }
}

