/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.KeyNotFoundException;
import com.sun.messaging.bridge.service.UpdateOpaqueDataCallback;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.PHashMapMMF;
import com.sun.messaging.jmq.util.SizeString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTxLogImpl
extends TxLog {
    private static final String _type = "file";
    private static final String FILENAME_BASE = "txlog";
    private static final String FILENAME_JMSBRIDGES = "jmsbridges.list";
    private static final boolean DEFAULT_TXLOG_USE_MMAPPED_FILE = true;
    private static final long DEFAULT_TXLOG_SIZE = 1024000L;
    private long _logsize = 1024000L;
    private String _txlogdir = null;
    private String _txlogdirParent = null;
    private String _logsuffix = null;
    private File _backFile = null;
    private boolean _useMmappedFile = true;
    private PHashMap _gxidMap = null;
    private boolean _sync = false;
    private static final int DEFAULT_CLIENTDATA_SIZE = 16;
    private int _clientDataSize = 16;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    @Override
    public String getType() {
        return _type;
    }

    public void setMaxBranches(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maximum branches " + n);
        }
        this._clientDataSize = n;
    }

    public void setUseMmap(boolean bl) {
        this._useMmappedFile = bl;
    }

    public void setSync(boolean bl) {
        this._sync = bl;
    }

    public void setTxlogSuffix(String string) {
        this._logsuffix = string;
    }

    public void setTxlogSize(String string) throws Exception {
        SizeString sizeString = new SizeString(string);
        if (sizeString.getBytes() <= 0L) {
            throw new IllegalArgumentException("Illegal txlog file size " + string);
        }
        this._logsize = sizeString.getBytes();
    }

    public void setTxlogDir(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid txlog directory " + string);
        }
        String string2 = string.trim();
        File file = new File(string2);
        if (!file.exists()) {
            throw new IllegalArgumentException("txlog directory " + string2 + " not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("" + string2 + " not a directory for txnlog");
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("txlog directory " + string2 + " not writable");
        }
        this._txlogdir = string2;
    }

    public void setTxlogDirParent(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid txlogDirParent directory " + string);
        }
        String string2 = string.trim();
        File file = new File(string2);
        if (!file.exists()) {
            throw new IllegalArgumentException("txlogDirParent directory " + string2 + " not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("" + string2 + " not a directory for txnlogDirParent");
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("txlogDirParent directory " + string2 + " not writable");
        }
        this._txlogdirParent = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logGlobalDecision(LogRecord logRecord) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: log global decision  " + logRecord);
        }
        String string = logRecord.getGlobalXid().toString();
        super.checkClosedAndSetInProgress();
        try {
            Object object = this._gxidMap.putIfAbsent((Object)string, (Object)logRecord);
            if (object != null) {
                String string2 = string + " already exist in txlog: " + object;
                this._logger.log(Level.SEVERE, string2);
                throw new IllegalStateException(string2);
            }
            if (this._sync) {
                this._gxidMap.force((Object)string);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public LogRecord getLogRecord(GlobalXid globalXid) throws Exception {
        return this.getLogRecord(globalXid.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord getLogRecord(String string) throws Exception {
        String string2 = string;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: get txlog log record: " + string2);
        }
        super.checkClosedAndSetInProgress();
        try {
            LogRecord logRecord;
            LogRecord logRecord2 = logRecord = (LogRecord)this._gxidMap.get((Object)string2);
            return logRecord2;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logHeuristicBranch(BranchXid branchXid, LogRecord logRecord) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: log branch heuristic decision  " + logRecord);
        }
        String string = logRecord.getGlobalXid().toString();
        super.checkClosedAndSetInProgress();
        try {
            LogRecord logRecord2 = (LogRecord)this._gxidMap.get((Object)string);
            if (logRecord2 == null) {
                this.logGlobalDecision(logRecord);
                if (this._sync) {
                    this._gxidMap.force((Object)string);
                }
                return;
            }
            if (logRecord2.getBranchDecision(branchXid) == logRecord.getBranchDecision(branchXid)) {
                return;
            }
            logRecord2.setBranchDecision(branchXid, logRecord.getBranchDecision(branchXid));
            if (this._useMmappedFile) {
                if (logRecord2.getBranchCount() > this._clientDataSize) {
                    throw new IllegalArgumentException("The number of branches exceeded maximum " + this._clientDataSize + " allowed");
                }
                byte[] byArray = ((PHashMapMMF)this._gxidMap).getClientData((Object)string);
                logRecord2.updateClientDataFromBranch(byArray, branchXid);
                ((PHashMapMMF)this._gxidMap).putClientData((Object)string, byArray);
            } else {
                this._gxidMap.put((Object)string, (Object)logRecord2);
            }
            if (this._sync) {
                this._gxidMap.force((Object)string);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reap(String string) throws Exception {
        String string2 = string;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: Remove " + string2);
        }
        super.checkClosedAndSetInProgress();
        try {
            Object object = this._gxidMap.remove((Object)string2);
            if (object == null) {
                String string3 = string + " not found in txlog";
                this._logger.log(Level.SEVERE, string3);
                throw new IllegalArgumentException(string3);
            }
            if (this._sync) {
                this._gxidMap.force((Object)string2);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogRecord> getAllLogRecords() throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: get all log records");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>(this._gxidMap.size());
            Iterator iterator = this._gxidMap.entrySet().iterator();
            Map.Entry entry = null;
            LogRecord logRecord = null;
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                logRecord = (LogRecord)entry.getValue();
                arrayList.add(logRecord);
            }
            ArrayList<LogRecord> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllLogRecordKeys() throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: get all log record keys");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList = new ArrayList<String>(this._gxidMap.keySet());
            return arrayList2;
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public void init(Properties properties, boolean bl) throws Exception {
        Object object;
        Object object2;
        if (this._logger == null) {
            throw new IllegalStateException("No logger set");
        }
        super.init(properties, bl);
        if (properties != null) {
            object2 = properties.propertyNames();
            object = null;
            String string = null;
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string = properties.getProperty((String)object);
                this._logger.log(Level.INFO, _jbr.getString("BSJ1058", (String)object + "=" + string, this._tmname));
                this.setProperty((String)object, string);
            }
        }
        if (this._txlogdir == null) {
            throw new IllegalStateException("Property txlogDir not set");
        }
        Object object3 = object2 = this._logsuffix == null ? FILENAME_BASE : "txlog." + this._logsuffix;
        if (bl) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1059", object2));
            if (this._txlogdirParent != null && ((File)(object = new File(this._txlogdirParent + File.separator + FILENAME_JMSBRIDGES))).exists()) {
                ((File)object).delete();
            }
        } else {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1060", object2));
        }
        this._backFile = new File(this._txlogdir, (String)object2);
        if (this._useMmappedFile) {
            this._gxidMap = new PHashMapMMF(this._backFile, this._logsize, 1024, false, bl);
            ((PHashMapMMF)this._gxidMap).intClientData(this._clientDataSize);
        } else {
            this._gxidMap = new PHashMap(this._backFile, this._logsize, 1024, false, bl);
        }
        try {
            this._gxidMap.load();
            if (this._clientDataSize > 0) {
                this.loadClientData();
            }
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this._logger.log(Level.WARNING, "Exception in loading txlog " + this._backFile, pHashMapLoadException);
            throw pHashMapLoadException;
        }
        object = this._gxidMap.getWarning();
        if (object != null) {
            this._logger.log(Level.WARNING, "Warning in loading txlog, possible loss of record", (Throwable)object);
        }
        this._logger.log(Level.INFO, _jbr.getString("BSJ1061", this._backFile, String.valueOf(this._gxidMap.size())));
    }

    private void setProperty(String string, String string2) throws Exception {
        if (string.equals("txlogDir")) {
            this.setTxlogDir(string2);
            return;
        }
        if (string.equals("txlogSuffix")) {
            this.setTxlogSuffix(string2);
            return;
        }
        if (string.equals("txlogSize")) {
            this.setTxlogSize(string2);
            return;
        }
        if (string.equals("txlogSync")) {
            this.setSync(Boolean.valueOf(string2));
            return;
        }
        if (string.equals("txlogMmap")) {
            this.setUseMmap(Boolean.valueOf(string2));
            return;
        }
        if (string.equals("txlogMaxBranches")) {
            this.setMaxBranches(Integer.valueOf(string2));
            return;
        }
        if (string.equals("txlogDirParent")) {
            this.setTxlogDirParent(string2);
            return;
        }
    }

    private void loadClientData() throws PHashMapLoadException {
        if (!this._useMmappedFile) {
            return;
        }
        PHashMapLoadException pHashMapLoadException = null;
        Iterator iterator = this._gxidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Throwable throwable = null;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            LogRecord logRecord = (LogRecord)entry.getValue();
            int n = logRecord.getBranchCount();
            if (n <= 0) continue;
            byte[] byArray = null;
            try {
                byArray = ((PHashMapMMF)this._gxidMap).getClientData(k);
                if (byArray != null && byArray.length > 0) {
                    logRecord.updateBranchFromClientData(byArray);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable == null) continue;
            PHashMapLoadException pHashMapLoadException2 = new PHashMapLoadException("Failed to load client data [cdata=" + byArray + "]");
            pHashMapLoadException2.setKey(k);
            pHashMapLoadException2.setValue((Object)logRecord);
            pHashMapLoadException2.setNextException(pHashMapLoadException);
            pHashMapLoadException2.initCause(throwable);
            pHashMapLoadException = pHashMapLoadException2;
        }
        if (pHashMapLoadException != null) {
            throw pHashMapLoadException;
        }
    }

    @Override
    public void close() throws Exception {
        this._logger.log(Level.INFO, _jbr.getString("BSJ1062", this._backFile, String.valueOf(this._gxidMap.size())));
        super.setClosedAndWait();
        super.close();
        if (this._gxidMap != null) {
            this._gxidMap.close();
        }
    }

    public void storeTMLogRecord(String string, byte[] byArray, String string2, boolean bl, Logger logger) throws DupKeyException, Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        LogRecord logRecord = (LogRecord)objectInputStream.readObject();
        this.logGlobalDecision(logRecord);
    }

    public void updateTMLogRecord(String string, byte[] byArray, String string2, UpdateOpaqueDataCallback updateOpaqueDataCallback, boolean bl, boolean bl2, Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("updateTMLogRecord");
    }

    public void removeTMLogRecord(String string, String string2, boolean bl, Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("removeTMLogRecord");
    }

    public byte[] getTMLogRecord(String string, String string2, Logger logger) throws Exception {
        LogRecord logRecord = this.getLogRecord(string);
        if (logRecord != null) {
            return logRecord.toBytes();
        }
        return null;
    }

    public long getTMLogRecordUpdatedTime(String string, String string2, Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("getTMLogRecordUpdatedTime");
    }

    public long getTMLogRecordCreatedTime(String string, String string2, Logger logger) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        throw new UnsupportedOperationException("getTMLogRecordCreatedTime");
    }

    public List getTMLogRecordsByName(String string, Logger logger) throws Exception {
        throw new UnsupportedOperationException("getTMLogRecordsByName");
    }

    public List<String> getTMLogRecordKeysByName(String string, Logger logger) throws Exception {
        if (this._jmsbridge.equals(string)) {
            throw new IllegalArgumentException("Unexpected jmsbridge name " + string + " expected " + this._jmsbridge);
        }
        return this.getAllLogRecordKeys();
    }

    public void addJMSBridge(String string, boolean bl, Logger logger) throws DupKeyException, Exception {
        if (this._txlogdirParent == null) {
            throw new UnsupportedOperationException("addJMSBridge: txlogDirParent property not available");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this._txlogdirParent + File.separator + FILENAME_JMSBRIDGES, true);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
        fileOutputStream.getChannel().force(true);
        fileOutputStream.close();
    }

    public List getJMSBridges(Logger logger) throws Exception {
        if (this._txlogdirParent == null) {
            throw new UnsupportedOperationException("getJMSBridges: txlogDirParent property not available");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        FileInputStream fileInputStream = new FileInputStream(this._txlogdirParent + File.separator + FILENAME_JMSBRIDGES);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        fileInputStream.close();
        return arrayList;
    }

    public long getJMSBridgeUpdatedTime(String string, Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("addJMSBridge");
    }

    public long getJMSBridgeCreatedTime(String string, Logger logger) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("addJMSBridge");
    }

    public void closeJMSBridgeStore() throws Exception {
        this.close();
    }
}

