/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.admin.jmsspi.JMSAdminFactoryImpl;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSSecurityException;

public class LocalBrokerRunner {
    private JMSAdmin jmsadmin = null;
    private JMSAdmin tjmsadmin = null;
    private String adminUsername;
    private String adminPassFile;
    String[] brokerArgs;
    String brokerBinDir;
    String brokerVarDir;
    String brokerInstanceName;
    String brokerLogFilename;
    int brokerStartTimeout;
    private boolean startedByAS = false;
    private boolean startingRMIRegistry = false;
    private String brokerURL;
    private static final transient String _className = "com.sun.messaging.jms.ra.LocalBrokerRunner";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_LB";
    protected static final transient String _lgrMID_EET = "MQJMSRA_LB1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_LB1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_LB2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_LB3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_LB4001: ";

    public LocalBrokerRunner(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, boolean bl, int n2, boolean bl2, boolean bl3, int n3, String string8, String string9, String string10, Properties properties) throws Exception {
        String string11;
        Object object;
        Object[] objectArray = new Object[]{string, string2, Integer.toString(n), string3, string4, string5, string6, string7, new Boolean(bl), new Integer(n2), new Boolean(bl2), new Boolean(bl3), string8, string10, properties};
        this.adminUsername = string8;
        _loggerL.entering(_className, "constructor()", objectArray);
        this.brokerURL = (string2 == null ? "localhost" : string2) + ":" + n;
        this.jmsadmin = new JMSAdminFactoryImpl().getJMSAdmin(this.brokerURL, string8, string9);
        this.tjmsadmin = new JMSAdminFactoryImpl().getJMSAdmin(this.brokerURL, "admin", "admin");
        LocalBrokerRunner.checkVersion(this.jmsadmin);
        this.brokerStartTimeout = n3;
        Vector<String> vector = new Vector<String>();
        if (string6 != null) {
            vector.add("-javahome");
            vector.add(string6);
        }
        if (string7 != null && !"".equals(string7)) {
            object = new StringTokenizer(string7, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string11 = ((StringTokenizer)object).nextToken();
                vector.add(string11);
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (object == null || (string11 = properties.getProperty((String)object)) == null) continue;
            vector.add("-D" + (String)object + "=" + string11);
        }
        this.brokerInstanceName = string;
        this.brokerBinDir = string3 + File.separator + "bin";
        this.brokerVarDir = string5;
        this.brokerLogFilename = string5 + File.separator + "instances" + File.separator + string + File.separator + "log" + File.separator + "log.txt";
        this.startedByAS = false;
        this.startingRMIRegistry = false;
        if (string5 != null) {
            vector.add("-varhome");
            vector.add(string5);
        }
        if (bl) {
            if (bl2) {
                vector.add("-startRmiRegistry");
                this.startingRMIRegistry = true;
            } else {
                vector.add("-useRmiRegistry");
                this.startingRMIRegistry = false;
            }
            vector.add("-rmiRegistryPort");
            vector.add(Integer.toString(n2));
        }
        if (string10 != null && !"".equals(string10) && string8 != null && !"".equals(string8)) {
            vector.add("-Dimq.imqcmd.user=" + string8);
            vector.add("-passfile");
            vector.add(string10);
            this.adminPassFile = string10;
        }
        if (string2 != null && !"localhost".equals(string2)) {
            vector.add("-Dimq.hostname=" + string2);
        }
        vector.add("-save");
        this.brokerArgs = vector.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void start() throws Exception {
        boolean bl;
        block18: {
            _loggerL.entering(_className, "start()");
            bl = false;
            String string = null;
            if (this.startingRMIRegistry) {
                _loggerL.info("MQJMSRA_LB1101: Looking for Broker Running at:" + this.brokerURL);
                try {
                    this.jmsadmin.pingProvider();
                    _loggerL.info("MQJMSRA_LB1101: Detected Broker Running at:" + this.brokerURL);
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) {
                    this.startedByAS = false;
                    try {
                        this.jmsadmin.connectToProvider();
                        string = this.jmsadmin.getProviderVarHome();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    _loggerL.info("MQJMSRA_LB1101: Detected Broker VAR directory=" + string);
                    if (string != null && !"".equals(string) && string.equals(this.brokerVarDir)) {
                        this.startedByAS = true;
                        break block18;
                    } else {
                        String string2 = "MQJMSRA_LB4001: start:Broker running at:" + this.brokerURL + " has a different var directory of:" + string + ":Failing ra.start()";
                        _loggerL.severe(string2);
                        throw new Exception(string2);
                    }
                }
                this.jmsadmin.startProvider(this.brokerBinDir, this.brokerArgs, this.brokerInstanceName);
                this.startedByAS = true;
            } else {
                this.jmsadmin.startProvider(this.brokerBinDir, this.brokerArgs, this.brokerInstanceName);
                this.startedByAS = true;
            }
        }
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        while (true) {
            try {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) {
                    this.jmsadmin.connectToProvider();
                }
                bl2 = true;
            }
            catch (JMSSecurityException jMSSecurityException) {
                Exception exception = new Exception("MQJMSRA_LB4001: start:Unable to ping Broker due to authentication error for user " + this.adminUsername + " : shutting down broker.");
                exception.initCause(jMSSecurityException);
                try {
                    this.tjmsadmin.connectToProvider();
                    this.tjmsadmin.shutdownProvider();
                    throw exception;
                }
                catch (Exception exception2) {
                    _loggerL.warning("MQJMSRA_LB4001: start:Exception on LOCAL broker shutdown after connect auth failure:msg=" + exception2.getMessage());
                }
                throw exception;
            }
            catch (Exception exception) {
                if (System.currentTimeMillis() - l < (long)this.brokerStartTimeout) continue;
                _loggerL.severe("MQJMSRA_LB4001: start:Ping broker failed " + (System.currentTimeMillis() - l) + " millis after broker start performed. Failing ra.start()");
                _loggerL.warning("MQJMSRA_LB4001: start:Aborting:Check Broker Log File at:" + this.brokerLogFilename);
                if (this.adminPassFile == null) break;
                _loggerL.warning("MQJMSRA_LB4001: start:Aborting:Check Broker Password File at:" + this.adminPassFile);
            }
            break;
        }
        if (bl2) return;
        throw new RuntimeException("MQJMSRA_LB4001: start:Aborted:Unable to ping Broker within " + this.brokerStartTimeout + " millis (startTimeOut)");
    }

    protected synchronized void stop() {
        block4: {
            _loggerL.entering(_className, "stop()");
            if (this.jmsadmin != null) {
                if (!this.startedByAS) {
                    _loggerL.warning("MQJMSRA_LB2001: stop:Skipping LOCAL broker shutdown:Broker not started by App Server");
                    return;
                }
                try {
                    this.jmsadmin.shutdownProvider();
                }
                catch (Exception exception) {
                    _loggerL.warning("MQJMSRA_LB4001: stop:Exception on LOCAL broker shutdown:msg=" + exception.getMessage());
                    if (!_loggerL.isLoggable(Level.FINER)) break block4;
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void checkVersion(JMSAdmin jMSAdmin) {
        float f = 0.0f;
        String string = "?.?";
        try {
            string = jMSAdmin.getVersion();
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while parsing SJSMQ SPI version string (" + string + ").");
        }
        if ((double)f < 2.0 || (double)f >= 3.0) {
            throw new RuntimeException("Incorrect SJSMQ SPI version detected (" + string + ").");
        }
    }
}

