/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DeleteAllMessages;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.Filter;
import java.util.Hashtable;

public class PurgeDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PurgeDestinationHandler.getDEBUG();
    private Filter deleteAll = new DeleteAllMessages();

    public PurgeDestinationHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        String string;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Purging: " + hashtable);
        }
        assert (hashtable != null);
        String string2 = (String)hashtable.get("JMQDestination");
        Integer n = (Integer)hashtable.get("JMQDestType");
        assert (string2 != null);
        assert (n != null);
        int n2 = 200;
        String string3 = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n2 = 500;
            string3 = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string3);
        } else {
            string = Globals.getBrokerResources().getKString("B1035");
            this.logger.log(8, "B1034", (Object)string2, (Object)string);
            try {
                Destination destination = Destination.getDestination(string2, DestType.isQueue((int)n));
                if (destination == null) {
                    string3 = Globals.getBrokerResources().getKString("B3128", this.getDestinationType(n), string2);
                    BrokerException brokerException = new BrokerException(string3);
                    brokerException.fillInStackTrace();
                    n2 = 500;
                    this.logger.log(16, "B2025", (Throwable)brokerException);
                } else {
                    Globals.getAuditSession().destinationOperation(iMQConnection.getUserName(), iMQConnection.remoteHostString(), "purge destination", destination.isQueue() ? "queue" : "topic", destination.getDestinationName());
                    destination.purgeDestination();
                }
            }
            catch (BrokerException brokerException) {
                n2 = 500;
                string3 = PurgeDestinationHandler.getMessageFromException(brokerException);
                this.logger.log(16, "B2025", (Throwable)brokerException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                n2 = 500;
                string3 = Globals.getBrokerResources().getString("B4117", throwable);
                this.logger.log(16, "B2025", throwable);
            }
        }
        string = new Packet(iMQConnection.useDirectBuffers());
        string.setPacketType(5);
        PurgeDestinationHandler.setProperties((Packet)string, 33, n2, string3);
        this.parent.sendReply(iMQConnection, packet, (Packet)string);
        return true;
    }
}

