/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class DestinationConfig
extends MQMBeanReadWrite {
    private Destination d = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] pauseSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationConfig(Destination destination) {
        this.d = destination;
    }

    public void setConsumerFlowLimit(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "ConsumerFlowLimit");
            this.d.setMaxPrefetch(l.intValue());
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("ConsumerFlowLimit", exception);
        }
    }

    public Long getConsumerFlowLimit() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return new Long(destinationInfo.maxPrefetch);
    }

    public Boolean getLocalOnly() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo.isDestinationLocal()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLocalOnly() {
        return this.getLocalOnly();
    }

    public void setLimitBehavior(String string) throws MBeanException {
        try {
            this.checkLimitBehavior(string);
            this.d.setLimitBehavior(DestinationUtil.toInternalDestLimitBehavior(string));
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("LimitBehavior", exception);
        }
    }

    public String getLimitBehavior() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return DestinationUtil.toExternalDestLimitBehavior(destinationInfo.destLimitBehavior);
    }

    private void checkLimitBehavior(String string) throws InvalidAttributeValueException {
        if (string.equals("FLOW_CONTROL") || string.equals("REMOVE_OLDEST") || string.equals("REJECT_NEWEST") || string.equals("REMOVE_LOW_PRIORITY")) {
            return;
        }
        throw new InvalidAttributeValueException("Invalid value for Destination LimitBehavior specified: " + string);
    }

    public void setLocalDeliveryPreferred(Boolean bl) throws MBeanException {
        try {
            int n = bl != false ? 1 : 2;
            this.d.setClusterDeliveryPolicy(n);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("LocalDeliveryPreferred", exception);
        }
    }

    public Boolean getLocalDeliveryPreferred() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo.destCDP == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setMaxBytesPerMsg(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "MaxBytesPerMsg");
            SizeString sizeString = new SizeString();
            sizeString.setBytes(l.longValue());
            this.d.setMaxByteSize(sizeString);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("MaxBytesPerMsg", exception);
        }
    }

    public Long getMaxBytesPerMsg() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return this.checkLongUnlimitedZero(new Long(destinationInfo.maxMessageSize));
    }

    public void setMaxNumActiveConsumers(Integer n) throws MBeanException {
        try {
            this.checkIntNegOneAndUp(n, "MaxNumActiveConsumers");
            this.d.setMaxActiveConsumers(n);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("MaxNumActiveConsumers", exception);
        }
    }

    public Integer getMaxNumActiveConsumers() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return new Integer(destinationInfo.maxActiveConsumers);
    }

    public void setMaxNumBackupConsumers(Integer n) throws MBeanException {
        try {
            this.checkIntNegOneAndUp(n, "MaxNumBackupConsumers");
            this.d.setMaxFailoverConsumers(n);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("MaxNumBackupConsumers", exception);
        }
    }

    public Integer getMaxNumBackupConsumers() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return new Integer(destinationInfo.maxFailoverConsumers);
    }

    public void setMaxNumMsgs(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "MaxNumMsgs");
            this.d.setCapacity(l.intValue());
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("MaxNumMsgs", exception);
        }
    }

    public Long getMaxNumMsgs() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return this.checkLongUnlimitedZero(new Long(destinationInfo.maxMessages));
    }

    public void setMaxNumProducers(Integer n) throws MBeanException {
        try {
            this.checkIntNegOneAndUp(n, "MaxNumProducers");
            this.d.setMaxProducers(n);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("MaxNumProducers", exception);
        }
    }

    public Integer getMaxNumProducers() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return new Integer(destinationInfo.maxProducers);
    }

    public void setMaxTotalMsgBytes(Long l) throws MBeanException {
        try {
            this.checkLongNegOneAndUp(l, "MaxTotalMsgBytes");
            SizeString sizeString = new SizeString();
            sizeString.setBytes(l.longValue());
            this.d.setByteCapacity(sizeString);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("MaxTotalMsgBytes", exception);
        }
    }

    public Long getMaxTotalMsgBytes() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return this.checkLongUnlimitedZero(new Long(destinationInfo.maxMessageBytes));
    }

    public String getName() {
        return this.d.getDestinationName();
    }

    public String getType() {
        return this.d.isQueue() ? "q" : "t";
    }

    public void setUseDMQ(Boolean bl) throws MBeanException {
        try {
            this.d.setUseDMQ(bl);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("UseDMQ", exception);
        }
    }

    public Boolean getUseDMQ() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        return destinationInfo.useDMQ;
    }

    public void setValidateXMLSchemaEnabled(Boolean bl) throws MBeanException {
        try {
            this.d.setValidateXMLSchemaEnabled(bl);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("ValidateXMLSchemaEnabled", exception);
        }
    }

    public Boolean getValidateXMLSchemaEnabled() {
        return this.d.validateXMLSchemaEnabled();
    }

    public void setXMLSchemaURIList(String string) throws MBeanException {
        try {
            this.d.setXMLSchemaUriList(string);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("XMLSchemaURIList", exception);
        }
    }

    public String getXMLSchemaURIList() {
        return this.d.getXMLSchemaUriList();
    }

    public void setReloadXMLSchemaOnFailure(Boolean bl) throws MBeanException {
        try {
            this.d.setReloadXMLSchemaOnFailure(bl);
            this.d.update();
        }
        catch (Exception exception) {
            this.handleSetterException("ReloadXMLSchemaOnFailure", exception);
        }
    }

    public Boolean getReloadXMLSchemaOnFailure() {
        return this.d.reloadXMLSchemaOnFailure();
    }

    public void compact() throws MBeanException {
        try {
            if (!this.d.isPaused()) {
                String string = rb.getString("B3134");
                String string2 = rb.getString("B4161", this.getName(), string);
                throw new BrokerException(string2);
            }
            this.d.compact();
        }
        catch (Exception exception) {
            this.handleOperationException("compact", exception);
        }
    }

    public void pause() throws MBeanException {
        this.pause("ALL");
    }

    public void pause(String string) throws MBeanException {
        try {
            DestinationUtil.checkPauseType(string);
            this.logger.log(8, "B1249", (Object)(this.getType() + ":" + this.getName()), (Object)string);
            int n = DestinationUtil.toInternalPauseType(string);
            this.d.pauseDestination(n);
        }
        catch (Exception exception) {
            this.handleOperationException("pause", exception);
        }
    }

    public void purge() throws MBeanException {
        try {
            String string = Globals.getBrokerResources().getKString("B1035");
            this.logger.log(8, "B1034", (Object)this.getName(), (Object)string);
            this.d.purgeDestination();
        }
        catch (Exception exception) {
            this.handleOperationException("purge", exception);
        }
    }

    public void resume() throws MBeanException {
        try {
            this.logger.log(8, "B1129", (Object)this.getName());
            this.d.resumeDestination();
        }
        catch (Exception exception) {
            this.handleOperationException("resume", exception);
        }
    }

    public String getMBeanName() {
        return "DestinationConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1076");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationAttrUpdated(int n, Object object, Object object2) {
        String string = DestinationUtil.getAttrNameFromDestinationInfoAttr(n);
        if (string != null) {
            this.notifyAttrChange(string, object2, object);
        } else {
            this.logger.log(16, this.getMBeanDescription() + ": Unknown attribute updated in destination " + this.d.toString());
        }
    }

    private Long checkLongUnlimitedZero(Long l) {
        if (l == 0L) {
            return new Long(-1L);
        }
        return l;
    }

    private void checkLongNegOneAndUp(Long l, String string) throws InvalidAttributeValueException {
        if (l >= -1L) {
            return;
        }
        throw new InvalidAttributeValueException("Invalid value for attribute " + string + ": " + l + ". Please use a positive number or -1");
    }

    private void checkIntNegOneAndUp(Integer n, String string) throws InvalidAttributeValueException {
        if (n >= -1) {
            return;
        }
        throw new InvalidAttributeValueException("Invalid value for attribute " + string + ": " + n + ". Please use a positive number or -1");
    }

    private void notifyAttrChange(String string, Object object, Object object2) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", string, object.getClass().getName(), object2, object));
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[16];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ConsumerFlowLimit", Long.class.getName(), mbr.getString("MB1077"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("LocalOnly", Boolean.class.getName(), mbr.getString("MB1078"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("LimitBehavior", String.class.getName(), mbr.getString("MB1079"), true, true, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("LocalDeliveryPreferred", Boolean.class.getName(), mbr.getString("MB1080"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("MaxBytesPerMsg", Long.class.getName(), mbr.getString("MB1081"), true, true, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("MaxNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1082"), true, true, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("MaxNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1083"), true, true, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("MaxNumMsgs", Long.class.getName(), mbr.getString("MB1084"), true, true, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("MaxNumProducers", Integer.class.getName(), mbr.getString("MB1085"), true, true, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("MaxTotalMsgBytes", Long.class.getName(), mbr.getString("MB1086"), true, true, false);
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1087"), true, false, false);
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("Type", String.class.getName(), mbr.getString("MB1088"), true, false, false);
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("UseDMQ", Boolean.class.getName(), mbr.getString("MB1089"), true, true, false);
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("ValidateXMLSchemaEnabled", Boolean.class.getName(), mbr.getString("MB1259"), true, true, false);
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("XMLSchemaURIList", String.class.getName(), mbr.getString("MB1260"), true, true, false);
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("ReloadXMLSchemaOnFailure", Boolean.class.getName(), mbr.getString("MB1261"), true, true, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("pauseType", String.class.getName(), mbr.getString("MB1125"));
        pauseSignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("compact", mbr.getString("MB1122"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("pause", mbr.getString("MB1123"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("pause", mbr.getString("MB1124"), pauseSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("purge", mbr.getString("MB1126"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("resume", mbr.getString("MB1127"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

