/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionFactoryAdapter;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.DirectConnectionFactory;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.Util;
import com.sun.messaging.jms.ra.util.CustomTokenizer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class ManagedConnectionFactory
implements javax.resource.spi.ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable {
    private ResourceAdapter ra = null;
    private XAConnectionFactory xacf = null;
    private String addressList = null;
    private String userName = null;
    private String password = null;
    private String clientId = null;
    private boolean useSharedSubscriptionsInClusteredContainer = true;
    private boolean enableRADirect = false;
    private boolean enableAPIDirect = false;
    private boolean reconnectEnabled = false;
    private boolean reconnectEnabledSet = false;
    private int reconnectInterval = -1;
    private int reconnectAttempts = -1;
    private String addressListBehavior = null;
    private int addressListIterations = -1;
    private String options = null;
    private transient PrintWriter logWriter = null;
    private transient int mcfId = 0;
    private static int idCounter = 0;
    private ConnectionCreator connectionCreator = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.ManagedConnectionFactory";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_MF";
    protected static final transient String _lgrMID_EET = "MQJMSRA_MF1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_MF1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_MF2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_MF3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_MF4001: ";

    public ManagedConnectionFactory() {
        _loggerOC.entering(_className, "constructor()");
        this.ra = null;
        this.logWriter = null;
        this.xacf = new XAConnectionFactory();
        this.mcfId = ++idCounter;
        _loggerOC.exiting(_className, "constructor()", ":Id=" + this.mcfId + ":config=" + this.toString());
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) {
        _loggerOC.entering(_className, "createConnectionFactory()", connectionManager);
        this.connectionCreator = this.ra._isRADirectAllowed() && this.getEnableRADirect() ? new DirectConnectionFactory(this, connectionManager) : (this.ra._isRADirect() && this.getEnableRADirect() ? new DirectConnectionFactory(this, connectionManager) : new ConnectionFactoryAdapter(this, connectionManager));
        return this.connectionCreator;
    }

    public Object createConnectionFactory() {
        _loggerOC.entering(_className, "createConnectionFactory()");
        return this.createConnectionFactory(ResourceAdapter._getConnectionManager());
    }

    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, javax.resource.spi.ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object[] objectArray = new Object[]{subject, connectionRequestInfo};
        _loggerOC.entering(_className, "createManagedConnection()", objectArray);
        if (this.connectionCreator == null) {
            ManagedConnectionFactory managedConnectionFactory = this;
            this.createConnectionFactory(managedConnectionFactory.ra._getConnectionManager());
        }
        ManagedConnection managedConnection = new ManagedConnection(this, subject, (ConnectionRequestInfo)connectionRequestInfo, this.ra);
        return managedConnection;
    }

    public javax.resource.spi.ManagedConnection matchManagedConnections(Set set, Subject subject, javax.resource.spi.ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object[] objectArray = new Object[]{set, subject, connectionRequestInfo};
        _loggerOC.entering(_className, "matchManagedConnections()", objectArray);
        PasswordCredential passwordCredential = Util.getPasswordCredential(this, subject, (ConnectionRequestInfo)connectionRequestInfo);
        for (Object e : set) {
            if (!(e instanceof ManagedConnection)) continue;
            ManagedConnection managedConnection = (ManagedConnection)e;
            ManagedConnectionFactory managedConnectionFactory = managedConnection.getManagedConnectionFactory();
            if (managedConnection.isDestroyed() || !Util.isPasswordCredentialEqual(managedConnection.getPasswordCredential(), passwordCredential) || !managedConnectionFactory.equals(this)) continue;
            return managedConnection;
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        _loggerOC.entering(_className, "setLogWriter()", printWriter);
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        _loggerOC.entering(_className, "getLogWriter()", this.logWriter);
        return this.logWriter;
    }

    public int hashCode() {
        if (this.mcfId == 0) {
            this.mcfId = ++idCounter;
        }
        return this.mcfId;
    }

    public boolean equals(Object object) {
        _loggerOC.entering(_className, "equals()", object);
        if (object == null) {
            return false;
        }
        if (object instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)object;
            if (_loggerOC.isLoggable(Level.FINER)) {
                _loggerOC.finer("MQJMSRA_MF1101: equals:thisMCF=" + this.toString() + "\n\t\totherMCF=" + managedConnectionFactory.toString());
            }
            String string = managedConnectionFactory.getAddressList();
            String string2 = managedConnectionFactory.getUserName();
            String string3 = managedConnectionFactory.getPassword();
            String string4 = managedConnectionFactory.getClientId();
            boolean bl = managedConnectionFactory.getEnableRADirect();
            boolean bl2 = managedConnectionFactory.getEnableAPIDirect();
            return (string != null && string.equals(this.addressList) || string == null && this.addressList == null) && (string2 != null && string2.equals(this.userName) || string2 == null && this.userName == null) && (string3 != null && string3.equals(this.password) || string3 == null && this.password == null) && (string4 != null && string4.equals(this.clientId) || string4 == null && this.clientId == null) && bl == this.enableRADirect && bl2 == this.enableAPIDirect;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter) throws ResourceException {
        _loggerOC.entering(_className, "setResourceAdapter()", resourceAdapter);
        ManagedConnectionFactory managedConnectionFactory = this;
        synchronized (managedConnectionFactory) {
            ResourceAdapter resourceAdapter2;
            if (this.ra != null) throw new ResourceException("MQRA:MCF:illegal to change resource adapter association");
            if (!(resourceAdapter instanceof ResourceAdapter)) throw new ResourceException("MQRA:MCF:associating unkown resource adapter class - " + resourceAdapter.getClass());
            this.ra = resourceAdapter2 = (ResourceAdapter)resourceAdapter;
            if (!resourceAdapter2.getInAppClientContainer()) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty("imq.DaemonThreads", "true");
                        return null;
                    }
                });
            }
            if (this.ra._isRADirectAllowed()) {
                this.setEnableRADirect(true);
            }
            if (this.ra._isAPIDirectAllowed()) {
                this.setEnableAPIDirect(true);
            }
            if (this.addressList == null) {
                try {
                    this._setAddressList(resourceAdapter2._getEffectiveConnectionURL());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _loggerOC.info("MQJMSRA_MF1101: setResourceAdapter:Using default addressList due to setAddressList Exception=" + illegalArgumentException.getMessage());
                }
            }
            if (this.userName == null) {
                try {
                    this._setUserName(resourceAdapter2.getUserName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _loggerOC.info("MQJMSRA_MF1101: setResourceAdapter:Using default userName due to setUserName Exception=" + illegalArgumentException.getMessage());
                }
            }
            if (this.password == null) {
                try {
                    this._setPassword(resourceAdapter2.getPassword());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _loggerOC.info("MQJMSRA_MF1101: setResourceAdapter:Using default password due to setPassword Exception=" + illegalArgumentException.getMessage());
                }
            }
            if (!this.reconnectEnabledSet) {
                try {
                    this.setReconnectEnabled(resourceAdapter2.getReconnectEnabled());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.reconnectInterval == -1) {
                try {
                    this.setReconnectInterval(resourceAdapter2.getReconnectInterval());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.reconnectAttempts == -1) {
                try {
                    this.setReconnectAttempts(resourceAdapter2.getReconnectAttempts());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.addressListIterations == -1) {
                try {
                    this.setAddressListIterations(resourceAdapter2.getAddressListIterations());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.addressListBehavior != null) return;
            try {
                this.setAddressListBehavior(resourceAdapter2.getAddressListBehavior());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return;
        }
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        _loggerOC.entering(_className, "getResourceAdapter()", this.ra);
        return this.ra;
    }

    public int _getMCFId() {
        if (this.mcfId == 0) {
            this.mcfId = ++idCounter;
        }
        return this.mcfId;
    }

    public void _setMessageServiceAddressList(String string) {
        _loggerOC.entering(_className, "_setMessageServiceAddressList()", string);
        this.setAddressList(string);
    }

    public String _getMessageServiceAddressList() {
        _loggerOC.entering(_className, "_getMessageServiceAddressList()", this.addressList);
        return this.addressList;
    }

    public void setAddressList(String string) {
        String string2 = string;
        _loggerOC.entering(_className, "setAddressList()", string2);
        if ("localhost".equals(string) && this.ra == null) {
            _loggerOC.info("MQJMSRA_MF1101: setAddressList:NOT setting default value=" + string);
            return;
        }
        this._setAddressList(string);
        if (string != null && !"".equals(string)) {
            this.setEnableRADirect(false);
            this.setEnableAPIDirect(false);
        }
    }

    private void _setAddressList(String string) {
        try {
            this.xacf.setProperty("imqAddressList", string);
            this.addressList = string;
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setAddressList:setProperty Exception for value=" + string);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setAddressList()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public String getAddressList() {
        _loggerOC.entering(_className, "getMessageServiceAddressList()", this.addressList);
        return this.addressList;
    }

    public void setUserName(String string) {
        _loggerOC.entering(_className, "setUserName()", string);
        if ("guest".equals(string) && this.ra == null) {
            _loggerOC.info("MQJMSRA_MF1101: setUserName:NOT setting default value=" + string);
            return;
        }
        this._setUserName(string);
    }

    private void _setUserName(String string) {
        this.userName = string;
        try {
            this.xacf.setProperty("imqDefaultUsername", string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setUserName:setProperty Exception for value=" + string);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setUserName()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public String getUserName() {
        _loggerOC.entering(_className, "getUserName()", this.userName);
        return this.userName;
    }

    public void setPassword(String string) {
        _loggerOC.entering(_className, "setPassword()");
        if ("guest".equals(string) && this.ra == null) {
            _loggerOC.info("MQJMSRA_MF1101: setPassword:NOT setting default value");
            return;
        }
        this._setPassword(string);
    }

    private void _setPassword(String string) {
        this.password = string;
        try {
            this.xacf.setProperty("imqDefaultPassword", string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setPassword:setProperty Exception");
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setPassword()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public String getPassword() {
        _loggerOC.entering(_className, "getPassword()");
        return this.password;
    }

    public void setClientId(String string) {
        _loggerOC.entering(_className, "setClientId()", string);
        if (string == null || "".equals(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setClientId:NULL or empty disallowed");
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setClientId()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.clientId = string;
    }

    public String getClientId() {
        _loggerOC.entering(_className, "getClientId()", this.clientId);
        return this.clientId;
    }

    public void setUseSharedSubscriptionInClusteredContainer(boolean bl) {
        this.useSharedSubscriptionsInClusteredContainer = bl;
    }

    public boolean isUseSharedSubscriptionInClusteredContainer() {
        return this.useSharedSubscriptionsInClusteredContainer;
    }

    public void setEnableRADirect(boolean bl) {
        _loggerOC.entering(_className, "setEnableRADirect()", Boolean.toString(bl));
        this.enableRADirect = this.ra != null && this.ra._isRADirectAllowed() && bl;
    }

    public void setEnableAPIDirect(boolean bl) {
        _loggerOC.entering(_className, "setEnableAPIDirect()", Boolean.toString(bl));
        if (this.ra != null && this.ra._isAPIDirectAllowed() && bl) {
            this.enableAPIDirect = true;
        } else {
            this.enableRADirect = false;
        }
    }

    public boolean getEnableRADirect() {
        _loggerOC.entering(_className, "getEnableRADirect()", Boolean.toString(this.enableRADirect));
        return this.enableRADirect;
    }

    public boolean getEnableAPIDirect() {
        _loggerOC.entering(_className, "getEnableAPIDirect()", Boolean.toString(this.enableAPIDirect));
        return this.enableAPIDirect;
    }

    public void setReconnectEnabled(boolean bl) {
        _loggerOC.entering(_className, "setReconnectEnabled()", Boolean.toString(bl));
        try {
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(bl));
            this.reconnectEnabled = bl;
            this.reconnectEnabledSet = true;
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setReconnectEnabled:setProperty Exception for value " + bl);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setReconnectEnabled()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public boolean getReconnectEnabled() {
        _loggerOC.entering(_className, "getReconnectEnabled()", Boolean.toString(this.reconnectEnabled));
        return this.reconnectEnabled;
    }

    public void setReconnectInterval(int n) {
        _loggerOC.entering(_className, "setReconnectInterval()", Integer.toString(n));
        this.reconnectInterval = n;
        try {
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(n));
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setReconnectInterval:setProperty Exception for value " + n);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setReconnectInterval()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public int getReconnectInterval() {
        _loggerOC.entering(_className, "getReconnectInterval()", Integer.toString(this.reconnectInterval));
        return this.reconnectInterval;
    }

    public void setReconnectAttempts(int n) {
        _loggerOC.entering(_className, "setReconnectAttempts()", Integer.toString(n));
        this.reconnectAttempts = n;
        try {
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(n));
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setReconnectAttempts:setProperty Exception for value " + n);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setReconnectAttempts()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public int getReconnectAttempts() {
        _loggerOC.entering(_className, "getReconnectAttempts()", Integer.toString(this.reconnectAttempts));
        return this.reconnectAttempts;
    }

    public void setAddressListBehavior(String string) {
        _loggerOC.entering(_className, "setAddressListBehavior()", string);
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(string) ? "RANDOM" : "PRIORITY";
        try {
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setAddressListBehavior:setProperty Exception for value " + string);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setAddressListBehavior()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public String getAddressListBehavior() {
        _loggerOC.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        return this.addressListBehavior;
    }

    public void setAddressListIterations(int n) {
        _loggerOC.entering(_className, "setAddressListIterations()", Integer.toString(n));
        if (n < 1) {
            _loggerOC.warning("MQJMSRA_MF2001: setAddressListIterations:Invalid value:" + n + ":Setting to 1");
            this.addressListIterations = 1;
        } else {
            this.addressListIterations = n;
        }
        try {
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setAddressListIterations:setProperty Exception for value " + n);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setAddressListIterations()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public int getAddressListIterations() {
        _loggerOC.entering(_className, "getAddressListIterations()", Integer.toString(this.addressListIterations));
        return this.addressListIterations;
    }

    public void setProperty(String string, String string2) {
        _loggerOC.entering(_className, "setProperty()", "Prop name=" + string + ":Prop value=" + string2);
        try {
            if ("MessageServiceAddressList".equalsIgnoreCase(string)) {
                this.xacf.setProperty("imqAddressList", string2);
            } else {
                this.xacf.setProperty(string, string2);
            }
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_MF4001: setProperty: exception setting property " + string + " to " + string2);
            illegalArgumentException.initCause(jMSException);
            _loggerOC.warning(illegalArgumentException.getMessage());
            _loggerOC.throwing(_className, "setProperty()", illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public void setOptions(String string) {
        _loggerOC.entering(_className, "setOptions()", "stringProps=" + string);
        Hashtable<String, String> hashtable = null;
        try {
            hashtable = CustomTokenizer.parseToProperties(string);
        }
        catch (InvalidPropertyException invalidPropertyException) {
            String string2 = "ManagedConnectionFactory property options has invalid value " + string + " error is: " + invalidPropertyException.getMessage();
            _loggerOC.warning(_lgrMID_WRN + string2);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(_lgrMID_EXC + string2);
            illegalArgumentException.initCause(invalidPropertyException);
            throw illegalArgumentException;
        }
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            if (string3.equals("imqReconnectInterval") | string3.equals("imqDefaultUsername") | string3.equals("imqDefaultPassword") | string3.equals("imqAddressList") | string3.equals("imqReconnectEnabled") | string3.equals("imqAddressListIterations") | string3.equals("imqReconnectAttempts") | string3.equals("imqAddressListBehavior")) {
                _loggerOC.warning("MQJMSRA_MF2001: Cannot use ManagedConnectionFactory property options to set property " + string3 + ": ignoring");
                continue;
            }
            this.setProperty(string3, hashtable.get(string3));
        }
    }

    public String getProperty(String string) {
        String string2 = null;
        try {
            string2 = this.xacf.getProperty(string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Error getting property named-" + string);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
        return string2;
    }

    protected XAConnectionFactory _getXACF() {
        return this.xacf;
    }

    protected ConnectionCreator getConnectionCreator() {
        return this.connectionCreator;
    }

    public String toString() {
        return "ManagedConnectionFactory configuration=\n\tMCFId                               =" + this.mcfId + "\n" + "\tAddressList                         =" + this.addressList + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tClientId                            =" + this.clientId + "\n" + "\tReconnectEnabled                    =" + this.reconnectEnabled + "\n" + "\tReconnectInterval                   =" + this.reconnectInterval + "\n" + "\tReconnectAttempts                   =" + this.reconnectAttempts + "\n" + "\tAddressListBehavior                 =" + this.addressListBehavior + "\n" + "\tAddressListIterations               =" + this.addressListIterations + "\n" + "\toptions                             =" + this.options + "\n";
    }

    public JMSService _getJMSService() {
        if (this.ra != null) {
            return this.ra._getJMSService();
        }
        return null;
    }
}

