/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.bridge.BridgeBaseContext;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.util.KeystoreUtil;
import com.sun.messaging.jmq.jmsserver.util.SSLPropertyMap;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryManager;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class BridgeBaseContextAdapter
implements BridgeBaseContext,
SSLPropertyMap {
    public static final String PROP_ADMIN_PASSWORD = "imq.bridge.admin.password";
    private Logger logger = null;
    private Broker broker = null;
    private boolean reset = false;
    private boolean embededBroker = false;

    protected static boolean bridgeEnabled() {
        return Globals.getConfig().getBooleanProperty("imq.bridge.enabled", false);
    }

    protected static String getManagerClass() {
        return Globals.getConfig().getProperty("imq.bridge.managerclass", "com.sun.messaging.bridge.BridgeServiceManagerImpl");
    }

    protected BridgeBaseContextAdapter(Broker broker, boolean bl) {
        this.broker = broker;
        this.reset = bl;
        this.embededBroker = broker.isInProcess();
        this.logger = Globals.getLogger();
    }

    public boolean isEmbeded() {
        return true;
    }

    public boolean isEmbededBroker() {
        return this.embededBroker;
    }

    public boolean isStartWithReset() {
        return this.reset;
    }

    public Properties getBridgeConfig() {
        Properties properties = new Properties();
        String string = "imq.bridge";
        BrokerConfig brokerConfig = Globals.getConfig();
        List list = Globals.getConfig().getPropertyNames(string);
        String string22 = null;
        for (String string22 : list) {
            properties.put(string22, brokerConfig.getProperty(string22));
        }
        properties.put(string + ".varhome", Globals.getInstanceDir() + File.separator + "bridge" + "s");
        String string3 = brokerConfig.getProperty("imq.libhome");
        properties.put(string + ".libhome", string3);
        properties.put(string + ".stomp.type", "stomp");
        properties.put(string + ".stomp.class", "com.sun.messaging.bridge.service.stomp.StompBridge");
        properties.put(string + ".jms.class", "com.sun.messaging.bridge.service.jms.BridgeImpl");
        properties.put("PROP_PREFIX", string);
        return properties;
    }

    public void updateBridgeConfig(Properties properties) throws Exception {
        Globals.getConfig().updateProperties(properties);
    }

    public boolean isJDBCStoreType() throws Exception {
        return Globals.getStore().getStoreType().equals("jdbc");
    }

    public Object getJDBCStore() throws Exception {
        if (!Globals.getStore().getStoreType().equals("jdbc")) {
            return null;
        }
        return (JDBCStore)Globals.getStore();
    }

    public boolean isHAEnabled() {
        return Globals.getHAEnabled();
    }

    public String getBrokerServiceAddress(String string, String string2) throws Exception {
        PortMapperEntry portMapperEntry = null;
        PortMapperEntry portMapperEntry22 = null;
        for (PortMapperEntry portMapperEntry22 : Globals.getPortMapper().getServices().values()) {
            if (!portMapperEntry22.getProtocol().toLowerCase().equals(string.toLowerCase()) || !portMapperEntry22.getType().equals(string2)) continue;
            portMapperEntry = portMapperEntry22;
            break;
        }
        if (portMapperEntry == null) {
            throw new Exception("No available service found with protocol " + string + " and type " + string2);
        }
        return "mq" + string.toLowerCase() + "://" + this.getBrokerHostName() + ":" + portMapperEntry.getPort() + "/" + portMapperEntry.getName();
    }

    public int getBrokerHostPort() {
        return Globals.getPortMapper().getPort();
    }

    public String getIdentityName() throws Exception {
        return Globals.getIdentityName();
    }

    public boolean allocateMemCheck(long l) {
        MemoryManager memoryManager = Globals.getMemManager();
        if (memoryManager == null) {
            return true;
        }
        return memoryManager.allocateMemCheck(l);
    }

    public String getBrokerHostName() {
        String string = Globals.getPortMapper().getHostname();
        if (string == null) {
            return "localhost";
        }
        return string;
    }

    public void logError(String string, Throwable throwable) {
        String string2 = "BridgeManager: " + string;
        if (throwable != null) {
            this.logger.logStack(32, string2, throwable);
        } else {
            this.logger.log(32, string2);
        }
    }

    public void logWarn(String string, Throwable throwable) {
        String string2 = "BridgeManager: " + string;
        if (throwable != null) {
            this.logger.logStack(16, string2, throwable);
        } else {
            this.logger.log(16, string2);
        }
    }

    public void logInfo(String string, Throwable throwable) {
        String string2 = "BridgeManager: " + string;
        if (throwable != null) {
            this.logger.logStack(8, string2, throwable);
        } else {
            this.logger.log(8, string2);
        }
    }

    public void logDebug(String string, Throwable throwable) {
        String string2 = "BridgeManager: " + string;
        if (throwable != null) {
            this.logger.logStack(4, string2, throwable);
        } else {
            this.logger.log(4, string2);
        }
    }

    public boolean handleGlobalError(Throwable throwable, String string) {
        Globals.handleGlobalError(throwable, string);
        return true;
    }

    public void registerService(String string, String string2, String string3, int n, HashMap hashMap) {
        String string4 = string + "[" + "bridge" + "]";
        String string5 = string3 + "[" + "bridge" + "]";
        Globals.getPortMapper().addService(string4, string2, string5, n, hashMap);
    }

    public Properties getDefaultSSLContextConfig(String string) throws Exception {
        return KeystoreUtil.getDefaultSSLContextConfig(string + "[" + "bridge" + "]", this);
    }

    public String mapSSLProperty(String string) throws Exception {
        if (string.equals("javax.net.ssl.keyStore")) {
            return "javax.net.ssl.keyStore";
        }
        if (string.equals("javax.net.ssl.keyStorePassword")) {
            return "javax.net.ssl.keyStorePassword";
        }
        if (string.equals("javax.net.ssl.keyStoreType")) {
            return "javax.net.ssl.keyStoreType";
        }
        if (string.equals("ssl.KeyManagerFactory.algorithm")) {
            return "ssl.KeyManagerFactory.algorithm";
        }
        if (string.equals("javax.net.ssl.trustStore")) {
            return "javax.net.ssl.trustStore";
        }
        if (string.equals("javax.net.ssl.trustStorePassword")) {
            return "javax.net.ssl.trustStorePassword";
        }
        if (string.equals("javax.net.ssl.trustStoreType")) {
            return "javax.net.ssl.trustStoreType";
        }
        if (string.equals("ssl.TrustManagerFactory.algorithm")) {
            return "ssl.TrustManagerFactory.algorithm";
        }
        if (string.equals("securesocket.protocol")) {
            return "securesocket.protocol";
        }
        throw new IllegalArgumentException("unknow " + string);
    }
}

