/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.InMemoryStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

class MsgStore {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = new ConcurrentHashMap(32);
    private InMemoryStore store = null;
    private static final Enumeration emptyEnum = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    MsgStore(InMemoryStore inMemoryStore) {
        this.store = inMemoryStore;
    }

    Hashtable getDebugState() {
        Hashtable hashtable = new Hashtable();
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            hashtable.putAll(dstMsgStore.getDebugState());
        }
        return hashtable;
    }

    void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "storeMessage for " + destinationUID);
        }
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true);
        dstMsgStore.storeMessage(packet, consumerUIDArray, nArray);
    }

    Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        try {
            return this.getDstMsgStore(destinationUID).getMessage(sysMessageID);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4107", (Object)sysMessageID.toString(), (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4107", sysMessageID.toString()), iOException);
        }
    }

    boolean containsMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true);
        return dstMsgStore.containsMsg(sysMessageID);
    }

    void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws IOException, BrokerException {
        this.getDstMsgStore(destinationUID).removeMessage(sysMessageID);
    }

    void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID);
        if (dstMsgStore == null || !dstMsgStore.containsMsg(sysMessageID)) {
            this.logger.log(32, "B3007", (Object)sysMessageID, (Object)destinationUID);
            throw new BrokerException(this.br.getString("B3007", sysMessageID, destinationUID));
        }
        this.storeMessage(destinationUID2, packet, consumerUIDArray, nArray);
        try {
            dstMsgStore.removeMessage(packet.getSysMessageID());
        }
        catch (BrokerException brokerException) {
            this.getDstMsgStore(destinationUID2).removeMessage(packet.getSysMessageID());
            Object[] objectArray = new Object[]{sysMessageID, destinationUID, destinationUID2};
            this.logger.log(32, "B4187", objectArray, (Throwable)brokerException);
            throw brokerException;
        }
    }

    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).hasMessageBeenAck();
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        return new HashMap();
    }

    void compactDestination(Destination destination) throws BrokerException {
    }

    void removeAllMessages(DestinationUID destinationUID, boolean bl) throws IOException, BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true);
        if (dstMsgStore != null) {
            dstMsgStore.removeAllMessages(bl);
        }
    }

    void releaseMessageDir(DestinationUID destinationUID) {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.remove(destinationUID);
        dstMsgStore.close();
    }

    Enumeration messageEnumeration() {
        Enumeration enumeration = new Enumeration(){
            Iterator dstitr;
            Enumeration tempenum;
            Object nextToReturn;
            {
                this.dstitr = MsgStore.this.store.getDstStore().getDestinations().iterator();
                this.tempenum = null;
                this.nextToReturn = null;
            }

            public boolean hasMoreElements() {
                while (true) {
                    if (this.tempenum != null) {
                        if (this.tempenum.hasMoreElements()) {
                            this.nextToReturn = this.tempenum.nextElement();
                            return true;
                        }
                        this.tempenum = null;
                        continue;
                    }
                    while (this.dstitr.hasNext()) {
                        Destination destination = (Destination)this.dstitr.next();
                        try {
                            this.tempenum = MsgStore.this.messageEnumeration(destination.getDestinationUID());
                            break;
                        }
                        catch (BrokerException brokerException) {
                            MsgStore.this.logger.log(32, "B4145", (Object)destination.getDestinationUID(), (Throwable)brokerException);
                        }
                    }
                    if (this.tempenum == null) break;
                }
                return false;
            }

            public Object nextElement() {
                if (this.nextToReturn != null) {
                    Object object = this.nextToReturn;
                    this.nextToReturn = null;
                    return object;
                }
                throw new NoSuchElementException();
            }
        };
        return enumeration;
    }

    Enumeration messageEnumeration(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true);
        if (dstMsgStore != null) {
            return dstMsgStore.messageEnumeration();
        }
        return emptyEnum;
    }

    int getMessageCount(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true);
        if (dstMsgStore != null) {
            return dstMsgStore.getMessageCount();
        }
        return 0;
    }

    long getByteCount(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(destinationUID, true);
        if (dstMsgStore != null) {
            return dstMsgStore.getByteCount();
        }
        return 0L;
    }

    void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        try {
            this.getDstMsgStore(destinationUID).storeInterestStates(sysMessageID, consumerUIDArray, nArray);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4105", (Object)sysMessageID.toString());
            throw new BrokerException(this.br.getString("B4105", sysMessageID.toString()), iOException);
        }
    }

    void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        try {
            this.getDstMsgStore(destinationUID).updateInterestState(sysMessageID, consumerUID, n);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4015", (Object)consumerUID.toString(), (Object)sysMessageID.toString());
            throw new BrokerException(this.br.getString("B4015", consumerUID.toString(), sysMessageID.toString()), iOException);
        }
    }

    int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).getInterestState(consumerUID);
    }

    HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).getInterestStates();
    }

    ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getDstMsgStore(destinationUID).getMessageInfo(sysMessageID).getConsumerUIDs();
    }

    void clearAll() throws BrokerException {
        if (this.dstMap != null) {
            this.closeAllDstMsgStore(false);
            this.dstMap.clear();
        }
    }

    void close(boolean bl) {
        this.closeAllDstMsgStore(bl);
        this.dstMap.clear();
    }

    private DstMsgStore getDstMsgStore(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(destinationUID);
        if (dstMsgStore == null) {
            this.logger.log(32, "B3013", (Object)destinationUID);
            throw new BrokerException(this.br.getString("B3013", destinationUID));
        }
        return dstMsgStore;
    }

    private DstMsgStore getDstMsgStore(DestinationUID destinationUID, boolean bl) throws BrokerException {
        DstMsgStore dstMsgStore;
        this.store.getDstStore().checkDestination(destinationUID);
        DstMsgStore dstMsgStore2 = (DstMsgStore)this.dstMap.get(destinationUID);
        if (dstMsgStore2 == null && bl && (dstMsgStore = this.dstMap.putIfAbsent(destinationUID, dstMsgStore2 = new DstMsgStore(destinationUID))) != null) {
            dstMsgStore2 = dstMsgStore;
        }
        return dstMsgStore2;
    }

    private void closeAllDstMsgStore(boolean bl) {
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            if (dstMsgStore == null) continue;
            dstMsgStore.close();
        }
    }
}

