/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class MessageAckHandler
extends GPacketHandler {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG_CLUSTER_TXN;
    private static boolean DEBUG = DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG;
    private FaultInjection fi = FaultInjection.getInjection();
    private HashMap fiackCounts = new HashMap();

    public MessageAckHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 3) {
            this.handleMessageAck(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 4) {
            this.handleMessageAckReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "B3100", (Object)("Cannot handle this packet :" + gPacket.toLongString()));
        }
    }

    public void handleMessageAck(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterMessageAckInfo clusterMessageAckInfo = ClusterMessageAckInfo.newInstance(gPacket, this.c);
        int n = clusterMessageAckInfo.getAckType();
        Long l = clusterMessageAckInfo.getTransactionID();
        if (this.fi.FAULT_INJECTION) {
            ClusterMessageAckInfo.CHECKFAULT(this.fiackCounts, n, l, "msg.remote_ack.home.p.", "1");
        }
        UID uID = clusterMessageAckInfo.getMessageStoreSessionUID();
        UID uID2 = clusterMessageAckInfo.getMessageBrokerSessionUID();
        int n2 = 1;
        if (clusterMessageAckInfo.getCount() != null) {
            n2 = clusterMessageAckInfo.getCount();
        }
        SysMessageID[] sysMessageIDArray = new SysMessageID[n2];
        ConsumerUID[] consumerUIDArray = new ConsumerUID[n2];
        if (n2 > 0) {
            clusterMessageAckInfo.initPayloadRead();
            for (int i = 0; i < n2; ++i) {
                try {
                    sysMessageIDArray[i] = clusterMessageAckInfo.readPayloadSysMessageID();
                    consumerUIDArray[i] = clusterMessageAckInfo.readPayloadConsumerUID();
                    continue;
                }
                catch (Exception exception) {
                    this.logger.logStack(32, this.br.getKString("B3189", gPacket.toString(), brokerAddress), (Throwable)exception);
                    this.sendReply(brokerAddress, clusterMessageAckInfo, 500, exception.getMessage(), null, null, null);
                    return;
                }
            }
        }
        if (DEBUG) {
            this.logger.log(1, "MessageBus: Received message ack : " + clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray));
        }
        if (uID != null != Globals.getHAEnabled()) {
            this.logger.log(32, "B3100", (Object)("HA mode not match for message ack " + clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray)));
            this.sendReply(brokerAddress, clusterMessageAckInfo, 500, "message HA mode not match", null, sysMessageIDArray, consumerUIDArray);
            return;
        }
        if (this.p.isTakeoverTarget(this.selfAddress)) {
            this.logger.log(32, this.br.getKString("B3191", clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray), this.selfAddress));
            this.sendReply(brokerAddress, clusterMessageAckInfo, 500, this.br.getKString("B4244", clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray), this.selfAddress), null, sysMessageIDArray, consumerUIDArray);
            return;
        }
        try {
            if (l != null) {
                messageBusCallback.processRemoteAck2P(sysMessageIDArray, consumerUIDArray, n, clusterMessageAckInfo.getOptionalProps(), l, brokerAddress);
            } else {
                if (sysMessageIDArray.length > 1) {
                    throw new BrokerException("Internal Error: Unexpected remote ack count " + sysMessageIDArray.length);
                }
                messageBusCallback.processRemoteAck(sysMessageIDArray[0], consumerUIDArray[0], n, clusterMessageAckInfo.getOptionalProps());
            }
            if (this.fi.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.fiackCounts, n, l, "msg.remote_ack.home.p.", "2");
            }
            this.sendReply(brokerAddress, clusterMessageAckInfo, 200, null, null, sysMessageIDArray, consumerUIDArray);
            if (this.fi.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.fiackCounts, n, l, "msg.remote_ack.home.p.", "3");
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                this.logger.logStack(16, this.br.getKString("B2136", clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray), brokerAddress), (Throwable)exception);
            } else {
                this.logger.log(16, this.br.getKString("B2136", clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray), brokerAddress) + ": " + exception.getMessage());
            }
            if (exception instanceof BrokerException) {
                this.sendReply(brokerAddress, clusterMessageAckInfo, (BrokerException)exception, sysMessageIDArray, consumerUIDArray);
            }
            this.sendReply(brokerAddress, clusterMessageAckInfo, 500, exception.getMessage(), null, sysMessageIDArray, consumerUIDArray);
        }
    }

    private void sendReply(BrokerAddress brokerAddress, ClusterMessageAckInfo clusterMessageAckInfo, BrokerException brokerException, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) {
        if (!(brokerException instanceof AckEntryNotFoundException)) {
            this.sendReply(brokerAddress, clusterMessageAckInfo, brokerException.getStatusCode(), brokerException.getMessage(), null, sysMessageIDArray, consumerUIDArray);
            return;
        }
        AckEntryNotFoundException ackEntryNotFoundException = (AckEntryNotFoundException)brokerException;
        this.sendReply(brokerAddress, clusterMessageAckInfo, brokerException.getStatusCode(), brokerException.getMessage(), ackEntryNotFoundException.getAckEntries(), sysMessageIDArray, consumerUIDArray);
    }

    private void sendReply(BrokerAddress brokerAddress, ClusterMessageAckInfo clusterMessageAckInfo, int n, String string, ArrayList[] arrayListArray, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) {
        if (clusterMessageAckInfo.needReply()) {
            try {
                this.c.unicast(brokerAddress, clusterMessageAckInfo.getReplyGPacket(n, string, arrayListArray));
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(4), brokerAddress, clusterMessageAckInfo.toString(sysMessageIDArray, consumerUIDArray)};
                this.logger.logStack(32, this.br.getKString("B3192", (Object)objectArray), (Throwable)iOException);
            }
        }
    }

    public void handleMessageAckReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_MESSAGE_ACK_REPLY (" + ClusterMessageAckInfo.getAckAckType(gPacket) + ")  from " + brokerAddress + " : STATUS = " + ClusterMessageAckInfo.getAckAckStatus(gPacket));
        this.p.receivedMessageAckReply(brokerAddress, gPacket);
    }
}

