/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.GenericDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.HADBDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.OracleDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class DBManager
extends CommDBManager
implements DBConstants {
    private static final String STORE_TYPE_PROP = "imq.persist.store";
    public static final String JDBC_PROP_PREFIX = "imq.persist.jdbc";
    public static final String FALLBACK_USER_PROP = "imq.persist.jdbc.user";
    public static final String FALLBACK_PWD_PROP = "imq.persist.jdbc.password";
    private static final String BROKERID_PROP = "imq.brokerid";
    private static final int LONGEST_TABLENAME_LEN = 13;
    private String clusterID = null;
    private String brokerID = null;
    private DAOFactory daoFactory = null;
    private DBConnectionPool dbpool = null;
    private boolean storeInited = false;
    private static final Object classLock = DBManager.class;
    private static DBManager dbMgr = null;
    private static String[] v370tableNames = new String[]{"IMQSV37", "IMQCCREC37", "IMQDEST37", "IMQINT37", "IMQMSG37", "IMQPROPS37", "IMQILIST37", "IMQTXN37", "IMQTACK37"};
    private static String[] v350tableNames = new String[]{"IMQSV35", "IMQCCREC35", "IMQDEST35", "IMQINT35", "IMQMSG35", "IMQPROPS35", "IMQILIST35", "IMQTXN35", "IMQTACK35"};

    protected boolean getDEBUG() {
        return Store.getDEBUG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBManager getDBManager() throws BrokerException {
        if (dbMgr == null) {
            Object object = classLock;
            synchronized (object) {
                if (dbMgr == null) {
                    dbMgr = new DBManager();
                    dbMgr.loadTableSchema();
                    DBManager.dbMgr.dbpool = new DBConnectionPool(dbMgr, "dbp");
                    dbMgr.initDBMetaData();
                }
            }
        }
        return dbMgr;
    }

    protected String getJDBCPropPrefix() {
        return JDBC_PROP_PREFIX;
    }

    protected String getStoreTypeProp() {
        return STORE_TYPE_PROP;
    }

    protected String getCreateStoreProp() {
        return "imq.persist.storecreate.all";
    }

    protected boolean getCreateStorePropDefault() {
        return false;
    }

    protected String getLogStringTag() {
        return "";
    }

    public String toString() {
        return "DBManager";
    }

    protected void checkMaxTableNameLength(int n) throws BrokerException {
        if (n > 0) {
            if (Globals.getHAEnabled()) {
                if (this.clusterID.length() + 13 + 1 > n) {
                    Object[] objectArray = new Object[]{this.clusterID, n, 14};
                    throw new BrokerException(this.br.getKString("B3179", objectArray));
                }
            } else if (this.brokerID.length() + 13 + 1 > n) {
                Object[] objectArray = new Object[]{this.brokerID, n, 14};
                throw new BrokerException(this.br.getKString("B3094", objectArray));
            }
        }
    }

    protected boolean isStoreInited() {
        return this.storeInited;
    }

    protected void setStoreInited(boolean bl) {
        this.storeInited = bl;
    }

    private DBManager() throws BrokerException {
        this.initDBManagerProps();
        this.fixOldTableNames();
        this.initDBDriver();
    }

    protected void initTableSuffix() throws BrokerException {
        this.brokerID = Globals.getBrokerID();
        if (this.brokerID == null || this.brokerID.length() == 0 || !Util.isAlphanumericString(this.brokerID)) {
            throw new BrokerException(this.br.getKString("B3093", this.brokerID));
        }
        if (Globals.getHAEnabled()) {
            this.clusterID = Globals.getClusterID();
            if (this.clusterID == null || this.clusterID.length() == 0 || !Util.isAlphanumericString(this.clusterID)) {
                throw new BrokerException(this.br.getKString("B3178", this.clusterID));
            }
            this.tableSuffix = "C" + this.clusterID;
        } else {
            this.tableSuffix = "S" + this.brokerID;
        }
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    String getClusterID() {
        return this.clusterID;
    }

    public int checkStoreExists(Connection connection) throws BrokerException {
        return super.checkStoreExists(connection, null);
    }

    protected Connection getConnection() throws BrokerException {
        return this.dbpool.getConnection();
    }

    protected void freeConnection(Connection connection, Throwable throwable) throws BrokerException {
        this.dbpool.freeConnection(connection, throwable);
    }

    public void closeSQLObjects(ResultSet resultSet, Statement statement, Connection connection, Throwable throwable) throws BrokerException {
        Util.close(resultSet, statement, connection, throwable);
    }

    public Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("storeInited", this.storeInited);
        hashtable.put("clusterID", "" + this.clusterID);
        hashtable.put("brokerID", "" + this.brokerID);
        hashtable.put(this.dbpool.toString(), this.dbpool.getDebugState());
        return hashtable;
    }

    public boolean isHAClusterActive(Connection connection) throws BrokerException {
        boolean bl = false;
        BrokerDAO brokerDAO = DBManager.getDBManager().getDAOFactory().getBrokerDAO();
        HashMap hashMap = brokerDAO.getAllBrokerInfos(connection, false);
        Iterator iterator = hashMap.values().iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            long l2;
            HABrokerInfo hABrokerInfo = (HABrokerInfo)iterator.next();
            int n = hABrokerInfo.getState();
            if (!BrokerState.getState(n).isActiveState() || (l2 = hABrokerInfo.getHeartbeat()) + 180000L <= l) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAOFactory getDAOFactory() {
        if (this.daoFactory == null) {
            Object object = classLock;
            synchronized (object) {
                if (this.daoFactory == null) {
                    if (this.isHADB) {
                        this.logger.log(4, "Instantiating HADB DAO factory");
                        this.daoFactory = new HADBDAOFactory();
                    } else if (this.isOracle) {
                        this.logger.log(4, "Instantiating Oracle DAO factory");
                        this.daoFactory = new OracleDAOFactory();
                    } else {
                        this.logger.log(4, "Instantiating generic DAO factory");
                        this.daoFactory = new GenericDAOFactory();
                    }
                }
            }
        }
        return this.daoFactory;
    }

    protected BaseDAO getFirstDAO() throws BrokerException {
        return (BaseDAO)this.getDAOFactory().getAllDAOs().get(0);
    }

    public void resetConnectionPool() throws BrokerException {
        this.dbpool.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = classLock;
        synchronized (object) {
            this.dbpool.close();
            super.close();
            if (dbMgr != null) {
                dbMgr = null;
            }
        }
    }

    String[] getTableNames(int n) {
        String[] stringArray = new String[]{};
        if (n == 410) {
            stringArray = this.tableSchemas.keySet().toArray(stringArray);
        } else if (n == 370) {
            stringArray = v370tableNames;
        } else if (n == 350) {
            stringArray = v350tableNames;
        }
        return stringArray;
    }

    public Iterator allDAOIterator() throws BrokerException {
        return this.getDAOFactory().getAllDAOs().iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void lockTables(Connection connection, boolean bl) throws BrokerException {
        boolean bl2;
        String string;
        Object object;
        LockFile lockFile = LockFile.getCurrentLockFile();
        String string2 = null;
        if (lockFile != null) {
            string2 = lockFile.getInstance() + ":" + lockFile.getHost() + ":" + lockFile.getPort();
        } else {
            object = Globals.getMQAddress();
            String string3 = string = object == null ? null : object.getHostName();
            if (string == null) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    string = MQAddress.getMQAddress((String)inetAddress.getCanonicalHostName(), (int)0).getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "";
                    Globals.getLogger().log(32, "B3152", (Throwable)unknownHostException);
                }
                catch (Exception exception) {
                    throw new BrokerException(exception.getMessage(), exception);
                }
            }
            string2 = Globals.getConfigName() + ":" + string + ":" + "imqdbmgr";
        }
        object = DBManager.getDBManager().getDAOFactory().getVersionDAO();
        string = object.getLock(connection, 410);
        if (string == null) {
            if (bl) throw new BrokerException(Globals.getBrokerResources().getKString("B3206", object.getTableName()), 404);
            Globals.getLogger().log(16, "B3206", (Object)object.getTableName());
            object.insert(connection, 410);
            return;
        }
        boolean bl3 = false;
        String string4 = null;
        String string5 = null;
        TableLock tableLock = new TableLock(string);
        if (tableLock.isNull) {
            if (bl) {
                bl3 = true;
                string4 = string2;
            }
        } else if (DBManager.isOurLock(lockFile, tableLock)) {
            if (!bl) {
                bl3 = true;
                string5 = tableLock.lockstr;
            }
        } else if (DBManager.validLock(tableLock)) {
            if (bl || tableLock.port != 0) throw new BrokerException(DBManager.generateLockError(tableLock));
            bl3 = true;
            string5 = tableLock.lockstr;
        } else if (bl) {
            bl3 = true;
            string4 = string2;
            string5 = tableLock.lockstr;
        } else {
            bl3 = true;
            string5 = tableLock.lockstr;
        }
        if (!bl3 || (bl2 = object.updateLock(connection, 410, string4, string5))) return;
        if (string4 == null) {
            Globals.getLogger().log(32, "B3205");
        }
        string = object.getLock(connection, 410);
        throw new BrokerException(DBManager.generateLockError(new TableLock(string)));
    }

    private static boolean isOurLock(LockFile lockFile, TableLock tableLock) {
        if (lockFile != null) {
            return lockFile.getPort() == tableLock.port && LockFile.equivalentHostNames(lockFile.getHost(), tableLock.host, false) && lockFile.getInstance().equals(tableLock.instance);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean validLock(TableLock tableLock) {
        boolean bl;
        if (tableLock.port == 0) {
            return true;
        }
        Socket socket = null;
        try {
            try {
                socket = new Socket(InetAddress.getByName(tableLock.host), tableLock.port);
                bl = true;
                Object var5_4 = null;
                if (socket == null) return bl;
            }
            catch (Exception exception) {
                boolean bl2 = false;
                Object var5_5 = null;
                if (socket == null) return bl2;
                try {
                    socket.close();
                    return bl2;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (socket == null) throw throwable;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        socket.close();
        return bl;
    }

    private void fixOldTableNames() {
        int n;
        for (n = 0; n < v370tableNames.length; ++n) {
            DBManager.v370tableNames[n] = v370tableNames[n] + this.brokerID;
        }
        for (n = 0; n < v350tableNames.length; ++n) {
            DBManager.v350tableNames[n] = v350tableNames[n] + this.brokerID;
        }
    }

    private static String generateLockError(TableLock tableLock) {
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (tableLock.port != 0) {
            return brokerResources.getKString("B3155", tableLock.host, String.valueOf(tableLock.port));
        }
        return brokerResources.getKString("B3156");
    }

    private static class TableLock {
        String lockstr;
        String instance;
        String host;
        String portstr;
        int port = 0;
        boolean isNull = false;

        TableLock(String string) {
            this.lockstr = string;
            if (this.lockstr == null || this.lockstr.length() == 0) {
                this.isNull = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.lockstr, " :\t\n\r\f");
                try {
                    this.instance = stringTokenizer.nextToken();
                    this.host = stringTokenizer.nextToken();
                    this.portstr = stringTokenizer.nextToken();
                    try {
                        this.port = Integer.parseInt(this.portstr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = 0;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Globals.getLogger().log(16, "B2087", (Object)this.lockstr);
                    this.lockstr = null;
                    this.isNull = true;
                }
            }
        }
    }
}

