/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.blc;

import com.sun.messaging.AdminConnectionFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import com.sun.messaging.jms.blc.EmbeddedBrokerRunner;
import com.sun.messaging.jms.blc.LocalBrokerRunner;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;
import javax.resource.spi.ResourceAdapterInternalException;

public class LifecycleManagedBroker {
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    protected static final String BROKER_TYPE_SOMEDIRECT = "DIRECT";
    protected static final String BROKER_TYPE_APIDIRECT = "APIDIRECT";
    protected static final String BROKER_TYPE_RADIRECT = "RADIRECT";
    private static final String DIRECT_MODE_DEFAULT = "true";
    private static final String APIDIRECT_MODE_DEFAULT = "false";
    private static final transient String _className = "com.sun.messaging.jms.ra.LifecycleManagedBroker";
    private static final transient String _lgrNameBase = "javax.resourceadapter.mqjmsra";
    private static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    private static final transient Logger _loggerB = Logger.getLogger("javax.resourceadapter.mqjmsra");
    private static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_RA";
    private static final transient String _lgrMID_EET = "MQJMSRA_RA1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_RA1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    private transient EmbeddedBrokerRunner ebr = null;
    private transient LocalBrokerRunner lbr = null;
    private static JMSService jmsservice = null;
    private transient boolean started;
    private transient boolean doBind = true;
    private static transient boolean _startedAtLeastOnce;
    private static transient int _rmiRegistryPort;
    private String requestedBrokerType = "REMOTE";
    private String actualBrokerType = "REMOTE";
    private String brokerInstanceName = "imqbroker";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String bridgeAdminPassword = null;
    private String keystorePassword = null;
    private String ldapPassword = null;
    private String hadbPassword = null;
    private String mysqlPassword = null;
    private String fallbackDBPassword = null;
    private String brokerBindAddress = null;
    private int rmiRegistryPort = 1099;
    private boolean startRmiRegistry = false;
    private transient String jmxServiceURL = null;
    private int brokerPort = 7676;
    private String brokerHomeDir = null;
    private String brokerLibDir = null;
    private String brokerVarDir = null;
    private String brokerJavaDir = null;
    private String brokerArgs = null;
    private boolean useJNDIRmiServiceURL = true;
    private boolean useSSLJMXConnector = true;
    private String masterBroker = null;
    private int nowaitForMasterBrokerTimeoutInSeconds = -1;
    private String brokerId = null;
    private int brokerStartTimeout = 10000;
    private String adminPassFile = null;
    private boolean brokerEnableHA = false;
    private String clusterId = null;
    private String dbType = null;
    private String connectionURL = "";
    public static final String DB_TYPE_DERBY = "derby";
    public static final String DB_TYPE_HADB = "hadb";
    public static final String DB_TYPE_MYSQL = "mysql";
    public static final String DB_TYPE_ORACLE = "oracle";
    public static final String DB_TYPE_POINTBASE = "pointbase";
    public static final String DB_TYPE_CLOUDSCAPE = "cloudscape";
    private static transient String IMQ_BROKERID;
    private static transient String IMQ_JDBC_VENDOR;
    private static transient String HADB_USER;
    private static transient String HADB_PASSWORD;
    private static transient String HADB_SERVERLIST;
    private static transient String IMQ_HADB;
    private static transient String IMQ_HADB_DSPROP;
    private static transient String IMQ_HADB_USER;
    private static transient String IMQ_HADB_PASSWORD;
    private static transient String IMQ_HADB_DSPROP_SERVERLIST;
    private static transient String MYSQL_USER;
    private static transient String MYSQL_PASSWORD;
    private static transient String MYSQL_URL;
    private static transient String FALLBACK_DATABASE_PASSWORD;
    private static transient String IMQ_MYSQL;
    private static transient String IMQ_MYSQL_DSPROP;
    private static transient String IMQ_MYSQL_USER;
    private static transient String IMQ_MYSQL_PASSWORD;
    private static transient String IMQ_MYSQL_DSPROP_URL;
    private static transient String IMQ_FALLBACK_DATABASE_PASSWORD;
    private Properties dbProps = new Properties();
    private Properties dsProps = new Properties();
    private transient HashMap<String, String[]> jmxConnectorEnv = null;
    private transient String jmxServiceURLList = null;
    private boolean isJMXServiceURLListValid = false;
    public static LifecycleManagedBroker lmb;

    public synchronized void start() throws ResourceAdapterInternalException {
        if (BROKER_TYPE_LOCAL.equals(this.actualBrokerType)) {
            try {
                this.lbr = new LocalBrokerRunner(this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, this.rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.brokerStartTimeout, this.adminUsername, this.adminPassword, this.adminPassFile, this.fallbackDBPassword, this.hadbPassword, this.mysqlPassword, this.keystorePassword, this.ldapPassword, this.bridgeAdminPassword, this._getEffectiveBrokerProps());
                this.lbr.start();
            }
            catch (Exception exception) {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting LOCAL broker=" + exception.getMessage());
                resourceAdapterInternalException.initCause((Throwable)exception);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                _loggerL.info(this.toString());
                exception.printStackTrace();
                _loggerL.throwing(_className, "start()", resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
        }
        if (BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType) || BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType)) {
            try {
                if (!_startedAtLeastOnce) {
                    _rmiRegistryPort = this.rmiRegistryPort;
                }
                if (this.ebr == null) {
                    this.ebr = new EmbeddedBrokerRunner(this.actualBrokerType, this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, _rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.adminUsername, this.adminPassword, this.adminPassFile, this.keystorePassword, this.ldapPassword, this.bridgeAdminPassword, this.doBind, this._getEffectiveBrokerProps());
                    this.ebr.init();
                }
                this.ebr.start();
                if (BROKER_TYPE_RADIRECT.equals(this.actualBrokerType)) {
                    jmsservice = this.ebr.getJMSService();
                }
                _startedAtLeastOnce = true;
            }
            catch (Exception exception) {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting EMBEDDED broker=" + exception.getMessage());
                resourceAdapterInternalException.initCause((Throwable)exception);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                _loggerL.info(this.toString());
                exception.printStackTrace();
                _loggerL.throwing(_className, "start()", resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
        }
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        if (this.ebr != null) {
            this.ebr.stop();
            this.ebr = null;
        }
        if (this.lbr != null) {
            this.lbr.stop();
            this.lbr = null;
        }
        this.started = false;
    }

    private Properties _getEffectiveBrokerProps() {
        Properties properties = new Properties();
        properties.setProperty("imq.cluster.nowaitForMasterBroker", DIRECT_MODE_DEFAULT);
        if (BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType) || BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType)) {
            properties.setProperty("imq.service.activate", "jmsdirect");
        }
        if (this.brokerEnableHA) {
            properties.setProperty("imq.cluster.ha", DIRECT_MODE_DEFAULT);
            if (this.clusterId != null) {
                properties.setProperty("imq.cluster.clusterid", this.clusterId);
            }
        } else {
            if (this.connectionURL != null && !"".equals(this.connectionURL)) {
                properties.setProperty("imq.cluster.brokerlist", this.connectionURL);
            }
            if (this.masterBroker != null) {
                properties.setProperty("imq.cluster.masterbroker", this.masterBroker);
            }
            if (this.nowaitForMasterBrokerTimeoutInSeconds > -1) {
                String string = String.valueOf(this.nowaitForMasterBrokerTimeoutInSeconds);
                properties.setProperty("imq.cluster.nowaitForMasterBrokerTimeoutInSeconds", string);
            }
        }
        if (this.dbType != null) {
            properties.setProperty("imq.persist.store", "jdbc");
            if (this.dbProps.containsKey(FALLBACK_DATABASE_PASSWORD)) {
                properties.setProperty(IMQ_FALLBACK_DATABASE_PASSWORD, this.dbProps.getProperty(FALLBACK_DATABASE_PASSWORD));
            }
            if (DB_TYPE_HADB.equals(this.dbType)) {
                properties.setProperty(IMQ_JDBC_VENDOR, this.dbType);
                properties.setProperty(IMQ_BROKERID, this.brokerId);
                if (this.dbProps.containsKey(HADB_USER)) {
                    properties.setProperty(IMQ_HADB_USER, this.dbProps.getProperty(HADB_USER));
                }
                if (this.dbProps.containsKey(HADB_PASSWORD)) {
                    properties.setProperty(IMQ_HADB_PASSWORD, this.dbProps.getProperty(HADB_PASSWORD));
                }
                if (this.dsProps.containsKey(HADB_SERVERLIST)) {
                    properties.setProperty(IMQ_HADB_DSPROP_SERVERLIST, this.dsProps.getProperty(HADB_SERVERLIST));
                }
            } else if (DB_TYPE_MYSQL.equals(this.dbType)) {
                properties.setProperty(IMQ_JDBC_VENDOR, this.dbType);
                properties.setProperty(IMQ_BROKERID, this.brokerId);
                if (this.dbProps.containsKey(MYSQL_USER)) {
                    properties.setProperty(IMQ_MYSQL_USER, this.dbProps.getProperty(MYSQL_USER));
                }
                if (this.dbProps.containsKey(MYSQL_PASSWORD)) {
                    properties.setProperty(IMQ_MYSQL_PASSWORD, this.dbProps.getProperty(MYSQL_PASSWORD));
                }
                if (this.dsProps.containsKey(MYSQL_URL)) {
                    properties.setProperty(IMQ_MYSQL_DSPROP_URL, this.dsProps.getProperty(MYSQL_URL));
                }
            }
        }
        return properties;
    }

    public JMSService _getJMSService() {
        if (!BROKER_TYPE_RADIRECT.equals(this.actualBrokerType)) {
            return null;
        }
        if (this.ebr == null) {
            return null;
        }
        if (jmsservice != null) {
            jmsservice = this.ebr.getJMSService();
        }
        return jmsservice;
    }

    public static final JMSService _getRAJMSService() {
        return jmsservice;
    }

    public synchronized void setStartRmiRegistry(boolean bl) {
        _loggerL.entering(_className, "setStartRmiRegistry()", new Boolean(bl));
        if (this.started || _startedAtLeastOnce && (BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType) || BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType))) {
            _loggerL.warning("MQJMSRA_RA2001: setStartRmiRegistry:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.startRmiRegistry + ":to:" + bl);
            return;
        }
        this.startRmiRegistry = bl;
    }

    public boolean getStartRmiRegistry() {
        _loggerL.entering(_className, "getStartRmiRegistry()", new Boolean(this.startRmiRegistry));
        return this.startRmiRegistry;
    }

    public synchronized void setRmiRegistryPort(int n) {
        _loggerL.entering(_className, "setRmiRegistryPort()", new Integer(n));
        if (this.started || _startedAtLeastOnce && (BROKER_TYPE_EMBEDDED.equals(this.actualBrokerType) || BROKER_TYPE_RADIRECT.equals(this.actualBrokerType) || BROKER_TYPE_APIDIRECT.equals(this.actualBrokerType))) {
            _loggerL.warning("MQJMSRA_RA2001: setRmiRegistryPort:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.rmiRegistryPort + ":to:" + n);
            return;
        }
        this.rmiRegistryPort = n;
    }

    public int getRmiRegistryPort() {
        _loggerL.entering(_className, "getRmiRegistryPort()", new Integer(this.rmiRegistryPort));
        return this.rmiRegistryPort;
    }

    public String getBrokerType() {
        return this.requestedBrokerType;
    }

    public synchronized void setBrokerType(String string) {
        _loggerL.entering(_className, "setBrokerType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:lifecycle managed broker already started:Disallowing change from:" + this.requestedBrokerType + ":to:" + string);
            return;
        }
        this.requestedBrokerType = string;
        if ("DIRECT".equals(string) || BROKER_TYPE_EMBEDDED.equals(string)) {
            this.actualBrokerType = LifecycleManagedBroker._isDirectDefault() ? "DIRECT" : BROKER_TYPE_EMBEDDED;
            if ("DIRECT".equals(this.actualBrokerType)) {
                this.actualBrokerType = LifecycleManagedBroker._useAPIDirectImplementation() ? BROKER_TYPE_APIDIRECT : BROKER_TYPE_RADIRECT;
            }
        } else if (BROKER_TYPE_LOCAL.equals(string) || BROKER_TYPE_REMOTE.equals(string)) {
            this.actualBrokerType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + string + ":remaining at brokerType=" + this.requestedBrokerType);
        }
    }

    private static boolean _isDirectDefault() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct", DIRECT_MODE_DEFAULT));
    }

    protected static boolean _useAPIDirectImplementation() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.apidirect", APIDIRECT_MODE_DEFAULT));
    }

    public boolean isLocal() {
        return BROKER_TYPE_LOCAL.equals(this.actualBrokerType);
    }

    public boolean isRemote() {
        return BROKER_TYPE_REMOTE.equals(this.actualBrokerType);
    }

    public String getBrokerInstanceName() {
        _loggerL.entering(_className, "getBrokerInstanceName()", this.brokerInstanceName);
        return this.brokerInstanceName;
    }

    public synchronized void setBrokerInstanceName(String string) {
        _loggerL.entering(_className, "setBrokerInstanceName()", string);
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(string)) {
            this.brokerInstanceName = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerInstanceName:Invalid value:" + string);
        }
    }

    public synchronized void setBrokerBindAddress(String string) {
        _loggerL.entering(_className, "setBrokerBindAddress()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:RA already started:Disallowing change from:" + this.brokerBindAddress + ":to:" + string);
            return;
        }
        try {
            InetAddress.getByName(string);
            this.brokerBindAddress = string;
        }
        catch (UnknownHostException unknownHostException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:Ignoring Invalid Address:" + string + ":ExceptionMsg=" + unknownHostException.getMessage());
        }
    }

    public String getBrokerBindAddress() {
        _loggerL.entering(_className, "getBrokerBindAddress()", this.brokerBindAddress);
        return this.brokerBindAddress;
    }

    public synchronized void setBrokerPort(int n) {
        _loggerL.entering(_className, "setBrokerPort()", new Integer(n));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + n);
            return;
        }
        this.brokerPort = n;
    }

    public int getBrokerPort() {
        _loggerL.entering(_className, "getBrokerPort()", new Integer(this.brokerPort));
        return this.brokerPort;
    }

    public int getBrokerStartTimeout() {
        return this.brokerStartTimeout;
    }

    public void setBrokerStartTimeout(int n) {
        this.brokerStartTimeout = n;
    }

    public synchronized void setBrokerHomeDir(String string) {
        _loggerL.entering(_className, "setBrokerHomeDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:RA already started:Disallowing change from:" + this.brokerHomeDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerHomeDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerHomeDir() {
        _loggerL.entering(_className, "getBrokerHomeDir()", this.brokerHomeDir);
        return this.brokerHomeDir;
    }

    public synchronized void setBrokerLibDir(String string) {
        _loggerL.entering(_className, "setBrokerLibDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:RA already started:Disallowing change from:" + this.brokerLibDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerLibDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerLibDir() {
        _loggerL.entering(_className, "getBrokerLibDir()", this.brokerLibDir);
        return this.brokerLibDir;
    }

    public synchronized void setBrokerVarDir(String string) {
        _loggerL.entering(_className, "setBrokerVarDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:RA already started:Disallowing change from:" + this.brokerVarDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerVarDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerVarDir() {
        _loggerL.entering(_className, "getBrokerVarDir()", this.brokerVarDir);
        return this.brokerVarDir;
    }

    public synchronized void setBrokerJavaDir(String string) {
        _loggerL.entering(_className, "setBrokerJavaDir()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:RA already started:Disallowing change from:" + this.brokerJavaDir + ":to:" + string);
            return;
        }
        try {
            String string2;
            this.brokerJavaDir = string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:Invalid value:" + string + ":Exception Message=" + iOException.getMessage());
        }
    }

    public String getBrokerJavaDir() {
        _loggerL.entering(_className, "getBrokerJavaDir()", this.brokerJavaDir);
        return this.brokerJavaDir;
    }

    public synchronized void setBrokerArgs(String string) {
        _loggerL.entering(_className, "setBrokerArgs()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerArgs:RA already started:Disallowing change from:" + this.brokerArgs + ":to:" + string);
            return;
        }
        this.brokerArgs = string;
    }

    public String getBrokerArgs() {
        _loggerL.entering(_className, "getBrokerArgs()", this.brokerArgs);
        return this.brokerArgs;
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean bl) {
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseJNDIRmiServiceURL:RA already started:Disallowing change from:" + this.useJNDIRmiServiceURL + ":to:" + bl);
            return;
        }
        this.useJNDIRmiServiceURL = bl;
    }

    public synchronized HashMap getJMXConnectorEnv() {
        _loggerL.entering(_className, "getJMXConnectorEnv()");
        if (this.jmxConnectorEnv == null) {
            this.jmxConnectorEnv = new HashMap();
            String[] stringArray = new String[]{this.getAdminUsername(), this.getAdminPassword()};
            this.jmxConnectorEnv.put("jmx.remote.credentials", stringArray);
        }
        return this.jmxConnectorEnv;
    }

    public synchronized String getJMXServiceURL() {
        _loggerL.entering(_className, "getJMXServiceURL()");
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: getJMXServiceURL:RA not started:Returning null");
            return null;
        }
        if (this.jmxServiceURL == null && !BROKER_TYPE_REMOTE.equals(this.actualBrokerType)) {
            AdminConnectionFactory adminConnectionFactory = new AdminConnectionFactory();
            try {
                adminConnectionFactory.setProperty("imqAddress", "mq://" + (this.getBrokerBindAddress() != null ? this.getBrokerBindAddress() : "localhost") + ":" + Integer.toString(this.getBrokerPort()) + "/jmxrmi");
                adminConnectionFactory.setProperty("imqDefaultAdminUsername", this.getAdminUsername());
                adminConnectionFactory.setProperty("imqDefaultAdminPassword", this.getAdminPassword());
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception configuring AdminConnectionFactory:Message=" + exception.getMessage());
            }
            try {
                JMXServiceURL jMXServiceURL = adminConnectionFactory.getJMXServiceURL();
                this.jmxServiceURL = jMXServiceURL.toString();
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception:Message=" + exception.getMessage());
            }
        }
        _loggerL.exiting(_className, "getJMXServiceURL()", this.jmxServiceURL);
        return this.jmxServiceURL;
    }

    public synchronized String getJMXServiceURLList() {
        _loggerL.entering(_className, "getJMXServiceURLList()", "For addressList = " + this.getConnectionURL());
        if (this.isJMXServiceURLListValid) {
            _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
            return this.jmxServiceURLList;
        }
        AdminConnectionFactory adminConnectionFactory = new AdminConnectionFactory();
        try {
            adminConnectionFactory.setProperty("imqDefaultAdminUsername", this.getAdminUsername());
            adminConnectionFactory.setProperty("imqDefaultAdminPassword", this.getAdminPassword());
        }
        catch (Exception exception) {
            _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception configuring AdminConnectionFactory:Message=" + exception.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("");
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getConnectionURL(), " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (_loggerL.isLoggable(Level.FINER)) {
                _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:addressList component = " + string2);
            }
            try {
                adminConnectionFactory.setProperty("imqAddress", string2);
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:address=" + string2);
                }
                string = adminConnectionFactory.getJMXServiceURL().toString();
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:JMXServiceURL string for addressList component " + string2 + " = " + string);
                }
                stringBuffer.append(string + " ");
            }
            catch (Exception exception) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception:Message=" + exception.getMessage());
            }
        }
        this.jmxServiceURLList = stringBuffer.toString();
        this.isJMXServiceURLListValid = true;
        _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
        return this.jmxServiceURLList;
    }

    public boolean getUseJNDIRmiServiceURL() {
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", new Boolean(this.useJNDIRmiServiceURL));
        return this.useJNDIRmiServiceURL;
    }

    public synchronized void setUseSSLJMXConnector(boolean bl) {
        _loggerL.entering(_className, "setUseSSLJMXConnector()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseSSLJMXConnector:RA already started:Disallowing change from:" + this.useSSLJMXConnector + ":to:" + bl);
            return;
        }
        this.useSSLJMXConnector = bl;
    }

    public boolean getUseSSLJMXConnector() {
        _loggerL.entering(_className, "getUseSSLJMXConnector()", new Boolean(this.useSSLJMXConnector));
        return this.useSSLJMXConnector;
    }

    public synchronized void setAdminUsername(String string) {
        _loggerL.entering(_className, "setAdminUsername()", string);
        this.adminUsername = string;
    }

    public String getAdminUsername() {
        _loggerL.entering(_className, "getAdminUsername()", this.adminUsername);
        return this.adminUsername;
    }

    public synchronized void setAdminPassword(String string) {
        _loggerL.entering(_className, "setAdminPassword()");
        this.adminPassword = string;
    }

    public String getAdminPassword() {
        _loggerL.entering(_className, "getAdminPassword()");
        return this.adminPassword;
    }

    public synchronized void setAdminPassFile(String string) {
        _loggerL.entering(_className, "setAdminPassFile()", string);
        this.adminPassFile = string;
    }

    public String getAdminPassFile() {
        _loggerL.entering(_className, "getAdminPassFile()", this.adminPassFile);
        return this.adminPassFile;
    }

    public synchronized void setKeystorePassword(String string) {
        _loggerL.entering(_className, "setKeystorePassword()");
        this.keystorePassword = string;
    }

    public String getKeystorePassword() {
        _loggerL.entering(_className, "getKeystorePassword()");
        return this.keystorePassword;
    }

    public synchronized void setBridgeAdminPassword(String string) {
        _loggerL.entering(_className, "setBridgeAdminPassword()");
        this.bridgeAdminPassword = string;
    }

    public String getBridgeAdminPassword() {
        _loggerL.entering(_className, "getBridgeAdminPassword()");
        return this.bridgeAdminPassword;
    }

    public synchronized void setLDAPPassword(String string) {
        _loggerL.entering(_className, "setLDAPPassword()");
        this.ldapPassword = string;
    }

    public String getLDAPPassword() {
        _loggerL.entering(_className, "getLDAPPassword()");
        return this.ldapPassword;
    }

    public synchronized void setBrokerEnableHA(boolean bl) {
        _loggerL.entering(_className, "setBrokerEnableHA()", new Boolean(bl));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerEnableHA:RA already started:Disallowing change from:" + this.brokerEnableHA + ":to:" + bl);
            return;
        }
        this.brokerEnableHA = bl;
    }

    public boolean getBrokerEnableHA() {
        _loggerL.entering(_className, "getBrokerEnableHA()", new Boolean(this.brokerEnableHA));
        return this.brokerEnableHA;
    }

    public synchronized void setClusterId(String string) {
        _loggerL.entering(_className, "setClusterId()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:RA already started:Disallowing change from:" + this.clusterId + ":to:" + string);
            return;
        }
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(string)) {
            this.clusterId = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:Invalid value:" + string);
        }
    }

    public String getClusterId() {
        _loggerL.entering(_className, "getClusterId()", this.clusterId);
        return this.clusterId;
    }

    public synchronized void setConnectionURL(String string) {
        String string2 = string;
        _loggerL.entering(_className, "setConnectionURL()", string2);
        this.connectionURL = string;
        this.isJMXServiceURLListValid = false;
    }

    public String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        if ("".equals(this.connectionURL)) {
            _loggerL.fine("MQJMSRA_RA1101: getConnectionURL:returning default of 'localhost' for empty connectionURL");
            return "localhost";
        }
        return this.connectionURL;
    }

    public synchronized void setMasterBroker(String string) {
        _loggerL.entering(_className, "setMasterBroker()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setMasterBroker:RA already started:Disallowing change from:" + this.masterBroker + ":to:" + string);
            return;
        }
        this.masterBroker = string;
    }

    public String getMasterBroker() {
        _loggerL.entering(_className, "getMasterBroker()", this.masterBroker);
        return this.masterBroker;
    }

    public int getNowaitForMasterBrokerTimeoutInSeconds() {
        return this.nowaitForMasterBrokerTimeoutInSeconds;
    }

    public void setNowaitForMasterBrokerTimeoutInSeconds(int n) {
        this.nowaitForMasterBrokerTimeoutInSeconds = n;
    }

    public synchronized void setBrokerId(String string) {
        _loggerL.entering(_className, "setBrokerId()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:RA already started:Disallowing change from:" + this.brokerId + ":to:" + string);
            return;
        }
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(string)) {
            this.brokerId = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:Invalid value:" + string);
        }
    }

    public String getBrokerId() {
        _loggerL.entering(_className, "getBrokerId()", this.brokerId);
        return this.brokerId;
    }

    public synchronized void setDBType(String string) {
        _loggerL.entering(_className, "setDBType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDBType:RA already started:Disallowing change from:" + this.dbType + ":to:" + string);
            return;
        }
        if (DB_TYPE_HADB.equals(string) || DB_TYPE_MYSQL.equals(string) || DB_TYPE_ORACLE.equals(string) || DB_TYPE_POINTBASE.equals(string) || DB_TYPE_CLOUDSCAPE.equals(string) || DB_TYPE_DERBY.equals(string)) {
            this.dbType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setDBType:Invalid value:" + string);
        }
    }

    public String getDBType() {
        _loggerL.entering(_className, "getDBType()", this.dbType);
        return this.dbType;
    }

    public synchronized void setDBProps(Properties properties) {
        _loggerL.entering(_className, "setDBProps()", properties);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDBProps:RA already started:Disallowing change from:" + this.dbProps.toString() + ":to:" + properties.toString());
            return;
        }
        this.dbProps = properties;
        if (properties.containsKey(HADB_PASSWORD)) {
            this.hadbPassword = properties.getProperty(HADB_PASSWORD);
        }
        if (properties.containsKey(MYSQL_PASSWORD)) {
            this.mysqlPassword = properties.getProperty(MYSQL_PASSWORD);
        }
        if (properties.containsKey(FALLBACK_DATABASE_PASSWORD)) {
            this.fallbackDBPassword = properties.getProperty(FALLBACK_DATABASE_PASSWORD);
        }
    }

    public Properties getDBProps() {
        _loggerL.entering(_className, "getDBProps()", this.dbProps);
        return this.dbProps;
    }

    public synchronized void setDSProps(Properties properties) {
        _loggerL.entering(_className, "setDSProps()", properties);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setDSProps:RA already started:Disallowing change from:" + this.dsProps.toString() + ":to:" + properties.toString());
            return;
        }
        this.dsProps = properties;
    }

    public Properties getDSProps() {
        _loggerL.entering(_className, "getDSProps()", this.dsProps);
        return this.dsProps;
    }

    public boolean isDoBind() {
        return this.doBind;
    }

    public void setDoBind(boolean bl) {
        this.doBind = bl;
    }

    public PortMapperClientHandler getPortMapperClientHandler() {
        if (this.isRemote() || this.isLocal()) {
            throw new IllegalStateException("Cannot access PortMapperClientHandler for LOCAL or REMOTE brokers");
        }
        if (this.isStarted()) {
            return Globals.getPortMapper();
        }
        throw new IllegalStateException("Cannot access PortMapperClientHandler until embedded broker has been started ");
    }

    private static final boolean isNameValidAlphaNumeric_(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SJSMQ LifecycleManagedBroker configuration=\n\tbrokerInstanceName       =" + this.brokerInstanceName + "\n" + "\tbrokerBindAddress        =" + this.brokerBindAddress + "\n" + "\tbrokerPort               =" + this.brokerPort + "\n" + "\tbrokerHomeDir            =" + this.brokerHomeDir + "\n" + "\tbrokerLibDir             =" + this.brokerLibDir + "\n" + "\tbrokerVarDir             =" + this.brokerVarDir + "\n" + "\tbrokerJavaDir            =" + this.brokerJavaDir + "\n" + "\tbrokerArgs               =" + this.brokerArgs + "\n" + "\tMasterBroker             =" + this.masterBroker + "\n" + "\tbrokerId                 =" + this.brokerId + "\n" + "\tadminUsername            =" + this.adminUsername + "\n" + "\tadminPassword            =" + ("admin".equals(this.adminPassword) ? "<default>" : "<modified>") + "\n" + "\tadminPassFile            =" + this.adminPassFile + "\n" + "\tConnectionURL            =" + this.connectionURL + "\n" + "\tdbType                   =" + this.dbType + "\n" + "\tdbProps                  =" + (this.dbProps != null ? this.dbProps.toString() : "null") + "\n" + "\tdsProps                  =" + (this.dsProps != null ? this.dsProps.toString() : "null") + "\n" + "\tuseJNDIRmiServiceURL     =" + this.useJNDIRmiServiceURL + "\n" + "\tuseSSLJMXConnector       =" + this.useSSLJMXConnector + "\n" + "\tbrokerEnableHA           =" + this.brokerEnableHA + "\n" + "\tclusterId                =" + this.clusterId + "\n" + "\trmiRegistryPort          =" + this.rmiRegistryPort + "\n" + "\tstartRmiRegistry         =" + this.startRmiRegistry + "\n" + "\tbrokerStartTimeout       =" + "\tjmxServiceURL            =" + this.jmxServiceURL + "\n" + this.brokerStartTimeout + "\n";
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("arg name:" + stringArray[i]);
                if (stringArray[i].equals("stop")) {
                    lmb.stop();
                    lmb = null;
                    continue;
                }
                if (stringArray[i].equals("brokerType")) {
                    string2 = stringArray[i + 1];
                    System.out.println("brokerType :" + string2);
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("brokerLibDir")) {
                    string3 = stringArray[i + 1];
                    System.out.println("brokerLibDir :" + string3);
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("brokerHomeDir")) {
                    string4 = stringArray[i + 1];
                    System.out.println("brokerHomeDir :" + string4);
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("brokerJavaHome")) {
                    string6 = stringArray[i + 1];
                    System.out.println("brokerJavaHome :" + string6);
                    ++i;
                    continue;
                }
                System.out.println("Ignoring unknown argument: " + stringArray[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("Received exception in parsing arguments");
            exception.printStackTrace();
            System.exit(1);
        }
        lmb = new LifecycleManagedBroker();
        if (string2 != null) {
            lmb.setBrokerType(string2);
        }
        if (string != null) {
            lmb.setBrokerPort(Integer.parseInt(string));
        }
        if (string3 != null) {
            lmb.setBrokerLibDir(string3);
        }
        if (string4 != null) {
            lmb.setBrokerHomeDir(string4);
        }
        if (string5 != null) {
            lmb.setBrokerVarDir(string5);
        }
        if (string6 != null) {
            lmb.setBrokerJavaDir(string6);
        }
        try {
            lmb.start();
        }
        catch (ResourceAdapterInternalException resourceAdapterInternalException) {
            resourceAdapterInternalException.printStackTrace();
            System.exit(1);
        }
    }

    static {
        IMQ_BROKERID = "imq.brokerid";
        IMQ_JDBC_VENDOR = "imq.persist.jdbc.dbVendor";
        HADB_USER = "hadb.user";
        HADB_PASSWORD = "hadb.password";
        HADB_SERVERLIST = "hadb.serverList";
        IMQ_HADB = "imq.persist.jdbc.hadb";
        IMQ_HADB_DSPROP = IMQ_HADB + ".property";
        IMQ_HADB_USER = IMQ_HADB + ".user";
        IMQ_HADB_PASSWORD = IMQ_HADB + ".password";
        IMQ_HADB_DSPROP_SERVERLIST = IMQ_HADB_DSPROP + ".serverList";
        MYSQL_USER = "mysql.user";
        MYSQL_PASSWORD = "mysql.password";
        MYSQL_URL = "mysqlproperty.url";
        FALLBACK_DATABASE_PASSWORD = "jdbc.password";
        IMQ_MYSQL = "imq.persist.jdbc.mysql";
        IMQ_MYSQL_DSPROP = IMQ_MYSQL + ".property";
        IMQ_MYSQL_USER = IMQ_MYSQL + ".user";
        IMQ_MYSQL_PASSWORD = IMQ_MYSQL + ".password";
        IMQ_MYSQL_DSPROP_URL = IMQ_MYSQL_DSPROP + ".url";
        IMQ_FALLBACK_DATABASE_PASSWORD = "imq.persist.jdbc.password";
        lmb = null;
    }
}

