/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;
import java.util.List;

public class ProducerHandler
extends PacketHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block40: {
            block39: {
                String string;
                int n;
                block38: {
                    packet2 = new Packet(iMQConnection.useDirectBuffers());
                    packet2.setPacketType(packet.getPacketType() + 1);
                    packet2.setConsumerID(packet.getConsumerID());
                    boolean bl = packet.getIndempotent();
                    n = 200;
                    string = null;
                    Hashtable hashtable2 = null;
                    try {
                        hashtable2 = packet.getProperties();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Can not load props", exception);
                    }
                    hashtable = new Hashtable<String, Object>();
                    Destination destination = null;
                    try {
                        block37: {
                            try {
                                if (packet.getPacketType() == 18) {
                                    Object object;
                                    Object object2;
                                    String string2 = (String)hashtable2.get("JMQDestination");
                                    Integer n2 = (Integer)hashtable2.get("JMQDestType");
                                    assert (string2 != null) : " bad protocol ";
                                    assert (n2 != null) : " bad protocol ";
                                    if (!iMQConnection.isAdminConnection() && MemoryGlobals.MEM_DISALLOW_PRODUCERS) {
                                        n = 500;
                                        string = "Low memory";
                                        this.logger.log(16, "B2076");
                                        throw new BrokerException(string, n);
                                    }
                                    Long l = (Long)hashtable2.get("JMQSessionID");
                                    if (l != null && (object2 = iMQConnection.getSession((SessionUID)((Object)(object = new SessionUID(l))))) == null) {
                                        throw new BrokerException("Internal Error: client sent invalid sessionUID w/ ADD_PRODUCER " + object + " session does not exist");
                                    }
                                    object = null;
                                    if (string2 != null && !DestinationUID.isWildcard(string2) && n2 != null) {
                                        while ((destination = Destination.getDestination(string2, (int)n2, true, !iMQConnection.isAdminConnection())) != null) {
                                            try {
                                                destination.incrementRefCount();
                                                break;
                                            }
                                            catch (BrokerException brokerException) {
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", illegalStateException, 500);
                                            }
                                        }
                                        if (destination == null) {
                                            this.logger.log(4, "Unable to add producer to " + string2 + " :" + DestType.toString((int)n2) + " destination can not be autocreated ");
                                            string = "can not create destination";
                                            n = 404;
                                            throw new BrokerException(string, n);
                                        }
                                        object = destination.getDestinationUID();
                                    } else {
                                        if (string2 == null || n2 == null) {
                                            string = "no destination passed [dest,type] = [" + string2 + "," + n2 + "]";
                                            n = 500;
                                            throw new BrokerException(string, n);
                                        }
                                        object = DestinationUID.getUID(string2, DestType.isQueue((int)n2));
                                    }
                                    object2 = packet.getSysMessageID().toString();
                                    Producer producer = this.addProducer((DestinationUID)object, iMQConnection, (String)object2, bl);
                                    ProducerUID producerUID = producer.getProducerUID();
                                    assert (producerUID != null);
                                    boolean bl2 = destination == null ? true : destination.isProducerActive(producerUID);
                                    hashtable.put("JMQProducerID", new Long(producerUID.longValue()));
                                    hashtable.put("JMQDestinationID", ((DestinationUID)object).toString());
                                    if (destination == null) {
                                        hashtable.put("JMQBytes", new Long(-1L));
                                        hashtable.put("JMQSize", new Integer(-1));
                                    } else if (bl2) {
                                        hashtable.put("JMQBytes", new Long(destination.getBytesProducerFlow()));
                                        hashtable.put("JMQSize", new Integer(destination.getSizeProducerFlow()));
                                    } else {
                                        hashtable.put("JMQBytes", new Long(0L));
                                        hashtable.put("JMQSize", new Integer(0));
                                    }
                                    break block37;
                                }
                                assert (packet.getPacketType() == 66);
                                Long l = (Long)hashtable2.get("JMQProducerID");
                                assert (l != null);
                                ProducerUID producerUID = new ProducerUID(l == null ? 0L : l);
                                this.removeProducer(producerUID, bl, iMQConnection, "Producer closed requested:\n\tconnection: " + (Object)((Object)iMQConnection.getConnectionUID()) + "\n\tproducerID: " + (Object)((Object)producerUID) + "\n\trequest sysmsgid message: " + packet.getSysMessageID());
                            }
                            catch (BrokerException brokerException) {
                                n = brokerException.getStatusCode();
                                string = brokerException.getMessage();
                                this.logger.log(8, string);
                                Object var19_26 = null;
                                if (destination != null) {
                                    destination.decrementRefCount();
                                }
                                break block38;
                            }
                            catch (Exception exception) {
                                this.logger.logStack(8, "B3100", (Object)"producer message ", (Throwable)exception);
                                string = exception.getMessage();
                                n = 500;
                                Object var19_27 = null;
                                if (destination != null) {
                                    destination.decrementRefCount();
                                }
                            }
                        }
                        Object var19_25 = null;
                        if (destination != null) {
                            destination.decrementRefCount();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_28 = null;
                        if (destination != null) {
                            destination.decrementRefCount();
                        }
                        throw throwable;
                    }
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block39;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block40;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    public Producer addProducer(DestinationUID destinationUID, IMQConnection iMQConnection, String string, boolean bl) throws BrokerException {
        Producer producer = null;
        boolean bl2 = true;
        boolean bl3 = false;
        if (bl) {
            producer = Producer.getProducer(string);
        }
        if (producer == null) {
            producer = Producer.createProducer(destinationUID, iMQConnection.getConnectionUID(), string);
            assert (producer != null);
            iMQConnection.addProducer(producer);
            List list = Destination.findMatchingIDs(destinationUID);
            for (DestinationUID destinationUID2 : list) {
                Destination destination = Destination.getDestination(destinationUID2);
                if (destinationUID.isWildcard() && destination.isTemporary()) {
                    this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + destinationUID + " to temporary destination " + destination.getUniqueName() + " is not supported, ignoring");
                    continue;
                }
                if (destinationUID.isWildcard() && destination.isInternal()) {
                    this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + destinationUID + " to internal destination " + destination.getUniqueName() + " is not supported, ignoring");
                    continue;
                }
                if (destinationUID.isWildcard() && destination.isDMQ()) {
                    this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + destinationUID + " to the DeadMessageQueue" + destination.getUniqueName() + " is not supported, ignoring");
                    continue;
                }
                bl2 = destination.addProducer(producer);
            }
        }
        return producer;
    }

    public void removeProducer(ProducerUID producerUID, boolean bl, IMQConnection iMQConnection, String string) throws BrokerException {
        String string2 = null;
        int n = 200;
        Producer producer = Producer.getProducer(producerUID);
        if (producer != null || !bl) {
            if (producer == null) {
                this.logger.log(8, "B3100", (Object)("Internal error Unable to find producer " + (Object)((Object)producerUID) + "\n\t checking if producer was removed recently " + Producer.checkProducer(producerUID)));
                string2 = "unknown producer";
                n = 500;
                throw new BrokerException(string2, n);
            }
            if (producer.getConnectionUID() != iMQConnection.getConnectionUID()) {
                this.logger.log(8, "B3100", (Object)(" error connection removing producer it doesnt own\n\tPID=" + (Object)((Object)producerUID) + "\n\tconnectionUID of request " + (Object)((Object)iMQConnection.getConnectionUID()) + "\n\tconnectionUID of creator " + (Object)((Object)producer.getConnectionUID()) + "\n\tchecking producer state: " + Producer.checkProducer(producerUID)));
                string2 = "unknown producer";
                n = 500;
                throw new BrokerException(string2, n);
            }
            iMQConnection.removeProducer(producerUID, string);
        }
    }
}

