/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import com.sun.messaging.jms.blc.LifecycleManagedBroker;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ConcurrentEndpointConsumer;
import com.sun.messaging.jms.ra.ConnectionManager;
import com.sun.messaging.jms.ra.EndpointConsumer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class ResourceAdapter
implements javax.resource.spi.ResourceAdapter,
ExceptionListener,
Serializable,
EventListener {
    boolean manageBrokerLifecycle = true;
    private String raUID = null;
    private transient BootstrapContext b_context = null;
    protected transient WorkManager workMgr = null;
    private transient boolean started;
    private transient boolean stopping;
    private transient HashMap<Integer, MessageEndpointFactory> epFactories = null;
    private transient HashMap<Integer, EndpointConsumer> epConsumers = null;
    private transient HashMap<Integer, Integer> epFactoryToConsumer = null;
    private transient int _factoryID = 0;
    private transient int _consumerID = 0;
    private transient XAConnectionFactory xacf = null;
    protected transient XAConnectionImpl xac = null;
    private transient Method onMessage = null;
    private transient boolean logRCFailures = true;
    private static final transient String _className = "com.sun.messaging.jms.ra.ResourceAdapter";
    protected static final transient String _lgrNameBase = "javax.resourceadapter.mqjmsra";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerB = Logger.getLogger("javax.resourceadapter.mqjmsra");
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_RA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_RA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_RA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    protected static final transient ConnectionManager _cm = new ConnectionManager();
    protected static final transient Version _version = new Version();
    private static boolean isSameRMAllowed = true;
    private static boolean isRevert6882044 = false;
    protected String userName = "guest";
    protected String password = "guest";
    private boolean reconnectEnabled = false;
    private int reconnectInterval = 5000;
    private int reconnectAttempts = 6;
    private String addressListBehavior = "PRIORITY";
    private int addressListIterations = 1;
    private int maxLoopDelay = 120000;
    private boolean inAppClientContainer = false;
    private boolean inClusteredContainer = false;
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    protected static final String BROKER_TYPE_SOMEDIRECT = "DIRECT";
    protected static final String BROKER_TYPE_APIDIRECT = "APIDIRECT";
    protected static final String BROKER_TYPE_RADIRECT = "RADIRECT";
    private static final String DIRECT_MODE_DEFAULT_STANDALONE = "true";
    private static final String DIRECT_MODE_DEFAULT_CLUSTERED = "false";
    private static final String APIDIRECT_MODE_DEFAULT = "false";
    private String groupName = null;
    private transient LifecycleManagedBroker lmb;
    private int brokerPort = 7676;
    private String brokerType = "REMOTE";
    private String connectionURL = "";

    public LifecycleManagedBroker getLifecycleManagedBroker() {
        if (this.lmb == null) {
            this.lmb = new LifecycleManagedBroker();
        }
        return this.lmb;
    }

    public ResourceAdapter() {
        _loggerL.entering(_className, "constructor()");
        this.started = false;
    }

    public synchronized void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        _loggerL.entering(_className, "start()", bootstrapContext);
        isSameRMAllowed = Boolean.valueOf(System.getProperty("imq.jmsra.isSameRMAllowed", DIRECT_MODE_DEFAULT_STANDALONE));
        isRevert6882044 = Boolean.valueOf(System.getProperty("imq.jmsra.isRevert6882044", "false"));
        this.stopping = false;
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: start:Previously started:Ignoring");
        } else {
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMS Resource Adapter starting: " + this.getPublicBrokerType());
            this.b_context = bootstrapContext;
            if (this.b_context != null) {
                this.workMgr = this.b_context.getWorkManager();
            }
            this._adjustInAppClientContainer();
            this.xacf = new XAConnectionFactory();
            if (!this.inAppClientContainer) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty("imq.DaemonThreads", ResourceAdapter.DIRECT_MODE_DEFAULT_STANDALONE);
                        return null;
                    }
                });
            }
            if (this.isManageBrokerLifecycle() && !this._isRemote()) {
                this.getLifecycleManagedBroker().start();
            }
            try {
                this.configureFactory();
                if (!this._isRADirect()) {
                    this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                    _loggerL.fine("MQJMSRA_RA1101: start:cID=" + this.xac._getConnectionID());
                    this.init();
                }
            }
            catch (JMSException jMSException) {
                if (this.getLifecycleManagedBroker().isStarted() && this.getLifecycleManagedBroker().isLocal()) {
                    this.getLifecycleManagedBroker().stop();
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:JMSException on createConnection=" + jMSException.getMessage());
                resourceAdapterInternalException.initCause((Throwable)jMSException);
                _loggerL.severe(resourceAdapterInternalException.getMessage());
                jMSException.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
            this.epFactories = new HashMap(10);
            this.epConsumers = new HashMap(10);
            this.epFactoryToConsumer = new HashMap(10);
            this._setOnMessageMethod();
            this.started = true;
            _loggerL.config(_lgrMID_INF + this.toString());
            _loggerL.config("MQJMSRA_RA1101: start:SJSMQ JMSRA Connection Factory Config=" + this.xacf.getCurrentConfiguration());
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA Started:" + this.getPublicBrokerType());
        }
        _loggerL.exiting(_className, "start()");
    }

    public synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        this.stopping = true;
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: stop:Previously stopped:Ignoring");
        } else {
            _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA stopping...");
            this.removeAllConsumers();
            if (this.xac != null) {
                try {
                    if (_loggerL.isLoggable(Level.FINER)) {
                        _loggerL.finer("MQJMSRA_RA1101: stop:close:cID=" + this.xac._getConnectionID());
                    }
                    this.xac.close();
                }
                catch (JMSException jMSException) {
                    _loggerL.logp(Level.WARNING, _className, "stop()", "MQJMSRA_RA2001: Exception on close:Ignoring:", jMSException);
                }
            }
            if (_cm != null) {
                _cm.destroyConnections();
            }
            if (this.isManageBrokerLifecycle() && !this._isRemote()) {
                this.getLifecycleManagedBroker().stop();
            }
            this.started = false;
        }
        _loggerL.info("MQJMSRA_RA1101: SJSMQ JMSRA stopped.");
        _loggerL.exiting(_className, "stop()");
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException {
        Object[] objectArray = new Object[]{messageEndpointFactory, activationSpec};
        _loggerIM.entering(_className, "endpointActivation()", objectArray);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", objectArray);
            NotSupportedException notSupportedException = new NotSupportedException("MQJMSRA-endpointActivation:Error:RA not started:aborting");
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)notSupportedException);
            throw notSupportedException;
        }
        EndpointConsumer endpointConsumer = System.getProperty("imq.jmsra.endpoint.concurrent", "false").equals(DIRECT_MODE_DEFAULT_STANDALONE) ? new ConcurrentEndpointConsumer(this, messageEndpointFactory, activationSpec, this._isRADirect()) : new EndpointConsumer(this, messageEndpointFactory, activationSpec, this._isRADirect());
        try {
            endpointConsumer.startMessageConsumer();
            if (_loggerIM.isLoggable(Level.FINER)) {
                _loggerIM.finer("MQJMSRA_RA1101: endpointActivation:createMessageConsumer:DONE:fID=" + endpointConsumer.getFactoryID() + " cID=" + endpointConsumer.getConsumerID());
            }
        }
        catch (Exception exception) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointActivation()", "MQJMSRA_RA4001: :Failed due to:" + exception.getMessage(), objectArray);
            NotSupportedException notSupportedException = new NotSupportedException("MQJMSRA-endpointActivation:Exception on createMessageConsumer:");
            notSupportedException.initCause((Throwable)exception);
            _loggerIM.throwing(_className, "endpointActivation()", (Throwable)notSupportedException);
            throw notSupportedException;
        }
        _loggerIM.exiting(_className, "endpointActivation()");
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        Object[] objectArray = new Object[]{messageEndpointFactory, activationSpec};
        _loggerIM.entering(_className, "endpointDeactivation()", objectArray);
        if (!this.started) {
            _loggerIM.logp(Level.SEVERE, _className, "endpointDeactivation()", "MQJMSRA_RA4001: MQJMSRA not started:Aborting:", objectArray);
        } else {
            int n = this.matchMessageFactory(messageEndpointFactory);
            if (n != -1) {
                int n2 = this._getConsumerIDbyFactoryID(n);
                EndpointConsumer endpointConsumer = this._getEndpointConsumer(n2);
                endpointConsumer.setDeactivated();
                try {
                    if (_loggerIM.isLoggable(Level.FINER)) {
                        _loggerIM.finer("MQJMSRA_RA1101: endpointDeactivation:stopMessageConsumer:fID=" + n + " cID=" + n2);
                    }
                    endpointConsumer.stopMessageConsumer();
                }
                catch (Exception exception) {
                    _loggerIM.logp(Level.WARNING, _className, "endpointDeactivation()", "MQJMSRA_RA2001: Exception on stopMessageConsumer:Ignoring:", exception);
                    exception.printStackTrace();
                }
                this.removeFromMaps(n);
            } else {
                _loggerIM.log(Level.WARNING, "MQJMSRA_RA2001: endpointDeactivation:Ignoring:Not found:" + activationSpec.toString());
            }
        }
        _loggerIM.exiting(_className, "endpointDeactivation()");
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecArray) throws ResourceException {
        _loggerL.entering(_className, "getXAResources()");
        XAResource[] xAResourceArray = new XAResource[]{};
        _loggerL.exiting(_className, "getXAResources()");
        return xAResourceArray;
    }

    public void onException(JMSException jMSException) {
        _loggerL.entering(_className, "onException()", (Object)jMSException);
        _loggerL.warning("MQJMSRA_RA2001: onException:Connection Failed:" + jMSException.getMessage());
        this.logRCFailures = true;
        int n = this.reconnectInterval;
        int n2 = 0;
        while (this.started && !this.stopping) {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                _loggerL.warning("MQJMSRA_RA2001: onException:Reconnecting...Loop Attempt# " + ++n2 + ":Delayed " + n + " milliseconds.");
                this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                this.init();
                _loggerL.warning("MQJMSRA_RA2001: onException:Reconnect successfull on loop# " + n2);
                break;
            }
            catch (JMSException jMSException2) {
                if (this.logRCFailures) {
                    _loggerL.severe("MQJMSRA_RA2001: onException:Reconnect unsuccessfull on loop# " + n2 + ":" + jMSException2.getMessage());
                    jMSException2.printStackTrace();
                } else {
                    _loggerL.severe("MQJMSRA_RA2001: onException:Reconnect unsuccessfull on loop# " + n2);
                }
                this.logRCFailures = false;
                if (n >= this.maxLoopDelay || (n *= 3) <= this.maxLoopDelay) continue;
                n = this.maxLoopDelay;
            }
        }
        _loggerL.exiting(_className, "onException()");
    }

    public void onEvent(Event event) {
        _loggerL.entering(_className, "onEvent()", event);
        _loggerL.info("MQJMSRA_RA1101: onEvent:Connection Event:" + (event == null ? "null" : event.toString()));
    }

    public synchronized void setUserName(String string) {
        _loggerL.entering(_className, "setUserName()", string);
        this.userName = string;
    }

    public String getUserName() {
        _loggerL.entering(_className, "getUserName()", this.userName);
        return this.userName;
    }

    public synchronized void setPassword(String string) {
        _loggerL.entering(_className, "setPassword()");
        this.password = string;
    }

    public String getPassword() {
        _loggerL.entering(_className, "getPassword()");
        return this.password;
    }

    public synchronized void setReconnectEnabled(boolean bl) {
        _loggerL.entering(_className, "setReconnectEnabled()", Boolean.toString(bl));
        this.reconnectEnabled = bl;
    }

    public boolean getReconnectEnabled() {
        _loggerL.entering(_className, "getReconnectEnabled()", Boolean.toString(this.reconnectEnabled));
        return this.reconnectEnabled;
    }

    public synchronized void setReconnectInterval(int n) {
        _loggerL.entering(_className, "setReconnectInterval()", Integer.toString(n));
        this.reconnectInterval = n;
    }

    public int getReconnectInterval() {
        _loggerL.entering(_className, "getReconnectInterval()", Integer.toString(this.reconnectInterval));
        return this.reconnectInterval;
    }

    public synchronized void setReconnectAttempts(int n) {
        _loggerL.entering(_className, "setReconnectAttempts()", Integer.toString(n));
        this.reconnectAttempts = n;
    }

    public int getReconnectAttempts() {
        _loggerL.entering(_className, "getReconnectAttempts()", Integer.toString(this.reconnectAttempts));
        return this.reconnectAttempts;
    }

    public synchronized void setAddressListBehavior(String string) {
        _loggerL.entering(_className, "setAddressListBehavior()", string);
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(string) ? "RANDOM" : "PRIORITY";
    }

    public String getAddressListBehavior() {
        _loggerL.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        return this.addressListBehavior;
    }

    public synchronized void setAddressListIterations(int n) {
        _loggerL.entering(_className, "setAddressListIterations()", Integer.toString(n));
        if (n < 1) {
            _loggerL.warning("MQJMSRA_RA2001: setAddressListIterations:Invalid value:" + Integer.toString(n) + ":Setting to 1");
            this.addressListIterations = 1;
        } else {
            this.addressListIterations = n;
        }
    }

    public int getAddressListIterations() {
        _loggerL.entering(_className, "getAddressListIterations()", Integer.toString(this.addressListIterations));
        return this.addressListIterations;
    }

    public synchronized void setInAppClientContainer(boolean bl) {
        _loggerL.entering(_className, "setInAppClientContainer()", Boolean.toString(bl));
        this.inAppClientContainer = bl;
        this._adjustInAppClientContainer();
    }

    public boolean getInAppClientContainer() {
        _loggerL.entering(_className, "getInAppClientContainer()", Boolean.toString(this.inAppClientContainer));
        return this.inAppClientContainer;
    }

    public synchronized void setInClusteredContainer(boolean bl) {
        _loggerL.entering(_className, "setInClusteredContainer()", Boolean.toString(bl));
        this.inClusteredContainer = bl;
    }

    public boolean getInClusteredContainer() {
        _loggerL.entering(_className, "getInClusteredContainer()", Boolean.toString(this.inClusteredContainer));
        return this.inClusteredContainer;
    }

    public synchronized void setGroupName(String string) {
        _loggerL.entering(_className, "setGroupName()", string);
        this.groupName = string;
    }

    public String getGroupName() {
        _loggerL.entering(_className, "getGroupName()", this.groupName);
        return this.groupName;
    }

    public synchronized void setBrokerType(String string) {
        _loggerL.entering(_className, "setBrokerType()", string);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:RA already started:Disallowing change from:" + this.brokerType + ":to:" + string);
            return;
        }
        if ("DIRECT".equals(string) || BROKER_TYPE_EMBEDDED.equals(string)) {
            this.brokerType = this.getInClusteredContainer() ? (ResourceAdapter._isDirectDefaultWhenClustered() ? "DIRECT" : BROKER_TYPE_EMBEDDED) : (ResourceAdapter._isDirectDefaultWhenStandalone() ? "DIRECT" : BROKER_TYPE_EMBEDDED);
            if ("DIRECT".equals(this.brokerType)) {
                if (ResourceAdapter._useAPIDirectImplementation()) {
                    _loggerL.fine("MQJMSRA_RA1101:  Using new API DIRECT mode");
                    this.brokerType = BROKER_TYPE_APIDIRECT;
                } else {
                    _loggerL.fine("MQJMSRA_RA1101:  Using old JMSRA DIRECT mode");
                    this.brokerType = BROKER_TYPE_RADIRECT;
                }
            }
        } else if (BROKER_TYPE_LOCAL.equals(string) || BROKER_TYPE_REMOTE.equals(string)) {
            this.brokerType = string;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + string + ":remaining at brokerType=" + this.brokerType);
        }
        if (this.isManageBrokerLifecycle()) {
            this.getLifecycleManagedBroker().setBrokerType(string);
        }
    }

    public String getBrokerType() {
        _loggerL.entering(_className, "getBrokerType()", this.brokerType);
        return this.brokerType;
    }

    private String getPublicBrokerType() {
        String string = this._isAnyDirect() ? "DIRECT" : this.getBrokerType();
        return string;
    }

    public synchronized void setBrokerInstanceName(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerInstanceName()", string);
        this.getLifecycleManagedBroker().setBrokerInstanceName(string);
    }

    public String getBrokerInstanceName() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerInstanceName();
        _loggerL.entering(_className, "getBrokerInstanceName()", string);
        return string;
    }

    public synchronized void setBrokerBindAddress(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerBindAddress()", string);
        this.getLifecycleManagedBroker().setBrokerBindAddress(string);
    }

    public String getBrokerBindAddress() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerBindAddress();
        _loggerL.entering(_className, "getBrokerBindAddress()", string);
        return string;
    }

    public synchronized void setBrokerPort(int n) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerPort()", new Integer(n));
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + n);
            return;
        }
        this.brokerPort = n;
        if (this.isManageBrokerLifecycle()) {
            this.getLifecycleManagedBroker().setBrokerPort(n);
        }
    }

    public int getBrokerPort() {
        this.checkManaged();
        _loggerL.entering(_className, "getBrokerPort()", new Integer(this.brokerPort));
        return this.brokerPort;
    }

    public synchronized void setConnectionURL(String string) {
        String string2 = string;
        _loggerL.entering(_className, "setConnectionURL()", string2);
        this.connectionURL = string;
        if (this.isManageBrokerLifecycle()) {
            this.getLifecycleManagedBroker().setConnectionURL(string);
        }
    }

    public String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        return this.connectionURL;
    }

    public synchronized void setBrokerHomeDir(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerHomeDir()", string);
        this.getLifecycleManagedBroker().setBrokerHomeDir(string);
    }

    public String getBrokerHomeDir() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerHomeDir();
        _loggerL.entering(_className, "getBrokerHomeDir()", string);
        return string;
    }

    public synchronized void setBrokerVarDir(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerVarDir()", string);
        this.getLifecycleManagedBroker().setBrokerVarDir(string);
    }

    public String getBrokerVarDir() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerVarDir();
        _loggerL.entering(_className, "getBrokerVarDir()", string);
        return string;
    }

    public synchronized void setBrokerLibDir(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerLibDir()", string);
        this.getLifecycleManagedBroker().setBrokerLibDir(string);
    }

    public String getBrokerLibDir() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerLibDir();
        _loggerL.entering(_className, "getBrokerLibDir()", string);
        return string;
    }

    public synchronized void setBrokerJavaDir(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerJavaDir()", string);
        this.getLifecycleManagedBroker().setBrokerJavaDir(string);
    }

    public String getBrokerJavaDir() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerJavaDir();
        _loggerL.entering(_className, "getBrokerJavaDir()", string);
        return string;
    }

    public synchronized void setBrokerArgs(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerArgs()", string);
        this.getLifecycleManagedBroker().setBrokerArgs(string);
    }

    public String getBrokerArgs() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerArgs();
        _loggerL.entering(_className, "getBrokerArgs()", string);
        return string;
    }

    public synchronized void setMasterBroker(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setMasterBroker()", string);
        this.getLifecycleManagedBroker().setMasterBroker(string);
    }

    public String getMasterBroker() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getMasterBroker();
        _loggerL.entering(_className, "getMasterBroker()", string);
        return string;
    }

    public void setBrokerStartTimeout(int n) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerStartTimeout()", n);
        this.getLifecycleManagedBroker().setBrokerStartTimeout(n);
    }

    public int getBrokerStartTimeout() {
        this.checkManaged();
        int n = this.getLifecycleManagedBroker().getBrokerStartTimeout();
        _loggerL.entering(_className, "getBrokerStartTimeout()", n);
        return n;
    }

    public synchronized void setAdminUsername(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setAdminUsername()", string);
        this.getLifecycleManagedBroker().setAdminUsername(string);
    }

    public String getAdminUsername() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getAdminUsername();
        _loggerL.entering(_className, "getAdminUsername()", string);
        return string;
    }

    public synchronized void setAdminPassword(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setAdminPassword()", string);
        this.getLifecycleManagedBroker().setAdminPassword(string);
    }

    public String getAdminPassword() {
        String string = this.getLifecycleManagedBroker().getAdminPassword();
        _loggerL.entering(_className, "getAdminUsername()", string);
        return string;
    }

    @Deprecated
    public synchronized void setAdminPassFile(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setAdminPassFile()", string);
        this.getLifecycleManagedBroker().setAdminPassFile(string);
    }

    @Deprecated
    public String getAdminPassFile() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getAdminPassFile();
        _loggerL.entering(_className, "getAdminPassFile()", string);
        return string;
    }

    public synchronized HashMap getJMXConnectorEnv() {
        this.checkManaged();
        HashMap hashMap = this.getLifecycleManagedBroker().getJMXConnectorEnv();
        _loggerL.entering(_className, "getJMXConnectorEnv()", hashMap);
        return hashMap;
    }

    public synchronized String getJMXServiceURLList() {
        this.checkManaged();
        _loggerL.entering(_className, "getJMXServiceURLList()", "For addressList = " + this.getConnectionURL());
        String string = this.getLifecycleManagedBroker().getJMXServiceURLList();
        _loggerL.exiting(_className, "getJMXServiceURLList()", string);
        return string;
    }

    public synchronized String getJMXServiceURL() {
        this.checkManaged();
        _loggerL.entering(_className, "getJMXServiceURL()");
        return this.getLifecycleManagedBroker().getJMXServiceURL();
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean bl) {
        this.checkManaged();
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", new Boolean(bl));
        this.getLifecycleManagedBroker().setUseJNDIRmiServiceURL(bl);
    }

    public boolean getUseJNDIRmiServiceURL() {
        this.checkManaged();
        boolean bl = this.getLifecycleManagedBroker().getUseJNDIRmiServiceURL();
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", new Boolean(bl));
        return bl;
    }

    public synchronized void setStartRmiRegistry(boolean bl) {
        this.checkManaged();
        _loggerL.entering(_className, "setStartRmiRegistry()", new Boolean(bl));
        this.getLifecycleManagedBroker().setStartRmiRegistry(bl);
    }

    public boolean getStartRmiRegistry() {
        this.checkManaged();
        boolean bl = this.getLifecycleManagedBroker().getStartRmiRegistry();
        _loggerL.entering(_className, "getStartRmiRegistry()", new Boolean(bl));
        return bl;
    }

    public synchronized void setRmiRegistryPort(int n) {
        this.checkManaged();
        _loggerL.entering(_className, "setRmiRegistryPort()", new Integer(n));
        this.getLifecycleManagedBroker().setRmiRegistryPort(n);
    }

    public int getRmiRegistryPort() {
        this.checkManaged();
        int n = this.getLifecycleManagedBroker().getRmiRegistryPort();
        _loggerL.entering(_className, "getRmiRegistryPort()", new Integer(n));
        return n;
    }

    public synchronized void setUseSSLJMXConnector(boolean bl) {
        this.checkManaged();
        _loggerL.entering(_className, "setUseSSLJMXConnector()", new Boolean(bl));
        this.getLifecycleManagedBroker().setUseSSLJMXConnector(bl);
    }

    public boolean getUseSSLJMXConnector() {
        this.checkManaged();
        boolean bl = this.getLifecycleManagedBroker().getUseSSLJMXConnector();
        _loggerL.entering(_className, "getUseSSLJMXConnector()", new Boolean(bl));
        return bl;
    }

    public synchronized void setBrokerEnableHA(boolean bl) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerEnableHA()", new Boolean(bl));
        this.getLifecycleManagedBroker().setBrokerEnableHA(bl);
    }

    public boolean getBrokerEnableHA() {
        this.checkManaged();
        boolean bl = this.getLifecycleManagedBroker().getBrokerEnableHA();
        _loggerL.entering(_className, "getBrokerEnableHA()", new Boolean(bl));
        return bl;
    }

    public void setNowaitForMasterBrokerTimeoutInSeconds(int n) {
        this.checkManaged();
        _loggerL.entering(_className, "setNowaitForMasterBrokerTimeoutInSeconds()", n);
        this.getLifecycleManagedBroker().setNowaitForMasterBrokerTimeoutInSeconds(n);
    }

    public int getNowaitForMasterBrokerTimeoutInSeconds() {
        this.checkManaged();
        int n = this.getLifecycleManagedBroker().getNowaitForMasterBrokerTimeoutInSeconds();
        _loggerL.entering(_className, "getNowaitForMasterBrokerTimeoutInSeconds()", n);
        return n;
    }

    public synchronized void setClusterId(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setClusterId()", string);
        this.getLifecycleManagedBroker().setClusterId(string);
    }

    public String getClusterId() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getClusterId();
        _loggerL.entering(_className, "getClusterId()", string);
        return string;
    }

    public synchronized void setBrokerId(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerId()", string);
        this.getLifecycleManagedBroker().setBrokerId(string);
    }

    public String getBrokerId() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getBrokerId();
        _loggerL.entering(_className, "getBrokerId()", string);
        return string;
    }

    @Deprecated
    public synchronized void setDBType(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setDBType()", string);
        this.getLifecycleManagedBroker().setDBType(string);
    }

    @Deprecated
    public String getDBType() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getDBType();
        _loggerL.entering(_className, "getDBType()", string);
        return string;
    }

    public synchronized void setBrokerProps(Properties properties) {
        this.checkManaged();
        _loggerL.entering(_className, "setBrokerProps()");
        this.getLifecycleManagedBroker().setBrokerProps(properties);
    }

    public void setBrokerProps(String string) {
        this.getLifecycleManagedBroker().setBrokerProps(string);
    }

    public Properties getBrokerProps() {
        this.checkManaged();
        _loggerL.entering(_className, "getBrokerProps()");
        Properties properties = this.getLifecycleManagedBroker().getBrokerProps();
        return properties;
    }

    public synchronized void setClusterBrokerList(String string) {
        this.checkManaged();
        _loggerL.entering(_className, "setClusterBrokerList()", string);
        this.getLifecycleManagedBroker().setClusterBrokerList(string);
    }

    public String getClusterBrokerList() {
        this.checkManaged();
        String string = this.getLifecycleManagedBroker().getClusterBrokerList();
        _loggerL.entering(_className, "getClusterBrokerList()", string);
        return string;
    }

    @Deprecated
    public synchronized void setDBProps(Properties properties) {
        this.checkManaged();
        _loggerL.entering(_className, "setDBProps()", properties);
        this.getLifecycleManagedBroker().setDBProps(properties);
    }

    @Deprecated
    public Properties getDBProps() {
        this.checkManaged();
        Properties properties = this.getLifecycleManagedBroker().getDBProps();
        _loggerL.entering(_className, "getDBProps()", properties);
        return properties;
    }

    @Deprecated
    public synchronized void setDSProps(Properties properties) {
        this.checkManaged();
        _loggerL.entering(_className, "setDSProps()", properties);
        this.getLifecycleManagedBroker().setDSProps(properties);
    }

    @Deprecated
    public Properties getDSProps() {
        this.checkManaged();
        Properties properties = this.getLifecycleManagedBroker().getDSProps();
        _loggerL.entering(_className, "getDSProps()", properties);
        return properties;
    }

    public boolean isDoBind() {
        this.checkManaged();
        return this.getLifecycleManagedBroker().isDoBind();
    }

    public void setDoBind(boolean bl) {
        this.checkManaged();
        this.getLifecycleManagedBroker().setDoBind(bl);
    }

    public PortMapperClientHandler getPortMapperClientHandler() {
        this.checkManaged();
        return this.getLifecycleManagedBroker().getPortMapperClientHandler();
    }

    protected String _getEffectiveConnectionURL() {
        _loggerL.entering(_className, "_getEffectiveConnectionURL()");
        String string = null;
        if (this._isAPIDirect()) {
            string = "mq://localhost/direct";
        } else if (this.isManageBrokerLifecycle() && (this._isLocal() || this._isEmbedded() || this._isRADirect())) {
            string = (this.getBrokerBindAddress() != null ? this.getBrokerBindAddress() : "localhost") + ":" + Integer.toString(this.getBrokerPort());
            if (this.getConnectionURL() != null && !"".equals(this.getConnectionURL())) {
                string = string + "," + this.getConnectionURL();
            }
        } else {
            string = this.getConnectionURL();
        }
        _loggerL.exiting(_className, "_getEffectiveConnectionURL()", string);
        return string;
    }

    protected XAConnectionFactory _getXACF() {
        return this.xacf;
    }

    protected String _getRAUID() {
        return this.raUID;
    }

    protected Method _getOnMessageMethod() {
        if (this.onMessage == null) {
            this._setOnMessageMethod();
        }
        return this.onMessage;
    }

    private void configureFactory() throws JMSException {
        Object var1_1 = null;
        if (!BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            this.xacf.setProperty("imqAddressList", this._getEffectiveConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", "PRIORITY");
        } else {
            this.xacf.setProperty("imqAddressList", this.getConnectionURL());
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
        }
        this.xacf.setProperty("imqDefaultUsername", this.userName);
        this.xacf.setProperty("imqDefaultPassword", this.password);
        this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
        this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
        this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
        this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
    }

    private void init() throws JMSException {
        if (this.xac != null) {
            if (this.inClusteredContainer && this.raUID == null) {
                this.raUID = Long.toString(this.xac.generateUID());
            }
            this.xac.setExceptionListener(this);
            this.xac.setEventListener(this);
        }
        if (_loggerL.isLoggable(Level.FINER)) {
            _loggerL.finer("MQJMSRA_RA1101: init:DONE:raUID=" + this.raUID);
        }
    }

    private int createFactoryID() {
        return ++this._factoryID;
    }

    private int createConsumerID() {
        return ++this._consumerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = this.createFactoryID();
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.put(new Integer(n), messageEndpointFactory);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageFactory(int n) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageEndpointFactory _getMessageFactory(int n) {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            MessageEndpointFactory messageEndpointFactory = this.epFactories.get(new Integer(n));
            return messageEndpointFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int matchMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = -1;
        if (messageEndpointFactory != null) {
            HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
            synchronized (hashMap) {
                Set<Map.Entry<Integer, MessageEndpointFactory>> set = this.epFactories.entrySet();
                if (set != null) {
                    for (Map.Entry entry : set) {
                        if (!messageEndpointFactory.equals(entry.getValue())) continue;
                        Integer n2 = (Integer)entry.getKey();
                        n = n2;
                        break;
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactorytoConsumerLink(int n, int n2) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.put(new Integer(n), new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFactorytoConsumerLink(int n) {
        HashMap<Integer, Integer> hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.remove(new Integer(n));
        }
    }

    private int _getConsumerIDbyFactoryID(int n) {
        return this.epFactoryToConsumer.get(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addEndpointConsumer(EndpointConsumer endpointConsumer) {
        int n = this.createConsumerID();
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.put(new Integer(n), endpointConsumer);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEndpointConsumer(int n) {
        HashMap<Integer, EndpointConsumer> hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.remove(new Integer(n));
        }
    }

    private EndpointConsumer _getEndpointConsumer(int n) {
        EndpointConsumer endpointConsumer = this.epConsumers.get(new Integer(n));
        return endpointConsumer;
    }

    private void removeFromMaps(int n) {
        int n2 = this._getConsumerIDbyFactoryID(n);
        this.removeEndpointConsumer(n2);
        this.removeMessageFactory(n);
        this.removeFactorytoConsumerLink(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConsumers() {
        HashMap<Integer, MessageEndpointFactory> hashMap = this.epFactories;
        synchronized (hashMap) {
            Set<Map.Entry<Integer, MessageEndpointFactory>> set = this.epFactories.entrySet();
            if (set != null) {
                for (Map.Entry entry : set) {
                    int n = (Integer)entry.getKey();
                    int n2 = this._getConsumerIDbyFactoryID(n);
                    EndpointConsumer endpointConsumer = this._getEndpointConsumer(n2);
                    try {
                        endpointConsumer.stopMessageConsumer();
                    }
                    catch (Exception exception) {
                        System.err.println("MQJMSRA:RA::Error:stopMessageConsumer exception:ignoring");
                    }
                }
                this.clearMaps();
            }
        }
    }

    private void clearMaps() {
        this.epFactories.clear();
        this.epConsumers.clear();
        this.epFactoryToConsumer.clear();
    }

    private void _setOnMessageMethod() {
        Method method = null;
        try {
            Class<MessageListener> clazz = MessageListener.class;
            Class[] classArray = new Class[]{Message.class};
            method = clazz.getMethod("onMessage", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this.onMessage = method;
    }

    private void _adjustInAppClientContainer() {
        String string = System.getProperty("imq.jmsra.inACC");
        if (string != null) {
            System.err.println("MQJMSRA:RA:AIACC:SystemProp imq.jmsra.inACC is NOT null!!");
            if (DIRECT_MODE_DEFAULT_STANDALONE.equals(string)) {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC true");
                this.inAppClientContainer = true;
            } else {
                System.err.println("MQJMSRA:RA:AIACC:setting inACC false");
                this.inAppClientContainer = false;
            }
        } else if (this.workMgr != null) {
            try {
                this.workMgr.doWork(new Work(){

                    public void run() {
                    }

                    public void release() {
                    }
                });
            }
            catch (Exception exception) {
                this.inAppClientContainer = true;
            }
        } else {
            this.inAppClientContainer = true;
        }
    }

    private static boolean _isDirectDefaultWhenStandalone() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct", DIRECT_MODE_DEFAULT_STANDALONE));
    }

    private static boolean _isDirectDefaultWhenClustered() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.direct.clustered", "false"));
    }

    protected static boolean _useAPIDirectImplementation() {
        return Boolean.valueOf(System.getProperty("imq.jmsra.apidirect", "false"));
    }

    public String toString() {
        return "SJSMQ JMSRA ResourceAdapter configuration=\n\traUID                    =" + this.raUID + "\n" + "\tGroupName                =" + this.groupName + "\n" + "\tbrokerType               =" + this.brokerType + "\tbrokerPort               =" + this.brokerPort + "\n" + "\tConnectionURL            =" + this.connectionURL + "\n" + "\tRADIRECT Mode allowed    =" + this._isRADirectAllowed() + "\n" + "\tAPIDIRECT Mode allowed   =" + this._isAPIDirectAllowed() + "\n" + "\tDIRECT Mode default      =" + ResourceAdapter._isDirectDefaultWhenStandalone() + "\n" + "\tUse APIDIRECT impl       =" + ResourceAdapter._useAPIDirectImplementation() + "\n" + "\tUserName                 =" + this.userName + "\n" + "\tPassword                 =" + ("guest".equals(this.password) ? "<default>" : "<modified>") + "\n" + "\tReconnectEnabled         =" + this.reconnectEnabled + "\n" + "\tReconnectInterval        =" + this.reconnectInterval + "\n" + "\tReconnectAttempts        =" + this.reconnectAttempts + "\n" + "\tAddressListBehavior      =" + this.addressListBehavior + "\n" + "\tAddressListIterations    =" + this.addressListIterations + "\n" + "\tInAppClientContainer     =" + this.inAppClientContainer + "\n" + "\tInClusteredContainer     =" + this.inClusteredContainer + "\n" + this.getLifecycleManagedBroker().toString();
    }

    protected static ConnectionManager _getConnectionManager() {
        return _cm;
    }

    public JMSService _getJMSService() {
        JMSService jMSService = null;
        if (this.getLifecycleManagedBroker() != null) {
            jMSService = this.getLifecycleManagedBroker()._getJMSService();
        }
        return jMSService;
    }

    protected static final JMSService _getRAJMSService() {
        return LifecycleManagedBroker._getRAJMSService();
    }

    public boolean _isAnyDirect() {
        return BROKER_TYPE_RADIRECT.equals(this.brokerType) | BROKER_TYPE_APIDIRECT.equals(this.brokerType);
    }

    public boolean _isRADirect() {
        return BROKER_TYPE_RADIRECT.equals(this.brokerType);
    }

    public boolean _isAPIDirect() {
        return BROKER_TYPE_APIDIRECT.equals(this.brokerType);
    }

    public boolean _isEmbedded() {
        return BROKER_TYPE_EMBEDDED.equals(this.brokerType);
    }

    public boolean _isLocal() {
        return BROKER_TYPE_LOCAL.equals(this.brokerType);
    }

    public boolean _isRemote() {
        return BROKER_TYPE_REMOTE.equals(this.brokerType);
    }

    public boolean _isRADirectAllowed() {
        return this._isRADirect() && !this.inAppClientContainer;
    }

    public boolean _isAPIDirectAllowed() {
        return this._isAPIDirect() && !this.inAppClientContainer;
    }

    public boolean _isAnyDirectAllowed() {
        return this._isAnyDirect() && !this.inAppClientContainer;
    }

    public void setDoInitOnlyOnStart(boolean bl) {
        if (bl) {
            throw new RuntimeException("setDoInitOnlyOnStart(true) is not supported any more");
        }
    }

    public static boolean isSameRMAllowed() {
        return isSameRMAllowed;
    }

    public static boolean isRevert6882044() {
        return isRevert6882044;
    }

    private void checkManaged() {
        if (!this.isManageBrokerLifecycle()) {
            throw new IllegalStateException("com.sun.messaging.jms.raResourceAdapter: cannot perform broker lifecycle operations if manageBrokerLifecycle=true");
        }
    }

    public boolean isManageBrokerLifecycle() {
        return this.manageBrokerLifecycle;
    }

    public void setManageBrokerLifecycle(boolean bl) {
        this.manageBrokerLifecycle = bl;
    }
}

