/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class HABrokerInfo
implements Externalizable {
    static final long serialVersionUID = -6833553314062089908L;
    public static final int UPDATE_VERSION = 0;
    public static final int UPDATE_URL = 1;
    public static final int RESET_TAKEOVER_BROKER_READY_OPERATING = 2;
    public static final int RESTORE_HEARTBEAT_ON_TAKEOVER_FAIL = 3;
    public static final int RESTORE_ON_TAKEOVER_FAIL = 4;
    private String id;
    private String takeoverBrokerID;
    private String url;
    private int version;
    private int state;
    private long sessionID;
    private long heartbeat;
    private List sessionList;
    private long takeoverTimestamp = 0L;

    public HABrokerInfo() {
    }

    public HABrokerInfo(String string, String string2, String string3, int n, int n2, long l, long l2) {
        this.id = string;
        this.takeoverBrokerID = string2 == null ? "" : string2;
        this.url = string3;
        this.version = n;
        this.state = n2;
        this.sessionID = l;
        this.heartbeat = l2;
        this.sessionList = Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public String getTakeoverBrokerID() {
        return this.takeoverBrokerID;
    }

    public String getUrl() {
        return this.url;
    }

    public int getVersion() {
        return this.version;
    }

    public int getState() {
        return this.state;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public List getAllSessions() {
        return this.sessionList;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public void setSessionID(long l) {
        this.sessionID = l;
    }

    public void setSessionList(List list) {
        this.sessionList = list;
    }

    public void setTakeoverTimestamp(long l) {
        this.takeoverTimestamp = l;
    }

    public long getTakeoverTimestamp() {
        return this.takeoverTimestamp;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128).append("(").append("brokerID=").append(this.id).append(", URL=").append(this.url).append(", version=").append(this.version).append(", state=").append(this.state).append(" [").append(BrokerState.getState(this.state).toString()).append("]").append(", sessionID=").append(this.sessionID).append(", heartbeatTS=").append(this.heartbeat).append(this.heartbeat > 0L ? " [" + new Date(this.heartbeat) + "]" : "").append(", takeoverBrokerID=").append(this.takeoverBrokerID).append(")");
        return stringBuffer.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (String)objectInput.readObject();
        this.takeoverBrokerID = (String)objectInput.readObject();
        this.url = (String)objectInput.readObject();
        this.version = objectInput.readInt();
        this.state = objectInput.readInt();
        this.sessionID = objectInput.readLong();
        this.heartbeat = objectInput.readLong();
        this.sessionList = (List)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.takeoverBrokerID);
        objectOutput.writeObject(this.url);
        objectOutput.writeInt(this.version);
        objectOutput.writeInt(this.state);
        objectOutput.writeLong(this.sessionID);
        objectOutput.writeLong(this.heartbeat);
        objectOutput.writeObject(this.sessionList);
    }

    public static class StoreSession
    implements Externalizable {
        static final long serialVersionUID = -1619140799512705251L;
        private long id;
        private String brokerID;
        private int isCurrent;
        private String createdBy;
        private long createdTS;

        public StoreSession() {
        }

        public StoreSession(long l, String string, int n, String string2, long l2) {
            this.id = l;
            this.brokerID = string;
            this.isCurrent = n;
            this.createdBy = string2;
            this.createdTS = l2;
        }

        public long getID() {
            return this.id;
        }

        public String getBrokerID() {
            return this.brokerID;
        }

        public int getIsCurrent() {
            return this.isCurrent;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public long getCreatedTS() {
            return this.createdTS;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.id = objectInput.readLong();
            this.brokerID = (String)objectInput.readObject();
            this.isCurrent = objectInput.readInt();
            this.createdBy = (String)objectInput.readObject();
            this.createdTS = objectInput.readLong();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeLong(this.id);
            objectOutput.writeObject(this.brokerID);
            objectOutput.writeInt(this.isCurrent);
            objectOutput.writeObject(this.createdBy);
            objectOutput.writeLong(this.createdTS);
        }
    }
}

