/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.QueueInfo;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.FeatureUnavailableException;
import com.sun.messaging.jmq.jmsserver.util.SelectorFilter;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Queue
extends Destination {
    static final long serialVersionUID = 3396316998214097558L;
    private static Object NULL_OBJECT = new Object();
    private static boolean DEBUG = false;
    private transient NFLPriorityFifoSet pending = null;
    private transient SubSet pendingSubset = null;
    private transient HashSet delivered = null;
    protected transient Map views = null;
    private boolean localDeliveryPreferred = false;
    private int maxActiveCount = 1;
    private int maxFailoverCount = 0;
    private int maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
    private transient Vector consumerPositions = null;
    private transient Map allConsumers = null;
    private transient int activeConsumerCnt = 0;
    private transient int failoverConsumerCnt = 0;
    private transient int localActiveConsumerCnt = 0;
    private transient int hwActiveCount = 0;
    private transient int hwFailoverCount = 0;
    private transient float activeAverage = 0.0f;
    private transient float failoverAverage = 0.0f;
    private transient int activeSampleCnt = 0;
    private transient int failoverSampleCnt = 0;
    public static final String MAX_ACTIVE = "max_active";
    public static final String MAX_FAILOVER = "max_failover";
    public static final String LOCAL_DELIVERY = "local_delivery_preferred";
    public static final int DEFAULT_MAX_ACTIVE_CONSUMERS = -1;
    public static String MAX_ACTIVE_CNT = "imq.autocreate.queue.maxNumActiveConsumers";
    private static String MAX_FAILOVER_CNT = "imq.autocreate.queue.maxNumBackupConsumers";
    private static int defaultMaxActiveCount = Globals.getConfig().getIntProperty(MAX_ACTIVE_CNT, -1);
    private static int defaultMaxFailoverCount = Globals.getConfig().getIntProperty(MAX_FAILOVER_CNT, 0);
    private static Set queueConsumer = null;
    private static int QUEUE_DEFAULT_PREFETCH = Globals.getConfig().getIntProperty("imq.autocreate.queue.consumerFlowLimit", 1000);
    private static boolean QUEUE_LDP = Globals.getConfig().getBooleanProperty("imq.autocreate.queue.localDeliveryPreferred", false);
    private static int MAX_LICENSED_ACTIVE = -1;
    private static int MAX_LICENSED_BACKUP = -1;
    private static ConfigListener cl;

    public void unload(boolean bl) {
        super.unload(bl);
        if (bl) {
            this.pending.clear();
            this.delivered.clear();
        }
    }

    public void sort(Comparator comparator) {
        this.pending.sort(comparator);
    }

    public PacketReference peekNext() {
        try {
            if (!this.loaded) {
                this.load();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (PacketReference)this.pending.peekNext();
    }

    public int getUnackSize() {
        int n = this.destMessages.size() - this.pending.size();
        if (n < 0) {
            this.logger.log(4, "Unexpected size for destination " + this + " [size,pending]=[" + this.destMessages.size() + "," + this.pending.size() + "]");
            n = 0;
        }
        return n;
    }

    public static Hashtable getAllDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("maxNumActiveConsumers", String.valueOf(defaultMaxActiveCount));
        hashtable.put("maxNumBackupConsumers", String.valueOf(defaultMaxFailoverCount));
        hashtable.put("consumerFlowLimit", String.valueOf(QUEUE_DEFAULT_PREFETCH));
        hashtable.put("localDeliveryPreferred", String.valueOf(QUEUE_LDP));
        return hashtable;
    }

    public Hashtable getDebugMessages(boolean bl) {
        Hashtable hashtable = super.getDebugMessages(bl);
        Vector<String> vector = new Vector<String>();
        for (PacketReference packetReference : this.pending) {
            vector.add(bl ? packetReference.getPacket().dumpPacketString() : packetReference.getPacket().toString());
        }
        hashtable.put("PendingList", vector);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        Vector<String> vector = null;
        Object object = this.consumerPositions;
        synchronized (object) {
            vector = new Vector<String>(this.consumerPositions.size());
            for (int i = 0; i < vector.size(); ++i) {
                Object object2 = this.consumerPositions.get(i);
                vector.add(object2 == NULL_OBJECT ? "none" : String.valueOf(((ConsumerUID)object2).longValue()));
            }
        }
        hashtable.put("ConsumerPositions", vector);
        hashtable.put("pendingCnt", String.valueOf(this.pending.size()));
        if (DEBUG && Destination.DEBUG_LISTS) {
            hashtable.put("pending", this.pending.toDebugString());
        }
        hashtable.put("deliveredCnt", String.valueOf(this.delivered.size()));
        hashtable.put("localDeliveryPreferred", String.valueOf(this.localDeliveryPreferred));
        hashtable.put("maxActiveCount", String.valueOf(this.maxActiveCount));
        hashtable.put("maxFailoverCount", String.valueOf(this.maxFailoverCount));
        hashtable.put("maxSize", String.valueOf(this.maxSize));
        object = this.allConsumers;
        synchronized (object) {
            vector = new Vector(this.allConsumers.size());
            for (Object object2 : this.allConsumers.values()) {
                String string = ((QueueInfo)object2).consumer.getConsumerUID().longValue() + "[" + ((QueueInfo)object2).position + "," + (((QueueInfo)object2).active ? "active" : "inactive") + "," + (((QueueInfo)object2).local ? "local" : "remote") + "," + (((QueueInfo)object2).consumingMsgs ? "consuming" : "passive") + "]";
                vector.add(string);
            }
        }
        hashtable.put("allConsumers", vector);
        hashtable.put("activeConsumerCnt", String.valueOf(this.activeConsumerCnt));
        hashtable.put("failoverConsumerCnt", String.valueOf(this.failoverConsumerCnt));
        hashtable.put("localActiveConsumerCnt", String.valueOf(this.localActiveConsumerCnt));
        return hashtable;
    }

    public static void init() {
        queueConsumer = new HashSet();
        queueConsumer.add(PacketReference.getQueueUID());
        Globals.getConfig().addListener(MAX_ACTIVE_CNT, cl);
        Globals.getConfig().addListener(MAX_FAILOVER_CNT, cl);
    }

    static void clear() {
        queueConsumer = null;
        Globals.getConfig().removeListener(MAX_ACTIVE_CNT, cl);
        Globals.getConfig().removeListener(MAX_FAILOVER_CNT, cl);
    }

    protected Queue(DestinationUID destinationUID) {
        super(destinationUID);
    }

    protected Queue(String string, int n, boolean bl, ConnectionUID connectionUID, boolean bl2) throws FeatureUnavailableException, BrokerException, IOException {
        super(string, n, bl, connectionUID, bl2);
        this.maxPrefetch = QUEUE_DEFAULT_PREFETCH;
        this.pending = new NFLPriorityFifoSet(11, false);
        this.delivered = new HashSet();
        this.localDeliveryPreferred = QUEUE_LDP;
        this.consumerPositions = new Vector();
        this.allConsumers = new LinkedHashMap();
        this.views = new WeakValueHashMap("Views");
        this.destMessages.addEventListener((EventListener)this, EventType.SET_CHANGED, (Object)this);
        this.setDefaultCounts(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestMetricsCounters getMetrics() {
        DestMetricsCounters destMetricsCounters = super.getMetrics();
        Queue queue = this;
        synchronized (queue) {
            destMetricsCounters.setActiveConsumers(this.activeConsumerCnt);
            destMetricsCounters.setFailoverConsumers(this.failoverConsumerCnt);
            destMetricsCounters.setHWActiveConsumers(this.hwActiveCount);
            destMetricsCounters.setHWFailoverConsumers(this.hwFailoverCount);
            destMetricsCounters.setAvgActiveConsumers((int)this.activeAverage);
            destMetricsCounters.setAvgFailoverConsumers((int)this.failoverAverage);
        }
        return destMetricsCounters;
    }

    protected void getDestinationProps(Map map) {
        super.getDestinationProps(map);
        map.put(MAX_ACTIVE, new Integer(this.maxActiveCount));
        map.put(MAX_FAILOVER, new Integer(this.maxFailoverCount));
        map.put(LOCAL_DELIVERY, this.localDeliveryPreferred);
    }

    public void setDestinationProperties(Map map) throws BrokerException {
        if (map.get(MAX_ACTIVE) != null) {
            try {
                this.setMaxActiveConsumers((Integer)map.get(MAX_ACTIVE));
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "Internal Error ", (Throwable)brokerException);
            }
        }
        if (map.get(MAX_FAILOVER) != null) {
            try {
                this.setMaxFailoverConsumers((Integer)map.get(MAX_FAILOVER));
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "Internal Error ", (Throwable)brokerException);
            }
        }
        if (map.get(LOCAL_DELIVERY) != null) {
            boolean bl = (Boolean)map.get(LOCAL_DELIVERY);
            this.setClusterDeliveryPolicy(bl ? 1 : 2);
        }
        super.setDestinationProperties(map);
    }

    private void setDefaultCounts(int n) throws BrokerException {
        int n2 = 0;
        int n3 = 0;
        if (DestType.isSingle((int)n)) {
            n2 = 1;
            n3 = 0;
        } else if (DestType.isFailover((int)n)) {
            n2 = 1;
            n3 = -1;
        } else if (DestType.isRRobin((int)n)) {
            n2 = -1;
            n3 = 0;
        } else {
            n2 = defaultMaxActiveCount;
            n3 = defaultMaxFailoverCount;
        }
        this.setMaxActiveConsumers(n2);
        this.setMaxFailoverConsumers(n3);
        int n4 = this.maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
        if (this.maxSize != -1) {
            try {
                this.setMaxConsumers(this.maxSize);
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "Internal Error ", (Throwable)brokerException);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pending = new NFLPriorityFifoSet(11, false);
        this.delivered = new HashSet();
        this.consumerPositions = new Vector();
        this.allConsumers = new LinkedHashMap();
        this.views = new WeakValueHashMap("views");
        this.destMessages.addEventListener((EventListener)this, EventType.SET_CHANGED, null);
        if (this.maxActiveCount == 0 && this.maxFailoverCount == 0) {
            try {
                this.setDefaultCounts(this.type);
            }
            catch (Exception exception) {
                this.logger.log(8, "Internal Error ", (Throwable)exception);
            }
        }
    }

    public Set routeAndMoveMessage(PacketReference packetReference, PacketReference packetReference2) throws IOException, BrokerException {
        try {
            PacketReference.moveMessage(packetReference, packetReference2, queueConsumer);
        }
        catch (BrokerException brokerException) {
            throw brokerException;
        }
        catch (RuntimeException runtimeException) {
            throw new BrokerException(runtimeException.toString(), runtimeException);
        }
        Destination destination = packetReference.getDestination();
        if (destination instanceof Queue) {
            ((Queue)destination).pending.remove((Object)packetReference);
        }
        this.pending.add(10 - packetReference2.getPriority(), (Object)packetReference2);
        return null;
    }

    public Set routeNewMessage(PacketReference packetReference) throws BrokerException {
        try {
            packetReference.store(queueConsumer);
        }
        catch (BrokerException brokerException) {
            throw brokerException;
        }
        catch (RuntimeException runtimeException) {
            throw new BrokerException(runtimeException.toString(), runtimeException);
        }
        this.pending.add(10 - packetReference.getPriority(), (Object)packetReference);
        return null;
    }

    public ConsumerUID[] calculateStoredInterests(PacketReference packetReference) throws BrokerException, SelectorFormatException {
        ConsumerUID[] consumerUIDArray = null;
        try {
            consumerUIDArray = packetReference.getRoutingForStore(queueConsumer);
        }
        catch (RuntimeException runtimeException) {
            throw new BrokerException(runtimeException.toString(), runtimeException);
        }
        return consumerUIDArray;
    }

    public void unrouteLoadedTransactionAckMessage(PacketReference packetReference, ConsumerUID consumerUID) throws BrokerException {
        boolean bl = this.pending.remove((Object)packetReference);
        Globals.getLogger().log(4, " removing from pending " + packetReference + " result=" + bl);
    }

    public void forwardOrphanMessage(PacketReference packetReference, ConsumerUID consumerUID) throws BrokerException {
        this.pending.add(10 - packetReference.getPriority(), (Object)packetReference);
    }

    public void forwardOrphanMessages(Collection collection, ConsumerUID consumerUID) throws BrokerException {
        this.pending.addAllOrdered(collection);
    }

    public void forwardMessage(Set set, PacketReference packetReference) {
    }

    protected ConsumerUID[] routeLoadedTransactionMessage(PacketReference packetReference) throws BrokerException, SelectorFormatException {
        ConsumerUID[] consumerUIDArray = new ConsumerUID[]{PacketReference.getQueueUID()};
        return consumerUIDArray;
    }

    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        if (eventType == EventType.SET_CHANGED) {
            assert (object == this.destMessages);
            if (object3 == null) {
                Map.Entry entry = (Map.Entry)object2;
                this.pending.remove(entry.getValue());
                this.delivered.remove(entry.getValue());
            }
        }
        super.eventOccured(eventType, reason, object, object2, object3, object4);
    }

    public static void setDefaultQueueType(int n) {
        if ((n & 0x200) > 0) {
            Queue.setDefaultMaxActiveConsumers(-1);
            Queue.setDefaultMaxFailoverConsumers(0);
        } else if ((n & 0x100) > 0) {
            Queue.setDefaultMaxActiveConsumers(1);
            Queue.setDefaultMaxFailoverConsumers(0);
        } else if ((n & 0x400) > 0) {
            Queue.setDefaultMaxActiveConsumers(1);
            Queue.setDefaultMaxFailoverConsumers(-1);
        }
    }

    public static void setDefaultQueueType(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("round-robin")) {
            Queue.setDefaultMaxActiveConsumers(-1);
            Queue.setDefaultMaxFailoverConsumers(0);
        } else if (string.equalsIgnoreCase("single")) {
            Queue.setDefaultMaxActiveConsumers(1);
            Queue.setDefaultMaxFailoverConsumers(0);
        } else if (string.equalsIgnoreCase("failover")) {
            Queue.setDefaultMaxActiveConsumers(1);
            Queue.setDefaultMaxFailoverConsumers(-1);
        }
    }

    public int getClusterDeliveryPolicy() {
        return this.localDeliveryPreferred ? 1 : 2;
    }

    public static void setDefaultMaxActiveConsumers(int n) {
        defaultMaxActiveCount = n;
    }

    public static void setDefaultMaxFailoverConsumers(int n) {
        defaultMaxFailoverCount = n;
    }

    public static int getDefaultMaxActiveConsumers() {
        return defaultMaxActiveCount;
    }

    public static int getDefaultMaxFailoverConsumers() {
        return defaultMaxFailoverCount;
    }

    public int getMaxActiveConsumers() {
        return this.maxActiveCount;
    }

    public int getMaxFailoverConsumers() {
        return this.maxFailoverCount;
    }

    public int getActiveConsumerCount() {
        return this.activeConsumerCnt;
    }

    public int getFailoverConsumerCount() {
        return this.failoverConsumerCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getActiveConsumers() {
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        Map map = this.allConsumers;
        synchronized (map) {
            for (QueueInfo queueInfo : this.allConsumers.values()) {
                if (!queueInfo.active) continue;
                hashSet.add(queueInfo.consumer);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFailoverConsumers() {
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        Map map = this.allConsumers;
        synchronized (map) {
            for (QueueInfo queueInfo : this.allConsumers.values()) {
                if (queueInfo.active) continue;
                hashSet.add(queueInfo.consumer);
            }
        }
        return hashSet;
    }

    public void setMaxActiveConsumers(int n) throws BrokerException {
        if (n == 0) {
            throw new BrokerException("Max Active Consumer count can not be 0");
        }
        if (MAX_LICENSED_ACTIVE != -1 && (n > MAX_LICENSED_ACTIVE || n < 0)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0050", String.valueOf(MAX_LICENSED_ACTIVE)), this.getName()), "B4180", null, 500);
        }
        Integer n2 = new Integer(this.maxActiveCount);
        this.maxActiveCount = n < -1 ? -1 : n;
        this.maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
        this.setMaxConsumers(this.maxSize);
        this.consumerListChanged();
        this.notifyAttrUpdated(512, n2, new Integer(this.maxActiveCount));
    }

    public void setMaxFailoverConsumers(int n) throws BrokerException {
        if (MAX_LICENSED_BACKUP != -1 && (n > MAX_LICENSED_BACKUP || n < 0)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0051", String.valueOf(MAX_LICENSED_BACKUP)), this.getName()), "B4180", null, 500);
        }
        Integer n2 = new Integer(this.maxFailoverCount);
        this.maxFailoverCount = n;
        this.maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
        this.setMaxConsumers(this.maxSize);
        this.consumerListChanged();
        this.notifyAttrUpdated(1024, n2, new Integer(this.maxFailoverCount));
    }

    public void setClusterDeliveryPolicy(int n) {
        boolean bl = this.localDeliveryPreferred;
        if (n == 1) {
            this.localDeliveryPreferred = true;
        } else {
            assert (n == 2);
            this.localDeliveryPreferred = false;
        }
        try {
            this.consumerListChanged();
            this.notifyAttrUpdated(256, bl, this.localDeliveryPreferred);
        }
        catch (BrokerException brokerException) {
            this.logger.log(8, "XXX - internal error handling delivery policy change ", (Throwable)brokerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPosition(ConsumerUID consumerUID, int n) {
        Vector vector = this.consumerPositions;
        synchronized (vector) {
            int n2 = n;
            for (n2 = this.consumerPositions.size(); n2 <= n; ++n2) {
                this.consumerPositions.add(NULL_OBJECT);
            }
            this.consumerPositions.set(n, consumerUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPosition(ConsumerUID consumerUID, boolean bl, boolean bl2) throws BrokerException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        while (!bl3) {
            Serializable serializable = this.consumerPositions;
            synchronized (serializable) {
                n = this.consumerPositions.indexOf(NULL_OBJECT, n);
                if (n == -1 && (this.maxSize == -1 || this.consumerPositions.size() < this.maxSize)) {
                    this.consumerPositions.add(NULL_OBJECT);
                    n = this.consumerPositions.size() - 1;
                }
                if (n == -1) {
                    break;
                }
                if (bl2 && n >= this.maxActiveCount) {
                    n = -1;
                    break;
                }
            }
            if (bl && !this.getIsLocal()) {
                if (Globals.getClusterBroadcast().getConsumerLock(consumerUID, this.getDestinationUID(), n, this.maxSize, (Object)consumerUID.getConnectionUID())) {
                    serializable = this.consumerPositions.set(n, consumerUID);
                    if (serializable != NULL_OBJECT && serializable != null) {
                        this.logger.log(4, "after lock, object unexpectly changed  position " + serializable + " at position " + n);
                    }
                    bl3 = true;
                    continue;
                }
                if (n == n2) {
                    if (++n3 > 10) {
                        this.logger.log(4, "Could not get position " + n + " in queue " + this + " for consumer " + consumerUID + " trying the next available position");
                    }
                } else if (n != n2) {
                    n3 = 0;
                }
                n2 = ++n;
                continue;
            }
            serializable = this.consumerPositions;
            synchronized (serializable) {
                ConsumerUID consumerUID2 = this.consumerPositions.set(n, consumerUID);
                if (consumerUID2 != NULL_OBJECT && consumerUID2 != null) {
                    this.logger.log(4, "during set: object unexpectly changed  in getPosition for " + consumerUID2 + " at position " + n);
                }
            }
            bl3 = true;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer addConsumer(Consumer consumer, boolean bl, Connection connection) throws BrokerException, SelectorFormatException {
        consumer.setStoredConsumerUID(PacketReference.getQueueUID());
        super.addConsumer(consumer, bl, connection);
        if (!bl && this.getIsLocal()) {
            throw new BrokerException("Internal Error " + this + " trying to add remote consumer to local dest", 409);
        }
        if (consumer.lockPosition == -1) {
            consumer.lockPosition = this.getPosition(consumer.getConsumerUID(), bl, false);
        } else {
            this.setPosition(consumer.getConsumerUID(), consumer.lockPosition);
        }
        if (consumer.lockPosition == -1) {
            Object[] objectArray = new String[]{this.getName(), String.valueOf(this.maxActiveCount), String.valueOf(this.maxFailoverCount)};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4006", objectArray), 409);
        }
        QueueInfo queueInfo = new QueueInfo();
        queueInfo.position = consumer.lockPosition;
        queueInfo.consumer = consumer;
        queueInfo.local = bl;
        queueInfo.active = this.maxActiveCount == -1 || consumer.lockPosition < this.maxActiveCount;
        Object object = this.allConsumers;
        synchronized (object) {
            this.allConsumers.put(consumer.getConsumerUID(), queueInfo);
        }
        object = this;
        synchronized (object) {
            if (queueInfo.local) {
                ++this.localActiveConsumerCnt;
            }
            if (queueInfo.active) {
                this.updateActive(true);
            } else {
                this.updateFailover(true);
            }
            boolean bl2 = this.localActiveConsumerCnt > 0;
            queueInfo.consumingMsgs = bl2 && this.localDeliveryPreferred && !bl ? false : queueInfo.active;
            this.makeActive(consumer);
            consumer.setIsActiveConsumer(queueInfo.consumingMsgs);
            if (this.localDeliveryPreferred && bl && this.localActiveConsumerCnt == 1 && this.activeConsumerCnt > this.localActiveConsumerCnt) {
                this.consumerListChanged();
            }
        }
        this.notifyConsumerAdded(consumer, connection);
        return consumer;
    }

    public void removeConsumer(ConsumerUID consumerUID, boolean bl) throws BrokerException {
        this.removeConsumer(consumerUID, null, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID consumerUID, Map map, boolean bl, boolean bl2) throws BrokerException {
        super.removeConsumer(consumerUID, map, bl, bl2);
        QueueInfo queueInfo = null;
        Object object = this.allConsumers;
        synchronized (object) {
            queueInfo = (QueueInfo)this.allConsumers.remove(consumerUID);
        }
        if (queueInfo == null) {
            this.notifyConsumerRemoved();
            return;
        }
        object = this;
        synchronized (object) {
            this.makeInactive(queueInfo.consumer);
        }
        if (queueInfo.local && !this.getIsLocal()) {
            Globals.getClusterBroadcast().unlockConsumer(consumerUID, this.getDestinationUID(), queueInfo.position);
        }
        object = this;
        synchronized (object) {
            Object object2 = this.consumerPositions.set(queueInfo.position, NULL_OBJECT);
            if (!consumerUID.equals(object2)) {
                this.logger.log(4, "object changed during remove of " + object2 + " at position " + queueInfo.position);
            }
            if (queueInfo.active) {
                if (queueInfo.local) {
                    --this.localActiveConsumerCnt;
                }
                this.updateActive(false);
            } else {
                this.updateFailover(false);
            }
        }
        this.consumerListChanged();
        this.notifyConsumerRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeActive(Consumer consumer) {
        if (consumer.getSelector() == null) {
            if (this.pendingSubset == null) {
                this.pendingSubset = this.pending.subSet((Filter)null);
            }
            consumer.setParentList(this.pendingSubset);
        } else {
            SubSet subSet = null;
            Map map = this.views;
            synchronized (map) {
                subSet = (SubSet)this.views.get(consumer.getSelectorStr());
                if (subSet == null) {
                    SelectorFilter selectorFilter = new SelectorFilter(consumer.getSelectorStr(), consumer.getSelector());
                    subSet = this.pending.subSet((Filter)selectorFilter);
                    this.views.put(consumer.getSelectorStr(), subSet);
                }
            }
            consumer.setParentList(subSet);
        }
    }

    private void makeInactive(Consumer consumer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerListChanged() throws BrokerException {
        if (this.activeConsumerCnt == this.maxActiveCount && this.getConsumerCount() == 0) {
            return;
        }
        boolean bl = !this.localDeliveryPreferred || this.localActiveConsumerCnt == 0;
        Object var2_2 = null;
        Map map = this.allConsumers;
        synchronized (map) {
            for (QueueInfo queueInfo : this.allConsumers.values()) {
                int n;
                if (queueInfo.active) {
                    if (queueInfo.position >= this.maxActiveCount && this.maxActiveCount != -1) {
                        if (this.failoverConsumerCnt >= this.maxFailoverCount) continue;
                        queueInfo.consumingMsgs = false;
                        queueInfo.active = false;
                        queueInfo.consumer.setIsActiveConsumer(false);
                        this.updateActive(false);
                        this.updateFailover(true);
                        continue;
                    }
                    if (queueInfo.local) {
                        assert (queueInfo.consumingMsgs);
                        continue;
                    }
                    assert (!queueInfo.local);
                    if (bl) {
                        if (queueInfo.consumingMsgs) continue;
                        queueInfo.consumingMsgs = true;
                        queueInfo.consumer.setIsActiveConsumer(true);
                        continue;
                    }
                    if (queueInfo.consumingMsgs) {
                        queueInfo.consumingMsgs = false;
                        queueInfo.consumer.setIsActiveConsumer(false);
                        continue;
                    }
                    queueInfo.consumer.setIsActiveConsumer(false);
                    continue;
                }
                if (queueInfo.position < this.maxActiveCount) {
                    queueInfo.active = true;
                    queueInfo.consumingMsgs = queueInfo.local || bl;
                    queueInfo.consumer.setIsActiveConsumer(queueInfo.consumingMsgs);
                    this.updateActive(true);
                    this.updateFailover(false);
                    this.logger.log(8, "B1133", (Object)String.valueOf(queueInfo.consumer.getConsumerUID().longValue()), (Object)queueInfo.consumer.getDestinationUID().getName());
                    continue;
                }
                if (this.activeConsumerCnt >= this.maxActiveCount || (n = this.getPosition(queueInfo.consumer.getConsumerUID(), queueInfo.local, true)) == -1) continue;
                if (!this.getIsLocal()) {
                    Globals.getClusterBroadcast().unlockConsumer(queueInfo.consumer.getConsumerUID(), this.getDestinationUID(), queueInfo.position);
                }
                Object object = this.consumerPositions.set(queueInfo.position, NULL_OBJECT);
                if (!queueInfo.consumer.getConsumerUID().equals(object)) {
                    this.logger.log(4, "failover update: object unexpected changed  position " + object + " at position " + queueInfo.position + " new pos " + n);
                }
                queueInfo.position = n;
                queueInfo.consumingMsgs = queueInfo.local || bl;
                queueInfo.consumer.setIsActiveConsumer(queueInfo.consumingMsgs);
                queueInfo.active = true;
                this.updateActive(true);
                this.updateFailover(false);
                this.logger.log(8, "B1133", (Object)String.valueOf(queueInfo.consumer.getConsumerUID().longValue()), (Object)queueInfo.consumer.getDestinationUID().getName());
                if (!queueInfo.consumingMsgs) continue;
                this.makeActive(queueInfo.consumer);
            }
        }
    }

    private synchronized void updateActive(boolean bl) {
        this.activeConsumerCnt = bl ? ++this.activeConsumerCnt : --this.activeConsumerCnt;
        if (this.activeConsumerCnt > this.hwActiveCount) {
            this.hwActiveCount = this.activeConsumerCnt;
        }
        this.activeAverage = ((float)this.activeSampleCnt * this.activeAverage + (float)this.activeConsumerCnt) / ((float)this.activeSampleCnt + 1.0f);
        ++this.activeSampleCnt;
    }

    private synchronized void updateFailover(boolean bl) {
        this.failoverConsumerCnt = bl ? ++this.failoverConsumerCnt : --this.failoverConsumerCnt;
        if (this.failoverConsumerCnt > this.hwFailoverCount) {
            this.hwFailoverCount = this.failoverConsumerCnt;
        }
        this.failoverAverage = ((float)this.failoverSampleCnt * this.failoverAverage + (float)this.failoverConsumerCnt) / ((float)this.failoverSampleCnt + 1.0f);
        ++this.failoverSampleCnt;
    }

    public int getSharedConsumerFlowLimit() {
        return this.getMaxPrefetch();
    }

    public void purgeDestination(boolean bl) throws BrokerException {
        super.purgeDestination(bl);
        this.pending.clear();
    }

    public void purgeDestination(Filter filter) throws BrokerException {
        super.purgeDestination(filter);
        Set set = this.pending.getAll(filter);
        for (Object e : set) {
            this.pending.remove(e);
        }
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            MAX_LICENSED_ACTIVE = licenseBase.getIntProperty("imq.max_active_cons", 5);
            MAX_LICENSED_BACKUP = licenseBase.getIntProperty("imq.max_backup_cons", 0);
            if (MAX_LICENSED_ACTIVE == Integer.MAX_VALUE) {
                MAX_LICENSED_ACTIVE = -1;
            }
            if (MAX_LICENSED_BACKUP == Integer.MAX_VALUE) {
                MAX_LICENSED_BACKUP = -1;
            }
        }
        catch (BrokerException brokerException) {
            MAX_LICENSED_ACTIVE = 5;
            MAX_LICENSED_BACKUP = 0;
        }
        if (MAX_LICENSED_ACTIVE != -1 && (defaultMaxActiveCount == -1 || defaultMaxActiveCount > MAX_LICENSED_ACTIVE)) {
            Globals.getLogger().log(32, "B3123", (Object)Globals.getBrokerResources().getKString("B0050", String.valueOf(MAX_LICENSED_ACTIVE)));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getKString("B0050", String.valueOf(MAX_LICENSED_ACTIVE))), BrokerEvent.Type.FATAL_ERROR);
        }
        if (MAX_LICENSED_BACKUP != -1 && (defaultMaxFailoverCount == -1 || defaultMaxFailoverCount > MAX_LICENSED_BACKUP)) {
            Globals.getLogger().log(32, "B3123", (Object)Globals.getBrokerResources().getKString("B0051", String.valueOf(MAX_LICENSED_BACKUP)));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getKString("B0051", String.valueOf(MAX_LICENSED_BACKUP))), BrokerEvent.Type.FATAL_ERROR);
        }
        cl = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
                if (string.equals(MAX_ACTIVE_CNT)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, "bad value " + string2 + " expected integer", exception);
                    }
                    if (MAX_LICENSED_ACTIVE != -1 && (n == -1 || n > MAX_LICENSED_ACTIVE)) {
                        throw new PropertyUpdateException(1, Globals.getBrokerResources().getKString("B3122", Globals.getBrokerResources().getKString("B0050", String.valueOf(MAX_LICENSED_ACTIVE))));
                    }
                } else if (string.equals(MAX_FAILOVER_CNT)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, "bad value " + string2 + " expected integer", exception);
                    }
                    if (MAX_LICENSED_BACKUP != -1 && (n == -1 || n > MAX_LICENSED_BACKUP)) {
                        throw new PropertyUpdateException(1, Globals.getBrokerResources().getKString("B3122", Globals.getBrokerResources().getKString("B0051", String.valueOf(MAX_LICENSED_BACKUP))));
                    }
                }
            }

            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                if (string.equals(MAX_ACTIVE_CNT)) {
                    defaultMaxActiveCount = brokerConfig.getIntProperty(MAX_ACTIVE_CNT);
                } else if (string.equals(MAX_FAILOVER_CNT)) {
                    defaultMaxFailoverCount = brokerConfig.getIntProperty(MAX_FAILOVER_CNT);
                }
                return true;
            }
        };
    }
}

