/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.apps.console.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.BrokerClusterInfo;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class BrokerAdmin
extends BrokerAdminConn {
    private Object aObj = null;
    private BrokerCmdStatusEvent statusEvent = null;

    public BrokerAdmin(String string, int n) throws BrokerAdminException {
        this(string, n, null, null, -1L, false, -1, -1L);
    }

    public BrokerAdmin(String string, int n, String string2, String string3) throws BrokerAdminException {
        this(string, n, string2, string3, -1L, false, -1, -1L);
    }

    public BrokerAdmin(String string, int n, String string2, String string3, int n2) throws BrokerAdminException {
        this(string, n, string2, string3, n2, false, -1, -1L);
    }

    public BrokerAdmin(String string, String string2, String string3, int n, boolean bl) throws BrokerAdminException {
        this(string, string2, string3, n, false, -1, -1L, bl);
    }

    public BrokerAdmin(String string, int n, String string2, String string3, long l, boolean bl, int n2, long l2) throws BrokerAdminException {
        super(string, n, string2, string3, l, bl, n2, l2);
    }

    public BrokerAdmin(String string, String string2, String string3, long l, boolean bl, int n, long l2, boolean bl2) throws BrokerAdminException {
        super(string, string2, string3, l, bl, n, l2, bl2);
    }

    public BrokerAdmin(Properties properties, String string, String string2, long l) throws BrokerAdminException {
        super(properties, string, string2, l);
    }

    public String getAdminQueueDest() {
        return "__JMQAdmin";
    }

    public String getAdminMessagePropNameMessageType() {
        return "JMQMessageType";
    }

    public String getAdminMessagePropNameErrorString() {
        return "JMQErrorString";
    }

    public String getAdminMessagePropNameStatus() {
        return "JMQStatus";
    }

    public int getAdminMessageStatusOK() {
        return 200;
    }

    public int getAdminMessageTypeSHUTDOWN_REPLY() {
        return 39;
    }

    public CommonCmdStatusEvent newCommonCmdStatusEvent(int n) {
        return new BrokerCmdStatusEvent(this, this, n);
    }

    public CommonCmdStatusEvent getCurrentStatusEvent() {
        return this.statusEvent;
    }

    public void clearStatusEvent() {
        this.statusEvent = null;
    }

    private BrokerCmdStatusEvent createStatusEvent(int n, int n2, String string) {
        CommonCmdStatusEvent commonCmdStatusEvent = this.newCommonCmdStatusEvent(n);
        commonCmdStatusEvent.setReplyType(n2);
        commonCmdStatusEvent.setReplyTypeString(string);
        return (BrokerCmdStatusEvent)commonCmdStatusEvent;
    }

    public void sendHelloMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendHelloMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 28);
            this.statusEvent = this.createStatusEvent(22, 29, "HELLO_REPLY");
            if (debug) {
                this.printMsgType(28, "HELLO");
                Globals.stdOutPrintln("\tJMQProtocolLevel=102");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveHelloReplyMessage() *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 29, "HELLO_REPLY");
            this.isConnected = true;
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetServicesMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetServicesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 26);
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(1, 27, "GET_SERVICES_REPLY");
            } else {
                this.statusEvent = this.createStatusEvent(2, 27, "GET_SERVICES_REPLY");
            }
            this.statusEvent.setServiceName(string);
            if (debug) {
                this.printMsgType(26, "GET_SERVICES");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetServicesReplyMessage() throws BrokerAdminException {
        return this.receiveGetServicesReplyMessage(true);
    }

    public Vector receiveGetServicesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetServicesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 27, "GET_SERVICES_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printServiceInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendPauseMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPauseMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 30);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQServiceName");
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(3, 31, "PAUSE_REPLY");
                this.statusEvent.setServiceName(string);
            } else {
                this.statusEvent = this.createStatusEvent(4, 31, "PAUSE_REPLY");
            }
            if (debug) {
                this.printMsgType(30, "PAUSE");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendPauseMessage(String string, int n, int n2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPauseMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 30);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQDestination");
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
                objectMessage.setIntProperty("JMQDestType", n);
            }
            if (n2 != -1) {
                objectMessage.setIntProperty("JMQDestState", n2);
            }
            this.statusEvent = this.createStatusEvent(28, 31, "PAUSE_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(30, "PAUSE");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
                Globals.stdOutPrintln("\tJMQDestState=" + n2);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receivePauseReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receivePauseReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 31, "PAUSE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendResetBrokerMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendResetBrokerMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 84);
            if (string != null) {
                objectMessage.setStringProperty("JMQResetType", string);
            }
            this.statusEvent = this.createStatusEvent(42, 85, "RESET_BROKER_REPLY");
            if (debug) {
                this.printMsgType(84, "RESET_BROKER");
                Globals.stdOutPrintln("\tJMQResetType=" + string);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveResetBrokerReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveResetBrokerReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 85, "RESET_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendCheckpointBrokerMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCheckpointBrokerMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 92);
            this.statusEvent = this.createStatusEvent(45, 93, "CHECKPOINT_BROKER_REPLY");
            if (debug) {
                this.printMsgType(92, "CHECKPOINT_BROKER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCheckpointBrokerReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCheckpointBrokerReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 93, "CHECKPOINT_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendResumeMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendResumeMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 36);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQServiceName");
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(5, 37, "RESUME_REPLY");
                this.statusEvent.setServiceName(string);
            } else {
                this.statusEvent = this.createStatusEvent(6, 37, "RESUME_REPLY");
            }
            if (debug) {
                this.printMsgType(36, "RESUME");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendResumeMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendResumeMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 36);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQDestination");
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
                objectMessage.setIntProperty("JMQDestType", n);
            }
            this.statusEvent = this.createStatusEvent(29, 37, "RESUME_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(36, "RESUME");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveResumeReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveResumeReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 37, "RESUME_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendQuiesceMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendQuiesceMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 74);
            this.statusEvent = this.createStatusEvent(36, 75, "QUIESCE_BROKER_REPLY");
            if (debug) {
                this.printMsgType(74, "QUIESCE_BROKER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveQuiesceReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveQuiesceReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 75, "QUIESCE_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendUnquiesceMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUnquiesceMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 82);
            this.statusEvent = this.createStatusEvent(41, 83, "UNQUIESCE_BROKER_REPLY");
            if (debug) {
                this.printMsgType(82, "UNQUIESCE_BROKER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUnquiesceReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUnquiesceReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 83, "UNQUIESCE_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendTakeoverMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendTakeoverMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 76);
            objectMessage.setStringProperty("JMQBrokerID", string);
            this.statusEvent = this.createStatusEvent(37, 77, "TAKEOVER_BROKER_REPLY");
            if (debug) {
                this.printMsgType(76, "TAKEOVER_BROKER");
                Globals.stdOutPrintln("\tJMQBrokerID = " + string);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveTakeoverReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveTakeoverReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 77, "TAKEOVER_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetDestinationsMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetDestinationsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 20);
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
                objectMessage.setIntProperty("JMQDestType", n);
                this.statusEvent = this.createStatusEvent(7, 21, "GET_DESTINATIONS_REPLY");
                this.statusEvent.setDestinationName(string);
                this.statusEvent.setDestinationType(n);
            } else {
                this.statusEvent = this.createStatusEvent(8, 21, "GET_DESTINATIONS_REPLY");
            }
            if (debug) {
                this.printMsgType(20, "GET_DESTINATIONS");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQDestination=" + string);
                    Globals.stdOutPrintln("\tJMQDestType=" + n);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetDestinationsReplyMessage() throws BrokerAdminException {
        return this.receiveGetDestinationsReplyMessage(true);
    }

    public Vector receiveGetDestinationsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetDestinationsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 21, "GET_DESTINATIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printDestinationInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendCreateDestinationMessage(DestinationInfo destinationInfo) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCreateDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 10);
            objectMessage.setObject((Serializable)destinationInfo);
            this.statusEvent = this.createStatusEvent(9, 11, "CREATE_DESTINATION_REPLY");
            this.statusEvent.setDestinationInfo(destinationInfo);
            if (debug) {
                this.printMsgType(10, "CREATE_DESTINATION");
                this.printDestinationInfo(destinationInfo);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCreateDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCreateDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 11, "CREATE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendDestroyDestinationMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 12);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            this.statusEvent = this.createStatusEvent(0, 13, "DESTROY_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(12, "DESTROY_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 13, "DESTROY_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendPurgeDestinationMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPurgeDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 32);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            this.statusEvent = this.createStatusEvent(10, 33, "PURGE_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(32, "PURGE_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receivePurgeDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receivePurgeDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 33, "PURGE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetBrokerPropsMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetBrokerPropsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 54);
            this.statusEvent = this.createStatusEvent(11, 55, "GET_BROKER_PROPS_REPLY");
            if (debug) {
                this.printMsgType(54, "GET_BROKER_PROPS");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Properties receiveGetBrokerPropsReplyMessage() throws BrokerAdminException {
        return this.receiveGetBrokerPropsReplyMessage(true);
    }

    public Properties receiveGetBrokerPropsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetBrokerPropsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 55, "GET_BROKER_PROPS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Properties) {
                return (Properties)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendUpdateBrokerPropsMessage(Properties properties) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUpdateBrokerPropsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 56);
            objectMessage.setObject((Serializable)properties);
            this.statusEvent = this.createStatusEvent(12, 57, "UPDATE_BROKER_PROPS_REPLY");
            this.statusEvent.setBrokerProperties(properties);
            if (debug) {
                this.printMsgType(56, "UPDATE_BROKER_PROPS");
                Globals.stdOutPrintln("\tProperties=" + properties.toString());
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUpdateBrokerPropsReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUpdateBrokerPropsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 57, "UPDATE_BROKER_PROPS_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendUpdateDestinationMessage(DestinationInfo destinationInfo) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUpdateDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 40);
            objectMessage.setObject((Serializable)destinationInfo);
            this.statusEvent = this.createStatusEvent(13, 41, "UPDATE_DESTINATION_REPLY");
            this.statusEvent.setDestinationInfo(destinationInfo);
            if (debug) {
                this.printMsgType(40, "UPDATE_DESTINATION");
                this.printDestinationInfo(destinationInfo);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUpdateDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUpdateDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 41, "UPDATE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendUpdateServiceMessage(ServiceInfo serviceInfo) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUpdateServiceMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 46);
            objectMessage.setObject((Serializable)serviceInfo);
            this.statusEvent = this.createStatusEvent(14, 47, "UPDATE_SERVICE_REPLY");
            this.statusEvent.setServiceInfo(serviceInfo);
            if (debug) {
                this.printMsgType(46, "UPDATE_SERVICE");
                this.printServiceInfo(serviceInfo);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUpdateServiceReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUpdateServiceReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 47, "UPDATE_SERVICE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendShutdownMessage(boolean bl) throws BrokerAdminException {
        this.sendShutdownMessage(bl, false);
    }

    public void sendShutdownMessage(boolean bl, boolean bl2) throws BrokerAdminException {
        this.sendShutdownMessage(bl, bl2, false, -1);
    }

    public void sendShutdownMessage(boolean bl, boolean bl2, boolean bl3, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendShutdownMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 38);
            if (bl) {
                this.statusEvent = this.createStatusEvent(15, 39, "SHUTDOWN_REPLY");
                objectMessage.setBooleanProperty("JMQRestart", true);
            } else {
                this.statusEvent = this.createStatusEvent(16, 39, "SHUTDOWN_REPLY");
                objectMessage.setBooleanProperty("JMQNoFailover", bl3);
                if (n > 0) {
                    objectMessage.setIntProperty("JMQTime", n);
                }
            }
            if (bl2) {
                objectMessage.setBooleanProperty("JMQKill", true);
            }
            if (debug) {
                this.printMsgType(38, "SHUTDOWN");
                if (bl) {
                    Globals.stdOutPrintln("\tJMQRestart=true");
                } else {
                    Globals.stdOutPrintln("\tJMQNoFailover=" + bl3);
                    Globals.stdOutPrintln("\tJMQTime=" + n);
                }
                if (bl2) {
                    Globals.stdOutPrintln("\tJMQKill=true");
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveShutdownReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveShutdownReplyMessage *****");
        }
        Message message = null;
        try {
            message = this.receiver.receive(this.timeout);
            this.checkReplyTypeStatus(message, 39, "SHUTDOWN_REPLY");
        }
        catch (JMSException jMSException) {
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetDurablesMessage(String string, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetDurablesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 22);
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
            }
            if (string2 != null) {
                objectMessage.setStringProperty("JMQDurableName", string2);
            }
            this.statusEvent = this.createStatusEvent(17, 23, "GET_DURABLES_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDurableName(string2);
            if (debug) {
                this.printMsgType(22, "GET_DURABLES");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                if (string2 != null) {
                    Globals.stdOutPrintln("\tJMQDurableName=" + string2);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetDurablesReplyMessage() throws BrokerAdminException {
        return this.receiveGetDurablesReplyMessage(true);
    }

    public Vector receiveGetDurablesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetDurablesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 23, "GET_DURABLES_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printDurableInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendDestroyDurableMessage(String string, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyDurableMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 14);
            objectMessage.setStringProperty("JMQDurableName", string);
            objectMessage.setStringProperty("JMQClientID", string2);
            this.statusEvent = this.createStatusEvent(18, 15, "DESTROY_DURABLE_REPLY");
            this.statusEvent.setDurableName(string);
            this.statusEvent.setClientID(string2);
            if (debug) {
                this.printMsgType(14, "DESTROY_DURABLE");
                Globals.stdOutPrintln("\tJMQDurableName=" + string);
                Globals.stdOutPrintln("\tJMQClientID=" + string2);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendPurgeDurableMessage(String string, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPurgeDurableMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 66);
            objectMessage.setStringProperty("JMQDurableName", string);
            objectMessage.setStringProperty("JMQClientID", string2);
            this.statusEvent = this.createStatusEvent(27, 67, "PURGE_DURABLE_REPLY");
            this.statusEvent.setDurableName(string);
            this.statusEvent.setClientID(string2);
            if (debug) {
                this.printMsgType(66, "PURGE_DURABLE");
                Globals.stdOutPrintln("\tJMQDurableName=" + string);
                Globals.stdOutPrintln("\tJMQClientID=" + string2);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyDurableReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyDurableReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 15, "DESTROY_DURABLE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void receivePurgeDurableReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receivePurgeDurableReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 67, "PURGE_DURABLE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetMetricsMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetMetricsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 52);
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(19, 53, "GET_METRICS_REPLY");
                this.statusEvent.setServiceName(string);
            } else {
                this.statusEvent = this.createStatusEvent(20, 53, "GET_METRICS_REPLY");
            }
            if (debug) {
                this.printMsgType(52, "GET_METRICS");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendGetMetricsMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetMetricsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 52);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            this.statusEvent = this.createStatusEvent(30, 53, "GET_METRICS_REPLY");
            if (debug) {
                this.printMsgType(52, "GET_METRICS");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Object receiveGetMetricsReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetMetricsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 53, "GET_METRICS_REPLY");
            String string = objectMessage.getStringProperty("JMQBodyType");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null) {
                if ("DESTINATION".equals(string) && serializable instanceof DestMetricsCounters) {
                    return (DestMetricsCounters)serializable;
                }
                if ((string == null || "SERVICE".equals(string)) && serializable instanceof MetricCounters) {
                    return (MetricCounters)serializable;
                }
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendReloadClusterMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendReloadClusterMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 58);
            this.statusEvent = this.createStatusEvent(21, 59, "RELOAD_CLUSTER_REPLY");
            if (debug) {
                this.printMsgType(58, "RELOAD_CLUSTER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveReloadClusterReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveReloadClusterReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 59, "RELOAD_CLUSTER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendClusterChangeMasterMessage(Properties properties) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendClusterChangeMasterMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 96);
            objectMessage.setStringProperty("JMQClusterNewMasterBroker", properties.getProperty("imq.cluster.masterbroker"));
            objectMessage.setObject((Serializable)properties);
            this.statusEvent = this.createStatusEvent(46, 97, "CHANGE_CLUSTER_MASTER_BROKER_REPLY");
            this.statusEvent.setBrokerProperties(properties);
            if (debug) {
                this.printMsgType(96, "CHANGE_CLUSTER_MASTER_BROKER");
                Globals.stdOutPrintln("\tProperties=" + properties.toString());
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveClusterChangeMasterReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveClusterChangeMasterReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 97, "CHANGE_CLUSTER_MASTER_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetClusterMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetClusterMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 78);
            this.statusEvent = bl ? this.createStatusEvent(38, 79, "GET_CLUSTER_REPLY") : this.createStatusEvent(11, 79, "GET_CLUSTER_REPLY");
            if (debug) {
                this.printMsgType(78, "GET_CLUSTER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetClusterReplyMessage() throws BrokerAdminException {
        return this.receiveGetClusterReplyMessage(true);
    }

    public Vector receiveGetClusterReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetClusterReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 79, "GET_CLUSTER_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printClusterList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendGetJMXConnectorsMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetJMXConnectorsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 80);
            this.statusEvent = this.createStatusEvent(39, 81, "GET_JMX_REPLY");
            if (debug) {
                this.printMsgType(80, "GET_JMX");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetJMXConnectorsReplyMessage() throws BrokerAdminException {
        return this.receiveGetJMXConnectorsReplyMessage(true);
    }

    public Vector receiveGetJMXConnectorsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetJMXConnectorsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 81, "GET_JMX_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printJMXList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendGetMessagesMessage(String string, int n, boolean bl, String string2, Long l, Long l2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetMessagesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 86);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            objectMessage.setBooleanProperty("JMQGetMessageBody", bl);
            if (string2 != null) {
                objectMessage.setStringProperty("JMQMessageID", string2);
            }
            if (l != null) {
                objectMessage.setLongProperty("JMQStartMessageIndex", l.longValue());
            }
            if (l2 != null) {
                objectMessage.setLongProperty("JMQMaxNumMsgsRetrieved", l2.longValue());
            }
            this.statusEvent = this.createStatusEvent(43, 87, "GET_MESSAGE_REPLY");
            if (debug) {
                this.printMsgType(86, "GET_MESSAGES");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetMessagesReplyMessage() throws BrokerAdminException {
        return this.receiveGetMessagesReplyMessage(true);
    }

    public Vector receiveGetMessagesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetMessagesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 87, "GET_MESSAGES_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendDestroyMessagesMessage(String string, int n, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyMessagesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 88);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            if (string2 != null) {
                objectMessage.setStringProperty("JMQMessageID", string2);
            }
            this.statusEvent = this.createStatusEvent(44, 89, "DELETE_MESSAGE_REPLY");
            if (debug) {
                this.printMsgType(88, "DELETE_MESSAGE");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyMessagesReplyMessage() throws BrokerAdminException {
        this.receiveDestroyMessagesReplyMessage(true);
    }

    public void receiveDestroyMessagesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyMessagesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 89, "DELETE_MESSAGE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendCommitTxnMessage(Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCommitTxnMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 62);
            objectMessage.setLongProperty("JMQTransactionID", l.longValue());
            this.statusEvent = this.createStatusEvent(23, 63, "COMMIT_TRANSACTION_REPLY");
            if (debug) {
                this.printMsgType(62, "COMMIT_TRANSACTION");
                Globals.stdOutPrintln("\tJMQTransactionID=" + l);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCommitTxnReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCommitTxnReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 63, "COMMIT_TRANSACTION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendRollbackTxnMessage(Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendRollbackTxnMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 64);
            objectMessage.setLongProperty("JMQTransactionID", l.longValue());
            this.statusEvent = this.createStatusEvent(24, 65, "ROLLBACK_TRANSACTION_REPLY");
            if (debug) {
                this.printMsgType(64, "ROLLBACK_TRANSACTION");
                Globals.stdOutPrintln("\tJMQTransactionID=" + l);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveRollbackTxnReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveRollbackTxnReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 65, "ROLLBACK_TRANSACTION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetTxnsMessage(Long l) throws BrokerAdminException {
        this.sendGetTxnsMessage(true, l);
    }

    public void sendGetTxnsMessage() throws BrokerAdminException {
        this.sendGetTxnsMessage(false, null);
    }

    private void sendGetTxnsMessage(boolean bl, Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetTxnsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 60);
            if (bl) {
                objectMessage.setLongProperty("JMQTransactionID", l.longValue());
                this.statusEvent = this.createStatusEvent(26, 61, "GET_TRANSACTIONS_REPLY");
                this.statusEvent.setTid(l);
            } else {
                this.statusEvent = this.createStatusEvent(25, 61, "GET_TRANSACTIONS_REPLY");
            }
            if (debug) {
                this.printMsgType(60, "GET_TRANSACTIONS");
                Globals.stdOutPrintln("\tJMQTransactionID=");
                if (bl) {
                    Globals.stdOutPrintln(l.toString());
                } else {
                    Globals.stdOutPrintln("NOT SPECIFIED");
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetTxnsReplyMessage() throws BrokerAdminException {
        return this.receiveGetTxnsReplyMessage(true);
    }

    public Vector receiveGetTxnsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetTxnsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 61, "GET_TRANSACTIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (debug) {
                int n = 0;
                Globals.stdOutPrintln("obj returned: " + serializable);
                try {
                    n = objectMessage.getIntProperty("JMQQuantity");
                }
                catch (JMSException jMSException) {
                    Globals.stdOutPrintln("failed to get JMQ_QUANTITY: " + (Object)((Object)jMSException));
                }
                Globals.stdOutPrintln("JMQ_QUANTTY: " + n);
            }
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printTxnInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendCompactDestinationMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCompactDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 68);
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
            }
            if (n != -1) {
                objectMessage.setIntProperty("JMQDestType", n);
            }
            this.statusEvent = this.createStatusEvent(32, 69, "COMPACT_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(68, "COMPACT_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCompactDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCompactDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 69, "COMPACT_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetConnectionsMessage(String string, Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetConnectionsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 16);
            if (l != null) {
                this.statusEvent = this.createStatusEvent(34, 17, "GET_CONNECTIONS_REPLY");
                objectMessage.setLongProperty("JMQConnectionID", l.longValue());
                this.statusEvent.setCxnid(l);
            } else {
                this.statusEvent = this.createStatusEvent(33, 17, "GET_CONNECTIONS_REPLY");
            }
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent.setServiceName(string);
            }
            if (debug) {
                this.printMsgType(16, "GET_CONNECTIONS");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
                if (l != null) {
                    Globals.stdOutPrintln("\tJMQConnectionID=" + l);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetConnectionsReplyMessage() throws BrokerAdminException {
        return this.receiveGetConnectionsReplyMessage(true);
    }

    public Vector receiveGetConnectionsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetConnectionsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 17, "GET_CONNECTIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printConnectionInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendDestroyConnectionMessage(Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyConnectionMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 70);
            if (l != null) {
                this.statusEvent = this.createStatusEvent(40, 71, "DESTROY_CONNECTION_REPLY");
                objectMessage.setLongProperty("JMQConnectionID", l.longValue());
                this.statusEvent.setCxnid(l);
            }
            if (debug) {
                this.printMsgType(70, "DESTROY_CONNECTION");
                if (l != null) {
                    Globals.stdOutPrintln("\tJMQConnectionID=" + l);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyConnectionReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyConnectionReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 71, "DESTROY_CONNECTION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendDebugMessage(String string, String string2, String string3, String string4, Properties properties) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDebugMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 72);
            if (string != null) {
                objectMessage.setStringProperty("JMQCommand", string);
            }
            if (string2 != null) {
                objectMessage.setStringProperty("JMQCommandArg", string2);
            }
            if (string3 != null) {
                objectMessage.setStringProperty("JMQTarget", string3);
            }
            if (string4 != null) {
                objectMessage.setStringProperty("JMQTargetType", string4);
            }
            if (properties != null) {
                objectMessage.setObject((Serializable)properties);
            }
            this.statusEvent = this.createStatusEvent(35, 73, "DEBUG_REPLY");
            if (debug) {
                this.printMsgType(72, "DEBUG");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Hashtable receiveDebugReplyMessage() throws BrokerAdminException {
        return this.receiveDebugReplyMessage(true);
    }

    public Hashtable receiveDebugReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDebugReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 73, "DEBUG_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Hashtable) {
                return (Hashtable)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    private void printMsgType(int n, String string) {
        Globals.stdOutPrintln("\tJMQMessageType=" + n + "(" + string + ")");
    }

    private void printDestinationInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DestinationInfo)) {
                Globals.stdOutPrintln("\tprintDestinationInfoList: Vector contained object of type: " + e.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            DestinationInfo destinationInfo = (DestinationInfo)e;
            this.printDestinationInfo(destinationInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printDestinationInfo(DestinationInfo destinationInfo) {
        Globals.stdOutPrintln("\tDestinationInfo:");
        Globals.stdOutPrintln("\t  name=" + destinationInfo.name);
        Globals.stdOutPrintln("\t  type=" + destinationInfo.type);
        Globals.stdOutPrintln("\t  nMessages=" + destinationInfo.nMessages);
        Globals.stdOutPrintln("\t  nMessageBytes=" + destinationInfo.nMessageBytes);
        Globals.stdOutPrintln("\t  nConsumers=" + destinationInfo.nConsumers);
        Globals.stdOutPrintln("\t  maxMessages=" + destinationInfo.maxMessages);
        Globals.stdOutPrintln("\t  maxMessageBytes=" + destinationInfo.maxMessageBytes);
        Globals.stdOutPrintln("\t  maxMessageSize=" + destinationInfo.maxMessageSize);
        Globals.stdOutPrintln("\t  maxFailoverConsumers=" + destinationInfo.maxFailoverConsumers);
        Globals.stdOutPrintln("\t  maxActiveConsumers=" + destinationInfo.maxActiveConsumers);
        Globals.stdOutPrintln("\t  destScope=" + destinationInfo.destScope);
        Globals.stdOutPrintln("\t  destLimitBehavior=" + destinationInfo.destLimitBehavior);
        Globals.stdOutPrintln("\t  destCDP=" + destinationInfo.destCDP);
        Globals.stdOutPrintln("\t  maxPrefetch=" + destinationInfo.maxPrefetch);
        Globals.stdOutPrintln("\t  maxProducers=" + destinationInfo.maxProducers);
        Globals.stdOutPrintln("\t  autocreated=" + destinationInfo.autocreated);
        Globals.stdOutPrintln("\t  naConsumers=" + destinationInfo.naConsumers);
        Globals.stdOutPrintln("\t  nfConsumers=" + destinationInfo.nfConsumers);
        Globals.stdOutPrintln("\t  destState=" + destinationInfo.destState);
    }

    private void printServiceInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ServiceInfo)) {
                Globals.stdOutPrintln("\tprintServiceInfoList: Vector contained object of type: " + e.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            ServiceInfo serviceInfo = (ServiceInfo)e;
            this.printServiceInfo(serviceInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printServiceInfo(ServiceInfo serviceInfo) {
        Globals.stdOutPrintln("\tServiceInfo:");
        Globals.stdOutPrintln("\t  name=" + serviceInfo.name);
        Globals.stdOutPrintln("\t  protocol=" + serviceInfo.protocol);
        Globals.stdOutPrintln("\t  type=" + serviceInfo.type);
        Globals.stdOutPrintln("\t  state=" + serviceInfo.state);
        Globals.stdOutPrintln("\t  nConnections=" + serviceInfo.nConnections);
        Globals.stdOutPrintln("\t  currentThreads=" + serviceInfo.currentThreads);
        Globals.stdOutPrintln("\t  dynamicPort=" + serviceInfo.dynamicPort);
        Globals.stdOutPrintln("\t  metrics=" + serviceInfo.metrics);
        Globals.stdOutPrintln("\t  port=" + serviceInfo.port);
        Globals.stdOutPrintln("\t  minThreads=" + serviceInfo.minThreads);
        Globals.stdOutPrintln("\t  maxThreads=" + serviceInfo.maxThreads);
    }

    private void printConnectionInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintConnectionInfoList: Vector contained object of type: " + e.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable hashtable = (Hashtable)e;
            this.printConnectionInfo(hashtable);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printConnectionInfo(Hashtable hashtable) {
        Globals.stdOutPrintln("\tConnection Info:");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            String string2 = v.toString();
            Globals.stdOutPrintln("\t  " + string + "=" + string2);
        }
    }

    private void printDurableInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DurableInfo)) {
                Globals.stdOutPrintln("\tprintDurableInfoList: Vector contained object of type: " + e.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            DurableInfo durableInfo = (DurableInfo)e;
            this.printDurableInfo(durableInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printDurableInfo(DurableInfo durableInfo) {
        Globals.stdOutPrintln("\tDurableInfo:");
        Globals.stdOutPrintln("\t  name=" + durableInfo.name);
        Globals.stdOutPrintln("\t  clientID=" + durableInfo.clientID);
        Globals.stdOutPrintln("\t  nMessages=" + durableInfo.nMessages);
        Globals.stdOutPrintln("\t  isActive=" + durableInfo.isActive);
        Globals.stdOutPrintln("\t  ConsumerInfo=" + durableInfo.consumer);
    }

    private void printTxnInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintTxnInfoList: Vector contained object of type: " + e.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable hashtable = (Hashtable)e;
            this.printTxnInfo(hashtable);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printTxnInfo(Hashtable hashtable) {
        Globals.stdOutPrintln("\tTransaction Info:");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            String string2 = v.toString();
            Globals.stdOutPrintln("\t  " + string + "=" + string2);
        }
    }

    private void printClusterList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof BrokerClusterInfo)) {
                Globals.stdOutPrintln("\tprintClusterList: Vector contained object of type: " + e.getClass().getName() + "(expected BrokerClusterInfo)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            BrokerClusterInfo brokerClusterInfo = (BrokerClusterInfo)e;
            this.printBkrClsInfo(brokerClusterInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printBkrClsInfo(BrokerClusterInfo brokerClusterInfo) {
        Globals.stdOutPrintln("\tBroker Cluster Info:");
    }

    private void printJMXList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintJMXList: Vector contained object of type: " + e.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable hashtable = (Hashtable)e;
            this.printJMXInfo(hashtable);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printJMXInfo(Hashtable hashtable) {
        Globals.stdOutPrintln("\tJMX Connector Info:");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            String string2 = v.toString();
            Globals.stdOutPrintln("\t  " + string + "=" + string2);
        }
    }

    public void setAssociatedObj(Object object) {
        this.aObj = object;
    }

    public Object getAssociatedObj() {
        return this.aObj;
    }
}

