/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.comm;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.ConnectionInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SupportUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DBConnectionPool {
    private static boolean DEBUG = false;
    private static final String REAP_INTERVAL_PROP_SUFFIX = ".connection.reaptime";
    private static final int DEFAULT_REAP_INTERVAL = 300;
    private static final String TIMEOUT_IDLE_PROP_SUFFIX = ".connection.timeoutIdle";
    public static final String NUM_CONN_PROP_SUFFIX = ".connection.limit";
    private static final String MIN_CONN_PROP_SUFFIX = ".min_connections";
    private static final String MAX_CONN_PROP_SUFFIX = ".max_connections";
    private static final int DEFAULT_NUM_CONN = 5;
    private static final String VALIDATION_QUERY_PROP_SUFFIX = ".connection.validationQuery";
    public static final String VALIDATE_ON_GET_PROP_SUFFIX = ".connection.validateOnGet";
    private int minConnections;
    private int maxConnections;
    private boolean initialized = false;
    private ReentrantLock lock = new ReentrantLock();
    private LinkedBlockingQueue<ConnectionInfo> idleConnections = new LinkedBlockingQueue();
    private ConcurrentHashMap<ConnectionInfo, Thread> activeConnections = new ConcurrentHashMap();
    private Map<Object, ConnectionInfo> connMap = Collections.synchronizedMap(new HashMap());
    private ConnectionReaperTask connectionReaper = null;
    private ConnectionEventListener connectionListener = null;
    private long reapInterval;
    private CommDBManager dbmgr = null;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private String validationQuery = null;
    private boolean validateOnGet = false;
    private boolean timeoutIdle = true;
    private boolean isPoolDataSource = false;
    private String name = null;
    private boolean dedicated = false;
    private ConfigListener cfgListener = new ConfigListener(){

        public void validate(String string, String string2) throws PropertyUpdateException {
            if (string.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MIN_CONN_PROP_SUFFIX)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", string + "=" + string2), exception);
                }
                if (n < 1) {
                    throw new PropertyUpdateException(2, "A minimum value of 1 connection is required");
                }
                if (n > DBConnectionPool.this.maxConnections) {
                    throw new PropertyUpdateException(2, "Minimum connections " + n + " is greater than maximum connections " + DBConnectionPool.this.maxConnections);
                }
            } else if (string.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MAX_CONN_PROP_SUFFIX)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", string + "=" + string2), exception);
                }
                if (n < DBConnectionPool.this.minConnections) {
                    throw new PropertyUpdateException(2, "Maximum connections " + n + " is less than minimum connections " + DBConnectionPool.this.minConnections);
                }
            } else if (string.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", string + "=" + string2), exception);
                }
                if (n < 60) {
                    throw new PropertyUpdateException(2, "A minimum value of 60 seconds is required for reap time interval");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean update(String string, String string2) {
            BrokerConfig brokerConfig = Globals.getConfig();
            DBConnectionPool.this.lock.lock();
            try {
                if (string.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MAX_CONN_PROP_SUFFIX)) {
                    DBConnectionPool.this.maxConnections = brokerConfig.getIntProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MAX_CONN_PROP_SUFFIX);
                } else if (string.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MIN_CONN_PROP_SUFFIX)) {
                    DBConnectionPool.this.minConnections = brokerConfig.getIntProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MIN_CONN_PROP_SUFFIX);
                } else if (string.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX)) {
                    DBConnectionPool.this.reapInterval = brokerConfig.getLongProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX) * 1000L;
                }
                Object var5_4 = null;
                DBConnectionPool.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DBConnectionPool.this.lock.unlock();
                throw throwable;
            }
            if (DBConnectionPool.this.connectionReaper != null) {
                DBConnectionPool.this.connectionReaper.cancel();
            }
            DBConnectionPool.this.connectionReaper = new ConnectionReaperTask();
            Globals.getTimer().schedule((TimerTask)DBConnectionPool.this.connectionReaper, DBConnectionPool.this.reapInterval, DBConnectionPool.this.reapInterval);
            return true;
        }
    };

    public DBConnectionPool(CommDBManager commDBManager, String string) throws BrokerException {
        this(commDBManager, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConnectionPool(CommDBManager commDBManager, String string, boolean bl) throws BrokerException {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (this.initialized) {
                    Object var11_4 = null;
                    this.lock.unlock();
                    return;
                }
                this.dbmgr = commDBManager;
                this.name = string;
                this.dedicated = bl;
                this.isPoolDataSource = this.dbmgr.isPoolDataSource();
                String string2 = this.dbmgr.getJDBCPropPrefix() + VALIDATION_QUERY_PROP_SUFFIX;
                this.validationQuery = Globals.getConfig().getProperty(string2);
                if (this.validationQuery != null && this.validationQuery.trim().length() == 0) {
                    this.validationQuery = null;
                }
                this.initValidationQuery();
                if (this.validationQuery != null) {
                    this.logger.log(8, string2 + "=" + this.validationQuery);
                }
                string2 = this.dbmgr.getJDBCPropPrefix() + VALIDATE_ON_GET_PROP_SUFFIX;
                this.validateOnGet = Globals.getConfig().getBooleanProperty(string2, Globals.getHAEnabled());
                this.logger.log(8, string2 + "=" + this.validateOnGet);
                string2 = this.dbmgr.getJDBCPropPrefix() + TIMEOUT_IDLE_PROP_SUFFIX;
                this.timeoutIdle = Globals.getConfig().getBooleanProperty(string2, true);
                this.logger.log(8, string2 + "=" + this.timeoutIdle);
                if (!bl) {
                    string2 = this.dbmgr.getJDBCPropPrefix() + NUM_CONN_PROP_SUFFIX;
                    int n = Globals.getConfig().getIntProperty(string2, 5);
                    if (n < 1) {
                        n = 5;
                        this.logger.log(16, "Invalid number of connections specified, set to default of " + n + this.toString());
                    }
                    string2 = this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX;
                    this.minConnections = Globals.getConfig().getIntProperty(string2, n);
                    if (this.minConnections < 1) {
                        this.minConnections = n;
                        this.logger.log(16, "Invalid number of minimum connections specified, set to default of " + this.minConnections + this.toString());
                    }
                    string2 = this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX;
                    this.maxConnections = Globals.getConfig().getIntProperty(string2, n);
                    if (this.maxConnections < this.minConnections) {
                        this.maxConnections = this.minConnections;
                        this.logger.log(16, "Invalid number of maximum connections specified, set to default of " + this.maxConnections + this.toString());
                    }
                } else {
                    this.minConnections = 1;
                    this.maxConnections = 2;
                }
                string2 = this.dbmgr.getJDBCPropPrefix() + REAP_INTERVAL_PROP_SUFFIX;
                long l = Globals.getConfig().getLongProperty(string2, 300L);
                if (l < 60L) {
                    l = 300L;
                    this.logger.log(16, "Invalid reap time interval for pool maintenance thread specified, set to default of " + l + this.toString());
                }
                this.logger.log(8, string2 + "=" + l);
                this.reapInterval = l * 1000L;
                if (this.dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty(this.dbmgr.getCreateStoreProp(), this.dbmgr.getCreateStorePropDefault())) {
                    try {
                        Connection connection = this.dbmgr.connectToCreate();
                        connection.close();
                    }
                    catch (Exception exception) {
                        String string3 = this.dbmgr.getCreateDBURL();
                        String string4 = this.br.getKString("B3073", string3);
                        this.logger.log(32, string4 + this.toString(), (Throwable)exception);
                        throw new BrokerException(string4, exception);
                    }
                }
                if (this.connectionListener == null) {
                    this.connectionListener = new DBConnectionListener();
                }
                if (!bl) {
                    this.logger.log(8, this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX + "=" + this.minConnections);
                    this.logger.log(8, this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX + "=" + this.maxConnections);
                }
                for (int i = 0; i < this.minConnections; ++i) {
                    ConnectionInfo connectionInfo = this.createConnection();
                    this.idleConnections.offer(connectionInfo);
                }
                if (!bl) {
                    Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX, this.cfgListener);
                    Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX, this.cfgListener);
                    Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + REAP_INTERVAL_PROP_SUFFIX, this.cfgListener);
                }
                if (this.connectionReaper != null) {
                    this.connectionReaper.cancel();
                }
                this.connectionReaper = new ConnectionReaperTask();
                Globals.getTimer().schedule((TimerTask)this.connectionReaper, this.reapInterval, this.reapInterval);
                this.initialized = true;
            }
            catch (Throwable throwable) {
                Object var11_6 = null;
                this.lock.unlock();
                throw throwable;
            }
            Object var11_5 = null;
            this.lock.unlock();
            {
            }
        }
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("initialized", String.valueOf(this.initialized));
        hashtable.put("minConnections", String.valueOf(this.minConnections));
        hashtable.put("maxConnections", String.valueOf(this.maxConnections));
        hashtable.put("reapInterval", String.valueOf(this.reapInterval));
        hashtable.put("timeoutIdle", this.timeoutIdle);
        hashtable.put("validateQuery", Boolean.valueOf(this.validationQuery));
        hashtable.put("validateOnGet", this.validateOnGet);
        hashtable.put("isPoolDataSource", this.isPoolDataSource);
        hashtable.put("idleConnections.size", String.valueOf(this.idleConnections.size()));
        hashtable.put("activeConnections.size", String.valueOf(this.activeConnections.size()));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.initialized) {
            return;
        }
        this.lock.lock();
        try {
            if (this.connectionReaper != null) {
                this.connectionReaper.cancel();
                this.connectionReaper = null;
            }
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX, this.cfgListener);
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX, this.cfgListener);
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + REAP_INTERVAL_PROP_SUFFIX, this.cfgListener);
            for (ConnectionInfo connectionInfo : this.idleConnections) {
                this.destroyConnection(connectionInfo);
            }
            this.idleConnections.clear();
            this.initialized = false;
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        return "(" + this.name + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws BrokerException {
        if (this.dbmgr.getDEBUG() || DEBUG) {
            this.logger.log(8, this.toString() + ".reset");
        }
        if (!this.initialized) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.maxConnections);
        this.lock.lock();
        try {
            this.activeConnections.clear();
            this.idleConnections.drainTo(arrayList);
            for (int i = 0; i < this.minConnections; ++i) {
                ConnectionInfo connectionInfo = this.createConnection();
                this.idleConnections.offer(connectionInfo);
            }
            for (ConnectionInfo connectionInfo : arrayList) {
                this.destroyConnection(connectionInfo);
            }
            Object var5_5 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private ConnectionInfo createConnection() throws BrokerException {
        Object object = this.dbmgr.newConnection();
        ConnectionInfo connectionInfo = new ConnectionInfo(object, this.connectionListener);
        this.connMap.put(object, connectionInfo);
        return connectionInfo;
    }

    private void destroyConnection(ConnectionInfo connectionInfo) {
        connectionInfo.destroy();
        this.connMap.remove(connectionInfo.getKey());
    }

    public Connection getConnection() throws BrokerException {
        Object object;
        Object object2;
        if (this.dbmgr.getDEBUG() || DEBUG) {
            this.logger.log(8, "[" + Thread.currentThread() + "]" + this.toString() + ".getConnection[" + this.idleConnections.size() + ", " + this.activeConnections.size() + "]");
        }
        if (DEBUG) {
            object2 = FaultInjection.getInjection();
            if (((FaultInjection)((Object)object2)).FAULT_INJECTION) {
                object2.checkFaultAndSleep("jdbc.getconn.1", null);
            }
        }
        object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ConnectionInfo connectionInfo = this.idleConnections.poll();
        if (connectionInfo == null && this.activeConnections.size() < this.maxConnections) {
            connectionInfo = this.createConnection();
            try {
                object2 = connectionInfo.getConnection();
            }
            catch (Exception exception) {
                this.destroyConnection(connectionInfo);
                throw new BrokerException(connectionInfo + exception.getMessage(), exception);
            }
            if (this.dbmgr.getDEBUG() || DEBUG) {
                bl = true;
            }
        } else {
            while (connectionInfo == null) {
                try {
                    if ((this.dbmgr.getDEBUG() || DEBUG) && !bl2) {
                        bl2 = true;
                    }
                    if ((connectionInfo = this.idleConnections.poll(60L, TimeUnit.SECONDS)) != null) continue;
                    object = new StringBuffer(1024);
                    for (Map.Entry entry : this.activeConnections.entrySet()) {
                        Thread thread = (Thread)entry.getValue();
                        ((StringBuffer)object).append("\n").append(thread.getName()).append(": using connection: ").append(entry.getKey());
                        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            ((StringBuffer)object).append("\n\tat " + stackTraceElementArray[i]);
                        }
                    }
                    String object32 = this.br.getKString("B1340", "(" + this.activeConnections.size() + "," + this.idleConnections.size() + ")[" + this.minConnections + "," + this.maxConnections + "]", String.valueOf(60)) + "\n" + ((StringBuffer)object).toString();
                    this.logger.log(16, object32 + this.toString());
                    if (!this.dbmgr.getIsClosing()) continue;
                    throw new BrokerException(object32);
                }
                catch (Exception exception) {
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (!this.dbmgr.getDEBUG() && !DEBUG) continue;
                    this.logger.logStack(8, this.toString() + ".getConnection: " + exception.getMessage(), (Throwable)exception);
                }
            }
            if (!this.validateConnection(connectionInfo, this.validateOnGet, true)) {
                this.destroyConnection(connectionInfo);
                try {
                    connectionInfo = this.createConnection();
                    object2 = connectionInfo.getConnection();
                    this.logger.log(8, this.br.getKString("B1149", "" + connectionInfo, this.dbmgr.getOpenDBURL()) + this.toString());
                }
                catch (Exception exception) {
                    this.destroyConnection(connectionInfo);
                    String string = this.br.getString("B4206", this.dbmgr.getOpenDBURL());
                    this.logger.logStack(32, (String)string + this.toString(), (Throwable)exception);
                    throw new BrokerException(string, exception);
                }
            }
            try {
                object2 = connectionInfo.getConnection();
            }
            catch (Exception exception) {
                this.destroyConnection(connectionInfo);
                throw new BrokerException(connectionInfo + exception.getMessage(), exception);
            }
        }
        object = Thread.currentThread();
        this.activeConnections.put(connectionInfo, (Thread)object);
        if (this.dbmgr.getDEBUG() || DEBUG) {
            this.logger.log(8, this.toString() + ".getConnection[" + bl + "," + bl2 + "]: " + ((Thread)object).getName() + " [" + new Date() + "]: check out connection: 0x" + object2.hashCode() + connectionInfo);
        }
        return object2;
    }

    public void freeConnection(Connection connection, Throwable throwable) {
        if (this.dbmgr.getDEBUG() || DEBUG) {
            this.logger.log(8, this.toString() + ".freeConnection: connection: 0x" + connection.hashCode() + (throwable == null ? "" : ", ex=" + throwable));
        }
        if (this.isPoolDataSource) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                this.logger.log(16, this.br.getKString("B2229", "0x" + connection.hashCode(), exception.toString()) + this.toString());
            }
            return;
        }
        ConnectionInfo connectionInfo = this.connMap.get(connection);
        if (connectionInfo == null) {
            this.logger.log(16, this.br.getKString("B2230", "0x" + connection.hashCode()) + this.toString());
            try {
                connection.close();
            }
            catch (Exception exception) {
                this.logger.log(16, this.br.getKString("B2229", "0x" + connection.hashCode(), exception.toString()) + this.toString());
            }
            return;
        }
        connectionInfo.setException(throwable);
        this.returnConnection(connectionInfo, throwable);
    }

    protected void returnConnection(ConnectionInfo connectionInfo, Throwable throwable) {
        this.returnConnection(connectionInfo, throwable, false);
    }

    protected void returnConnection(ConnectionInfo connectionInfo, Throwable throwable, boolean bl) {
        Thread thread;
        if (this.dbmgr.getDEBUG() || DEBUG) {
            this.logger.log(8, this.toString() + ".returnConnection: connection: " + connectionInfo + (throwable == null ? "" : ", ex=" + throwable) + (!bl ? "" : ", destroy=" + bl));
        }
        if ((thread = this.activeConnections.remove(connectionInfo)) == null) {
            if (bl) {
                this.logger.log(8, this.br.getKString("B1344", connectionInfo.toString(), throwable.toString()) + this.toString());
                if (!this.idleConnections.remove(connectionInfo) && (this.dbmgr.getDEBUG() || DEBUG)) {
                    this.logger.log(8, this.toString() + ".returnConnection: " + "Destroy an inactive/non-idle database connection " + connectionInfo.toString());
                }
            } else if (this.dbmgr.getDEBUG() || DEBUG) {
                this.logger.log(16, this.toString() + ".returnConnection(" + connectionInfo + (throwable == null ? "" : ", ex=" + throwable) + "): not found in connection pool\n" + SupportUtil.getStackTrace((String)""));
            } else {
                this.logger.log(16, this.br.getKString("B2228", "" + connectionInfo + "[" + (throwable == null ? "" : ", ex=" + throwable) + "]") + this.toString());
            }
            this.destroyConnection(connectionInfo);
        } else {
            if (bl) {
                this.logger.log(8, this.br.getKString("B1345", connectionInfo.toString(), throwable.toString()) + this.toString());
                this.destroyConnection(connectionInfo);
                return;
            }
            if (throwable != null && !this.validateConnection(connectionInfo, throwable instanceof SQLException || throwable.getCause() instanceof SQLException, false)) {
                this.destroyConnection(connectionInfo);
                return;
            }
            connectionInfo.idleStart();
            this.idleConnections.offer(connectionInfo);
        }
    }

    private void initValidationQuery() throws BrokerException {
        if (this.dbmgr.isMysql()) {
            this.validationQuery = "/* ping */";
        } else if (this.dbmgr.isOracle()) {
            this.validationQuery = "SELECT 1 FROM DUAL";
        } else if (this.validationQuery == null && this.dbmgr.isStoreInited()) {
            try {
                this.validationQuery = "SELECT 1 FROM " + this.dbmgr.getFirstDAO().getTableName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean validateConnection(ConnectionInfo var1_1, boolean var2_2, boolean var3_3) {
        block43: {
            block42: {
                block41: {
                    block40: {
                        block38: {
                            block39: {
                                var4_4 = var2_2;
                                var5_5 = null;
                                var6_6 = null;
                                var7_7 = null;
                                var1_1.setValidating(true);
                                var8_8 = var1_1.getKey();
                                if (!(var8_8 instanceof Connection)) break block38;
                                if (!((Connection)var8_8).isClosed()) break block39;
                                var9_10 = false;
                                var23_18 = null;
                                var1_1.setValidating(false);
                                var1_1.setException(null);
                                return var9_10;
                            }
                            if (Util.isConnectionError(var1_1.getException(), this.dbmgr)) {
                                var9_11 = false;
                                var23_19 = null;
                                var1_1.setValidating(false);
                                var1_1.setException(null);
                                return var9_11;
                            }
                            break block40;
                        }
                        if (var1_1.getException() == null) break block40;
                        var9_12 = false;
                        var23_20 = null;
                        var1_1.setValidating(false);
                        var1_1.setException(null);
                        return var9_12;
                    }
                    if (!var3_3 || System.currentTimeMillis() - var1_1.getIdleStartTime() < this.reapInterval) ** GOTO lbl48
                    if (!this.timeoutIdle) break block41;
                    var9_13 = false;
                    var23_21 = null;
                    var1_1.setValidating(false);
                    var1_1.setException(null);
                    return var9_13;
                }
                var4_4 = true;
lbl48:
                // 2 sources

                if (var4_4) break block42;
                var9_14 = true;
                var23_22 = null;
                var1_1.setValidating(false);
                var1_1.setException(null);
                return var9_14;
            }
            var5_5 = var1_1.getConnection();
            if (var5_5 != null) break block43;
            var9_15 = false;
            var23_23 = null;
            var1_1.setValidating(false);
            var1_1.setException(null);
            return var9_15;
        }
        try {
            block46: {
                var9_16 = null;
                try {
                    block44: {
                        var6_6 = var5_5.createStatement();
                        var10_27 = var6_6.getQueryTimeout();
                        if (this.dbmgr.isJDBC4()) {
                            try {
                                var11_28 = Connection.class;
                                var12_31 = var11_28.getMethod("isValid", new Class[]{Integer.TYPE});
                                var13_32 = System.currentTimeMillis();
                                var15_33 = (Boolean)var12_31.invoke((Object)var5_5, new Object[]{new Integer(var10_27)});
                                if (!var15_33) {
                                    if (System.currentTimeMillis() < var13_32 + (long)var10_27 * 1000L) {
                                        var9_16 = false;
                                    }
                                } else {
                                    var9_16 = var15_33;
                                }
                            }
                            catch (NoSuchMethodException var11_29) {
                                this.dbmgr.setJDBC4(false);
                            }
                            catch (Throwable var11_30) {
                                if (!this.dbmgr.getDEBUG() && !DBConnectionPool.DEBUG) break block44;
                                this.logger.logStack(8, this.toString() + ".validateConnection: " + "Exception in invoking Connection.isValid(" + var10_27 + ")", var11_30);
                            }
                        }
                    }
                    var11_28 = null;
                    if (var9_16 == null && (var11_28 = this.validationQuery) == null) {
                        var9_16 = true;
                    }
                    if (var9_16 == null) {
                        try {
                            var7_7 = var6_6.executeQuery((String)var11_28);
                            var9_16 = var7_7.next() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            var17_34 = null;
                        }
                        catch (Throwable var16_38) {
                            var17_35 = null;
                            try {
                                if (!var5_5.getAutoCommit()) {
                                    var5_5.rollback();
                                }
                            }
                            catch (Exception var18_37) {
                                this.logger.log(16, this.br.getKString("B2226", "[" + (String)var11_28 + "]" + var1_1, var18_37.toString()) + this.toString());
                                var9_16 = false;
                            }
                            throw var16_38;
                        }
                        try {
                            if (!var5_5.getAutoCommit()) {
                                var5_5.rollback();
                            }
                        }
                        catch (Exception var18_36) {
                            this.logger.log(16, this.br.getKString("B2226", "[" + (String)var11_28 + "]" + var1_1, var18_36.toString()) + this.toString());
                            var9_16 = false;
                        }
                    }
                    var20_39 = null;
                    if (var7_7 == null) break block46;
                }
                catch (Throwable var19_43) {
                    var20_40 = null;
                    if (var7_7 != null) {
                        var7_7.close();
                    }
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    if (var8_8 instanceof PooledConnection) {
                        try {
                            var5_5.close();
                        }
                        catch (Exception var21_42) {
                            this.logger.log(16, this.br.getKString("B2226", "" + var1_1 + "[0x" + var5_5.hashCode() + "]", var21_42.toString()) + this.toString());
                            var9_16 = false;
                        }
                    }
                    throw var19_43;
                }
                var7_7.close();
            }
            if (var6_6 != null) {
                var6_6.close();
            }
            if (var8_8 instanceof PooledConnection) {
                try {
                    var5_5.close();
                }
                catch (Exception var21_41) {
                    this.logger.log(16, this.br.getKString("B2226", "" + var1_1 + "[0x" + var5_5.hashCode() + "]", var21_41.toString()) + this.toString());
                    var9_16 = false;
                }
            }
            if (var9_16 == null) {
                var9_16 = false;
            }
            var10_27 = (int)var9_16.booleanValue();
            var23_24 = null;
            var1_1.setValidating(false);
            var1_1.setException(null);
            return (boolean)var10_27;
        }
        catch (Exception var8_9) {
            try {
                this.logger.logStack(16, this.br.getKString("B2226", var1_1.toString(), var8_9.getMessage()) + this.toString(), (Throwable)var8_9);
                var9_17 = false;
                var23_25 = null;
                var1_1.setValidating(false);
                var1_1.setException(null);
                return var9_17;
            }
            catch (Throwable var22_44) {
                var23_26 = null;
                var1_1.setValidating(false);
                var1_1.setException(null);
                throw var22_44;
            }
        }
    }

    private void reapExcessConnection() {
        int n = 0;
        ConnectionInfo connectionInfo = null;
        int n2 = this.idleConnections.size();
        int n3 = this.activeConnections.size();
        if (this.dbmgr.getDEBUG() || DEBUG) {
            this.logger.log(8, this.toString() + ".reapExcessConnection: " + "pool size: min=" + this.minConnections + ", max=" + this.maxConnections + ", active=" + n3 + ", idle=" + n2);
        }
        while (n2 > 0 && n3 + n2 > this.minConnections) {
            connectionInfo = this.idleConnections.poll();
            this.destroyConnection(connectionInfo);
            ++n;
            n2 = this.idleConnections.size();
            n3 = this.activeConnections.size();
        }
        if (!this.dedicated || n != 0) {
            this.logger.log(8, this.br.getKString("B1342", n) + this.toString());
        }
        if (!this.timeoutIdle) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.idleConnections.toArray();
        int n4 = objectArray.length > this.minConnections ? this.minConnections : objectArray.length;
        long l = System.currentTimeMillis();
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            arrayList.add(objectArray[i]);
            if (l - ((ConnectionInfo)objectArray[i]).getIdleStartTime() < this.reapInterval) continue;
            bl = true;
        }
        if (!bl || arrayList.size() == 0) {
            return;
        }
        connectionInfo = this.idleConnections.peek();
        if (connectionInfo == null) {
            return;
        }
        ArrayList<ConnectionInfo> arrayList2 = new ArrayList<ConnectionInfo>();
        Thread thread = Thread.currentThread();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            if (DEBUG) {
                this.logger.log(8, "DBConnectionPool.reapExcessConnection idleTimeoutCnt=" + n6 + ", cnt=" + n4 + ", i=" + n5);
            }
            if ((connectionInfo = this.idleConnections.peek()) == null || !arrayList.contains(connectionInfo) || arrayList2.contains(connectionInfo) || (connectionInfo = this.idleConnections.poll()) == null) break;
            arrayList2.add(connectionInfo);
            ++n5;
            this.activeConnections.put(connectionInfo, thread);
            if (arrayList.contains(connectionInfo) && l - connectionInfo.getIdleStartTime() >= this.reapInterval) {
                this.activeConnections.remove(connectionInfo);
                this.destroyConnection(connectionInfo);
                ++n6;
                if (this.activeConnections.size() + this.idleConnections.size() >= this.minConnections) continue;
                try {
                    connectionInfo = this.createConnection();
                    if (this.idleConnections.size() + this.activeConnections.size() < this.minConnections) {
                        this.idleConnections.offer(connectionInfo);
                        continue;
                    }
                    this.destroyConnection(connectionInfo);
                }
                catch (BrokerException brokerException) {
                    if (this.dbmgr.getDEBUG() || DEBUG) {
                        this.logger.logStack(16, "JDBC connection pool reaper thread failed to create new connection", (Throwable)brokerException);
                        continue;
                    }
                    this.logger.log(16, this.br.getKString("B2235", brokerException.getMessage()));
                }
                continue;
            }
            this.activeConnections.remove(connectionInfo);
            this.idleConnections.offer(connectionInfo);
        }
        this.logger.log(8, this.br.getKString("B1343", n6) + this.toString());
    }

    private class DBConnectionListener
    implements ConnectionEventListener {
        public void connectionClosed(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            ConnectionInfo connectionInfo = (ConnectionInfo)DBConnectionPool.this.connMap.get(pooledConnection);
            if (connectionInfo == null) {
                throw new IllegalStateException("No mapping for PooledConnection 0x" + pooledConnection.hashCode() + "[" + pooledConnection.getClass().getName() + "]");
            }
            if (DBConnectionPool.this.dbmgr.getDEBUG() || DEBUG) {
                Logger logger = DBConnectionPool.this.logger;
                DBConnectionPool.this.logger;
                logger.log(8, this.toString() + ".connectionClosed event on " + connectionInfo);
            }
            if (!connectionInfo.inValidating()) {
                DBConnectionPool.this.returnConnection(connectionInfo, connectionInfo.getException());
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            ConnectionInfo connectionInfo = (ConnectionInfo)DBConnectionPool.this.connMap.get(pooledConnection);
            if (connectionInfo == null) {
                throw new IllegalStateException("connectionErrorOccurred: No mapping for PooledConnection 0x" + pooledConnection.hashCode() + "[" + pooledConnection.getClass().getName() + "]");
            }
            SQLException sQLException = connectionEvent.getSQLException();
            Logger logger = DBConnectionPool.this.logger;
            DBConnectionPool.this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            BrokerResources brokerResources = DBConnectionPool.this.br;
            DBConnectionPool.this.br;
            logger.log(16, stringBuilder.append(brokerResources.getKString("B2231", "" + connectionInfo, "" + sQLException)).append(this.toString()).toString());
            if (sQLException == null) {
                sQLException = new SQLException();
            }
            connectionInfo.setException(sQLException);
            if (!connectionInfo.inValidating()) {
                DBConnectionPool.this.returnConnection(connectionInfo, connectionInfo.getException(), true);
            }
        }
    }

    private class ConnectionReaperTask
    extends TimerTask {
        private volatile boolean canceled = false;

        private ConnectionReaperTask() {
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                DBConnectionPool.this.reapExcessConnection();
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B3245" + this.toString(), (Throwable)exception);
            }
        }
    }
}

