/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsserver.util.UnknownTransactionException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AckHandler
extends PacketHandler {
    static final int ACK_BLOCK_SIZE = 40;
    private int ackProcessCnt = 0;
    private FaultInjection fi = null;
    private TransactionList translist = null;
    private final Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    public static final int ACKNOWLEDGE_REQUEST = 0;
    public static final int UNDELIVERABLE_REQUEST = 1;
    public static final int DEAD_REQUEST = 2;
    public static final int DEAD_REASON_UNDELIVERABLE = 0;
    public static final int DEAD_REASON_EXPIRED = 1;

    public static void checkRequestType(int n) throws BrokerException {
        if (n > 2 || n < 0) {
            throw new BrokerException("Internal Error: unknown ackType " + n);
        }
    }

    public AckHandler(TransactionList transactionList) {
        this.translist = transactionList;
        this.fi = FaultInjection.getInjection();
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        HashMap<String, Integer> hashMap;
        Object object;
        Hashtable hashtable;
        TransactionUID transactionUID;
        block39: {
            Hashtable<String, Object> hashtable2;
            block41: {
                block40: {
                    boolean bl;
                    Comparable<Boolean> comparable;
                    String string;
                    int n;
                    block38: {
                        Serializable serializable;
                        int n2 = packet.getMessageBodySize();
                        int n3 = n2 / 40;
                        int n4 = n2 % 40;
                        n = 200;
                        string = null;
                        if (DEBUG) {
                            this.logger.log(4, "AckHandler: processing message {0} {1}", (Object)packet.toString(), (Object)iMQConnection.getConnectionUID().toString());
                        }
                        this.ackProcessCnt = !iMQConnection.isAdminConnection() && this.fi.FAULT_INJECTION ? ++this.ackProcessCnt : 0;
                        if (n3 == 0) {
                            this.logger.log(32, "B3100", (Object)("Internal Error: Empty Ack Message " + packet.getSysMessageID().toString()));
                            string = "Empty ack message";
                            n = 500;
                        }
                        if (n4 != 0) {
                            this.logger.log(32, "B3100", (Object)("Internal Error: Invalid Ack Message Size " + String.valueOf(n2) + " for message " + packet.getSysMessageID().toString()));
                            string = "corrupted ack message";
                            n = 500;
                        }
                        transactionUID = null;
                        if (packet.getTransactionID() != 0L) {
                            try {
                                transactionUID = new TransactionUID(packet.getTransactionID());
                            }
                            catch (Exception exception) {
                                this.logger.log(32, "B3100", (Object)("Internal Error: can not create transactionID for " + packet), (Throwable)exception);
                                n = 500;
                            }
                        }
                        boolean bl2 = false;
                        hashtable = null;
                        Throwable throwable = null;
                        String string2 = null;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        boolean bl3 = false;
                        try {
                            hashtable = packet.getProperties();
                            serializable = hashtable == null ? null : (Integer)hashtable.get("JMQAckType");
                            n7 = serializable == null ? 0 : (Integer)serializable;
                            comparable = hashtable == null ? null : (Boolean)hashtable.get("JMQValidate");
                            bl3 = comparable == null ? false : (Boolean)comparable;
                            AckHandler.checkRequestType(n7);
                            if (n7 == 2) {
                                throwable = (Throwable)hashtable.get("JMQException");
                                string2 = (String)hashtable.get("JMQComment");
                                object = (Integer)hashtable.get("JMQDeadReason");
                                if (object != null) {
                                    n5 = (Integer)object;
                                }
                                n6 = (object = (Integer)hashtable.get("JMSXDeliveryCount")) == null ? -1 : (Integer)object;
                            }
                        }
                        catch (Exception exception) {
                            this.logger.logStack(8, "Internal Error: bad protocol", (Throwable)exception);
                            n7 = 0;
                        }
                        if (!iMQConnection.isAdminConnection() && this.fi.FAULT_INJECTION) {
                            serializable = new HashMap();
                            if (hashtable != null) {
                                serializable.putAll(hashtable);
                            }
                            serializable.put("mqAckCount", new Integer(this.ackProcessCnt));
                            serializable.put("mqIsTransacted", transactionUID != null);
                            this.fi.checkFaultAndExit("msg.ack.1", (Map)((Object)serializable), 2, false);
                        }
                        bl = false;
                        comparable = null;
                        object = null;
                        SysMessageID[] sysMessageIDArray = null;
                        ConsumerUID[] consumerUIDArray = null;
                        try {
                            if (n == 200) {
                                hashMap = new DataInputStream(packet.getMessageBodyStream());
                                sysMessageIDArray = new SysMessageID[n3];
                                consumerUIDArray = new ConsumerUID[n3];
                                for (int i = 0; i < n3; ++i) {
                                    long l = ((DataInputStream)((Object)hashMap)).readLong();
                                    consumerUIDArray[i] = new ConsumerUID(l);
                                    consumerUIDArray[i].setConnectionUID(iMQConnection.getConnectionUID());
                                    sysMessageIDArray[i] = new SysMessageID();
                                    sysMessageIDArray[i].readID(hashMap);
                                }
                                if (bl3) {
                                    if (n7 == 2 || n7 == 1) {
                                        n = 400;
                                        string = "Can not use JMQValidate with ackType of " + n7;
                                    } else if (transactionUID == null) {
                                        n = 400;
                                        string = "Can not use JMQValidate with no tid ";
                                    } else if (!this.validateMessages(transactionUID, sysMessageIDArray, consumerUIDArray)) {
                                        n = 404;
                                        string = "Acknowledgement not processed";
                                    }
                                } else {
                                    object = n7 == 2 ? this.handleDeadMsgs(sysMessageIDArray, consumerUIDArray, n5, throwable, string2, n6) : (n7 == 1 ? this.handleUndeliverableMsgs(sysMessageIDArray, consumerUIDArray) : (transactionUID != null ? this.handleTransaction(transactionUID, sysMessageIDArray, consumerUIDArray) : this.handleAcks(iMQConnection, sysMessageIDArray, consumerUIDArray, packet.getSendAcknowledge())));
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            n = 500;
                            if (throwable2 instanceof BrokerException) {
                                n = ((BrokerException)throwable2).getStatusCode();
                                bl = ((BrokerException)throwable2).isRemote();
                                if (bl && sysMessageIDArray != null && consumerUIDArray != null) {
                                    comparable = new StringBuffer();
                                    ((StringBuffer)comparable).append(((BrokerException)throwable2).getRemoteConsumerUIDs());
                                    ((StringBuffer)comparable).append(" ");
                                    String string3 = null;
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    for (int i = 0; i < sysMessageIDArray.length; ++i) {
                                        ConsumerUID consumerUID;
                                        PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                                        Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                                        if (consumer == null || (consumerUID = consumer.getStoredConsumerUID()) == null || consumerUID.equals(consumerUIDArray[i])) continue;
                                        BrokerAddress brokerAddress = packetReference == null ? null : packetReference.getAddress();
                                        BrokerAddress brokerAddress2 = ((BrokerException)throwable2).getRemoteBrokerAddress();
                                        if (consumer == null || packetReference == null || brokerAddress == null || brokerAddress2 == null || !brokerAddress.equals(brokerAddress2) || arrayList.contains(string3 = String.valueOf(consumer.getConsumerUID().longValue()))) continue;
                                        arrayList.add(string3);
                                        ((StringBuffer)comparable).append(string3);
                                        ((StringBuffer)comparable).append(" ");
                                    }
                                }
                            }
                            string = throwable2.getMessage();
                            if (n != 500) break block38;
                            this.logger.logStack(32, "B3100", (Object)("-------------------------------------------Internal Error: Invalid Acknowledge Packet processing\n " + (packet.getSendAcknowledge() ? " notifying client\n" : " can not notify the client") + PacketUtil.dumpPacket(packet) + "--------------------------------------------"), throwable2);
                        }
                    }
                    if (!iMQConnection.isAdminConnection() && this.fi.FAULT_INJECTION) {
                        hashMap = new HashMap();
                        if (hashtable != null) {
                            hashMap.putAll(hashtable);
                        }
                        hashMap.put("mqAckCount", new Integer(this.ackProcessCnt));
                        hashMap.put("mqIsTransacted", (Integer)((Object)Boolean.valueOf(transactionUID != null)));
                        this.fi.checkFaultAndExit("msg.ack.2", hashMap, 2, false);
                    }
                    if (!packet.getSendAcknowledge()) break block39;
                    hashMap = new Packet(iMQConnection.useDirectBuffers());
                    hashMap.setPacketType(25);
                    hashMap.setConsumerID(packet.getConsumerID());
                    hashtable2 = new Hashtable<String, Object>();
                    hashtable2.put("JMQStatus", new Integer(n));
                    if (string != null) {
                        hashtable2.put("JMQReason", string);
                    }
                    if (bl) {
                        hashtable2.put("JMQRemote", true);
                        if (comparable != null) {
                            hashtable2.put("JMQRemoteConsumerIDs", ((StringBuffer)comparable).toString());
                        }
                    }
                    IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                    if (IMQBasicConnection.getDumpPacket()) break block40;
                    IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                    if (!IMQBasicConnection.getDumpOutPacket()) break block41;
                }
                hashtable2.put("JMQReqID", packet.getSysMessageID().toString());
            }
            hashMap.setProperties(hashtable2);
            iMQConnection.sendControlMessage((Packet)hashMap);
        }
        if (!iMQConnection.isAdminConnection() && this.fi.FAULT_INJECTION) {
            hashMap = new HashMap<String, Integer>();
            if (hashtable != null) {
                hashMap.putAll(hashtable);
            }
            hashMap.put("mqAckCount", new Integer(this.ackProcessCnt));
            hashMap.put("mqIsTransacted", (Integer)((Object)Boolean.valueOf(transactionUID != null)));
            this.fi.checkFaultAndExit("msg.ack.3", hashMap, 2, false);
        }
        this.cleanUp((List)object);
        return true;
    }

    public void cleanUp(List list) {
        if (list != null && !list.isEmpty()) {
            for (PacketReference packetReference : list) {
                Destination destination = packetReference.getDestination();
                try {
                    if (packetReference.isDead()) {
                        destination.removeDeadMessage(packetReference);
                        continue;
                    }
                    destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{packetReference == null ? "null" : packetReference.toString(), destination == null ? "null" : destination.getUniqueName(), exception.getMessage()};
                    String string = Globals.getBrokerResources().getKString("B3277", objectArray);
                    if (DEBUG) {
                        this.logger.logStack(8, string, (Throwable)exception);
                        continue;
                    }
                    this.logger.log(8, string);
                }
            }
        }
    }

    public List handleAcks(IMQConnection iMQConnection, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, boolean bl) throws BrokerException, IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            Object object;
            Object object2;
            Session session;
            if (DEBUG) {
                this.logger.log(8, "handleAcks[" + i + ", " + sysMessageIDArray.length + "]:sysid=" + sysMessageIDArray[i] + ", cid=" + consumerUIDArray[i]);
            }
            if ((session = Session.getSession(consumerUIDArray[i])) == null) {
                object2 = Consumer.getConsumer(consumerUIDArray[i]);
                if (object2 == null) {
                    if (!iMQConnection.isValid() || iMQConnection.isBeingDestroyed()) {
                        this.logger.log(4, "Received ack for consumer " + consumerUIDArray[i] + " on closing connection " + iMQConnection);
                        continue;
                    }
                    if (BrokerStateHandler.shutdownStarted) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing acks: Unknown consumer " + consumerUIDArray[i]);
                }
                if (((Consumer)object2).getConsumerUID().getBrokerAddress() != Globals.getClusterBroadcast().getMyAddress()) {
                    ConsumerUID consumerUID;
                    object = Destination.get(sysMessageIDArray[i]);
                    if (!((PacketReference)object).acknowledged(consumerUID = ((Consumer)object2).getConsumerUID(), ((Consumer)object2).getStoredConsumerUID(), !consumerUID.isDupsOK(), true, bl)) continue;
                    linkedList.add(object);
                    continue;
                }
                this.logger.log(8, Globals.getBrokerResources().getString("B3100", "local consumer does not have associated session " + object2));
                throw new BrokerException("Unknown local consumer " + consumerUIDArray[i]);
            }
            if (this.fi.FAULT_INJECTION && (object2 = Destination.get(sysMessageIDArray[i])) != null && !((PacketReference)object2).getDestination().isAdmin() && !((PacketReference)object2).getDestination().isInternal()) {
                if (this.fi.checkFault("msg.ack.1_5", null)) {
                    this.fi.unsetFault("msg.ack.1_5");
                    object = new BrokerException("FAULT:" + "msg.ack.1_5", 410);
                    ((BrokerException)object).setRemoteConsumerUIDs(String.valueOf(consumerUIDArray[i].longValue()));
                    ((BrokerException)object).setRemote(true);
                    throw object;
                }
            }
            if ((object2 = session.ackMessage(consumerUIDArray[i], sysMessageIDArray[i], bl)) == null) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    public List handleTransaction(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            int n;
            BrokerAddress brokerAddress;
            Object object;
            Consumer consumer = null;
            try {
                Session session = Session.getSession(consumerUIDArray[i]);
                consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1260", consumerUIDArray[i]), 404);
                }
                object = consumer.getStoredConsumerUID();
                if (session == null) {
                    SessionUID sessionUID = consumer.getSessionUID();
                    session = Session.getSession(sessionUID);
                }
                if (session == null) {
                    if (BrokerStateHandler.shutdownStarted) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing transaction: Unknown consumer/session " + consumerUIDArray[i]);
                }
                if (DEBUG) {
                    this.logger.log(8, "handleTransaction.addAck[" + i + ", " + sysMessageIDArray.length + "]:tid=" + transactionUID + ", sysid=" + sysMessageIDArray[i] + ", cid=" + consumerUIDArray[i] + ", sid=" + object);
                }
                if ((brokerAddress = session.acknowledgeInTransaction(consumerUIDArray[i], sysMessageIDArray[i], transactionUID, (n = this.translist.addAcknowledgement(transactionUID, sysMessageIDArray[i], consumerUIDArray[i], (ConsumerUID)object)) != 0)) != null && brokerAddress != Globals.getMyAddress()) {
                    this.translist.setAckBrokerAddress(transactionUID, sysMessageIDArray[i], consumerUIDArray[i], brokerAddress);
                }
                if (!this.fi.FAULT_INJECTION) continue;
                if (!this.fi.checkFault("txn.ack.1_5", null)) continue;
                this.fi.unsetFault("txn.ack.1_5");
                TransactionAckExistException transactionAckExistException = new TransactionAckExistException("FAULT:" + "txn.ack.1_5", 410);
                transactionAckExistException.setRemoteConsumerUIDs(String.valueOf(consumerUIDArray[i].longValue()));
                transactionAckExistException.setRemote(true);
                consumer.recreationRequested();
                throw transactionAckExistException;
            }
            catch (Exception exception) {
                Object object2;
                block16: {
                    object = "[" + sysMessageIDArray[i] + ", " + consumerUIDArray[i] + "]TUID=" + transactionUID;
                    if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() != 500) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B3229", object, exception.getMessage()), (Throwable)exception);
                    } else {
                        this.logger.log(32, Globals.getBrokerResources().getKString("B3229", object, exception.getMessage()), (Throwable)exception);
                    }
                    n = -1;
                    brokerAddress = null;
                    try {
                        object2 = this.translist.retrieveState(transactionUID);
                        if (object2 != null) {
                            n = ((TransactionState)object2).getState();
                            brokerAddress = ((TransactionState)object2).getXid();
                        }
                        this.translist.updateState(transactionUID, 2, true);
                    }
                    catch (Exception exception2) {
                        if (exception2 instanceof UnknownTransactionException) break block16;
                        Object[] objectArray = new String[]{TransactionState.toString(n), TransactionState.toString(2), transactionUID.toString(), brokerAddress == null ? "null" : brokerAddress.toString()};
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2179", objectArray));
                    }
                }
                if (exception instanceof TransactionAckExistException && (object2 = Destination.get(sysMessageIDArray[i])) != null && (((PacketReference)object2).isOverrided() || ((PacketReference)object2).isOverriding())) {
                    ((BrokerException)exception).overrideStatusCode(410);
                    ((BrokerException)exception).setRemoteConsumerUIDs(String.valueOf(consumerUIDArray[i].longValue()));
                    ((BrokerException)exception).setRemote(true);
                    consumer.recreationRequested();
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException("Internal Error: Unable to  complete processing acknowledgements in a tranaction: " + exception, exception);
            }
        }
        return null;
    }

    public boolean validateMessages(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        boolean bl = false;
        try {
            this.translist.getTransactionMap(transactionUID, false);
            bl = true;
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        if (bl) {
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + consumerUIDArray[i], 400);
                }
                if (this.translist.checkAcknowledgement(transactionUID, sysMessageIDArray[i], consumer.getConsumerUID())) continue;
                return false;
            }
        } else {
            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                if (consumer == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + consumerUIDArray[i], 400);
                }
                PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                if (packetReference == null) {
                    this.logger.log(4, "in validateMessages: Could not find " + sysMessageIDArray[i]);
                    continue;
                }
                if (packetReference.hasConsumerAcked(consumer.getStoredConsumerUID())) continue;
                return false;
            }
        }
        return true;
    }

    public List handleDeadMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Throwable throwable, String string, int n2) throws BrokerException {
        RemoveReason removeReason = RemoveReason.UNDELIVERABLE;
        if (n == 1) {
            removeReason = RemoveReason.EXPIRED_BY_CLIENT;
        }
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                this.logger.log(4, "Dead message for Unknown Consumer/Session" + consumerUIDArray[i]);
                continue;
            }
            if (DEBUG) {
                this.logger.log(4, "Handling Dead Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            if ((packetReference = session.handleDead(consumerUIDArray[i], sysMessageIDArray[i], removeReason, throwable, string, n2)) == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }

    public List handleUndeliverableMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                this.logger.log(4, "Undeliverable message for Unknown Consumer/Session" + consumerUIDArray[i]);
            }
            if (DEBUG) {
                this.logger.log(4, "Handling Undeliverable Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            PacketReference packetReference2 = packetReference = session == null ? null : session.handleUndeliverable(consumerUIDArray[i], sysMessageIDArray[i]);
            if (packetReference == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }
}

