/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ProducerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;

public class ProducerManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getProducerInfoByIDSignature;
    private static MBeanParameterInfo[] numWildcardProducersSignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumProducers() {
        return new Integer(Producer.getNumProducers());
    }

    public Integer getNumWildcardProducers() throws MBeanException {
        return new Integer(Producer.getNumWildcardProducers());
    }

    public Integer getNumWildcardProducers(String string) throws MBeanException {
        int n = Producer.getNumWildcardProducers();
        if (n <= 0) {
            return new Integer(0);
        }
        Iterator iterator = Producer.getWildcardProducers();
        if (iterator == null) {
            return new Integer(0);
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            ProducerUID producerUID = (ProducerUID)((Object)iterator.next());
            Producer producer = Producer.getProducer(producerUID);
            if (string != null) {
                DestinationUID destinationUID = producer.getDestinationUID();
                if (!destinationUID.getName().equals(string)) continue;
                ++n2;
                continue;
            }
            ++n2;
        }
        return new Integer(n2);
    }

    public String[] getProducerWildcards() throws MBeanException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        int n = Producer.getNumWildcardProducers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = Producer.getWildcardProducers();
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ProducerUID producerUID = (ProducerUID)((Object)iterator.next());
            Producer producer = Producer.getProducer(producerUID);
            DestinationUID destinationUID = producer.getDestinationUID();
            arrayList.add(destinationUID.getName());
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getProducerIDs() throws MBeanException {
        return ProducerUtil.getProducerIDs();
    }

    public CompositeData[] getProducerInfo() throws MBeanException {
        CompositeData[] compositeDataArray = null;
        try {
            compositeDataArray = ProducerUtil.getProducerInfo();
        }
        catch (Exception exception) {
            this.handleOperationException("getProducerInfo", exception);
        }
        return compositeDataArray;
    }

    public CompositeData getProducerInfoByID(String string) throws MBeanException {
        CompositeData compositeData = null;
        try {
            compositeData = ProducerUtil.getProducerInfo(string);
        }
        catch (Exception exception) {
            this.handleOperationException("getProducerInfoByID", exception);
        }
        return compositeData;
    }

    public String getMBeanName() {
        return "ProducerManagerMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1147");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[2];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1142"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumWildcardProducers", Integer.class.getName(), mbr.getString("MB1256"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("producerID", String.class.getName(), mbr.getString("MB1146"));
        getProducerInfoByIDSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1252"));
        numWildcardProducersSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1143"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getProducerInfo", mbr.getString("MB1144"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getProducerInfoByID", mbr.getString("MB1145"), getProducerInfoByIDSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getProducerWildcards", mbr.getString("MB1257"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getNumWildcardProducers", mbr.getString("MB1258"), numWildcardProducersSignature, Integer.class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

