/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc;

import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigChangeDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordBaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareConfigRecordDAOImpl
extends ShareConfigRecordBaseDAOImpl
implements ShareConfigRecordDAO {
    protected String tableName = this.getDBManager().getTableName("MQSHARECC45");
    protected String insertSQLOracle;
    protected String selectSeqSQLOracle;
    protected String insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
    protected String insertResetRecordSQL;
    protected String insertResetRecordWithLockSQL;
    protected String selectRecordsSinceSQL;
    protected String selectSinceWithResetRecordSQL;
    protected String selectAllSQL;
    protected String selectSeqByUUIDSQL;
    protected String updateResetRecordUUIDSQL;
    protected String setResetRecordFLAGNULLSQL;
    protected String selectResetRecordUUIDSQL;

    ShareConfigRecordDAOImpl() throws BrokerException {
        this.insertSQLOracle = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(") VALUES (" + this.tableName + "_seq.NEXTVAL, ?, ?, ?, ? )").toString();
        this.selectSeqSQLOracle = new StringBuffer(128).append("SELECT ").append(this.tableName + "_seq.CURRVAL ").append("FROM DUAL").toString();
        this.insertResetRecordSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(") VALUES ( 1, ?, ?, ?, ? )").toString();
        this.insertResetRecordWithLockSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(", ").append("FLAG").append(") VALUES ( 1, ?, ?, ?, ?, ? )").toString();
        this.selectSinceWithResetRecordSQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("SEQ").append(" > ?").append(" OR ").append("TYPE").append(" = ").append(31).append(" ORDER BY ").append("SEQ").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(", ").append("UUID").append(", ").append("RECORD").append(", ").append("TYPE").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" ORDER BY ").append("SEQ").toString();
        this.selectSeqByUUIDSQL = new StringBuffer(128).append("SELECT ").append("SEQ").append(" FROM ").append(this.tableName).append(" WHERE ").append("UUID").append(" = ?").toString();
        this.updateResetRecordUUIDSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("UUID").append(" = ?").append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
        this.setResetRecordFLAGNULLSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("FLAG").append(" = NULL").append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
        this.selectResetRecordUUIDSQL = new StringBuffer(128).append("SELECT ").append("UUID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TYPE").append(" = ").append(31).toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQSHARECC45";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public ChangeRecordInfo insert(Connection connection, ChangeRecordInfo changeRecordInfo) throws BrokerException {
        return this.insert(connection, changeRecordInfo, true);
    }

    public ChangeRecordInfo insert(Connection connection, ChangeRecordInfo changeRecordInfo, boolean bl) throws BrokerException {
        ChangeRecordInfo changeRecordInfo2;
        block25: {
            Exception exception;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block24: {
                String string = null;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                exception = null;
                try {
                    Object object;
                    CommDBManager commDBManager = this.getDBManager();
                    if (connection == null) {
                        connection = commDBManager.getConnection(commDBManager.isDerby());
                        bl2 = true;
                    }
                    String string2 = changeRecordInfo.getResetUUID();
                    if (bl) {
                        this.setResetRecordFLAGNULL(connection);
                    }
                    string = commDBManager.isOracle() ? this.insertSQLOracle : this.insertSQL;
                    preparedStatement = commDBManager.supportsGetGeneratedKey() ? connection.prepareStatement(string, new String[]{"SEQ"}) : connection.prepareStatement(string);
                    preparedStatement.setString(1, changeRecordInfo.getUUID());
                    Util.setBytes(preparedStatement, 2, changeRecordInfo.getRecord());
                    preparedStatement.setInt(3, changeRecordInfo.getType());
                    preparedStatement.setLong(4, changeRecordInfo.getTimestamp());
                    preparedStatement.executeUpdate();
                    Long l = null;
                    if (commDBManager.supportsGetGeneratedKey()) {
                        resultSet = preparedStatement.getGeneratedKeys();
                        if (resultSet.next()) {
                            l = new Long(resultSet.getLong(1));
                        }
                    } else if (commDBManager.isOracle()) {
                        object = connection.createStatement();
                        resultSet = object.executeQuery(this.selectSeqSQLOracle);
                        if (resultSet.next()) {
                            l = new Long(resultSet.getLong(1));
                        }
                        resultSet.close();
                        resultSet = null;
                        object.close();
                    } else {
                        l = this.getSequenceByUUID(connection, changeRecordInfo.getUUID());
                    }
                    if (l == null) {
                        throw new BrokerException(this.br.getKString("B4320", changeRecordInfo));
                    }
                    object = this.getResetRecordUUID(connection);
                    if (string2 != null && !((String)object).equals(string2)) {
                        throw new BrokerException(this.br.getKString("B4321", "[" + string2 + ", " + (String)object + "]"), 412);
                    }
                    if (bl2 && !connection.getAutoCommit()) {
                        connection.commit();
                    }
                    if (string2 == null) {
                        changeRecordInfo.setResetUUID((String)object);
                    }
                    changeRecordInfo.setSeq(l);
                    changeRecordInfo2 = changeRecordInfo;
                    Object var15_17 = null;
                    if (!bl2) break block24;
                }
                catch (Exception exception2) {
                    try {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", (Throwable)sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof SQLException) {
                            this.getDBManager();
                            exception3 = CommDBManager.wrapSQLException("[" + string + "]", (SQLException)exception2);
                        } else {
                            exception3 = exception2;
                        }
                        throw new BrokerException(this.br.getKString("B4325", changeRecordInfo.toString(), exception3.getMessage()), exception3);
                    }
                    catch (Throwable throwable) {
                        Object var15_18 = null;
                        if (bl2) {
                            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                        } else {
                            this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                break block25;
            }
            this.closeSQLObjects(resultSet, preparedStatement, null, exception);
        }
        return changeRecordInfo2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertResetRecord(Connection connection, ChangeRecordInfo changeRecordInfo, boolean bl) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block27: {
            String string = null;
            boolean bl2 = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(false);
                        bl2 = true;
                    }
                    if (!this.hasResetRecord(connection)) {
                        int n;
                        string = this.insertResetRecordSQL;
                        if (!bl) {
                            string = this.insertResetRecordWithLockSQL;
                        }
                        preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setString(1, changeRecordInfo.getUUID());
                        Util.setBytes(preparedStatement, 2, changeRecordInfo.getRecord());
                        preparedStatement.setInt(3, 31);
                        preparedStatement.setLong(4, changeRecordInfo.getTimestamp());
                        if (!bl) {
                            preparedStatement.setInt(5, 1);
                        }
                        if ((n = preparedStatement.executeUpdate()) == 1) {
                            this.setResetRecordUUID(connection, changeRecordInfo.getUUID());
                        } else {
                            if (!this.hasResetRecord(connection)) throw new BrokerException("Unexpected affected row count " + n + " on  " + string);
                            if (!bl) {
                                throw new BrokerException("Unexpected affected row count " + n + " on  " + string);
                            }
                        }
                    } else if (!bl) {
                        throw new BrokerException(this.br.getKString("B3266", ((ShareConfigChangeDBManager)this.getDBManager()).getClusterID()));
                    }
                    if (bl2) {
                        connection.commit();
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    block26: {
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", (Throwable)sQLException);
                        }
                        try {
                            boolean bl3 = this.hasResetRecord(connection);
                            if (!bl3) break block26;
                            if (!bl) {
                                throw new BrokerException(this.br.getKString("B3266", ((ShareConfigChangeDBManager)this.getDBManager()).getClusterID()));
                            }
                            exception = null;
                        }
                        catch (Exception exception4) {
                            this.logger.log(32, this.br.getKString("B3268", exception4.getMessage()));
                            break block26;
                        }
                        Object var11_11 = null;
                        if (bl2) {
                            this.closeSQLObjects(null, preparedStatement, connection, exception);
                            return;
                        }
                        this.closeSQLObjects(null, preparedStatement, null, exception);
                        return;
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        this.getDBManager();
                        exception3 = CommDBManager.wrapSQLException("[" + this.insertResetRecordSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4324", exception3.getMessage()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4324", exception3.getMessage()), exception3);
                }
                Object var11_10 = null;
                if (!bl2) break block27;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (bl2) {
                    this.closeSQLObjects(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                this.closeSQLObjects(null, preparedStatement, null, exception);
                throw throwable;
            }
            this.closeSQLObjects(null, preparedStatement, connection, exception);
            return;
        }
        this.closeSQLObjects(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasResetRecord(Connection connection) throws BrokerException {
        boolean bl;
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl2;
        block16: {
            boolean bl3;
            block14: {
                block15: {
                    bl2 = false;
                    preparedStatement = null;
                    ResultSet resultSet = null;
                    exception = null;
                    try {
                        try {
                            if (connection == null) {
                                connection = this.getDBManager().getConnection(true);
                                bl2 = true;
                            }
                            if ((resultSet = (preparedStatement = connection.prepareStatement(this.selectAllSQL)).executeQuery()).next()) {
                                int n = resultSet.getInt(4);
                                if (n != 31) throw new BrokerException("Unexpected 1st record type " + n + " for first record in database table " + this.getTableName());
                                bl3 = true;
                                Object var9_12 = null;
                                if (!bl2) break block14;
                                break block15;
                            }
                            bl = false;
                            break block16;
                        }
                        catch (Exception exception2) {
                            Exception exception3;
                            exception = exception2;
                            try {
                                if (connection != null && !connection.getAutoCommit()) {
                                    connection.rollback();
                                }
                            }
                            catch (SQLException sQLException) {
                                this.logger.log(32, "B4080", (Throwable)sQLException);
                            }
                            if (exception2 instanceof BrokerException) {
                                throw (BrokerException)exception2;
                            }
                            if (exception2 instanceof SQLException) {
                                this.getDBManager();
                                exception3 = CommDBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception2);
                                throw new BrokerException(this.br.getKString("B4326", exception3.getMessage()), exception3);
                            }
                            exception3 = exception2;
                            throw new BrokerException(this.br.getKString("B4326", exception3.getMessage()), exception3);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        if (bl2) {
                            this.closeSQLObjects(null, preparedStatement, connection, exception);
                            throw throwable;
                        }
                        this.closeSQLObjects(null, preparedStatement, null, exception);
                        throw throwable;
                    }
                }
                this.closeSQLObjects(null, preparedStatement, connection, exception);
                return bl3;
            }
            this.closeSQLObjects(null, preparedStatement, null, exception);
            return bl3;
        }
        Object var9_13 = null;
        if (bl2) {
            this.closeSQLObjects(null, preparedStatement, connection, exception);
            return bl;
        }
        this.closeSQLObjects(null, preparedStatement, null, exception);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResetRecordUUID(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block13: {
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateResetRecordUUIDSQL);
                    preparedStatement.setString(1, string);
                    if (preparedStatement.executeUpdate() < 1) {
                        throw new BrokerException("Unexpected affected row count for " + this.updateResetRecordUUIDSQL);
                    }
                    Object var10_7 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        this.getDBManager();
                        exception3 = CommDBManager.wrapSQLException("[" + this.updateResetRecordUUIDSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4327", string, exception3.getMessage()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4327", string, exception3.getMessage()), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (bl) {
                    this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
            return;
        }
        this.closeSQLObjects(resultSet, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResetRecordFLAGNULL(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block13: {
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(true);
                        bl = true;
                    }
                    if ((preparedStatement = connection.prepareStatement(this.setResetRecordFLAGNULLSQL)).executeUpdate() < 1) {
                        throw new BrokerException("Unexpected affected row count for " + this.setResetRecordFLAGNULLSQL);
                    }
                    Object var9_6 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        this.getDBManager();
                        exception3 = CommDBManager.wrapSQLException("[" + this.setResetRecordFLAGNULLSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4328", "FLAG", exception3.getMessage()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4328", "FLAG", exception3.getMessage()), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (bl) {
                    this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
            return;
        }
        this.closeSQLObjects(resultSet, preparedStatement, null, exception);
    }

    public String getResetRecordUUID(Connection connection) throws BrokerException {
        String string;
        block16: {
            Exception exception;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block15: {
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                exception = null;
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectResetRecordUUIDSQL);
                    resultSet = preparedStatement.executeQuery();
                    String string2 = null;
                    if (resultSet.next()) {
                        string2 = resultSet.getString(1);
                    }
                    if (string2 == null) {
                        throw new BrokerException("No reset record found in database table " + this.getTableName());
                    }
                    string = string2;
                    Object var9_11 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    try {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", (Throwable)sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof SQLException) {
                            this.getDBManager();
                            exception3 = CommDBManager.wrapSQLException("[" + this.selectResetRecordUUIDSQL + "]", (SQLException)exception2);
                        } else {
                            exception3 = exception2;
                        }
                        throw new BrokerException(this.br.getKString("B4329", exception3.getMessage()), exception3);
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (bl) {
                            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                        } else {
                            this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                break block16;
            }
            this.closeSQLObjects(resultSet, preparedStatement, null, exception);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ChangeRecordInfo> getRecords(Connection connection, Long l, String string, boolean bl) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        List<ChangeRecordInfo> list;
        block22: {
            list = new ArrayList();
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            String string2 = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(false);
                        bl2 = true;
                    }
                    if (l == null || string == null) {
                        list = this.getAllRecords(connection);
                    } else {
                        string2 = this.selectSinceWithResetRecordSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setLong(1, l);
                        resultSet = preparedStatement.executeQuery();
                        long l2 = -1L;
                        String string3 = null;
                        byte[] byArray = null;
                        int n = 0;
                        long l3 = -1L;
                        ChangeRecordInfo changeRecordInfo = null;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String string4 = null;
                        while (resultSet.next()) {
                            try {
                                l2 = resultSet.getLong(1);
                                string3 = resultSet.getString(2);
                                byArray = Util.readBytes(resultSet, 3);
                                n = resultSet.getInt(4);
                                l3 = resultSet.getLong(5);
                                if (n == 31) {
                                    bl5 = true;
                                    if (string3.equals(string)) continue;
                                    string4 = string3;
                                    bl4 = true;
                                    break;
                                }
                                changeRecordInfo = new ChangeRecordInfo(l2, string3, byArray, n, l3);
                                changeRecordInfo.setResetUUID(string);
                                changeRecordInfo.setIsSelectAll(false);
                                ((ArrayList)list).add(changeRecordInfo);
                            }
                            catch (IOException iOException) {
                                bl3 = true;
                                this.getDBManager();
                                IOException iOException2 = CommDBManager.wrapIOException("[" + this.selectAllSQL + "]", iOException);
                                this.logger.logStack(32, "B4123", (Object)String.valueOf(l), (Throwable)iOException2);
                            }
                        }
                        if (!bl5) {
                            throw new BrokerException("Unexpected: shared database table " + this.getTableName() + " has no reset record", 412);
                        }
                        if (bl4) {
                            if (!bl) {
                                throw new BrokerException(this.br.getKString("B4321", "[" + string + ", " + string4 + "]"), 412);
                            }
                            this.logger.log(8, this.br.getKString("B1364", "[" + string + ", " + string4 + "]"));
                            list = this.getAllRecords(connection);
                        }
                    }
                    if (bl2) {
                        connection.commit();
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        this.getDBManager();
                        exception3 = CommDBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4330", exception3.getMessage()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4330", exception3.getMessage()), exception3);
                }
                Object var26_24 = null;
                if (!bl2) break block22;
            }
            catch (Throwable throwable) {
                Object var26_25 = null;
                if (bl2) {
                    this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
            return list;
        }
        this.closeSQLObjects(resultSet, preparedStatement, null, exception);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<ChangeRecordInfo> getAllRecords(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<ChangeRecordInfo> arrayList;
        block17: {
            arrayList = new ArrayList<ChangeRecordInfo>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    long l = -1L;
                    String string = null;
                    byte[] byArray = null;
                    int n = 0;
                    long l2 = -1L;
                    ChangeRecordInfo changeRecordInfo = null;
                    boolean bl2 = false;
                    while (resultSet.next()) {
                        try {
                            l = resultSet.getLong(1);
                            string = resultSet.getString(2);
                            byArray = Util.readBytes(resultSet, 3);
                            n = resultSet.getInt(4);
                            if (n == 31) {
                                bl2 = true;
                            }
                            l2 = resultSet.getLong(5);
                            changeRecordInfo = new ChangeRecordInfo(l, string, byArray, n, l2);
                            changeRecordInfo.setIsSelectAll(true);
                            arrayList.add(changeRecordInfo);
                        }
                        catch (IOException iOException) {
                            this.getDBManager();
                            IOException iOException2 = CommDBManager.wrapIOException("[" + this.selectAllSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", (Object)String.valueOf(l), (Throwable)iOException2);
                            throw new BrokerException(iOException2.getMessage(), 412);
                        }
                    }
                    if (!bl2) {
                        throw new BrokerException("Unexpected: shared database table " + this.getTableName() + " has no reset record", 412);
                    }
                    Object var19_17 = null;
                    if (!bl) break block17;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        this.getDBManager();
                        exception3 = CommDBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4331", exception3.getMessage()), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4331", exception3.getMessage()), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                if (bl) {
                    this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        this.closeSQLObjects(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long getSequenceByUUID(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Long l;
        block14: {
            l = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSeqByUUIDSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        long l2 = resultSet.getLong(1);
                        l = new Long(l2);
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        this.getDBManager();
                        exception3 = CommDBManager.wrapSQLException("[" + this.selectSeqByUUIDSQL + "]", (SQLException)exception2);
                    } else {
                        exception3 = exception2;
                    }
                    Object[] objectArray = new String[]{"SEQ", String.valueOf(l), exception3.getMessage()};
                    throw new BrokerException(this.br.getKString("B4332", objectArray), exception3);
                }
                Object var12_10 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (bl) {
                    this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                this.closeSQLObjects(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, preparedStatement, connection, exception);
            return l;
        }
        this.closeSQLObjects(resultSet, preparedStatement, null, exception);
        return l;
    }

    @Override
    public HashMap getDebugInfo(Connection connection) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        try {
            list = this.getAllRecords(connection);
            Iterator iterator = ((ArrayList)list).iterator();
            ChangeRecordInfo changeRecordInfo = null;
            while (iterator.hasNext()) {
                changeRecordInfo = (ChangeRecordInfo)iterator.next();
                stringBuffer.append(changeRecordInfo.toString()).append("\n");
            }
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        linkedHashMap.put("Cluster Config Change Records:\n", stringBuffer.toString());
        if (list != null) {
            linkedHashMap.put("Count", ((ArrayList)list).size());
        }
        return linkedHashMap;
    }
}

