/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.JMSBridge;
import java.util.Properties;

public class ConnectionFactoryElement {
    private Properties _attrs = null;
    private Properties _props = null;

    public void setAttributes(Properties properties) {
        String string = null;
        if (properties != null) {
            string = properties.getProperty("ref-name");
            if (string.equals("built-in-dmq") || string.equals("imq.bridge.jms.dmq")) {
                throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "ref-name", string));
            }
            String string2 = properties.getProperty("username");
            if (string2 != null) {
                if (string2.trim().equals("")) {
                    Object[] objectArray = new String[]{"username", string2, "connection-factory", string};
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4035", objectArray));
                }
                properties.setProperty("username", string2.trim());
                String string3 = properties.getProperty("password");
                if (string3 == null) {
                    Object[] objectArray = new String[]{"password", "connection-factory", string};
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4036", objectArray));
                }
            }
        }
        this._attrs = properties;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public Properties getAttributes() {
        return this._attrs;
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getLookupName() {
        return this._attrs.getProperty("lookup-name");
    }

    public String getRefName() {
        return this._attrs.getProperty("ref-name");
    }

    public String getUsername() {
        String string = this._attrs.getProperty("username");
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public String getPassword() {
        return this._attrs.getProperty("password");
    }

    public boolean isMultiRM() {
        return Boolean.valueOf(this._attrs.getProperty("multi-rm", "false"));
    }

    public String toString() {
        return "connection-factory[" + this.getRefName() + "]";
    }
}

