/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLinkWriter;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerListLock;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterInfoInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class BrokerLink
extends Thread {
    private static boolean DEBUG = false;
    private boolean connected = false;
    private boolean expectBrokerInfoPkt = true;
    private boolean expectBrokerInfoReplyPkt = false;
    private Object handshakeLock = new Object();
    private boolean handshakeSent = false;
    private Socket conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private BrokerLinkWriter writer = null;
    private BrokerAddressImpl self;
    private BrokerAddressImpl remote;
    private ClusterImpl parent = null;
    private boolean linkInitDone = false;
    private Object linkInitWaitObject = null;
    private boolean autoConnect = false;
    private BrokerListLock brokerListLock = new BrokerListLock();
    private static Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private long createLinkFailures = 0L;
    private static Hashtable waitingMasterLogs = new Hashtable();
    private boolean readActive = true;
    private long initWaitTimeSeconds = Globals.getConfig().getLongProperty("imq.cluster.waitConnectionInitTimeout", 180L);
    private long initWaitTime = this.initWaitTimeSeconds * 1000L;
    private long DEFAULT_INIT_WAIT_INTERVAL = 60000L;
    private boolean firstInfoSent = false;
    private boolean firstReceive = true;
    private SSLSocketFactory factory = null;

    public BrokerLink(BrokerAddressImpl brokerAddressImpl, BrokerAddressImpl brokerAddressImpl2, ClusterImpl clusterImpl) {
        this.self = brokerAddressImpl;
        this.remote = brokerAddressImpl2;
        this.setName("BrokerLink:" + this.getRemoteString());
        this.parent = clusterImpl;
        this.linkInitDone = false;
        this.linkInitWaitObject = new Object();
        this.setDaemon(true);
    }

    public void setAutoConnect(boolean bl) {
        this.autoConnect = bl;
    }

    public boolean getAutoConnect() {
        return this.autoConnect;
    }

    private void setRemote(BrokerAddressImpl brokerAddressImpl) {
        this.remote = brokerAddressImpl;
        this.setName("BrokerLink:" + this.getRemoteString());
    }

    protected BrokerAddressImpl getRemote() {
        return this.remote;
    }

    protected String getRemoteString() {
        String string = this.getRealRemoteString();
        if (string == null) {
            return this.remote.toString();
        }
        return this.remote.toString() + "[" + string + "]";
    }

    private String getRealRemoteString() {
        Socket socket = this.conn;
        if (socket == null || socket.isClosed()) {
            return null;
        }
        return socket.getRemoteSocketAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLinkInit() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.waitLinkInit : " + this);
        }
        long l = System.currentTimeMillis() + this.initWaitTime;
        long l2 = this.initWaitTime;
        if (l2 > this.DEFAULT_INIT_WAIT_INTERVAL) {
            l2 = this.DEFAULT_INIT_WAIT_INTERVAL;
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            while (!this.linkInitDone) {
                try {
                    logger.log(8, "B1150", (Object)this.getRemoteString());
                    this.linkInitWaitObject.wait(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.linkInitDone) break;
                long l3 = System.currentTimeMillis();
                if (l3 >= l) {
                    logger.log(16, br.getKString("B2191", String.valueOf(this.initWaitTimeSeconds), this.getRemoteString()));
                    break;
                }
                l2 = l - l3;
                if (l2 <= this.DEFAULT_INIT_WAIT_INTERVAL) continue;
                l2 = this.DEFAULT_INIT_WAIT_INTERVAL;
            }
        }
        if (DEBUG) {
            logger.log(4, "Returning from BrokerLink.waitLinkInit : " + this);
        }
    }

    public synchronized void setFlowControl(boolean bl) {
        if (this.writer == null) {
            return;
        }
        this.writer.setFlowControl(bl);
    }

    public synchronized void sendPacket(GPacket gPacket) throws IOException {
        this.sendPacket(gPacket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendPacket(GPacket gPacket, boolean bl) throws IOException {
        short s = gPacket.getType();
        if (DEBUG) {
            logger.log(8, "BrokerLink.sendPacket(" + ProtocolGlobals.getPacketTypeString(s) + ")");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.getRemoteString());
        }
        Object object = this.handshakeLock;
        synchronized (object) {
            if (!this.handshakeSent && s != 46) {
                throw new IOException("Handshake not complete in link " + this);
            }
        }
        if (s != 46) {
            if (!this.firstInfoSent) {
                if (s == 49 && ClusterInfoInfo.isFirstInfo(gPacket)) {
                    this.firstInfoSent = true;
                } else {
                    object = this.parent.getFirstInfoPacket();
                    this.firstInfoSent = true;
                    if (object != null) {
                        this.sendPacket((GPacket)object);
                    }
                }
            } else if (s == 49 && ClusterInfoInfo.isFirstInfo(gPacket)) {
                return;
            }
        }
        if (ClusterManagerImpl.DEBUG_CLUSTER_PACKET || ClusterManagerImpl.DEBUG_CLUSTER_PING && (s == 33 || s == 34) || ClusterManagerImpl.DEBUG_CLUSTER_ALL) {
            logger.log(8, "SENDING PACKET : " + this + "\n" + gPacket.toLongString());
            if (logger.getLevel() <= 4 && gPacket.getPayload() != null) {
                object = gPacket.getPayload().array();
                logger.log(4, "Payload : " + Packet.hexdump((byte[])object, Integer.MAX_VALUE));
            }
        }
        this.writer.sendPacket(gPacket, bl);
    }

    public synchronized void sendPacket(Packet packet) throws IOException {
        this.sendPacket(packet, false);
    }

    public synchronized void sendPacket(Packet packet, boolean bl) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.sendPacket(Packet)");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.getRemoteString());
        }
        if (ClusterManagerImpl.DEBUG_CLUSTER_PACKET || ClusterManagerImpl.DEBUG_CLUSTER_PING && packet.getPacketType() == 7 || ClusterManagerImpl.DEBUG_CLUSTER_ALL) {
            logger.log(8, "SENDING PACKET : " + this + "\nPacket = " + packet + "\n");
        }
        this.writer.sendPacket(packet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void linkDown() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.linkDown()");
        }
        if (ClusterManagerImpl.DEBUG_CLUSTER_ALL || ClusterManagerImpl.DEBUG_CLUSTER_CONN) {
            logger.log(8, "Link down\n\tRemote BrokerAddress = " + this.getRemoteString() + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        if (DEBUG) {
            logger.log(2, "Cluster connection closed.");
        }
        this.brokerListLock.lock();
        try {
            BrokerLink brokerLink = this;
            synchronized (brokerLink) {
                if (this.writer == null) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connected = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 14] lbl19 : MonitorExitStatement: MONITOREXIT : var1_1
                    Object var5_5 = null;
                    this.brokerListLock.unlock();
                    return;
                }
                this.writer.shutdown();
                this.writer = null;
                try {
                    this.is.close();
                    this.os.close();
                    this.conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connected = false;
                this.is = null;
                this.os = null;
            }
            this.parent.removeBroker(this.remote, this);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.brokerListLock.unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.brokerListLock.unlock();
        try {
            Thread.sleep(5000L);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized SSLSocketFactory getTrustSocketFactory() throws Exception {
        if (this.factory == null) {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
            sSLContext.init(null, trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
        }
        return this.factory;
    }

    private Socket makeSSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws Exception {
        if (Globals.getConfig().getBooleanProperty("imq.cluster.trust_all", true)) {
            SSLSocketFactory sSLSocketFactory = this.getTrustSocketFactory();
            if (inetAddress2 == null) {
                return sSLSocketFactory.createSocket(inetAddress, n);
            }
            return sSLSocketFactory.createSocket(inetAddress, n, inetAddress2, n2);
        }
        if (inetAddress2 == null) {
            return SSLSocketFactory.getDefault().createSocket(inetAddress, n);
        }
        return SSLSocketFactory.getDefault().createSocket(inetAddress, n, inetAddress2, n2);
    }

    private PortMapperEntry getRealRemotePort() throws Exception {
        String string = String.valueOf(101) + "\n";
        PortMapperTable portMapperTable = new PortMapperTable();
        Socket socket = new Socket(this.remote.getHost(), this.remote.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        portMapperTable.read(inputStream);
        inputStream.close();
        outputStream.close();
        socket.close();
        return portMapperTable.get("cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createLink() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.createLink()");
        }
        this.brokerListLock.lock();
        try {
            BrokerAddressImpl brokerAddressImpl = null;
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            if (!this.autoConnect) {
                // MONITOREXIT : brokerLink
                Object var13_3 = null;
                this.brokerListLock.unlock();
                return;
            }
            if (this.connected) {
                // MONITOREXIT : brokerLink
                Object var13_4 = null;
                this.brokerListLock.unlock();
                return;
            }
            try {
                PortMapperEntry portMapperEntry = this.getRealRemotePort();
                if (portMapperEntry == null) {
                    throw new BrokerException(br.getKString("B4256", this.getRemoteString()));
                }
                if (!portMapperEntry.getProtocol().equalsIgnoreCase(this.parent.getTransport())) {
                    throw new BrokerException(br.getKString("B4208", this.parent.getTransport(), portMapperEntry.getProtocol()));
                }
                int n = portMapperEntry.getPort();
                String string = portMapperEntry.getProperty("hostaddr");
                InetAddress inetAddress = this.parent.getListenHost();
                boolean bl = this.parent.getTCPNodelay();
                boolean bl2 = false;
                if (portMapperEntry.getProtocol().equalsIgnoreCase("ssl")) {
                    bl = this.parent.getSSLNodelay();
                    bl2 = true;
                }
                this.conn = inetAddress == null ? (bl2 ? this.makeSSLSocket(string == null ? this.remote.getHost() : InetAddress.getByName(string), n, null, 0) : new Socket(string == null ? this.remote.getHost() : InetAddress.getByName(string), n)) : (bl2 ? this.makeSSLSocket(string == null ? this.remote.getHost() : InetAddress.getByName(string), n, inetAddress, 0) : new Socket(string == null ? this.remote.getHost() : InetAddress.getByName(string), n, inetAddress, 0));
                try {
                    this.conn.setTcpNoDelay(bl);
                }
                catch (SocketException socketException) {
                    logger.log(16, this.getClass().getSimpleName() + ".createLink(): [" + this.conn.toString() + "]setTcpNoDelay(" + bl + "): " + socketException.toString(), (Throwable)socketException);
                }
                this.initNewConn(false, bl2);
                this.connected = true;
                brokerAddressImpl = BrokerLink.consumeLinkInit(this.conn, this, this.parent);
            }
            catch (Exception exception) {
                Object object;
                if (!this.connected) {
                    if (this.conn != null) {
                        try {
                            this.conn.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (this.writer != null) {
                        this.writer.shutdown();
                        this.writer = null;
                    }
                }
                if (this.createLinkFailures % 40L == 0L) {
                    object = exception.getMessage();
                    if (object == null) {
                        object = exception.getClass().getName();
                    }
                    logger.log(16, "B2105", (Object)this.getRemoteString(), object);
                    logger.logStack(4, "BrokerLink.createLink() failed", (Throwable)exception);
                }
                ++this.createLinkFailures;
                object = this.linkInitWaitObject;
                // MONITORENTER : object
                if (!this.linkInitDone) {
                    this.linkInitDone = true;
                    this.linkInitWaitObject.notifyAll();
                }
                // MONITOREXIT : object
            }
            if (brokerAddressImpl != null && !this.parent.addBroker(this.remote, this)) {
                this.closeConn();
            }
            Object var13_5 = null;
            this.brokerListLock.unlock();
        }
        catch (Throwable throwable) {
            Object var13_6 = null;
            this.brokerListLock.unlock();
            throw throwable;
        }
        if (!DEBUG) return;
        logger.log(4, "BrokerLink.createLink() finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BrokerAddressImpl consumeLinkInit(Socket socket, BrokerLink brokerLink, ClusterImpl clusterImpl) throws IOException {
        Cloneable cloneable;
        Cloneable cloneable2;
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeLinkInit()");
        }
        BrokerAddressImpl brokerAddressImpl = null;
        InputStream inputStream = socket.getInputStream();
        Packet packet = new Packet();
        packet.readPacket(inputStream);
        if (ClusterManagerImpl.DEBUG_CLUSTER_PACKET || ClusterManagerImpl.DEBUG_CLUSTER_PING && packet.getPacketType() == 7 || ClusterManagerImpl.DEBUG_CLUSTER_PACKET) {
            logger.log(8, "RECEIVING PACKET : " + (brokerLink == null ? "from " + socket.getInetAddress() : brokerLink) + "\nPacket = " + packet);
        }
        if (packet.getPacketType() != 4) {
            logger.log(4, (brokerLink == null ? "Socket=" + socket.getInetAddress() : "Link=" + brokerLink) + ", expect LINK_INIT but got:" + packet.getPacketType());
            socket.close();
            return null;
        }
        LinkInfo linkInfo = null;
        try {
            linkInfo = ClusterImpl.processLinkInit(packet);
            brokerAddressImpl = linkInfo.getAddress();
            if (brokerLink != null && brokerAddressImpl.getMQAddress().equals((Object)brokerLink.self.getMQAddress())) {
                Object[] objectArray = new String[]{brokerAddressImpl.getHost().toString(), socket.getInetAddress().toString(), brokerLink.self.toString() + " <---> " + brokerAddressImpl.toString()};
                throw new BrokerException(br.getString("B3099", objectArray));
            }
            if (brokerLink != null && brokerAddressImpl.equals(brokerLink.self)) {
                Object[] objectArray = new String[]{brokerAddressImpl.toShortString(), socket.getInetAddress().toString(), brokerLink.self.toString() + " <---> " + brokerAddressImpl.toString()};
                logger.log(32, br.getKString("B3241", objectArray));
                Broker.getBroker().exit(1, br.getString("B3241", objectArray), BrokerEvent.Type.FATAL_ERROR, null, false, true, false);
                throw new BrokerException(br.getString("B3241", objectArray));
            }
        }
        catch (BrokerException brokerException) {
            logger.log(32, br.getKString("B3195", socket.getInetAddress().toString()), (Throwable)brokerException);
            if (brokerLink == null) {
                socket.close();
            } else {
                brokerLink.shutdown();
            }
            return null;
        }
        catch (Exception exception) {
            socket.close();
            return null;
        }
        if (DEBUG) {
            logger.log(4, "processLinkInit returned!");
        }
        if (brokerLink != null) {
            brokerLink.setRemote(brokerAddressImpl);
        }
        if (!clusterImpl.checkConfigServer(brokerAddressImpl)) {
            BrokerAddressImpl brokerAddressImpl2 = (BrokerAddressImpl)clusterImpl.getConfiguredConfigServer();
            if (brokerAddressImpl2 != null) {
                Integer n = (Integer)waitingMasterLogs.get((Object)brokerAddressImpl.getMQAddress());
                if (n == null || n % 30 == 0) {
                    logger.log(8, "B1251", (Object)brokerAddressImpl, (Object)brokerAddressImpl2);
                } else {
                    logger.log(4, "B1251", (Object)brokerAddressImpl, (Object)brokerAddressImpl2);
                }
                Hashtable hashtable = waitingMasterLogs;
                synchronized (hashtable) {
                    Integer n2 = (Integer)waitingMasterLogs.get((Object)brokerAddressImpl.getMQAddress());
                    if (n2 == null) {
                        waitingMasterLogs.put(brokerAddressImpl.getMQAddress(), new Integer(1));
                    } else {
                        waitingMasterLogs.put(brokerAddressImpl.getMQAddress(), new Integer(n2 + 1));
                    }
                }
            } else {
                logger.log(32, "B3100", (Object)("No master broker. Closing cluster connection with " + brokerAddressImpl));
            }
            socket.close();
            return null;
        }
        try {
            cloneable2 = clusterImpl.getConfigServer();
            cloneable = linkInfo.getConfigServer();
            if ((cloneable2 == null || cloneable == null) && cloneable2 != cloneable || cloneable2 != null && cloneable != null && !((BrokerAddress)cloneable2).getMQAddress().equals((Object)((BrokerAddress)cloneable).getMQAddress())) {
                Object[] objectArray = new String[]{brokerAddressImpl.toString(), cloneable2 == null ? "null" : ((BrokerAddress)cloneable2).getMQAddress().toString(), cloneable == null ? "null" : ((BrokerAddress)cloneable).getMQAddress().toString()};
                logger.log(32, br.getKString("B3097", objectArray));
                if (brokerLink == null) {
                    socket.close();
                } else {
                    brokerLink.shutdown();
                }
                return null;
            }
        }
        catch (Exception exception) {
            logger.logStack(4, exception.getMessage() + (brokerLink == null ? "Socket " + socket.getInetAddress() : "Link " + brokerLink), (Throwable)exception);
            if (brokerLink == null) {
                socket.close();
            } else {
                brokerLink.linkDown();
            }
            return null;
        }
        if (DEBUG) {
            logger.log(2, "remote.matchProps = " + linkInfo.getMatchProps());
            logger.log(2, "local.matchProps = " + clusterImpl.getMatchProps());
        }
        cloneable2 = linkInfo.getMatchProps();
        cloneable = clusterImpl.getMatchProps();
        String string = BrokerLink.compareProps((Properties)cloneable, (Properties)cloneable2);
        if (string != null) {
            logger.log(32, "B3098", (Object)brokerAddressImpl, (Object)string);
            if (brokerLink == null) {
                socket.close();
            } else {
                brokerLink.shutdown();
            }
            return null;
        }
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeLinkInit() finished");
        }
        assert (brokerAddressImpl != null);
        return brokerAddressImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acceptConnection(BrokerAddressImpl brokerAddressImpl, Socket socket, boolean bl) {
        block18: {
            boolean bl2;
            block17: {
                if (DEBUG) {
                    logger.log(4, "BrokerLink.acceptConnection()");
                }
                this.brokerListLock.lock();
                try {
                    BrokerLink brokerLink = this;
                    synchronized (brokerLink) {
                        this.setRemote(brokerAddressImpl);
                        if (this.connected) {
                            if (DEBUG) {
                                logger.log(4, "Already connected!");
                            }
                            try {
                                socket.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 8] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
                            Object var9_10 = null;
                            this.brokerListLock.unlock();
                            return bl3;
                        }
                        if (!this.parent.addBroker(brokerAddressImpl, this)) {
                            try {
                                socket.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            bl2 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 8, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var4_4
                            break block17;
                        }
                        this.conn = socket;
                        try {
                            this.initNewConn(true, bl);
                        }
                        catch (Exception exception) {
                            boolean bl4 = true;
                            // MONITOREXIT @DISABLED, blocks:[0, 8, 11] lbl39 : MonitorExitStatement: MONITOREXIT : var4_4
                            Object var9_12 = null;
                            this.brokerListLock.unlock();
                            return bl4;
                        }
                        this.connected = true;
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    this.brokerListLock.unlock();
                    throw throwable;
                }
            }
            Object var9_11 = null;
            this.brokerListLock.unlock();
            return bl2;
        }
        Object var9_13 = null;
        this.brokerListLock.unlock();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNewConn(boolean bl, boolean bl2) throws IOException {
        Object object;
        if (DEBUG) {
            logger.log(4, "BrokerLink.initNewconn()");
        }
        if (ClusterManagerImpl.DEBUG_CLUSTER_ALL || ClusterManagerImpl.DEBUG_CLUSTER_CONN) {
            object = bl ? "Accepted" : "Established";
            logger.log(8, "Connection " + (String)object + "\n\tRemote BrokerAddress = " + this.getRemoteString() + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        this.expectBrokerInfoPkt = true;
        object = this.handshakeLock;
        synchronized (object) {
            this.handshakeSent = false;
        }
        this.firstInfoSent = false;
        this.firstReceive = true;
        int n = this.parent.getTCPInputBufferSize();
        int n2 = this.parent.getTCPOutputBufferSize();
        if (bl2) {
            n = this.parent.getSSLInputBufferSize();
            n2 = this.parent.getSSLOutputBufferSize();
        }
        this.is = this.conn.getInputStream();
        if (n > 0) {
            this.is = new BufferedInputStream(this.is, n);
        }
        this.os = this.conn.getOutputStream();
        if (n2 > 0) {
            this.os = new BufferedOutputStream(this.os, n2);
        }
        this.writer = new BrokerLinkWriter(this);
        this.writer.startWriterThread(this.os);
        Packet packet = this.parent.getLinkInitPkt();
        Packet packet2 = this.parent.getBrokerInfoPkt();
        if (DEBUG) {
            logger.log(2, "Cluster connection established: {0}", (Object)this);
        }
        this.sendPacket(packet);
        this.sendPacket(packet2);
        this.parent.sendFlowControlUpdate(this.remote);
    }

    public void closeConn() {
        this.closeConn(false);
    }

    public void closeConn(boolean bl) {
        this.closeConn(false, bl);
    }

    protected void closeConn(boolean bl, boolean bl2) {
        if (DEBUG) {
            logger.log(4, "BrokerLink.closeConn()");
        }
        if (!this.connected && !this.autoConnect) {
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                logger.log(4, "BrokerLink.closeConn(): interrupt thread failed: " + exception.getMessage());
            }
        }
        try {
            if (bl) {
                this.conn.shutdownOutput();
                return;
            }
            if (bl2) {
                this.conn.close();
                return;
            }
            if (!this.writer.isOutputShutdown()) {
                this.conn.close();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isOutputShutdown() {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isOutputShutdown();
    }

    public void shutdown() {
        if (DEBUG) {
            logger.log(4, "BrokerLink.shutdown()");
        }
        this.autoConnect = false;
        this.closeConn();
    }

    private static String compareProps(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            String string4 = properties2.getProperty(string2);
            if (string3 == null && string4 == null) continue;
            if (string3 == null && string4 != null || string4 == null && string3 != null) {
                string = string + "\t" + string2 + "=" + string3 + "," + string4 + "\n";
                continue;
            }
            if (string3.equals(string4)) continue;
            if (string == null) {
                string = "\t" + string2 + "=" + string3 + "," + string4 + "\n";
                continue;
            }
            string = string + "\t" + string2 + "=" + string3 + "," + string4 + "\n";
        }
        return string;
    }

    private Packet tryReadPacket(boolean bl) throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.tryReadPacket()");
        }
        Packet packet = null;
        try {
            packet = new Packet();
            packet.readPacket(this.is);
            this.readActive = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (!bl) {
                throw outOfMemoryError;
            }
            Globals.handleGlobalError(outOfMemoryError, br.getKString("B0019"));
            packet = this.tryReadPacket(false);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeBrokerInfoPkt() throws Exception {
        Object object;
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeBrokerInfoPkt()");
        }
        this.expectBrokerInfoReplyPkt = false;
        Packet packet = new Packet();
        packet.readPacket(this.is);
        if (ClusterManagerImpl.DEBUG_CLUSTER_PACKET || ClusterManagerImpl.DEBUG_CLUSTER_PING && packet.getPacketType() == 7 || ClusterManagerImpl.DEBUG_CLUSTER_PACKET) {
            logger.log(8, "RECEIVING PACKET : " + this + "\nPacket = " + packet);
        }
        if (packet.getPacketType() != 3) {
            logger.log(4, "Link = " + this + ", Missed BROKER_INFO : " + packet.getPacketType());
            this.conn.close();
            return;
        }
        BrokerInfo brokerInfo = (BrokerInfo)this.parent.receivePacket(this.remote, packet, this.getRealRemoteString(), this);
        if (brokerInfo == null) {
            logger.log(4, "Link = " + this + ", BROKER_INFO rejected");
            throw new IOException("BrokerInfo rejected");
        }
        this.expectBrokerInfoPkt = false;
        Integer n = brokerInfo.getClusterProtocolVersion();
        if (n != null && n >= 400) {
            object = null;
            try {
                object = this.parent.getConfigServer();
            }
            catch (Exception exception) {
                this.conn.close();
                logger.log(4, "Exception in getConfigServer: " + exception.getMessage() + ", link " + this);
                return;
            }
            if (this.parent.waitForConfigSync() && !((BrokerAddress)object).equals(brokerInfo.getBrokerAddr())) {
                if (ClusterManagerImpl.DEBUG_CLUSTER_CONN || ClusterManagerImpl.DEBUG_CLUSTER_PACKET || DEBUG) {
                    logger.log(8, "Waiting for sync with master broker " + object + ", Please retry  " + this);
                }
                this.conn.close();
                return;
            }
            ClusterBrokerInfoReply clusterBrokerInfoReply = this.parent.getBrokerInfoReply(brokerInfo);
            GPacket gPacket = clusterBrokerInfoReply.getGPacket();
            boolean bl = clusterBrokerInfoReply.sendAndClose();
            this.sendPacket(gPacket, bl);
            this.expectBrokerInfoReplyPkt = true;
            if (bl) {
                return;
            }
        }
        object = this.handshakeLock;
        synchronized (object) {
            this.handshakeSent = true;
        }
        object = this.linkInitWaitObject;
        synchronized (object) {
            if (this.parent.isConfigServerResolved()) {
                this.linkInitDone = true;
                this.linkInitWaitObject.notifyAll();
            }
        }
    }

    protected void handshakeSent() {
        this.handshakeSent = true;
    }

    private void consumeBrokerInfoReplyPkt() throws Exception {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeBrokerInfoReplyPkt()");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(this.is);
        if (gPacket.getType() != 46) {
            logger.log(4, "Link = " + this + ", Missed BROKER_INFO_REPLY : " + gPacket.getType());
            this.conn.close();
            return;
        }
        this.parent.receivePacket(this.remote, gPacket, this.getRealRemoteString());
        gPacket = this.parent.getFirstInfoPacket();
        if (gPacket != null) {
            this.sendPacket(gPacket);
        }
    }

    private void consumePacket() throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumePacket()");
        }
        Packet packet = new Packet();
        try {
            packet = this.tryReadPacket(true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.log(32, "B3108");
            Broker broker = Broker.getBroker();
            Globals.getBrokerStateHandler();
            broker.exit(BrokerStateHandler.getRestartCode(), br.getString("B3108"), BrokerEvent.Type.ERROR);
        }
        if (ClusterManagerImpl.DEBUG_CLUSTER_PACKET || ClusterManagerImpl.DEBUG_CLUSTER_PING && packet.getPacketType() == 7 || ClusterManagerImpl.DEBUG_CLUSTER_PACKET) {
            logger.log(8, "RECEIVING PACKET : " + this + "\nPacket = " + packet);
        }
        try {
            this.parent.receivePacket(this.remote, packet, this.getRealRemoteString(), this);
        }
        catch (Exception exception) {
            logger.logStack(32, "B2036", (Object)packet, (Throwable)exception);
        }
    }

    private void consumeGPacket() throws IOException {
        if (DEBUG) {
            logger.log(4, "BrokerLink.consumeGPacket()");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(this.is);
        this.readActive = true;
        if (ClusterManagerImpl.DEBUG_CLUSTER_PACKET || ClusterManagerImpl.DEBUG_CLUSTER_PING && (gPacket.getType() == 33 || gPacket.getType() == 34) || ClusterManagerImpl.DEBUG_CLUSTER_ALL) {
            logger.log(8, "RECEIVING PACKET : " + this + "\nPacket = " + gPacket.toLongString());
            if (logger.getLevel() <= 4 && gPacket.getPayload() != null) {
                byte[] byArray = gPacket.getPayload().array();
                logger.log(4, "Payload : " + Packet.hexdump(byArray, Integer.MAX_VALUE));
            }
        }
        if (this.firstReceive) {
            this.firstReceive = false;
            if (gPacket.getType() == 49) {
                this.parent.processFirstInfoPacket(gPacket, this);
                return;
            }
        }
        try {
            this.parent.receivePacket(this.remote, gPacket, null);
        }
        catch (Exception exception) {
            logger.logStack(32, "B2036", (Object)gPacket, (Throwable)exception);
        }
    }

    protected boolean isIOActive() {
        boolean bl = false;
        try {
            if (this.writer != null) {
                bl = this.writer.isWriteActive();
            }
        }
        catch (Exception exception) {
            logger.log(1, "Ignoring exception on isIOActive", (Throwable)exception);
        }
        return this.readActive || bl;
    }

    protected void clearIOActiveFlag() {
        this.readActive = false;
        try {
            if (this.writer != null) {
                this.writer.clearWriteActiveFlag();
            }
        }
        catch (Exception exception) {
            logger.log(1, "Ignoring exception on clearIOActiveFlag", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (!this.connected) {
                if (!this.autoConnect) break;
                this.createLink();
                if (this.connected) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                if (this.expectBrokerInfoPkt) {
                    if (DEBUG) {
                        logger.log(4, "Waiting for BROKER_INFO...");
                    }
                    this.consumeBrokerInfoPkt();
                    if (this.expectBrokerInfoReplyPkt) {
                        this.consumeBrokerInfoReplyPkt();
                    }
                    if (DEBUG) {
                        logger.log(4, "Received BROKER_INFO...");
                    }
                }
                if (this.parent.useGPackets) {
                    this.consumeGPacket();
                    continue;
                }
                this.consumePacket();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.log(32, "B3108");
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), br.getString("B3108"), BrokerEvent.Type.ERROR);
            }
            catch (Exception exception) {
                logger.logStack(4, "Link Down " + this, (Throwable)exception);
                this.linkDown();
            }
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            this.linkInitDone = true;
            this.linkInitWaitObject.notifyAll();
        }
        this.parent.handleBrokerLinkShutdown(this.remote);
    }

    public String toString() {
        String string = this.parent.getServerSocketString();
        if (string == null) {
            return this.self.toString() + " <---> " + this.getRemoteString();
        }
        return this.self.toString() + "[" + string + "]" + " <---> " + this.getRemoteString();
    }
}

