/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx;

import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerImpl;
import com.sun.messaging.bridge.service.jms.tx.XAParticipant;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionImpl
implements Transaction {
    private Logger _logger = null;
    private int _status = 6;
    private GlobalXid _gxid = null;
    private TransactionManagerImpl _tm = null;
    private ArrayList<BranchXid> _seenBranchXids = new ArrayList();
    private ArrayList<XAResource> _associatedXAResources = new ArrayList();
    private Map<XAResource, XAParticipant> _participants = new LinkedHashMap<XAResource, XAParticipant>();
    private byte _branchCount = 0;
    private int _maxBranches;
    private TxLog _txlog = null;

    public TransactionImpl(GlobalXid globalXid, TransactionManagerImpl transactionManagerImpl) throws SystemException {
        if (globalXid == null) {
            throw new SystemException("null xid");
        }
        this._tm = transactionManagerImpl;
        this._logger = transactionManagerImpl.getLogger();
        this._txlog = transactionManagerImpl.getTxLog();
        this._gxid = globalXid;
        this._maxBranches = transactionManagerImpl.getMaxBranches();
        this._branchCount = 0;
        this._status = 0;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Object object;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " commit " + this);
        }
        if (this._status == 1) {
            this.rollback();
            throw new RollbackException(this.toString());
        }
        if (this._status != 0) {
            throw new IllegalStateException(this.toString());
        }
        if (this._associatedXAResources.size() != 0) {
            throw new IllegalStateException("There are undelisted XAResources " + this._associatedXAResources + " in " + this);
        }
        boolean bl = false;
        if (this._participants.size() == 1) {
            bl = true;
        }
        if (!bl) {
            this._status = 7;
            object = null;
            boolean bl2 = false;
            for (Map.Entry<XAResource, XAParticipant> object2 : this._participants.entrySet()) {
                object = object2.getValue();
                try {
                    ((XAParticipant)object).prepare();
                    bl2 = true;
                }
                catch (IllegalStateException illegalStateException) {
                    if (!bl2) {
                        throw illegalStateException;
                    }
                    this.setRollbackOnly();
                    this.rollback();
                    RollbackException illegalStateException2 = new RollbackException(this.toString() + ": " + illegalStateException.getMessage());
                    illegalStateException2.initCause((Throwable)illegalStateException);
                    throw illegalStateException2;
                }
                catch (Throwable throwable) {
                    this.setRollbackOnly();
                    if (!(throwable instanceof RollbackException) && !(throwable instanceof SystemException)) {
                        this._logger.log(Level.SEVERE, "Unexpected exception on prepare from " + object, throwable);
                    }
                    this.rollback();
                    RollbackException rollbackException = new RollbackException(throwable.getMessage());
                    rollbackException.initCause(throwable);
                    throw rollbackException;
                }
            }
            this._status = 2;
        }
        if (this._status == 1) {
            this.rollback();
            throw new RollbackException(this.toString());
        }
        if (!bl) {
            try {
                object = new LogRecord(this._gxid, this._participants.values(), 0);
                this._txlog.logGlobalDecision((LogRecord)object);
            }
            catch (Throwable throwable) {
                this.setRollbackOnly();
                this._logger.log(Level.SEVERE, "Unable to log commit decision " + this, throwable);
                this.rollback();
                RollbackException rollbackException = new RollbackException(this.toString() + ": " + throwable.getMessage());
                rollbackException.initCause(throwable);
                throw rollbackException;
            }
            this._status = 2;
        }
        this._status = 8;
        object = null;
        XAParticipant xAParticipant = null;
        boolean bl3 = false;
        for (Map.Entry<XAResource, XAParticipant> entry : this._participants.entrySet()) {
            BranchXid branchXid;
            LogRecord throwable;
            xAParticipant = entry.getValue();
            try {
                xAParticipant.commit(bl);
                bl3 = true;
            }
            catch (IllegalStateException heuristicMixedException) {
                if (!bl3) {
                    throw heuristicMixedException;
                }
                object = heuristicMixedException;
            }
            catch (RollbackException heuristicRollbackException) {
                if (!bl) {
                    this._logger.log(Level.SEVERE, "Unexpected RollbackException on 2-phase commit from " + xAParticipant, heuristicRollbackException);
                    object = new HeuristicMixedException(heuristicRollbackException.getMessage());
                    ((Throwable)object).initCause(heuristicRollbackException);
                    continue;
                }
                throw heuristicRollbackException;
            }
            catch (HeuristicCommitException throwable2) {
                try {
                    throwable = new LogRecord(this._gxid, this._participants.values(), 0);
                    branchXid = xAParticipant.getBranchXid();
                    throwable.setBranchHeurCommit(branchXid);
                    this._txlog.logHeuristicBranch(branchXid, throwable);
                }
                catch (Throwable throwable3) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic commit from " + xAParticipant, throwable3);
                }
            }
            catch (HeuristicMixedException heuristicMixedException) {
                object = heuristicMixedException;
                try {
                    throwable = new LogRecord(this._gxid, this._participants.values(), 0);
                    branchXid = xAParticipant.getBranchXid();
                    throwable.setBranchHeurMixed(branchXid);
                    this._txlog.logHeuristicBranch(branchXid, throwable);
                }
                catch (Throwable throwable4) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic mixed from " + xAParticipant, throwable4);
                }
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                object = heuristicRollbackException;
                try {
                    throwable = new LogRecord(this._gxid, this._participants.values(), 0);
                    branchXid = xAParticipant.getBranchXid();
                    throwable.setBranchHeurRollback(branchXid);
                    this._txlog.logHeuristicBranch(branchXid, throwable);
                }
                catch (Throwable throwable5) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic rollback from " + xAParticipant, throwable5);
                }
            }
            catch (Throwable throwable6) {
                if (!(throwable6 instanceof SystemException)) {
                    this._logger.log(Level.SEVERE, "Unexpected exception on commit from " + xAParticipant, throwable6);
                    object = new SystemException(throwable6.getMessage());
                    ((Throwable)object).initCause(throwable6);
                    continue;
                }
                object = (SystemException)throwable6;
            }
        }
        this._status = 3;
        if (object == null) {
            this._status = 6;
            if (!bl) {
                try {
                    this._txlog.remove(this._gxid);
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Exception in removing comitted TM log record " + (Object)((Object)this._gxid), throwable);
                }
            }
        }
        if (object != null) {
            if (object instanceof SystemException) {
                throw (SystemException)object;
            }
            if (object instanceof HeuristicMixedException) {
                throw (HeuristicMixedException)((Object)object);
            }
            if (object instanceof IllegalStateException) {
                throw (IllegalStateException)object;
            }
            if (object instanceof HeuristicRollbackException) {
                throw (HeuristicRollbackException)((Object)object);
            }
            SystemException systemException = new SystemException(((Throwable)object).getMessage());
            systemException.initCause((Throwable)object);
            throw systemException;
        }
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " dellistResource " + xAResource + " from " + this);
        }
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(this.toString());
        }
        XAParticipant xAParticipant = this._participants.get(xAResource);
        if (xAParticipant == null) {
            throw new IllegalStateException("XAResource " + xAResource + " had not associated to " + this);
        }
        int n2 = n;
        if (this._status == 1) {
            n2 = 0x20000000;
        }
        try {
            xAParticipant.end(n2);
            this._associatedXAResources.remove(xAResource);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (RollbackException rollbackException) {
            this.setRollbackOnly();
            return true;
        }
        catch (Throwable throwable) {
            this.setRollbackOnly();
            if (throwable instanceof SystemException) {
                throw (SystemException)throwable;
            }
            this._logger.log(Level.SEVERE, "Unexpected exception occurred on end from " + xAParticipant, throwable);
            SystemException systemException = new SystemException(throwable.getMessage());
            systemException.initCause(throwable);
            throw systemException;
        }
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " enlistResource " + xAResource + " to " + this);
        }
        if (this._status == 1) {
            throw new RollbackException(this.toString());
        }
        if (this._status != 0) {
            throw new IllegalStateException(this.toString());
        }
        if (this._participants.get(xAResource) != null) {
            throw new IllegalStateException("XAResource " + xAResource + " already enlisted in " + this);
        }
        String string = null;
        try {
            string = this._tm.getRM(xAResource);
        }
        catch (Exception exception) {
            String string2 = "Enlist XAResource " + xAResource + " failed";
            this._logger.log(Level.SEVERE, string2, exception);
            SystemException systemException = new SystemException(string2);
            systemException.initCause((Throwable)exception);
            throw systemException;
        }
        if (string == null) {
            this.setRollbackOnly();
            throw new SystemException("No RM is registered for XAResource " + xAResource);
        }
        BranchXid branchXid = this._tm.genBranchXid(this._gxid, string, xAResource.getClass().getName(), this.getBranchCount());
        if (this._seenBranchXids.contains((Object)branchXid)) {
            throw new SystemException("Unexpected duplicated branch " + (Object)((Object)branchXid) + " for RM " + string + " in " + (Object)((Object)this._gxid));
        }
        this._seenBranchXids.add(branchXid);
        XAParticipant xAParticipant = new XAParticipant(string, xAResource, branchXid);
        xAParticipant.setLogger(this._logger);
        this._participants.put(xAResource, xAParticipant);
        this._associatedXAResources.add(xAResource);
        try {
            xAParticipant.start(0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Throwable throwable) {
            this.setRollbackOnly();
            if (throwable instanceof RollbackException) {
                throw (RollbackException)throwable;
            }
            if (throwable instanceof SystemException) {
                throw (SystemException)throwable;
            }
            this._logger.log(Level.SEVERE, "Unexpected exception occurred on start from " + xAParticipant, throwable);
            SystemException systemException = new SystemException(throwable.getMessage());
            systemException.initCause(throwable);
            throw systemException;
        }
    }

    private synchronized byte getBranchCount() throws SystemException {
        this._branchCount = (byte)(this._branchCount + 1);
        if (this._branchCount > this._maxBranches) {
            throw new SystemException("Number of branches " + this._branchCount + " exceeded max " + this._maxBranches);
        }
        return this._branchCount;
    }

    public int getStatus() throws SystemException {
        return this._status;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("operation not supported");
    }

    public void rollback() throws IllegalStateException, SystemException {
        SystemException systemException;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " rollback " + this);
        }
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(this.toString());
        }
        if (this._associatedXAResources.size() > 0) {
            systemException = this._associatedXAResources.toArray(new XAResource[0]);
            for (int i = 0; i < ((XAResource[])systemException).length; ++i) {
                try {
                    this.delistResource(systemException[i], 0x20000000);
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to delist resource " + systemException[i] + " for rollback", throwable);
                }
            }
        }
        this._status = 9;
        systemException = null;
        XAParticipant xAParticipant = null;
        boolean bl = false;
        for (Map.Entry<XAResource, XAParticipant> entry : this._participants.entrySet()) {
            BranchXid branchXid;
            LogRecord logRecord;
            xAParticipant = entry.getValue();
            try {
                xAParticipant.rollback();
                bl = true;
            }
            catch (IllegalStateException illegalStateException) {
                if (!bl) {
                    throw illegalStateException;
                }
                systemException = new SystemException(illegalStateException.getMessage());
                systemException.initCause(illegalStateException);
            }
            catch (HeuristicCommitException heuristicCommitException) {
                systemException = heuristicCommitException;
                try {
                    logRecord = new LogRecord(this._gxid, this._participants.values(), 1);
                    branchXid = xAParticipant.getBranchXid();
                    logRecord.setBranchHeurCommit(branchXid);
                    this._txlog.logHeuristicBranch(branchXid, logRecord);
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic commit from " + xAParticipant, throwable);
                }
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                try {
                    logRecord = new LogRecord(this._gxid, this._participants.values(), 1);
                    branchXid = xAParticipant.getBranchXid();
                    logRecord.setBranchHeurRollback(branchXid);
                    this._txlog.logHeuristicBranch(branchXid, logRecord);
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic rollback from " + xAParticipant, throwable);
                }
            }
            catch (HeuristicMixedException heuristicMixedException) {
                systemException = heuristicMixedException;
                try {
                    logRecord = new LogRecord(this._gxid, this._participants.values(), 1);
                    branchXid = xAParticipant.getBranchXid();
                    logRecord.setBranchHeurMixed(branchXid);
                    this._txlog.logHeuristicBranch(branchXid, logRecord);
                }
                catch (Throwable throwable) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic mixed from " + xAParticipant, throwable);
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof SystemException)) {
                    systemException = new SystemException(throwable.getMessage());
                    systemException.initCause(throwable);
                    continue;
                }
                systemException = (SystemException)throwable;
            }
        }
        this._status = 4;
        if (systemException == null) {
            this._status = 6;
        }
        if (systemException != null) {
            if (systemException instanceof SystemException) {
                throw (SystemException)systemException;
            }
            if (systemException instanceof IllegalStateException) {
                throw (IllegalStateException)systemException;
            }
            SystemException systemException2 = new SystemException(systemException.getMessage());
            systemException2.initCause((Throwable)systemException);
            throw systemException2;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this._status = 1;
    }

    private String statusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "STATUS_UNKNOWN";
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionImpl)) {
            return false;
        }
        TransactionImpl transactionImpl = (TransactionImpl)object;
        if (this == transactionImpl) {
            return true;
        }
        return this._gxid.equals((Xid)((Object)transactionImpl._gxid));
    }

    public int hashCode() {
        return this._gxid.hashCode();
    }

    public String toString() {
        return (Object)((Object)this._gxid) + "[" + this.statusString(this._status) + "]";
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public String getGXidString() {
        return this._gxid.toString();
    }
}

