/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.ResourceAdapter;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.transaction.xa.XAResource;

public class DirectConnectionFactory
extends ConnectionCreator
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable,
Serializable {
    private Properties configuration = null;
    private ResourceAdapter ra = null;
    private ManagedConnectionFactory mcf = null;
    private boolean inACC = false;
    private boolean inClusteredContainer = false;
    private String raNameSpace = null;
    private transient JMSService jmsservice = null;
    private Reference reference = null;
    private ConnectionManager cm = null;
    private transient Vector<DirectConnection> connections = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectConnectionFactory";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSConnectionFactory = "javax.jms.ConnectionFactory.mqjmsra";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJF = Logger.getLogger("javax.jms.ConnectionFactory.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DCF";
    private static final transient String _lgrMID_EET = "MQJMSRA_DCF1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DCF1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DCF2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DCF3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DCF4001: ";
    private static boolean _disableConnectionManagement = Boolean.getBoolean("imq.jmsra.direct.disableCM");

    public DirectConnectionFactory(JMSService jMSService, Properties properties) {
        Object[] objectArray = new Object[]{jMSService, properties};
        _loggerOC.entering(_className, "constructor(jmsservice, props)", objectArray);
        this.jmsservice = jMSService;
        this.configuration = properties;
        this.connections = new Vector();
        _loggerOC.exiting(_className, "constructor(jmsservice, props):config=" + this.toString());
    }

    public DirectConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        Object[] objectArray = new Object[]{managedConnectionFactory, connectionManager};
        _loggerOC.entering(_className, "constructor(mcf, cm)", objectArray);
        this.mcf = managedConnectionFactory;
        this.cm = connectionManager;
        this.ra = (ResourceAdapter)managedConnectionFactory.getResourceAdapter();
        this.jmsservice = this.ra._getJMSService();
        this.inACC = this.ra.getInAppClientContainer();
        this.inClusteredContainer = this.ra.getInClusteredContainer();
        this.raNameSpace = this.ra._getRAUID();
        this.connections = new Vector();
        _loggerOC.exiting(_className, "constructor(mcf, cm):config=" + this.toString());
    }

    public void setReference(Reference reference) {
        _loggerJF.fine("MQJMSRA_DCF1101: setReference():Reference=" + reference);
        this.reference = reference;
    }

    public Reference getReference() throws NamingException {
        _loggerJF.fine("MQJMSRA_DCF1101: getReference():");
        throw new NamingException("MQRA:DCF:getReference:NOT Supported");
    }

    public Connection createConnection() throws javax.jms.JMSException {
        String string;
        String string2;
        _loggerJF.fine("MQJMSRA_DCF1101: createConnection():");
        if (this.mcf == null) {
            string2 = "guest";
            string = "guest";
        } else {
            string2 = this.mcf.getUserName();
            string = this.mcf.getPassword();
        }
        return this.createConnection(string2, string);
    }

    public Connection createConnection(String string, String string2) throws javax.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createConnection(u,p):username=" + string);
        if (!_disableConnectionManagement) {
            return this._allocateConnection(string, string2);
        }
        long l = this._createConnectionId(string, string2);
        DirectConnection directConnection = new DirectConnection(this, this.jmsservice, l, this.inACC);
        return directConnection;
    }

    public QueueConnection createQueueConnection() throws javax.jms.JMSException {
        String string;
        String string2;
        _loggerJF.fine("MQJMSRA_DCF1101: createQueueConnection():");
        if (this.mcf == null) {
            string2 = "guest";
            string = "guest";
        } else {
            string2 = this.mcf.getUserName();
            string = this.mcf.getPassword();
        }
        return this.createQueueConnection(string2, string);
    }

    public QueueConnection createQueueConnection(String string, String string2) throws javax.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createQueueConnection(u,p):username=" + string);
        if (!_disableConnectionManagement) {
            return (QueueConnection)this._allocateConnection(string, string2);
        }
        long l = this._createConnectionId(string, string2);
        DirectConnection directConnection = new DirectConnection(this, this.jmsservice, l, this.inACC);
        return directConnection;
    }

    public TopicConnection createTopicConnection() throws javax.jms.JMSException {
        String string;
        String string2;
        _loggerJF.fine("MQJMSRA_DCF1101: createTopicConnection():");
        if (this.mcf == null) {
            string2 = "guest";
            string = "guest";
        } else {
            string2 = this.mcf.getUserName();
            string = this.mcf.getPassword();
        }
        return this.createTopicConnection(string2, string);
    }

    public TopicConnection createTopicConnection(String string, String string2) throws javax.jms.JMSException {
        _loggerJF.fine("MQJMSRA_DCF1101: createTopicConnection(u,p):username=" + string);
        if (!_disableConnectionManagement) {
            return (TopicConnection)this._allocateConnection(string, string2);
        }
        long l = this._createConnectionId(string, string2);
        DirectConnection directConnection = new DirectConnection(this, this.jmsservice, l, this.inACC);
        return directConnection;
    }

    private long _createConnectionId(String string, String string2) throws javax.jms.JMSException {
        long l = 0L;
        if (this.jmsservice == null) {
            if (this.ra != null) {
                this.jmsservice = this.ra._getJMSService();
            }
            if (this.jmsservice == null) {
                this.jmsservice = ResourceAdapter._getRAJMSService();
            }
        }
        assert (this.jmsservice != null);
        try {
            JMSServiceReply jMSServiceReply = this.jmsservice.createConnection(string, string2, null);
            try {
                l = jMSServiceReply.getJMQConnectionID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string3 = "MQJMSRA_DCF4001: JMSServiceException:Missing JMQConnectionID";
                javax.jms.JMSException jMSException = new javax.jms.JMSException(string3);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJF.severe(string3);
                throw jMSException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string4;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            boolean bl = true;
            switch (status) {
                case INVALID_LOGIN: {
                    string4 = "authentication failure.";
                    break;
                }
                case FORBIDDEN: {
                    string4 = "authorization failure.";
                    break;
                }
                default: {
                    string4 = "unkown JMSService server error.";
                    bl = false;
                }
            }
            String string5 = "createConnection on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for username:" + string + " due to " + string4;
            _loggerJF.severe(string5);
            Object object = bl ? new JMSSecurityException(string5) : new javax.jms.JMSException(string5);
            object.initCause((Throwable)jMSServiceException);
            throw object;
        }
        return l;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.ra = resourceAdapter;
    }

    public Properties _getConfiguration() {
        return this.configuration;
    }

    public void setConfigurationProperty(String string, String string2) throws IllegalArgumentException {
    }

    protected boolean isRAClustered() {
        return this.inClusteredContainer;
    }

    protected String getRANamespace() {
        return this.raNameSpace;
    }

    protected Connection _createConnection(String string, String string2) throws javax.jms.JMSException {
        long l = this._createConnectionId(string, string2);
        DirectConnection directConnection = new DirectConnection(this, this.jmsservice, l, this.inACC);
        return directConnection;
    }

    protected XAResource _createXAResource(ManagedConnection managedConnection, Object object) throws javax.jms.JMSException {
        return null;
    }

    private Connection _allocateConnection(String string, String string2) throws javax.jms.JMSException {
        ConnectionRequestInfo connectionRequestInfo = new ConnectionRequestInfo(this.mcf, string, string2);
        try {
            DirectConnection directConnection = (DirectConnection)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)connectionRequestInfo);
            return directConnection;
        }
        catch (ResourceException resourceException) {
            String string3 = "1";
            throw new JMSException("MQRA:DCF:allocation failure:createConnection:" + resourceException.getMessage(), string3, resourceException);
        }
    }
}

