/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HAClusterManagerImpl
extends ClusterManagerImpl
implements ClusterManager {
    private static boolean IGNORE_HADB_ERRORS = true;
    private String localBrokerId = null;
    private int VERSION = 40;
    UID localSessionUID = null;

    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return true;
    }

    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] stringArray = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), stringArray, false);
    }

    protected Map getAllBrokers() throws BrokerException {
        return new HAMap();
    }

    public String initialize(MQAddress mQAddress) throws BrokerException {
        Store store;
        this.logger.log(4, "initializingCluster at " + mQAddress);
        this.localBrokerId = Globals.getBrokerID();
        if (this.localBrokerId == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3093", "null"));
        }
        String string = this.config.getProperty("imq.cluster.masterbroker");
        if (string != null) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B2194", "imq.cluster.masterbroker=" + string));
        }
        if (!(store = Globals.getStore()).isJDBCStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3221"));
        }
        super.initialize(mQAddress);
        return this.localBrokerId;
    }

    protected boolean allowMasterBroker() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set parseBrokerList() throws MalformedURLException {
        String string = this.config.getProperty("imq.cluster.brokerlist");
        String string2 = this.config.getProperty("imq.cluster.brokerlist.manual");
        if (string != null) {
            this.logger.log(8, "B1192", (Object)"imq.cluster.brokerlist");
        }
        if (string2 != null) {
            this.logger.log(8, "B1192", (Object)"imq.cluster.brokerlist.manual");
        }
        HashSet<MQAddress> hashSet = new HashSet<MQAddress>();
        Map map = this.allBrokers;
        synchronized (map) {
            for (Object v : this.allBrokers.values()) {
                HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)v;
                if (hAClusteredBroker.isLocalBroker()) continue;
                hashSet.add(hAClusteredBroker.getBrokerURL());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addBroker(MQAddress mQAddress, boolean bl, boolean bl2, UID uID) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String string = null;
        ClusteredBroker clusteredBroker = null;
        if (bl) {
            string = this.localBrokerId;
            clusteredBroker = this.getBroker(string);
            if (clusteredBroker == null) {
                clusteredBroker = new HAClusteredBrokerImpl(string, mQAddress, this.VERSION, BrokerState.INITIALIZING, uID);
                ((HAClusteredBrokerImpl)clusteredBroker).setIsLocal(true);
                clusteredBroker.setInstanceName(Globals.getConfigName());
            } else {
                ((HAClusteredBrokerImpl)clusteredBroker).setIsLocal(true);
                clusteredBroker.setInstanceName(Globals.getConfigName());
            }
            Map map = this.allBrokers;
            synchronized (map) {
                this.allBrokers.put(string, clusteredBroker);
            }
        } else {
            string = this.lookupBrokerID(mQAddress);
            if (string != null) {
                clusteredBroker = this.getBroker(string);
            }
        }
        if (uID != null) {
            ((HAClusteredBrokerImpl)clusteredBroker).setBrokerSessionUID(uID);
        }
        if (string == null) {
            throw new NoSuchElementException(Globals.getBrokerResources().getKString("B3169", string));
        }
        if (bl) {
            clusteredBroker.setStatus(257, null);
        } else {
            this.updateBroker(clusteredBroker);
        }
        this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, clusteredBroker.getBrokerName(), null, clusteredBroker, clusteredBroker.getBrokerSessionUID(), null);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBroker updateBroker(ClusteredBroker clusteredBroker) {
        Map map = this.allBrokers;
        synchronized (map) {
            return (HAClusteredBroker)((HAMap)this.allBrokers).get(clusteredBroker.getBrokerName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateBroker(String string, Object object) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ClusteredBroker clusteredBroker = this.getBroker(string);
        if (clusteredBroker == null) {
            throw new NoSuchElementException("Unknown brokerid " + string);
        }
        clusteredBroker.setInstanceName(null);
        HAClusterManagerImpl hAClusterManagerImpl = this;
        synchronized (hAClusterManagerImpl) {
            clusteredBroker.setStatus(BrokerStatus.setBrokerLinkIsDown(clusteredBroker.getStatus()), object);
        }
    }

    public String lookupStoreSessionOwner(UID uID) {
        try {
            return Globals.getStore().getStoreSessionOwner(uID.longValue());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B3044", (Throwable)exception);
            return null;
        }
    }

    public String getStoreSessionCreator(UID uID) {
        try {
            return Globals.getStore().getStoreSessionCreator(uID.longValue());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B3044", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupBrokerID(MQAddress mQAddress) {
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((HAMap)this.allBrokers).updateHAMap();
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(8, "B3044", (Throwable)brokerException);
        }
        return super.lookupBrokerID(mQAddress);
    }

    public int getConfigBrokerCount() {
        return super.getKnownBrokerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKnownBrokers(boolean bl) {
        Map map;
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet hashSet = null;
        if (bl) {
            try {
                map = this.allBrokers;
                synchronized (map) {
                    ((HAMap)this.allBrokers).updateHAMap(true);
                }
            }
            catch (BrokerException brokerException) {
                this.logger.logStack(16, "B3044", (Throwable)brokerException);
            }
        }
        map = this.allBrokers;
        synchronized (map) {
            hashSet = new HashSet(this.allBrokers.values());
        }
        return hashSet.iterator();
    }

    public Iterator getConfigBrokers() {
        return this.getKnownBrokers(true);
    }

    protected void masterBrokerChanged(String string) {
        throw new UnsupportedOperationException("Can not use/set/ change masterbroker");
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (string.equals("imq.cluster.masterbroker")) {
            throw new PropertyUpdateException(Globals.getBrokerResources().getKString("B4250"));
        }
        super.validate(string, string2);
    }

    public ClusteredBroker getLocalBroker() {
        return super.getLocalBroker();
    }

    public UID getStoreSessionUID() {
        if (this.localSessionUID == null) {
            this.localSessionUID = ((HAClusteredBroker)this.getLocalBroker()).getStoreSessionUID();
        }
        return this.localSessionUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBroker getBroker(String string) {
        ClusteredBroker clusteredBroker = super.getBroker(string);
        if (clusteredBroker != null) {
            return clusteredBroker;
        }
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((HAMap)this.allBrokers).updateHAMap(true);
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "B3044", (Throwable)brokerException);
        }
        return super.getBroker(string);
    }

    public class HAMap
    extends HashMap
    implements Map {
        public HAMap() throws BrokerException {
            HashMap hashMap = Globals.getStore().getAllBrokerInfos();
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                HABrokerInfo hABrokerInfo = (HABrokerInfo)entry.getValue();
                HAClusteredBrokerImpl hAClusteredBrokerImpl = new HAClusteredBrokerImpl(hABrokerInfo.getId(), hABrokerInfo);
                this.put(string, hAClusteredBrokerImpl);
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
            }
        }

        public void updateHAMap() throws BrokerException {
            this.updateHAMap(false);
        }

        public void updateHAMap(boolean bl) throws BrokerException {
            if (bl) {
                this.updateHAMapForState(null);
            } else {
                this.updateHAMapForState(BrokerState.OPERATING);
            }
        }

        private void updateHAMapForState(BrokerState brokerState) throws BrokerException {
            Object object;
            String string;
            HashMap hashMap = brokerState == null ? Globals.getStore().getAllBrokerInfos() : Globals.getStore().getAllBrokerInfoByState(brokerState);
            for (Map.Entry entry : hashMap.entrySet()) {
                string = (String)entry.getKey();
                object = (HABrokerInfo)entry.getValue();
                HAClusteredBrokerImpl hAClusteredBrokerImpl = (HAClusteredBrokerImpl)this.get(string);
                if (hAClusteredBrokerImpl == null) {
                    HAClusteredBrokerImpl hAClusteredBrokerImpl2 = new HAClusteredBrokerImpl(((HABrokerInfo)object).getId(), (HABrokerInfo)object);
                    this.put(string, hAClusteredBrokerImpl2);
                    HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, hAClusteredBrokerImpl2.getBrokerName(), null, hAClusteredBrokerImpl2, hAClusteredBrokerImpl2.getBrokerSessionUID(), null);
                    continue;
                }
                hAClusteredBrokerImpl.update((HABrokerInfo)object);
            }
            if (brokerState == null) {
                Iterator iterator = this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    entry = iterator.next();
                    string = (String)entry.getKey();
                    if (hashMap.containsKey(string)) continue;
                    iterator.remove();
                    object = (HAClusteredBrokerImpl)entry.getValue();
                    HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.REMOVED, ((HAClusteredBrokerImpl)object).getBrokerName(), object, null, ((HAClusteredBrokerImpl)object).getBrokerSessionUID(), null);
                }
            }
        }

        public Object get(Object object) {
            return this.get(object, false);
        }

        public Object get(Object object, boolean bl) {
            Object object2 = super.get(object);
            if (object2 == null || bl) {
                try {
                    HABrokerInfo hABrokerInfo = Globals.getStore().getBrokerInfo((String)object);
                    if (hABrokerInfo != null && object2 == null) {
                        HAClusteredBrokerImpl hAClusteredBrokerImpl = new HAClusteredBrokerImpl((String)object, hABrokerInfo);
                        this.put(object, hAClusteredBrokerImpl);
                        HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
                        object2 = hAClusteredBrokerImpl;
                    }
                    if (hABrokerInfo != null && bl) {
                        ((HAClusteredBrokerImpl)object2).update(hABrokerInfo);
                    }
                }
                catch (BrokerException brokerException) {
                    HAClusterManagerImpl.this.logger.log(8, "B3100", (Object)(" exception while creating broker entry " + object), (Throwable)brokerException);
                }
            }
            return object2;
        }
    }

    public class HAClusteredBrokerImpl
    implements HAClusteredBroker {
        boolean local = false;
        Integer status = new Integer(0);
        BrokerState state = BrokerState.INITIALIZING;
        String brokerid = null;
        MQAddress address = null;
        transient String instanceName = null;
        Integer version = new Integer(0);
        UID session = null;
        long heartbeat = 0L;
        String takeoverBroker = null;
        UID brokerSessionUID;

        public HAClusteredBrokerImpl(String string) throws BrokerException {
            this(string, Globals.getStore().getBrokerInfo(string));
        }

        public HAClusteredBrokerImpl(String string, HABrokerInfo hABrokerInfo) throws BrokerException {
            this.brokerid = string;
            this.status = new Integer(0);
            String string2 = hABrokerInfo.getUrl();
            try {
                this.address = BrokerMQAddress.createAddress(string2);
            }
            catch (Exception exception) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "invalid URL stored on disk " + string2, exception));
            }
            this.version = new Integer(hABrokerInfo.getVersion());
            this.state = BrokerState.getState(hABrokerInfo.getState());
            this.session = new UID(hABrokerInfo.getSessionID());
            this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
            this.heartbeat = hABrokerInfo.getHeartbeat();
        }

        public HAClusteredBrokerImpl(String string, MQAddress mQAddress, int n, BrokerState brokerState, UID uID) throws BrokerException {
            this.brokerid = string;
            this.local = this.local;
            this.status = new Integer(0);
            this.address = mQAddress;
            this.version = new Integer(n);
            this.state = brokerState;
            this.session = uID;
            this.takeoverBroker = "";
            this.brokerSessionUID = new UID();
            Store store = Globals.getStore();
            store.addBrokerInfo(string, this.address.toString(), brokerState, this.version, uID.longValue(), this.heartbeat);
            this.heartbeat = store.getBrokerHeartbeat(string);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClusteredBroker)) {
                return false;
            }
            return this.getBrokerName().equals(((ClusteredBroker)object).getBrokerName());
        }

        public int hashCode() {
            return this.getBrokerName().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(HABrokerInfo hABrokerInfo) {
            MQAddress mQAddress = this.address;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                this.brokerid = hABrokerInfo.getId();
                String string = hABrokerInfo.getUrl();
                try {
                    this.address = BrokerMQAddress.createAddress(string);
                }
                catch (Exception exception) {
                    Logger logger = HAClusterManagerImpl.this.logger;
                    HAClusterManagerImpl.this.logger;
                    logger.logStack(16, exception.getMessage(), (Throwable)exception);
                    this.address = mQAddress;
                }
                this.version = new Integer(hABrokerInfo.getVersion());
                this.state = BrokerState.getState(hABrokerInfo.getState());
                this.session = new UID(hABrokerInfo.getSessionID());
                this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
                this.heartbeat = hABrokerInfo.getHeartbeat();
            }
            if (!mQAddress.equals((Object)this.address)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress, this.address, null, null);
            }
        }

        void setIsLocal(boolean bl) {
            this.local = bl;
        }

        public String toString() {
            if (!this.local) {
                return "-" + this.brokerid + "@" + this.address + ":" + this.state + "[StoreSession:" + this.session + ", BrokerSession:" + this.brokerSessionUID + "]" + ":" + BrokerStatus.toString(this.status);
            }
            return "*" + this.brokerid + "@" + this.address + ":" + this.state + "[StoreSession:" + this.session + ", BrokerSession:" + this.brokerSessionUID + "]" + ":" + BrokerStatus.toString(this.status);
        }

        public String getBrokerName() {
            return this.brokerid;
        }

        public MQAddress getBrokerURL() {
            return this.address;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String string) {
            this.instanceName = string;
        }

        public void setBrokerURL(MQAddress mQAddress) throws Exception {
            if (!this.local) {
                throw new UnsupportedOperationException("Only the local broker can have its url changed");
            }
            MQAddress mQAddress2 = this.address;
            try {
                this.updateEntry(1, null, mQAddress.toString());
                this.address = mQAddress;
            }
            catch (Exception exception) {
                Logger logger = HAClusterManagerImpl.this.logger;
                HAClusterManagerImpl.this.logger;
                logger.logStack(32, exception.getMessage() + "[" + mQAddress2 + ", " + mQAddress + "]" + this.brokerid, (Throwable)exception);
                throw exception;
            }
            HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress2, this.address, null, null);
        }

        public void resetTakeoverBrokerReadyOperating() throws Exception {
            if (!this.local) {
                throw new UnsupportedOperationException("Only the local broker can have its takeover broker reset");
            }
            this.getState();
            if (this.state == BrokerState.FAILOVER_PENDING || this.state == BrokerState.FAILOVER_STARTED) {
                String string = this.getTakeoverBroker();
                throw new IllegalStateException(Globals.getBrokerResources().getKString("B4310", string == null ? "" : string, this.toString()));
            }
            try {
                UID uID = this.updateEntry(2, this.state, this.getBrokerSessionUID());
                if (uID != null) {
                    this.session = uID;
                    HAClusterManagerImpl.this.localSessionUID = uID;
                }
            }
            catch (Exception exception) {
                Logger logger = HAClusterManagerImpl.this.logger;
                HAClusterManagerImpl.this.logger;
                logger.logStack(32, exception.getMessage() + "[" + this.brokerid + "]", (Throwable)exception);
                throw exception;
            }
        }

        public boolean isLocalBroker() {
            return this.local;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized int getVersion() {
            return this.version == null ? 0 : this.version;
        }

        public synchronized void setVersion(int n) throws Exception {
            Integer n2 = this.version;
            Integer n3 = new Integer(n);
            if (this.local) {
                try {
                    this.updateEntry(0, this.version, n3);
                    this.version = n3;
                }
                catch (Exception exception) {
                    Logger logger = HAClusterManagerImpl.this.logger;
                    HAClusterManagerImpl.this.logger;
                    logger.logStack(16, exception.getMessage() + "[" + n2 + ", " + n + "]" + this.brokerid, (Throwable)exception);
                    throw exception;
                }
            }
            HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.VERSION_CHANGED, this.getBrokerName(), n2, this.version, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatus(int n, Object object) {
            UID uID = null;
            Integer n2 = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (this.status == n) {
                    return;
                }
                uID = this.getBrokerSessionUID();
                n2 = this.status;
                this.status = new Integer(n);
            }
            if (!n2.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n2, this.status, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerIsUp(boolean bl, UID uID, Object object) {
            UID uID2 = uID;
            Integer n = null;
            Integer n2 = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (!bl && !uID2.equals((Object)this.getBrokerSessionUID())) {
                    Logger logger = HAClusterManagerImpl.this.logger;
                    HAClusterManagerImpl.this.logger;
                    logger.log(8, Globals.getBrokerResources().getKString("B1337", "[BrokerSession:" + uID2 + "]", this.toString()));
                    n = new Integer(16);
                    n2 = BrokerStatus.setBrokerIsDown(n);
                } else {
                    n = this.status;
                    int n3 = 0;
                    if (bl) {
                        n3 = BrokerStatus.setBrokerIsUp(this.status);
                    } else {
                        n3 = BrokerStatus.setBrokerIsDown(this.status);
                        n3 = BrokerStatus.setBrokerNotInDoubt(n3);
                    }
                    uID2 = this.getBrokerSessionUID();
                    n2 = this.status = new Integer(n3);
                }
            }
            if (!n.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerLinkUp(boolean bl, Object object) {
            UID uID = null;
            Integer n = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                n = this.status;
                int n2 = 0;
                uID = this.getBrokerSessionUID();
                n2 = bl ? BrokerStatus.setBrokerLinkIsUp(this.status) : BrokerStatus.setBrokerLinkIsDown(this.status);
                this.status = new Integer(n2);
            }
            if (!n.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerInDoubt(boolean bl, Object object) {
            UID uID = (UID)object;
            Integer n = null;
            Integer n2 = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (bl && !uID.equals((Object)this.getBrokerSessionUID())) {
                    Logger logger = HAClusterManagerImpl.this.logger;
                    HAClusterManagerImpl.this.logger;
                    logger.log(8, Globals.getBrokerResources().getKString("B1336", "[BrokerSession:" + uID + "]", this.toString()));
                    n = new Integer(257);
                    n2 = BrokerStatus.setBrokerInDoubt(n);
                } else {
                    n = this.status;
                    int n3 = 0;
                    n3 = bl ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                    uID = this.getBrokerSessionUID();
                    n2 = this.status = new Integer(n3);
                }
            }
            if (!n.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
            }
        }

        public synchronized UID getStoreSessionUID() {
            return this.session;
        }

        public synchronized UID getBrokerSessionUID() {
            return this.brokerSessionUID;
        }

        public synchronized void setBrokerSessionUID(UID uID) {
            this.brokerSessionUID = uID;
        }

        public boolean isBrokerIDGenerated() {
            return false;
        }

        public synchronized String getTakeoverBroker() throws BrokerException {
            HABrokerInfo hABrokerInfo = Globals.getStore().getBrokerInfo(this.brokerid);
            if (hABrokerInfo == null) {
                HAClusterManagerImpl.this.logger.log(32, "B3169", (Object)this.brokerid);
                return null;
            }
            this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
            return this.takeoverBroker;
        }

        public long getHeartbeat() throws BrokerException {
            this.heartbeat = Globals.getStore().getBrokerHeartbeat(this.brokerid);
            return this.heartbeat;
        }

        public synchronized long updateHeartbeat() throws BrokerException {
            return this.updateHeartbeat(false);
        }

        public synchronized long updateHeartbeat(boolean bl) throws BrokerException {
            Store store = Globals.getStore();
            Long l = null;
            if (bl) {
                l = store.updateBrokerHeartbeat(this.brokerid);
                if (l == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4223", this.brokerid, "Failed to reset heartbeat timestamp."));
                }
            } else {
                l = store.updateBrokerHeartbeat(this.brokerid, this.heartbeat);
                if (l == null) {
                    HAClusterManagerImpl.this.logger.log(16, Globals.getBrokerResources().getKString("B4223", this.brokerid, "Reset heartbeat timestamp due to synchronization problem."));
                    l = store.updateBrokerHeartbeat(this.brokerid);
                    if (l == null) {
                        throw new BrokerException(Globals.getBrokerResources().getKString("B4223", this.brokerid, "Failed to reset heartbeat timestamp."));
                    }
                }
            }
            this.heartbeat = l;
            return this.heartbeat;
        }

        private synchronized UID updateEntry(int n, Object object, Object object2) throws Exception {
            if (!this.local) {
                throw new IllegalAccessException("Can not update entry  for broker " + this.brokerid);
            }
            Store store = Globals.getStore();
            UID uID = store.updateBrokerInfo(this.brokerid, n, object, object2);
            try {
                this.heartbeat = store.getBrokerHeartbeat(this.brokerid);
            }
            catch (Exception exception) {
                Logger logger = HAClusterManagerImpl.this.logger;
                HAClusterManagerImpl.this.logger;
                logger.logStack(16, exception.getMessage() + "[" + this.brokerid + "]", (Throwable)exception);
            }
            return uID;
        }

        public BrokerState getState() throws BrokerException {
            BrokerState brokerState = this.state;
            this.state = Globals.getStore().getBrokerState(this.brokerid);
            if (brokerState != this.state && this.state != BrokerState.FAILOVER_PENDING) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState, this.state, null, null);
            }
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStateFailoverProcessed(UID uID) throws Exception {
            if (this.local) {
                throw new IllegalAccessException("Cannot update self state to " + BrokerState.FAILOVER_PROCESSED);
            }
            BrokerState brokerState = BrokerState.FAILOVER_PROCESSED;
            try {
                BrokerState brokerState2 = this.getState();
                HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
                synchronized (hAClusteredBrokerImpl) {
                    if (uID.equals((Object)this.session)) {
                        this.state = brokerState;
                    } else {
                        brokerState2 = BrokerState.FAILOVER_COMPLETE;
                    }
                }
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, brokerState, uID, null);
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException("Failed to update state " + BrokerState.FAILOVER_COMPLETE + " for " + this.brokerid);
                illegalStateException.initCause(exception);
                throw illegalStateException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStateFailoverFailed(UID uID) throws Exception {
            if (this.local) {
                throw new IllegalAccessException("Cannot update self state to " + BrokerState.FAILOVER_FAILED);
            }
            BrokerState brokerState = BrokerState.FAILOVER_FAILED;
            try {
                BrokerState brokerState2 = this.getState();
                HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
                synchronized (hAClusteredBrokerImpl) {
                    if (this.brokerSessionUID.equals((Object)uID)) {
                        this.state = brokerState;
                    } else {
                        brokerState2 = BrokerState.OPERATING;
                    }
                }
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, brokerState, uID, null);
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException("Failed to update state to " + BrokerState.FAILOVER_FAILED + " for " + this.brokerid);
                illegalStateException.initCause(exception);
                throw illegalStateException;
            }
        }

        public void setState(BrokerState brokerState) throws IllegalAccessException, IllegalStateException, IndexOutOfBoundsException {
            if (!this.local && brokerState != BrokerState.FAILOVER_PROCESSED && brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_COMPLETE && brokerState != BrokerState.FAILOVER_FAILED) {
                throw new IllegalAccessException("Cannot update state  for broker " + this.brokerid);
            }
            try {
                BrokerState brokerState2 = this.getState();
                if (brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_PROCESSED && brokerState != BrokerState.FAILOVER_FAILED && !Globals.getStore().updateBrokerState(this.brokerid, brokerState, this.state, this.local)) {
                    throw new IllegalStateException("Could not update broker state from " + brokerState2 + " to state " + brokerState + " for " + this.brokerid);
                }
                this.state = brokerState;
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, this.state, null, null);
            }
            catch (BrokerException brokerException) {
                IllegalStateException illegalStateException = new IllegalStateException(Globals.getBrokerResources().getKString("B3100", "Failed to update state for " + this.brokerid));
                illegalStateException.initCause(brokerException);
                throw illegalStateException;
            }
        }

        public TakeoverStoreInfo takeover(boolean bl, TakingoverTracker takingoverTracker) throws BrokerException {
            int n = HAClusterManagerImpl.this.config.getIntProperty("imq.cluster.takeover.delay.interval", 0);
            if (n > 0) {
                try {
                    Thread.sleep((long)n * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean bl2 = false;
            boolean bl3 = false;
            BrokerState brokerState = this.getState();
            if (!bl) {
                if (brokerState == BrokerState.INITIALIZING || brokerState == BrokerState.SHUTDOWN_STARTED || brokerState == BrokerState.SHUTDOWN_COMPLETE) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1191", this.brokerid), 405);
                }
                if (brokerState == BrokerState.FAILOVER_PENDING || brokerState == BrokerState.FAILOVER_STARTED || brokerState == BrokerState.FAILOVER_COMPLETE || brokerState == BrokerState.FAILOVER_PROCESSED) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1191", this.brokerid), 409);
                }
            }
            long l = System.currentTimeMillis();
            BrokerState brokerState2 = BrokerState.FAILOVER_PENDING;
            Globals.getStore().getTakeOverLock(HAClusterManagerImpl.this.localBroker, this.brokerid, takingoverTracker.getLastHeartbeat(), brokerState, l, brokerState2, bl, takingoverTracker);
            bl2 = true;
            this.state = brokerState2;
            HAClusterManagerImpl.this.logger.log(4, "state = FAILOVER_PENDING " + this.brokerid);
            HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.brokerid, brokerState, brokerState2, null, null);
            TakeoverStoreInfo takeoverStoreInfo = null;
            try {
                HAClusterManagerImpl.this.logger.log(4, "state = FAILOVER_STARTED " + this.brokerid);
                this.setState(BrokerState.FAILOVER_STARTED);
                takeoverStoreInfo = Globals.getStore().takeOverBrokerStore(HAClusterManagerImpl.this.localBroker, this.brokerid, takingoverTracker);
                HAClusterManagerImpl.this.logger.log(4, "state = FAILOVER_COMPLETE " + this.brokerid);
                bl3 = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Internal error, shouldnt happen", illegalAccessException);
            }
            finally {
                if (bl2 && !bl3) {
                    try {
                        this.setStateFailoverFailed(takingoverTracker.getBrokerSessionUID());
                    }
                    catch (Exception exception) {
                        Logger logger = HAClusterManagerImpl.this.logger;
                        HAClusterManagerImpl.this.logger;
                        logger.log(8, "Unable to set state to failed for broker " + this + ": " + exception.getMessage(), (Throwable)exception);
                    }
                    HAClusterManagerImpl.this.logger.log(16, "Failed to takeover :" + this.brokerid + " state expected is " + brokerState);
                }
            }
            this.heartbeat = l;
            HAClusterManagerImpl.this.addSupportedStoreSessionUID(this.session);
            this.takeoverBroker = HAClusterManagerImpl.this.localBroker;
            return takeoverStoreInfo;
        }

        public boolean isConfigBroker() {
            return true;
        }
    }
}

