/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.sharecc;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShareConfigChangeStore {
    private static boolean DEBUG = false;
    public static final String CLUSTER_SHARECC_PROP_PREFIX = "imq.cluster.sharecc";
    public static final String STORE_TYPE_PROP = "imq.cluster.sharecc.persist";
    public static final String DEFAULT_STORE_TYPE = "jdbc";
    public static final String CREATE_STORE_PROP = "imq.cluster.sharecc.persistCreate";
    public static final boolean CREATE_STORE_PROP_DEFAULT = false;
    private static final String CLASS_PROP_SUFFIX = ".class";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.JDBCShareConfigChangeStore";
    private static ShareConfigChangeStore store = null;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static synchronized ShareConfigChangeStore getStore() throws BrokerException {
        if (store != null) {
            return store;
        }
        if (BrokerStateHandler.shuttingDown) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
        }
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (!string.toLowerCase().equals(DEFAULT_STORE_TYPE)) {
            throw new BrokerException("Not supportedimq.cluster.sharecc.persist=" + string);
        }
        String string2 = "imq.cluster.sharecc.persist." + string + CLASS_PROP_SUFFIX;
        String string3 = brokerConfig.getProperty(string2);
        if (string3 == null || string3.equals("")) {
            string3 = DEFAULT_JDBCSTORE_CLASS;
        } else if (!string3.equals(DEFAULT_JDBCSTORE_CLASS)) {
            throw new BrokerException("Not supported " + string2 + "=" + string3);
        }
        try {
            store = (ShareConfigChangeStore)Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3252", exception.getMessage()), exception);
        }
        return store;
    }

    public static synchronized void releaseStore(boolean bl) {
        if (store != null) {
            store.close();
        }
        store = null;
    }

    public ChangeRecordInfo storeChangeRecord(ChangeRecordInfo changeRecordInfo, boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void storeResetRecord(ChangeRecordInfo changeRecordInfo, boolean bl, boolean bl2) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public List<ChangeRecordInfo> getChangeRecordsSince(Long l, String string, boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public List<ChangeRecordInfo> getAllChangeRecords() throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void clearAllChangeRecords(boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public abstract Properties getStoreShareProperties();

    public abstract String getVendorPropertySetting();

    public abstract void close();
}

