/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Hashtable;

public class DeliverHandler
extends PacketHandler {
    static final int DELIVER_BLOCK_SIZE = 32;
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        SysMessageID sysMessageID;
        int n;
        Packet[] packetArray;
        block25: {
            block24: {
                int n2;
                String string;
                block23: {
                    int n3;
                    block22: {
                        long l;
                        string = null;
                        Hashtable hashtable = null;
                        try {
                            hashtable = packet.getProperties();
                        }
                        catch (Exception exception) {
                            this.logger.log(8, "Internal Error: unable to retrieve  properties from deliver message " + packet, (Throwable)exception);
                            hashtable = new Hashtable();
                        }
                        int n4 = packet.getMessageBodySize();
                        n3 = n4 / 32;
                        int n5 = n4 % 32;
                        if (n3 == 0) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Empty Deliver Message"));
                        }
                        if (n5 != 0) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Deliver Message Size: " + n4 + ". Not multiple of " + 32));
                        }
                        if (DEBUG) {
                            this.logger.log(4, "Deliver Message: processing message {0} {1}", (Object)packet.toString(), (Object)iMQConnection.getConnectionUID().toString());
                        }
                        Long l2 = (Long)hashtable.get("JMQConsumerID");
                        assert (l2 != null);
                        long l3 = l = l2 == null ? 0L : l2;
                        assert (l != 0L);
                        DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
                        packetArray = new Packet[n3];
                        n = 0;
                        try {
                            for (n2 = 0; n2 < n3; ++n2) {
                                Packet packet2;
                                sysMessageID = new SysMessageID();
                                sysMessageID.readID((DataInput)dataInputStream);
                                object = Destination.get(sysMessageID);
                                Packet packet3 = packet2 = object == null ? null : ((PacketReference)object).getPacket();
                                if (object == null || ((PacketReference)object).isInvalid() || packet2 == null) continue;
                                Packet packet4 = new Packet(iMQConnection.useDirectBuffers());
                                packet4.fill(packet2);
                                packet4.setConsumerID(l);
                                packetArray[n] = packet4;
                                ++n;
                            }
                        }
                        catch (Exception exception) {
                            this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "\tackcnt = " + n3 + "\n" + PacketUtil.dumpPacket(packet) + "\n" + "\t" + PacketUtil.dumpThrowable(exception)), (Throwable)exception);
                            if ($assertionsDisabled) break block22;
                            throw new AssertionError();
                        }
                    }
                    n2 = 200;
                    try {
                        if (n > 0) {
                            assert (packetArray[n - 1] != null);
                            packetArray[n - 1].setIsLast(true);
                        } else {
                            string = "NOT FOUND";
                            n2 = 404;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "\tackcnt = " + n3 + "\n" + PacketUtil.dumpPacket(packet) + "\n" + "\t" + PacketUtil.dumpThrowable(exception)), (Throwable)exception);
                        assert (false);
                        string = exception.getMessage();
                        n2 = 500;
                        if (!(exception instanceof BrokerException)) break block23;
                        n2 = ((BrokerException)exception).getStatusCode();
                    }
                }
                sysMessageID = new Packet(iMQConnection.useDirectBuffers());
                sysMessageID.setConsumerID(packet.getConsumerID());
                sysMessageID.setPacketType(43);
                object = new Hashtable();
                ((Hashtable)object).put("JMQStatus", new Integer(n2));
                if (string != null) {
                    ((Hashtable)object).put("JMQReason", string);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block24;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block25;
            }
            ((Hashtable)object).put("JMQReqID", packet.getSysMessageID().toString());
        }
        sysMessageID.setProperties((Hashtable)object);
        iMQConnection.sendControlMessage((Packet)sysMessageID);
        for (int i = 0; i < n; ++i) {
            assert (packetArray[i] != null);
            if (packetArray[i] == null) continue;
            iMQConnection.sendControlMessage(packetArray[i]);
        }
        return true;
    }
}

