/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.SessionAdapter;
import com.sun.messaging.jms.ra.util.XAResourceMapForRAMC;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForMC
implements XAResource,
XAResourceForJMQ {
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private ManagedConnection mc;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    protected boolean active = false;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private int resourceState = 0;
    private static Hashtable xaTable = new Hashtable();
    private static final transient String _className = "com.sun.messaging.jmq.jmsclient.XAResourceForMC";
    private static final transient String _lgrName = "com.sun.messaging.jmq.jmsclient.XAResourceForMC";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jmq.jmsclient.XAResourceForMC");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_XARMC";
    private static final transient String _lgrMID_EET = "MQJMSRA_XARMC1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_XARMC1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_XARMC2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_XARMC3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_XARMC4001: ";

    public XAResourceForMC(ManagedConnection managedConnection, ConnectionImpl connectionImpl, ConnectionImpl connectionImpl2) throws JMSException {
        this.mc = managedConnection;
        this.id = managedConnection.getMCId();
        this.epConnection = connectionImpl2;
        if (connectionImpl == null) {
            System.err.println("MQRA:XARFMC:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (connectionImpl._isClosed()) {
            System.err.println("MQRA:XARFMC:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = connectionImpl.getProtocolHandler().generateUID();
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFMC:constr:Exc aquiring RMId:assume distinct");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid;
        boolean bl2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Commit  " + this.printXid(xid) + " (onePhase=" + bl + ")");
        }
        JMQXid jMQXid2 = new JMQXid(xid);
        try {
            try {
                if (this.epConnection._isClosed()) {
                    System.err.println("MQRA:XARFMC:commit:ConnectionClosed:throw XAExc txn:1p=" + bl + ":xid=" + jMQXid2.toString());
                    XAException xAException = new XAException(-7);
                    throw xAException;
                }
                if (bl) {
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HAOnePhaseCommit(xid, jMQXid2);
                    } else {
                        this.epConnection.getProtocolHandler().commit(0L, 0x40000000, jMQXid2);
                    }
                } else if (this.epConnection.isConnectedToHABroker()) {
                    this.HATwoPhaseCommit(jMQXid2);
                } else {
                    this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid2);
                }
                SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
                if (sessionAdapter != null) {
                    sessionAdapter.getXASession()._finishXATransactionForMC();
                }
                this.active = false;
                Object var7_8 = null;
                bl2 = false;
                jMQXid = this.jmqXid;
            }
            catch (XAException xAException) {
                throw xAException;
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + exception.getMessage());
                Debug.printStackTrace(exception);
                xAException = new XAException(-7);
                xAException.initCause(exception);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            boolean bl3 = false;
            JMQXid jMQXid3 = this.jmqXid;
            XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources(this.jmqXid, bl3);
            int i = 0;
            while (true) {
                if (i >= xAResourceForJMQArray.length) {
                    XAResourceMapForRAMC.unregister(jMQXid3);
                    throw throwable;
                }
                XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
                try {
                    xAResourceForJMQ.clearTransactionInfo();
                }
                catch (JMSException jMSException) {
                    System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + jMSException.getMessage());
                    Debug.printStackTrace(jMSException);
                    XAException xAException = new XAException(-7);
                    xAException.initCause(jMSException);
                    throw xAException;
                }
                ++i;
            }
        }
        XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources(this.jmqXid, bl2);
        for (int i = 0; i < xAResourceForJMQArray.length; ++i) {
            XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
            try {}
            catch (JMSException jMSException) {
                System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + jMSException.getMessage());
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
            xAResourceForJMQ.clearTransactionInfo();
        }
        XAResourceMapForRAMC.unregister(jMQXid);
        this.removeXid(jMQXid2);
    }

    private void HAOnePhaseCommit(Xid xid, JMQXid jMQXid) throws JMSException, XAException {
        int n = 1;
        try {
            this.prepare(xid, true);
            n = 2;
            if (this.isXATracking()) {
                xaTable.put(jMQXid, XAResourceForRA.XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid, true);
        }
        catch (Exception exception) {
            this.checkCommitStatus(exception, n, jMQXid, true);
        }
        this.removeXid(jMQXid);
    }

    private void HATwoPhaseCommit(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n == 2) {
                    this.checkCommitStatus((Exception)((Object)jMSException), 2, jMQXid, false);
                }
            }
            throw jMSException;
        }
        this.removeXid(jMQXid);
    }

    private void checkPrepareStatus(XAException xAException, JMQXid jMQXid) throws XAException {
        if (!this.epConnection.imqReconnect) {
            throw xAException;
        }
        try {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw xAException;
            }
            this.verifyPrepare(jMQXid);
        }
        catch (XAException xAException2) {
            throw xAException2;
        }
        catch (Exception exception) {
            XAException xAException3 = new XAException(-7);
            xAException3.initCause(exception);
            throw xAException3;
        }
    }

    private void verifyPrepare(JMQXid jMQXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jMQXid);
        int n = this.epConnection.protocolHandler.verifyHATransaction(0L, 1, jMQXid);
        switch (n) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + this.transactionID);
                return;
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void checkCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(exception, n, jMQXid, bl);
        }
        catch (Exception exception2) {
            if (exception2 instanceof JMSException) {
                throw (JMSException)((Object)exception2);
            }
            if (exception2 instanceof XAException) {
                throw (XAException)exception2;
            }
            XAException xAException = new XAException(-7);
            xAException.initCause(exception2);
            throw xAException;
        }
    }

    private void doCheckCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws Exception {
        if (!this.epConnection.imqReconnect) {
            throw exception;
        }
        SessionImpl.yield();
        this.epConnection.checkReconnecting(null);
        if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
            throw exception;
        }
        this.verifyTransaction(n, jMQXid, bl);
    }

    private void verifyTransaction(int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        int n2 = this.epConnection.protocolHandler.verifyHATransaction(0L, n, jMQXid);
        switch (n2) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid, bl);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jMSException) {
                    SessionImpl.yield();
                    this.epConnection.checkReconnecting(null);
                    throw jMSException;
                }
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") End     " + this.printXid(xid) + this.printFlags(n));
        }
        JMQXid jMQXid = new JMQXid(xid);
        this.resourceState = this.isFail(n) ? 2 : (this.isSuspend(n) ? 3 : 4);
        if (ResourceAdapter.isRevert6882044()) {
            this.sendEndToBroker(n, false, jMQXid);
        } else if (this.resourceState == 4) {
            boolean bl = true;
            XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources(jMQXid, true);
            for (int i = 0; i < xAResourceForJMQArray.length; ++i) {
                XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
                if (xAResourceForJMQ.isComplete()) continue;
                bl = false;
            }
            if (bl) {
                this.sendEndToBroker(n, false, jMQXid);
            } else {
                this.sendEndToBroker(n, true, jMQXid);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(n, false, jMQXid);
        } else if (this.resourceState == 3) {
            // empty if block
        }
        this.started = false;
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XAResourceForRA.XA_END);
        }
    }

    private void sendEndToBroker(int n, boolean bl, JMQXid jMQXid) throws XAException {
        try {
            this.epConnection.protocolHandler.endTransaction(0L, bl, n, jMQXid);
            SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
            if (sessionAdapter != null) {
                sessionAdapter.getXASession()._finishXATransactionForMC();
            }
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:end:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
        XidImpl xidImpl = new XidImpl(xid);
        XAResourceMapForRAMC.unregister(xidImpl);
        if (this.jmqXid != null && this.jmqXid.equals(xidImpl)) {
            try {
                this.clearTransactionInfo();
            }
            catch (JMSException jMSException) {
                System.err.println("MQRA:XARFMC:forget:XAException-Exception=" + jMSException.getMessage());
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource instanceof XAResourceForMC || xAResource instanceof XAResourceForRA) {
            return this.isSameJMQRM((XAResourceForJMQ)((Object)xAResource));
        }
        return false;
    }

    public boolean isSameJMQRM(XAResourceForJMQ xAResourceForJMQ) {
        boolean bl = ResourceAdapter.isSameRMAllowed() ? this.getBrokerSessionID() != 0L && this.getBrokerSessionID() == xAResourceForJMQ.getBrokerSessionID() : false;
        return bl;
    }

    public long getBrokerSessionID() {
        return this.epConnection.getBrokerSessionID();
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        try {
            this.prepare(xid, false);
        }
        catch (XAException xAException) {
            if (this.epConnection.isConnectedToHABroker) {
                this.checkPrepareStatus(xAException, this.jmqXid);
            }
            throw xAException;
        }
        if (this.isXATracking()) {
            xaTable.put(this.jmqXid, XAResourceForRA.XA_PREPARE);
        }
        return n;
    }

    private synchronized int prepare(Xid xid, boolean bl) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Prepare     " + this.printXid(xid));
        }
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (this.epConnection._isClosed()) {
                System.err.println("MQRA:XARFMC:prepare:ConnectionClosed:Rollback txn:xid=" + jMQXid.toString());
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jMQXid, bl);
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:prepare:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        this.resourceState = 5;
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        JMQXid[] jMQXidArray = null;
        try {
            if (!this.epConnection._isClosed()) {
                jMQXidArray = this.epConnection.getProtocolHandler().recover(n);
            }
        }
        catch (Exception exception) {
            System.err.println("MQRA:XARFMC:recover:XAException-Exception=" + exception.getMessage());
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return jMQXidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback(Xid xid) throws XAException {
        JMQXid jMQXid;
        boolean bl;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Rollback  " + this.printXid(xid) + ")");
        }
        JMQXid jMQXid2 = new JMQXid(xid);
        XASessionImpl xASessionImpl = null;
        SessionAdapter sessionAdapter = null;
        try {
            try {
                if (this.epConnection._isClosed()) {
                    System.err.println("MQRA:XARFMC:rollback:ConnectionClosed:Rollback txn:xid=" + jMQXid2.toString());
                    XAException xAException = new XAException(-7);
                    throw xAException;
                }
                sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
                if (this.epConnection.isConnectedToHABroker()) {
                    this.HARollback(jMQXid2);
                } else {
                    this.epConnection.getProtocolHandler().rollback(0L, jMQXid2, true);
                }
                if (sessionAdapter != null) {
                    xASessionImpl = sessionAdapter.getXASession();
                    xASessionImpl._finishXATransactionForMC();
                }
                this.active = false;
                Object var8_7 = null;
                if (sessionAdapter != null && (xASessionImpl = sessionAdapter.getXASession()) != null) {
                    xASessionImpl.failoverOccurred = false;
                }
                bl = false;
                jMQXid = this.jmqXid;
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + exception.getMessage());
                Debug.printStackTrace(exception);
                XAException xAException = new XAException(-7);
                xAException.initCause(exception);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (sessionAdapter != null && (xASessionImpl = sessionAdapter.getXASession()) != null) {
                xASessionImpl.failoverOccurred = false;
            }
            boolean bl2 = false;
            JMQXid jMQXid3 = this.jmqXid;
            XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources(this.jmqXid, bl2);
            int i = 0;
            while (true) {
                if (i >= xAResourceForJMQArray.length) {
                    XAResourceMapForRAMC.unregister(jMQXid3);
                    throw throwable;
                }
                XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
                try {
                    xAResourceForJMQ.clearTransactionInfo();
                }
                catch (JMSException jMSException) {
                    System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + jMSException.getMessage());
                    Debug.printStackTrace(jMSException);
                    XAException xAException = new XAException(-7);
                    xAException.initCause(jMSException);
                    throw xAException;
                }
                ++i;
            }
        }
        XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources(this.jmqXid, bl);
        for (int i = 0; i < xAResourceForJMQArray.length; ++i) {
            XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
            try {}
            catch (JMSException jMSException) {
                System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + jMSException.getMessage());
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
            xAResourceForJMQ.clearTransactionInfo();
        }
        XAResourceMapForRAMC.unregister(jMQXid);
        this.removeXid(jMQXid2);
    }

    private void HARollback(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true);
        }
        catch (JMSException jMSException) {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw jMSException;
            }
            this.retryRollBack(jMQXid);
        }
        this.removeXid(jMQXid);
    }

    private void retryRollBack(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true, true);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jMSException.toString());
                }
                throw jMSException;
            }
            throw jMSException;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Start   " + this.printXid(xid) + this.printFlags(n));
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (!this.isResume(n) || ResourceAdapter.isRevert6882044()) {
            try {
                this.transactionID = this.epConnection.protocolHandler.startTransaction(this.transactionID, n, jMQXid);
                this.jmqXid = jMQXid;
                SessionAdapter sessionAdapter = this.mc.getConnectionAdapter().getSessionAdapter();
                if (sessionAdapter != null) {
                    sessionAdapter.getXASession()._initXATransactionForMC(this.transactionID);
                }
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFMC:start:XAException-Exception=" + exception.getMessage());
                Debug.printStackTrace(exception);
                XAException xAException = new XAException(-7);
                xAException.initCause(exception);
                throw xAException;
            }
            XAResourceMapForRAMC.register(jMQXid, this, this.isJoin(n));
        }
        this.started = true;
        this.active = true;
        this.resourceState = 1;
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XAResourceForRA.XA_START);
        }
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public void clearTransactionInfo() throws JMSException {
        this.mc.getConnectionAdapter().closeForPoolingIfClosed();
        this.resourceState = 0;
    }

    private boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XAResourceForRA.XATracking;
    }

    private void removeXid(JMQXid jMQXid) {
        if (this.isXATracking()) {
            xaTable.remove(jMQXid);
        }
    }

    private boolean isJoin(int n) {
        return (n & 0x200000) == 0x200000;
    }

    private boolean isResume(int n) {
        return (n & 0x8000000) == 0x8000000;
    }

    private boolean isFail(int n) {
        return (n & 0x20000000) == 0x20000000;
    }

    private boolean isSuspend(int n) {
        return (n & 0x2000000) == 0x2000000;
    }

    private String printXid(Xid xid) {
        return "(GlobalTransactionID=" + xid.getGlobalTransactionId() + ", BranchQualifier=" + xid.getBranchQualifier() + ") ";
    }

    private String printFlags(int n) {
        String string = "(Flags: ";
        if (this.isJoin(n)) {
            string = string + "JOIN ";
        }
        if (this.isNoFlags(n)) {
            string = string + "TMNOFLAGS ";
        }
        if (this.isFail(n)) {
            string = string + "TMFAIL ";
        }
        if (this.isOnePhase(n)) {
            string = string + "TMONEPHASE ";
        }
        if (this.isResume(n)) {
            string = string + "TMRESUME ";
        }
        if (this.isSuccess(n)) {
            string = string + "TMSUCCESS ";
        }
        if (this.isSuspend(n)) {
            string = string + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(n)) {
            string = string + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(n)) {
            string = string + "TMSTARTRSCAN ";
        }
        string = string + ")";
        return string;
    }

    private boolean isNoFlags(int n) {
        return (n & 0) == 0;
    }

    private boolean isOnePhase(int n) {
        return (n & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int n) {
        return (n & 0x4000000) == 0x4000000;
    }

    private boolean isTMENDRSCAN(int n) {
        return (n & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int n) {
        return (n & 0x1000000) == 0x1000000;
    }

    public boolean isComplete() {
        return this.resourceState == 4;
    }
}

