/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.falcon;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class FalconProtocol {
    protected static final long ConsumerVersionUID = 99353142765567461L;
    protected Logger logger = Globals.getLogger();
    protected MessageBusCallback cb = null;
    protected CallbackDispatcher cbDispatcher = null;
    protected int version = 300;

    public FalconProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress) throws BrokerException {
        this.cb = messageBusCallback;
        this.cbDispatcher = new CallbackDispatcher(messageBusCallback);
    }

    public static Consumer readConsumer(DataInputStream dataInputStream, CallbackDispatcher callbackDispatcher) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Logger logger = Globals.getLogger();
        ConsumerUID consumerUID = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = dataInputStream.readLong();
        if (l != 99353142765567461L) {
            throw new IOException("Wrong Consumer Version " + l + " expected " + 99353142765567461L);
        }
        string = dataInputStream.readUTF();
        boolean bl4 = dataInputStream.readBoolean();
        if (bl4) {
            consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
        }
        if (bl3 = dataInputStream.readBoolean()) {
            string2 = dataInputStream.readUTF();
        }
        if (bl2 = dataInputStream.readBoolean()) {
            string3 = dataInputStream.readUTF();
        }
        if (bl = dataInputStream.readBoolean()) {
            string4 = dataInputStream.readUTF();
        }
        boolean bl5 = dataInputStream.readBoolean();
        boolean bl6 = dataInputStream.readBoolean();
        boolean bl7 = dataInputStream.readBoolean();
        try {
            DestinationUID destinationUID = DestinationUID.getUID(string, bl5);
            Consumer consumer = new Consumer(destinationUID, string4, bl6, consumerUID);
            if (string3 != null) {
                Subscription subscription = Subscription.findCreateDurableSubscription(string2, string3, destinationUID, string4, bl6);
                int n = destinationUID.isQueue() ? 1 : 2;
                Destination destination = Destination.getDestination(destinationUID.getName(), n, true, true);
                if (callbackDispatcher != null) {
                    callbackDispatcher.interestCreated(subscription);
                }
                subscription.attachConsumer(consumer);
            }
            return consumer;
        }
        catch (SelectorFormatException selectorFormatException) {
            logger.log(8, "L10N-XXX Got bad selector[" + string4 + "] ", (Throwable)selectorFormatException);
            throw new IOException("bad selector " + string4);
        }
        catch (BrokerException brokerException) {
            logger.log(8, "L10N-XXX error creating consumer ", (Throwable)brokerException);
            throw new IOException("error creating consumer ");
        }
    }

    protected static ConsumerUID readConsumerUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        ConnectionUID connectionUID = new ConnectionUID(dataInputStream.readLong());
        BrokerAddress brokerAddress = Globals.getMyAddress();
        if (brokerAddress == null) {
            try {
                brokerAddress = new BrokerAddressImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BrokerAddress brokerAddress2 = (BrokerAddress)brokerAddress.clone();
        brokerAddress2.readBrokerAddress(dataInputStream);
        ConsumerUID consumerUID = new ConsumerUID(l);
        consumerUID.setConnectionUID(connectionUID);
        consumerUID.setBrokerAddress(brokerAddress2);
        return consumerUID;
    }

    public static byte[] upgradeConfigChangeRecord(byte[] byArray) throws IOException {
        ChangeRecord changeRecord = ChangeRecord.makeChangeRecord(byArray);
        if (changeRecord.eventDestId == 12) {
            return RaptorProtocol.prepareResetPersistenceRecord();
        }
        if (changeRecord.eventDestId == 3) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(changeRecord.rec);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n2 == 1) {
                dataInputStream.readBoolean();
                dataInputStream.readUTF();
                dataInputStream.readUTF();
                Consumer consumer = FalconProtocol.readConsumer(dataInputStream, null);
                Subscription subscription = consumer.getSubscription();
                return RaptorProtocol.generateAddDurableRecord(subscription);
            }
            if (n2 == 5) {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                Subscription subscription = Subscription.findDurableSubscription(string2, string);
                return RaptorProtocol.generateRemDurableRecord(subscription);
            }
        } else if (changeRecord.eventDestId == 11) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(changeRecord.rec);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            int n5 = dataInputStream.readInt();
            if (n4 == 1) {
                DestinationUID destinationUID = null;
                try {
                    destinationUID = DestinationUID.getUID(string, n5);
                }
                catch (BrokerException brokerException) {
                    return byArray;
                }
                Destination destination = Destination.getDestination(destinationUID);
                return RaptorProtocol.generateAddDestinationRecord(destination);
            }
            if (n4 == 2) {
                DestinationUID destinationUID = null;
                try {
                    destinationUID = DestinationUID.getUID(string, n5);
                }
                catch (BrokerException brokerException) {
                    return byArray;
                }
                Destination destination = Destination.getDestination(destinationUID);
                return RaptorProtocol.generateRemDestinationRecord(destination);
            }
        }
        Globals.getLogger().log(8, "Internal error : upgradeConfigChangeRecord conversion failed.");
        return byArray;
    }
}

