/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.ra.ConnectionMetaData;
import com.sun.messaging.jms.ra.DirectConnectionFactory;
import com.sun.messaging.jms.ra.DirectConnectionMetaData;
import com.sun.messaging.jms.ra.DirectConsumer;
import com.sun.messaging.jms.ra.DirectQueueSession;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectTopicSession;
import com.sun.messaging.jms.ra.DirectTransactionManagedSession;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.TemporaryDestination;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectConnection
implements Connection,
QueueConnection,
TopicConnection {
    private DirectConnectionFactory dcf;
    private final JMSService jmsservice;
    private final long connectionId;
    private final boolean inACC;
    private String clientID;
    private ExceptionListener exceptionListener;
    private ConnectionMetaData connectionMetaData;
    private DirectXAResource xar = null;
    private DirectSession ds = null;
    private transient Vector<DirectSession> sessions = null;
    private transient Vector<TemporaryDestination> tmp_destinations = null;
    private transient Vector<DirectConsumer> durable_consumers = null;
    ManagedConnection mc = null;
    private boolean isManaged = false;
    private boolean isPooled = false;
    private boolean isEnlisted = false;
    private boolean isClosed;
    private boolean isClosing;
    private boolean isStopped;
    private boolean isUsed;
    private Object syncObj = new Object();
    private int temporaryDestinationId = 0;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectConnection";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSConnection = "javax.jms.Connection.mqjmsra";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJC = Logger.getLogger("javax.jms.Connection.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DC";
    private static final transient String _lgrMID_EET = "MQJMSRA_DC1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DC1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DC2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DC3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DC4001: ";

    public DirectConnection(DirectConnectionFactory directConnectionFactory, JMSService jMSService, long l, boolean bl) {
        Object[] objectArray = new Object[]{directConnectionFactory, jMSService, l, bl};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.dcf = directConnectionFactory;
        this.jmsservice = jMSService;
        this.connectionId = l;
        this.inACC = bl;
        this.clientID = null;
        this.exceptionListener = null;
        this.connectionMetaData = new DirectConnectionMetaData(directConnectionFactory._getConfiguration());
        this.sessions = new Vector();
        this.tmp_destinations = new Vector();
        this.durable_consumers = new Vector();
        this.isClosed = false;
        this.isClosing = false;
        this.isStopped = true;
        this.isUsed = false;
    }

    public void close() throws JMSException {
        boolean bl = false;
        this.close(bl);
    }

    public void closeAndDestroy() throws JMSException {
        boolean bl = true;
        this.close(bl);
        this._destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean bl) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "close():");
        DirectConnection directConnection = this;
        synchronized (directConnection) {
            if (this.isClosed) {
                return;
            }
            this.isClosing = true;
            this._stop();
            this._closeAndClearSessions();
            if (this.mc == null || !this.mc.xaTransactionActive()) {
                this._deleteTemporaryDestinations();
            }
            this.isClosing = false;
            this.isClosed = true;
            if (bl) {
                return;
            }
            if (this.isManaged) {
                this.mc.sendEvent(1, null, this);
                return;
            }
        }
        this._destroy();
    }

    public ConnectionConsumer createConnectionConsumer(javax.jms.Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createConnectionConsumer():" + "Destination=" + destination + ":" + "MessageSelector=" + string + ":" + "ServerSessionPool=" + serverSessionPool + ":" + "MaxMessages=" + n);
        this._unsupported("createConnectionConsumer():");
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createDurableConnectionConsumer():" + "Topic=" + topic + ":" + "SubscriptionName=" + string + ":" + "MessageSelector=" + string2 + ":" + "ServerSessionPool=" + serverSessionPool + ":" + "MaxMessages=" + n);
        this._unsupported("createDurableConnectionConsumer():");
        return null;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        JMSService.SessionAckMode sessionAckMode;
        long l;
        boolean bl2;
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createSession():" + "isTransacted=" + bl + ":" + "acknowledgeMode=" + n);
        this._checkIfClosed("createSession():");
        this.setUsed();
        if (ResourceAdapter._isFixCR6760301()) {
            bl2 = this.overrideTransacted(bl);
            int n2 = this.overrideAcknowledgeMode(n);
            l = this._createSessionId(this.connectionId, bl2, n2);
            sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl2, n2);
        } else {
            bl2 = this.isManaged() ? false : bl;
            l = this._createSessionId(this.connectionId, bl2, n);
            sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl2, n);
        }
        DirectSession directSession = this.isManaged() ? new DirectTransactionManagedSession(this, this.jmsservice, l, sessionAckMode) : new DirectSession(this, this.jmsservice, l, sessionAckMode);
        this.addSession(directSession);
        return directSession;
    }

    public Session createSessionForRAEndpoint() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createSessionForRAEndpoint():");
        this._checkIfClosed("createSession():");
        this.setUsed();
        boolean bl = false;
        int n = 2;
        long l = this._createSessionId(this.connectionId, bl, n);
        JMSService.SessionAckMode sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl, n);
        DirectSession directSession = new DirectSession(this, this.jmsservice, l, sessionAckMode);
        this.addSession(directSession);
        return directSession;
    }

    private boolean overrideTransacted(boolean bl) {
        boolean bl2 = this.inACC ? bl : false;
        return bl2;
    }

    private int overrideAcknowledgeMode(int n) {
        int n2 = this.inACC ? n : (n == 2 ? 1 : n);
        return n2;
    }

    public String getClientID() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "getClientID():");
        this._checkIfClosed("getClientID():");
        this.setUsed();
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "getExceptionListener():");
        this._checkIfClosed("getExceptionListener():");
        this.setUsed();
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "getMetaData():");
        this._checkIfClosed("getMetaData():");
        this.setUsed();
        return this.connectionMetaData;
    }

    public void setClientID(String string) throws JMSException {
        String string2 = "setClientID()";
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + string2);
        if (!this.inACC) {
            this._unsupported(string2);
        }
        this._checkIfClosed(string2);
        this._setClientID(string);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        String string = "setExceptionListener()";
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + string);
        if (!this.inACC) {
            this._unsupported(string);
        }
        this._checkIfClosed(string);
    }

    public synchronized void start() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "start():");
        this._checkIfClosed("start():");
        if (!this.isStopped()) {
            return;
        }
        this.setUsed();
        try {
            this.jmsservice.startConnection(this.connectionId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "start():" + "JMSService.startConnection():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
        this.isStopped = false;
        this._startSessions();
    }

    public synchronized void stop() throws JMSException {
        String string = "stop()";
        _loggerJC.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId);
        if (!this.inACC) {
            this._unsupported(string);
        }
        this._stop();
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createConnectionConsumer():" + "Queue=" + queue + ":" + "MessageSelector=" + string + ":" + "ServerSessionPool=" + serverSessionPool + ":" + "MaxMessages=" + n);
        this._unsupported("createConnectionConsumer():");
        return null;
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        JMSService.SessionAckMode sessionAckMode;
        long l;
        boolean bl2;
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createQueueSession():" + "isTransacted=" + bl + ":" + "acknowledgeMode=" + n);
        this._checkIfClosed("createQueueSession():");
        this.setUsed();
        if (ResourceAdapter._isFixCR6760301()) {
            bl2 = this.overrideTransacted(bl);
            int n2 = this.overrideAcknowledgeMode(n);
            l = this._createSessionId(this.connectionId, bl2, n2);
            sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl2, n2);
        } else {
            bl2 = this.isManaged() ? false : bl;
            l = this._createSessionId(this.connectionId, bl2, n);
            sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl2, n);
        }
        DirectQueueSession directQueueSession = new DirectQueueSession(this, this.jmsservice, l, sessionAckMode);
        this.addSession(directQueueSession);
        return directQueueSession;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createConnectionConsumer():" + "Topic=" + topic + ":" + "MessageSelector=" + string + ":" + "ServerSessionPool=" + serverSessionPool + ":" + "MaxMessages=" + n);
        this._unsupported("createConnectionConsumer():");
        return null;
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        JMSService.SessionAckMode sessionAckMode;
        long l;
        boolean bl2;
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "createTopicSession():" + "isTransacted=" + bl + ":" + "acknowledgeMode=" + n);
        this._checkIfClosed("createTopicSession():");
        this.setUsed();
        if (ResourceAdapter._isFixCR6760301()) {
            bl2 = this.overrideTransacted(bl);
            int n2 = this.overrideAcknowledgeMode(n);
            l = this._createSessionId(this.connectionId, bl2, n2);
            sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl2, n2);
        } else {
            bl2 = this.isManaged() ? false : bl;
            l = this._createSessionId(this.connectionId, bl2, n);
            sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl2, n);
        }
        DirectTopicSession directTopicSession = new DirectTopicSession(this, this.jmsservice, l, sessionAckMode);
        this.addSession(directTopicSession);
        return directTopicSession;
    }

    public String _getClientID() {
        return this.clientID;
    }

    public void _setClientID(String string) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "_setClientID():" + "clientID=" + string);
        if (this.clientID != null) {
            String string2 = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "_setclientID():" + "Error to overwrite existing clientID:" + this.clientID + "with new clientID=" + string;
            _loggerJC.warning(string2);
            throw new JMSException(string2);
        }
        if (string == null || "".equals(string)) {
            String string3 = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "_setclientID():" + "Error to set a null or empty clientID:" + string;
            _loggerJC.warning(string3);
            throw new JMSException(string3);
        }
        try {
            _loggerJC.finer("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "_setClientID():" + "jmsservice.clientId():" + "params=" + string + ":" + this.dcf.isRAClustered() + ":" + this.dcf.getRANamespace());
            this.jmsservice.setClientId(this.connectionId, string, this.dcf.isRAClustered(), this.dcf.getRANamespace());
            this.clientID = string;
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "_setClientID():" + "JMSService.setClientId():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    public void _unsetClientID() throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "_unsetClientID():");
        if (this.clientID == null) {
            return;
        }
        try {
            _loggerJC.finer("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "_unsetClientID():" + "jmsservice.unclientId():");
            this.jmsservice.unsetClientId(this.connectionId);
            this.clientID = null;
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "_unsetClientID():" + "JMSService.unsetClientId():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    public void _setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        _loggerJC.fine("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "_setExceptionListener()");
        this.exceptionListener = exceptionListener;
    }

    protected synchronized DirectXAResource _getXAResource() {
        if (this.xar == null) {
            this.xar = new DirectXAResource(this, this.jmsservice, this.connectionId);
        }
        return this.xar;
    }

    protected JMSService _getJMSService() {
        return this.jmsservice;
    }

    protected synchronized void _activate(String string) throws JMSException {
        if (this.isManaged) {
            if (string != null && !"".equals(string)) {
                this._setClientID(string);
            }
            this.isPooled = false;
            this.isClosed = false;
        }
    }

    protected synchronized void _cleanup() throws JMSException {
        if (this.isManaged) {
            this.isPooled = true;
            this.isUsed = false;
            this._unsetClientID();
        }
    }

    protected synchronized void _destroy() throws JMSException {
        if (!this.isClosed) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "_destroy():" + "called on a connection that was not closed.");
        }
        if (this.isManaged) {
            this.isPooled = false;
        }
        try {
            this.jmsservice.destroyConnection(this.connectionId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "_close():" + "JMSService.destroyConnection():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    protected void _stop() throws JMSException {
        this._checkIfClosed("stop():");
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this._stopSessions();
        try {
            _loggerJC.finer("MQJMSRA_DC1101: connectionId=" + this.connectionId + ":" + "stop():" + "jmsservice.stopConnection():" + "connectionId=" + this.connectionId);
            this.jmsservice.stopConnection(this.connectionId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "stop():" + "JMSService.stopConnection():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    private long _createSessionId(long l, boolean bl, int n) throws JMSException {
        long l2 = 0L;
        JMSService.SessionAckMode sessionAckMode = DirectConnection._getSessionAckModeFromSessionParams(bl, n);
        try {
            JMSServiceReply jMSServiceReply = this.jmsservice.createSession(l, sessionAckMode);
            try {
                l2 = jMSServiceReply.getJMQSessionID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = "MQJMSRA_DC4001: JMSServiceException:Missing JMQSessionID";
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJC.severe(string);
                throw jMSException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case BAD_REQUEST: {
                    string = "invalid acknowledgment mode.";
                    break;
                }
                case NOT_ALLOWED: {
                    string = "acknowledgmentmode is not allowed.";
                    break;
                }
                default: {
                    string = "unkown JMSService server error.";
                }
            }
            String string2 = "createSession on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + l + " due to " + string;
            _loggerJC.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)jMSServiceException);
            throw jMSException;
        }
        return l2;
    }

    private void _checkIfClosed(String string) throws JMSException {
        if (this.isClosed()) {
            String string2 = _lgrMID_EXC + string + "Connection is closed:Id=" + this.connectionId;
            _loggerJC.warning(string2);
            throw new IllegalStateException(string2);
        }
    }

    private void _checkUsed(String string) throws JMSException {
        if (this.isUsed()) {
            String string2 = _lgrMID_EXC + string + "Operation disallowed:Connection has been used:Id=" + this.connectionId;
            _loggerJC.warning(string2);
            throw new JMSException(string2);
        }
    }

    private void _unsupported(String string) throws JMSException {
        String string2 = "MQJMSRA_DC2001: Unsupported:" + string + ":inACC=" + this.inACC + ":connectionId=" + this.connectionId;
        _loggerJC.warning(string2);
        throw new JMSException(string2);
    }

    private synchronized void setUsed() {
        this.isUsed = true;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public synchronized boolean isPooled() {
        return this.isPooled;
    }

    public synchronized boolean isEnlisted() {
        return this.isEnlisted;
    }

    public synchronized boolean isManaged() {
        return this.isManaged;
    }

    public synchronized void setManaged(boolean bl, ManagedConnection managedConnection) {
        this.isManaged = bl;
        this.mc = managedConnection;
    }

    public synchronized void setEnlisted(boolean bl) {
        this.isEnlisted = bl;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isStopped() {
        return this.isStopped;
    }

    public synchronized boolean isStarted() {
        return !this.isStopped;
    }

    public synchronized boolean isUsed() {
        return this.isUsed;
    }

    protected static JMSService.SessionAckMode _getSessionAckModeFromSessionParams(boolean bl, int n) {
        JMSService.SessionAckMode sessionAckMode = JMSService.SessionAckMode.UNSPECIFIED;
        sessionAckMode = bl ? JMSService.SessionAckMode.TRANSACTED : (n == 1 ? JMSService.SessionAckMode.AUTO_ACKNOWLEDGE : (n == 2 ? JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE : (n == 32768 ? JMSService.SessionAckMode.NO_ACKNOWLEDGE : JMSService.SessionAckMode.DUPS_OK_ACKNOWLEDGE)));
        return sessionAckMode;
    }

    protected void addSession(DirectSession directSession) {
        this.sessions.add(directSession);
        this.ds = directSession;
    }

    protected void removeSession(DirectSession directSession) {
        boolean bl = this.sessions.remove(directSession);
        assert (bl);
        this.ds = null;
    }

    protected void addDurableConsumer(DirectConsumer directConsumer) {
        this.durable_consumers.add(directConsumer);
    }

    protected void removeDurableConsumer(DirectConsumer directConsumer) {
        boolean bl = this.durable_consumers.remove(directConsumer);
    }

    protected Vector<DirectConsumer> _getDurableConsumers() {
        return this.durable_consumers;
    }

    protected void _createDestination(Destination destination) throws JMSException {
        try {
            this.jmsservice.createDestination(this.connectionId, destination);
        }
        catch (JMSServiceException jMSServiceException) {
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            String string = null;
            switch (status) {
                case FORBIDDEN: {
                    string = "client unauthorized for create.";
                    break;
                }
                case ERROR: {
                    string = "unkown JMSService server error.";
                    break;
                }
                default: {
                    string = "status =" + status;
                }
            }
            String string2 = "createDestination on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and Destination:" + (Object)((Object)destination.getType()) + ":" + destination.getName() + ":due to " + string;
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)jMSServiceException);
            if (status != JMSServiceReply.Status.CONFLICT) {
                _loggerJC.severe(string2);
                throw jMSException;
            }
            _loggerJC.fine(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteDestination(TemporaryDestination temporaryDestination, Destination destination) throws JMSException {
        JMSException jMSException = null;
        String string = null;
        try {
            try {
                this.jmsservice.destroyDestination(this.connectionId, destination);
            }
            catch (JMSServiceException jMSServiceException) {
                JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
                switch (status) {
                    case FORBIDDEN: {
                        string = "client unauthorized for delete.";
                        break;
                    }
                    case NOT_FOUND: {
                        string = "destination does not exist.";
                        break;
                    }
                    case CONFLICT: {
                        string = "destination has producers or consumers.";
                        break;
                    }
                    default: {
                        string = "unkown JMSService server error.";
                    }
                }
                String string2 = "destroyDestination on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and Destination:" + (Object)((Object)destination.getType()) + ":" + destination.getName() + ":due to " + string;
                jMSException = new JMSException(string2);
                jMSException.initCause((Throwable)jMSServiceException);
                _loggerJC.warning(string2);
                Object var10_6 = null;
            }
            Object var10_5 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            throw throwable;
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    protected long _startTransaction(String string) throws JMSException {
        JMSServiceReply jMSServiceReply = null;
        long l = 0L;
        try {
            jMSServiceReply = this.jmsservice.startTransaction(this.connectionId, 0L, null, 0, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                l = jMSServiceReply.getJMQTransactionID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string2 = "MQJMSRA_DC4001: :_startTransaction from " + string + ":JMSServiceException:Missing JMQTransactionID";
                JMSException jMSException = new JMSException(string2);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJC.severe(string2);
                throw jMSException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string3 = "MQJMSRA_DC4001: :_startTransaction from " + string + "JMSServiceException=" + jMSServiceException.getMessage();
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)jMSServiceException);
            _loggerJC.severe(string3);
            throw jMSException;
        }
        return l;
    }

    protected void _commitTransaction(String string, long l) throws JMSException {
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.commitTransaction(this.connectionId, l, null, 0);
        }
        catch (JMSServiceException jMSServiceException) {
            String string2 = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + string + ":JMSServiceException=" + jMSServiceException.getMessage();
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)jMSServiceException);
            _loggerJC.severe(string2);
            throw jMSException;
        }
    }

    protected void _rollbackTransaction(String string, long l) throws JMSException {
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.rollbackTransaction(this.connectionId, l, null, true, true);
        }
        catch (JMSServiceException jMSServiceException) {
            String string2 = "MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + string + ":JMSServiceException=" + jMSServiceException.getMessage();
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)jMSServiceException);
            _loggerJC.severe(string2);
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextTemporaryDestinationId() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.temporaryDestinationId;
            return this.temporaryDestinationId;
        }
    }

    protected String _getConnectionIdentifierForTemporaryDestination() {
        StringBuilder stringBuilder;
        try {
            stringBuilder = new StringBuilder(InetAddress.getLocalHost().getHostAddress());
        }
        catch (Exception exception) {
            stringBuilder = new StringBuilder("127.0.0.1");
        }
        if (this.clientID != null) {
            stringBuilder.append(":" + this.clientID);
        }
        stringBuilder.append("/" + this.connectionId);
        return stringBuilder.toString();
    }

    protected void addTemporaryDestination(TemporaryDestination temporaryDestination) {
        this.tmp_destinations.add(temporaryDestination);
    }

    protected void removeTemporaryDestination(TemporaryDestination temporaryDestination) {
        boolean bl = this.tmp_destinations.remove(temporaryDestination);
        assert (bl);
    }

    protected boolean _hasTemporaryDestination(TemporaryDestination temporaryDestination) {
        return this.tmp_destinations.contains(temporaryDestination);
    }

    protected boolean _hasConsumers(TemporaryDestination temporaryDestination) {
        return temporaryDestination._getConsumerCount() > 0;
    }

    private void _startSessions() {
        DirectSession directSession2 = null;
        for (DirectSession directSession2 : this.sessions) {
            directSession2._start();
        }
    }

    private void _stopSessions() {
        DirectSession directSession2 = null;
        for (DirectSession directSession2 : this.sessions) {
            directSession2._stop();
        }
    }

    private void _closeAndClearSessions() {
        DirectSession directSession = null;
        Iterator<DirectSession> iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            directSession = iterator.next();
            try {
                directSession._close();
                iterator.remove();
            }
            catch (JMSException jMSException) {
                _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "close_session:" + "sessionId:" + directSession.getSessionId() + ":JMSException=" + jMSException.getMessage());
            }
        }
        this.sessions.clear();
    }

    protected void _deleteTemporaryDestinations() throws JMSException {
        TemporaryDestination temporaryDestination = null;
        Iterator<TemporaryDestination> iterator = this.tmp_destinations.iterator();
        while (iterator.hasNext()) {
            temporaryDestination = iterator.next();
            try {
                temporaryDestination._delete();
                iterator.remove();
            }
            catch (JMSException jMSException) {
                _loggerJC.warning("MQJMSRA_DC2001: connectionId=" + this.connectionId + ":" + "delete_temporary_destination=" + temporaryDestination.getName() + ":JMSException=" + jMSException.getMessage());
            }
        }
        this.tmp_destinations.clear();
    }

    protected void _incrementTemporaryDestinationUsage(TemporaryDestination temporaryDestination) throws JMSException {
        temporaryDestination._incrementConsumerCount();
    }

    protected void _decrementTemporaryDestinationUsage(TemporaryDestination temporaryDestination) throws JMSException {
        temporaryDestination._decrementConsumerCount();
    }

    public void deleteTemporaryDestinationsIfClosed() throws JMSException {
        if (this.isClosed) {
            this._deleteTemporaryDestinations();
        }
    }
}

