/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerErrorEvent;
import com.sun.messaging.jmq.admin.apps.console.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.AdminMQAddress;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.MessageAckThread;
import com.sun.messaging.jmq.admin.bkrutil.SSLAdminMQAddress;
import com.sun.messaging.jmq.admin.util.CommonGlobals;
import com.sun.messaging.jmq.io.MQAddress;
import java.io.EOFException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public abstract class BrokerAdminConn
implements ExceptionListener {
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWD = "admin";
    public static long defaultTimeout = 10000L;
    public static int defaultNumRetries = 5;
    public static final int RECONNECT_RETRIES = 5;
    public static final long RECONNECT_DELAY = 5000L;
    private String key = null;
    private String username;
    private String passwd;
    private int numRetries;
    private QueueConnectionFactory qcf;
    private QueueConnection connection;
    private Queue requestQueue;
    protected long timeout;
    protected static boolean debug = false;
    protected QueueSession session;
    protected TemporaryQueue replyQueue;
    protected QueueSender sender;
    protected QueueReceiver receiver;
    protected boolean isConnected = false;
    private MQAddress address = null;
    private boolean checkShutdownReply = true;
    private static final String[] savedQCFProperties = new String[]{"imqBrokerHostName", "imqBrokerHostPort"};
    private boolean adminKeyUsed = false;
    private boolean sslTransportUsed = false;
    private boolean isInitiator = false;
    private boolean isReconnect = false;
    private Vector eListeners = new Vector();
    private MessageAckThread msgAckThread = null;
    private boolean busy = false;

    public BrokerAdminConn(String string, int n) throws BrokerAdminException {
        this(string, n, null, null, -1L, false, -1, -1L);
    }

    public BrokerAdminConn(String string, int n, String string2, String string3) throws BrokerAdminException {
        this(string, n, string2, string3, -1L, false, -1, -1L);
    }

    public BrokerAdminConn(String string, int n, String string2, String string3, int n2) throws BrokerAdminException {
        this(string, n, string2, string3, n2, false, -1, -1L);
    }

    public BrokerAdminConn(String string, String string2, String string3, int n, boolean bl) throws BrokerAdminException {
        this(string, string2, string3, n, false, -1, -1L, bl);
    }

    public BrokerAdminConn(String string, int n, String string2, String string3, long l, boolean bl, int n2, long l2) throws BrokerAdminException {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("imqBrokerHostName", string);
        }
        if (n > 0) {
            properties.setProperty("imqBrokerHostPort", String.valueOf(n));
        }
        if (bl) {
            properties.setProperty("imqReconnectEnabled", String.valueOf(bl));
            properties.setProperty("imqReconnectAttempts", String.valueOf(n2));
            properties.setProperty("imqReconnectInterval", String.valueOf(l2));
        }
        this.timeout = l >= 0L ? l : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = string2;
        this.passwd = string3;
        this.createFactory(properties);
    }

    public BrokerAdminConn(String string, String string2, String string3, long l, boolean bl, int n, long l2, boolean bl2) throws BrokerAdminException {
        Properties properties = new Properties();
        if (string == null) {
            string = "";
        }
        try {
            this.address = bl2 ? SSLAdminMQAddress.createAddress(string) : AdminMQAddress.createAddress(string);
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(16);
            brokerAdminException.setBrokerAddress(string);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        properties.setProperty("imqAddressList", this.address.toString());
        if (bl) {
            properties.setProperty("imqReconnectEnabled", String.valueOf(bl));
            properties.setProperty("imqReconnectAttempts", String.valueOf(n));
            properties.setProperty("imqReconnectInterval", String.valueOf(l2));
        }
        this.timeout = l >= 0L ? l : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = string2;
        this.passwd = string3;
        this.createFactory(properties);
    }

    public BrokerAdminConn(Properties properties, String string, String string2, long l) throws BrokerAdminException {
        this.timeout = l >= 0L ? l : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = string;
        this.passwd = string2;
        this.createFactory(properties);
    }

    public void setBrokerHost(String string) throws BrokerAdminException {
        try {
            this.setFactoryAttr("imqBrokerHostName", string);
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(9);
            brokerAdminException.setBadValue(string);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
    }

    public String getBrokerAddress() {
        if (this.address != null) {
            return this.address.toString();
        }
        return this.getFactoryAttr("imqAddressList");
    }

    public String getBrokerHost() {
        if (this.address != null) {
            return this.address.getHostName();
        }
        return this.getFactoryAttr("imqBrokerHostName");
    }

    public void setBrokerPort(String string) throws BrokerAdminException {
        try {
            this.setFactoryAttr("imqBrokerHostPort", string);
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(10);
            brokerAdminException.setBadValue(string);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
    }

    public String getBrokerPort() {
        if (this.address != null) {
            return new Integer(this.address.getPort()).toString();
        }
        return this.getFactoryAttr("imqBrokerHostPort");
    }

    public static void setDefaultTimeout(long l) {
        defaultTimeout = l;
        if (debug) {
            CommonGlobals.stdOutPrintln("BrokerAdminConn defaultTimeout set to: " + defaultTimeout);
        }
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static void setDefaultNumRetries(int n) {
        defaultNumRetries = n;
        if (debug) {
            CommonGlobals.stdOutPrintln("BrokerAdminConn defaultNumRetries set to: " + defaultNumRetries);
        }
    }

    public static long getDefaultNumRetries() {
        return defaultNumRetries;
    }

    public void setNumRetries(int n) {
        this.numRetries = n;
        if (debug) {
            CommonGlobals.stdOutPrintln("BrokerAdminConn num retries set to: " + this.numRetries);
        }
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String string) {
        this.passwd = string;
    }

    public String getPassword() {
        return this.passwd;
    }

    protected void setBusy(boolean bl) {
        this.busy = bl;
        if (debug) {
            CommonGlobals.stdOutPrintln("***** BrokerAdminConn.setBusy(): " + bl);
        }
        if (!bl && this.msgAckThread != null) {
            this.msgAckThread = null;
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    protected void checkIfBusy() throws BrokerAdminException {
        if (this.isBusy()) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(13);
            brokerAdminException.setBrokerAdminConn(this);
            throw brokerAdminException;
        }
    }

    public void setAdminKeyUsed(boolean bl) {
        this.adminKeyUsed = bl;
    }

    public boolean getAdminKeyUsed() {
        return this.adminKeyUsed;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        return this.getBrokerHost() + ":" + this.getBrokerPort();
    }

    public void setSSLTransportUsed(boolean bl) {
        this.sslTransportUsed = bl;
    }

    public boolean getSSLTransportUsed() {
        return this.sslTransportUsed;
    }

    public void setInitiator(boolean bl) {
        this.isInitiator = bl;
    }

    private boolean isInitiator() {
        return this.isInitiator;
    }

    public void setCheckShutdownReply(boolean bl) {
        this.checkShutdownReply = bl;
    }

    public void setReconnect(boolean bl) {
        this.isReconnect = bl;
    }

    public boolean isReconnect() {
        return this.isReconnect;
    }

    public Properties getBrokerAttrs() {
        Properties properties = new Properties();
        if (this.qcf == null) {
            return properties;
        }
        for (int i = 0; i < savedQCFProperties.length; ++i) {
            String string = savedQCFProperties[i];
            String string2 = this.getFactoryAttr(string);
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public void connect() throws BrokerAdminException {
        this.connect(null, null, false);
    }

    public void connect(String string, String string2) throws BrokerAdminException {
        this.connect(string, string2, true);
    }

    private void connect(String string, String string2, boolean bl) throws BrokerAdminException {
        try {
            if (this.adminKeyUsed) {
                this.qcf.setConnectionType("ADMINKEY");
            }
            if (this.sslTransportUsed) {
                try {
                    this.qcf.setProperty("imqConnectionType", "SSL");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.setFactoryAttr("imqConnectionType", "SSL");
                }
                catch (JMSException jMSException) {
                    BrokerAdminException brokerAdminException = new BrokerAdminException(15);
                    brokerAdminException.setBrokerHost(this.getBrokerHost());
                    brokerAdminException.setBrokerPort(this.getBrokerPort());
                    brokerAdminException.setLinkedException((Exception)((Object)jMSException));
                    throw brokerAdminException;
                }
            }
            if (debug) {
                this.printObjProperties(this.qcf);
            }
            this.connection = bl ? this.qcf.createQueueConnection(string, string2) : this.qcf.createQueueConnection(this.username, this.passwd);
            this.connection.setExceptionListener((ExceptionListener)this);
            this.connection.start();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Creating queue connection");
            }
            this.session = this.connection.createQueueSession(false, 2);
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Creating queue session: not transacted, auto ack");
            }
            this.requestQueue = this.session.createQueue(this.getAdminQueueDest());
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created requestQueue: " + this.requestQueue);
            }
            this.replyQueue = this.session.createTemporaryQueue();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created replyQueue: " + this.replyQueue);
            }
            this.sender = this.session.createSender(this.requestQueue);
            this.sender.setDeliveryMode(1);
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created a sender: " + this.sender);
            }
            this.receiver = this.session.createReceiver((Queue)this.replyQueue);
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Created a receiver: " + this.receiver);
            }
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException;
            if (jMSException instanceof JMSSecurityException) {
                String string3 = jMSException.getErrorCode();
                brokerAdminException = "C4060".equals(string3) ? new BrokerAdminException(11) : new BrokerAdminException(12);
            } else {
                brokerAdminException = new BrokerAdminException(0);
            }
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            throw brokerAdminException;
        }
    }

    public abstract String getAdminQueueDest();

    public abstract String getAdminMessagePropNameMessageType();

    public abstract String getAdminMessagePropNameErrorString();

    public abstract String getAdminMessagePropNameStatus();

    public abstract int getAdminMessageStatusOK();

    public abstract int getAdminMessageTypeSHUTDOWN_REPLY();

    public abstract CommonCmdStatusEvent newCommonCmdStatusEvent(int var1);

    public abstract CommonCmdStatusEvent getCurrentStatusEvent();

    public abstract void clearStatusEvent();

    private void printObjProperties(AdministeredObject administeredObject) {
        CommonGlobals.stdOutPrintln("Connection Factory Object properties:");
        Properties properties = administeredObject.getConfiguration();
        Enumeration enumeration = administeredObject.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            try {
                string = administeredObject.getPropertyLabel(string2);
            }
            catch (Exception exception) {
                string = "UNKNOWN";
            }
            String string4 = string2 + " [" + string + "]";
            CommonGlobals.stdOutPrintln("\t" + string4 + " = " + string3);
        }
        CommonGlobals.stdOutPrintln("");
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    private String getErrorMessage(Message message) {
        String string;
        block4: {
            string = null;
            try {
                string = message.getStringProperty(this.getAdminMessagePropNameErrorString());
            }
            catch (JMSException jMSException) {
                if (debug) {
                    CommonGlobals.stdErrPrint("Failed to retrieve the error message: ");
                    CommonGlobals.stdErrPrintln(jMSException.getMessage());
                    jMSException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (!debug) break block4;
                CommonGlobals.stdErrPrintln("Exception caught: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return string;
    }

    public void forceClose() {
        try {
            this.connection.close();
            this.isConnected = false;
        }
        catch (JMSException jMSException) {
            CommonGlobals.stdErrPrintln("JMSException caught: " + jMSException.getMessage());
            jMSException.printStackTrace();
        }
    }

    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            if (this.msgAckThread != null) {
                this.msgAckThread.stop();
                this.msgAckThread = null;
                if (debug) {
                    CommonGlobals.stdOutPrintln("***** Stopped msgAckThread thread...");
                }
            }
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closing sender and receiver...");
            }
            this.sender.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed sender.");
            }
            this.receiver.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed receiver.");
            }
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closing queue session and queue connection...");
            }
            this.session.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed session.");
            }
        }
        catch (JMSException jMSException) {
            CommonGlobals.stdErrPrintln("JMSException caught: " + jMSException.getMessage());
            jMSException.printStackTrace();
        }
        catch (Exception exception) {
            CommonGlobals.stdErrPrintln("Exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            this.connection.close();
            if (debug) {
                CommonGlobals.stdOutPrintln("***** Closed connection.");
            }
            this.isConnected = false;
            this.setBusy(false);
        }
        catch (JMSException jMSException) {
            if (this.sslTransportUsed) {
                this.isConnected = false;
                this.setBusy(false);
            } else {
                CommonGlobals.stdErrPrintln("JMSException caught: " + jMSException.getMessage());
                jMSException.printStackTrace();
            }
        }
        catch (Exception exception) {
            if (this.sslTransportUsed) {
                this.isConnected = false;
                this.setBusy(false);
            }
            CommonGlobals.stdErrPrintln("Exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void setFactoryAttr(String string, String string2) throws JMSException {
        if (this.qcf == null) {
            return;
        }
        this.qcf.setProperty(string, string2);
    }

    private String getFactoryAttr(String string) {
        String string2;
        if (this.qcf == null) {
            return null;
        }
        try {
            string2 = this.qcf.getProperty(string);
        }
        catch (JMSException jMSException) {
            string2 = null;
        }
        return string2;
    }

    private void createFactory(Properties properties) throws BrokerAdminException {
        this.qcf = new QueueConnectionFactory();
        try {
            this.qcf.setConnectionType("ADMIN");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string2 == null) continue;
                this.qcf.setProperty(string, string2);
            }
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            throw brokerAdminException;
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            throw brokerAdminException;
        }
        if (debug) {
            CommonGlobals.stdOutPrintln("***** BrokerAdminConn instance: " + this.getKey());
            CommonGlobals.stdOutPrintln("BrokerAdminConn created with timeout set to: " + this.timeout / 1000L + " seconds");
            CommonGlobals.stdOutPrintln("BrokerAdminConn created with num retries set to: " + this.numRetries);
        }
    }

    protected Message receiveCheckMessageTimeout(boolean bl) throws BrokerAdminException {
        return this.receiveCheckMessageTimeout(bl, true);
    }

    protected Message receiveCheckMessageTimeout(boolean bl, boolean bl2) throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        long l = this.timeout;
        int n = 0;
        try {
            while (n <= this.numRetries && (objectMessage = (ObjectMessage)this.receiver.receive(l)) == null) {
                if (bl) {
                    this.isConnected = false;
                    break;
                }
                l += this.timeout;
                if (++n <= this.numRetries) {
                    CommonCmdStatusEvent commonCmdStatusEvent = this.newCommonCmdStatusEvent(10000);
                    commonCmdStatusEvent.setNumRetriesAttempted(n);
                    commonCmdStatusEvent.setMaxNumRetries(this.numRetries);
                    commonCmdStatusEvent.setRetryTimeount(l / 1000L);
                    this.fireAdminEventDispatched(commonCmdStatusEvent);
                    continue;
                }
                this.msgAckThread = new MessageAckThread(this);
                this.msgAckThread.start();
                BrokerAdminException brokerAdminException = bl2 ? new BrokerAdminException(6) : new BrokerAdminException(14);
                throw brokerAdminException;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return objectMessage;
    }

    protected void checkReplyTypeStatus(Message message, int n, String string) throws BrokerAdminException {
        int n2;
        int n3;
        if (message == null && this.checkShutdownReply && n == this.getAdminMessageTypeSHUTDOWN_REPLY()) {
            this.isConnected = false;
            return;
        }
        try {
            n3 = message.getIntProperty(this.getAdminMessagePropNameMessageType());
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(4);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
        try {
            n2 = message.getIntProperty(this.getAdminMessagePropNameStatus());
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(5);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
        if (debug) {
            CommonGlobals.stdOutPrintln("\tReplyMsgType=" + n3 + "(expecting " + n + "[" + string + "]), ReplyStatus=" + n2);
        }
        if (n == n3 && n2 == this.getAdminMessageStatusOK()) {
            if (n == this.getAdminMessageTypeSHUTDOWN_REPLY()) {
                this.isConnected = false;
            }
            return;
        }
        String string2 = this.getErrorMessage(message);
        if (debug) {
            CommonGlobals.stdOutPrintln("\tJMQ_ERROR_STRING=" + string2);
        }
        BrokerAdminException brokerAdminException = new BrokerAdminException(2);
        brokerAdminException.setBrokerErrorStr(string2);
        brokerAdminException.setReplyMsgType(n3);
        brokerAdminException.setReplyStatus(n2);
        brokerAdminException.setReplyMsg(message);
        throw brokerAdminException;
    }

    protected void handleSendExceptions(Exception exception) throws BrokerAdminException {
        if (exception instanceof BrokerAdminException) {
            throw (BrokerAdminException)exception;
        }
        if (exception instanceof JMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(1);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        BrokerAdminException brokerAdminException = new BrokerAdminException(1);
        brokerAdminException.setLinkedException(exception);
        throw brokerAdminException;
    }

    protected void handleReceiveExceptions(Exception exception) throws BrokerAdminException {
        if (exception instanceof BrokerAdminException) {
            throw (BrokerAdminException)exception;
        }
        if (exception instanceof JMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(2);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        BrokerAdminException brokerAdminException = new BrokerAdminException(2);
        brokerAdminException.setLinkedException(exception);
        throw brokerAdminException;
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.eListeners.addElement(adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.eListeners.removeElement(adminEventListener);
    }

    public void removeAllAdminEventListeners() {
        this.eListeners.removeAllElements();
    }

    public void fireAdminEventDispatched(AdminEvent adminEvent) {
        for (int i = 0; i < this.eListeners.size(); ++i) {
            ((AdminEventListener)this.eListeners.elementAt(i)).adminEventDispatched(adminEvent);
        }
    }

    protected void sendStatusEvent(Message message, Exception exception) {
        if (this.getCurrentStatusEvent() != null) {
            if (message == null) {
                this.getCurrentStatusEvent().setSuccess(false);
                this.getCurrentStatusEvent().setLinkedException(exception);
            } else {
                try {
                    this.checkReplyTypeStatus(message, this.getCurrentStatusEvent().getReplyType(), this.getCurrentStatusEvent().getReplyTypeString());
                    if (message instanceof ObjectMessage) {
                        try {
                            this.getCurrentStatusEvent().setReturnedObject(((ObjectMessage)message).getObject());
                        }
                        catch (JMSException jMSException) {
                            this.getCurrentStatusEvent().setSuccess(false);
                            this.getCurrentStatusEvent().setLinkedException((Exception)((Object)jMSException));
                        }
                    }
                    this.getCurrentStatusEvent().setSuccess(true);
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.getCurrentStatusEvent().setSuccess(false);
                    this.getCurrentStatusEvent().setLinkedException(brokerAdminException);
                }
            }
            this.fireAdminEventDispatched(this.getCurrentStatusEvent());
            this.clearStatusEvent();
        }
    }

    public void onException(JMSException jMSException) {
        BrokerErrorEvent brokerErrorEvent = null;
        this.isConnected = false;
        if ("C4056" == jMSException.getErrorCode()) {
            if (!this.isInitiator()) {
                brokerErrorEvent = new BrokerErrorEvent(this, 1);
                brokerErrorEvent.setBrokerHost(this.getBrokerHost());
                brokerErrorEvent.setBrokerPort(this.getBrokerPort());
                brokerErrorEvent.setBrokerName(this.getKey());
            }
        } else if (jMSException.getLinkedException() instanceof EOFException) {
            brokerErrorEvent = new BrokerErrorEvent(this, 0);
            brokerErrorEvent.setBrokerHost(this.getBrokerHost());
            brokerErrorEvent.setBrokerPort(this.getBrokerPort());
            brokerErrorEvent.setBrokerName(this.getKey());
        } else {
            brokerErrorEvent = new BrokerErrorEvent(this, 2);
            brokerErrorEvent.setBrokerHost(this.getBrokerHost());
            brokerErrorEvent.setBrokerPort(this.getBrokerPort());
            brokerErrorEvent.setBrokerName(this.getKey());
        }
        if (brokerErrorEvent != null) {
            this.fireAdminEventDispatched(brokerErrorEvent);
        }
        this.removeAllAdminEventListeners();
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean getDebug() {
        return debug;
    }
}

