/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import java.util.Hashtable;

public class TakeoverHandler
extends AdminCmdHandler {
    private static boolean DEBUG = TakeoverHandler.getDEBUG();

    public TakeoverHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        BrokerStateHandler brokerStateHandler;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Taking over broker: " + hashtable);
        }
        String string = (String)hashtable.get("JMQBrokerID");
        int n = 200;
        String string2 = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n = 500;
            string2 = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string2);
        } else {
            this.logger.log(8, "B1190", (Object)string);
            try {
                brokerStateHandler = Globals.getBrokerStateHandler();
                brokerStateHandler.takeoverBroker(string, null, true);
            }
            catch (Exception exception) {
                this.logger.logStack(32, Globals.getBrokerResources().getKString("B3231", string, exception.getMessage()), (Throwable)exception);
                n = 500;
                string2 = exception.toString();
            }
        }
        brokerStateHandler = new Packet(iMQConnection.useDirectBuffers());
        brokerStateHandler.setPacketType(5);
        TakeoverHandler.setProperties((Packet)brokerStateHandler, 77, n, string2);
        this.parent.sendReply(iMQConnection, packet, (Packet)brokerStateHandler);
        return true;
    }
}

