/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterReplicationGroupInfo
implements ClusterProtocolHelper {
    protected Logger logger = Globals.getLogger();
    private String groupName = null;
    private String nodeName = null;
    private String masterHostPort = null;
    private Integer replicaPort = null;
    private Cluster c = null;
    private GPacket pkt = null;

    private ClusterReplicationGroupInfo(String string, String string2, String string3, Integer n, Cluster cluster) {
        this.groupName = string;
        this.nodeName = string2;
        this.masterHostPort = string3;
        this.replicaPort = n;
        this.c = cluster;
    }

    private ClusterReplicationGroupInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterReplicationGroupInfo newInstance(String string, String string2, String string3, Integer n, Cluster cluster) {
        return new ClusterReplicationGroupInfo(string, string2, string3, n, cluster);
    }

    public static ClusterReplicationGroupInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterReplicationGroupInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)55);
        gPacket.putProp((Object)"groupName", (Object)this.groupName);
        gPacket.putProp((Object)"nodeName", (Object)this.nodeName);
        gPacket.putProp((Object)"masterHostPort", (Object)this.masterHostPort);
        gPacket.putProp((Object)"replicaPort", (Object)this.replicaPort);
        gPacket.putProp((Object)"clusterid", (Object)Globals.getClusterID());
        gPacket.putProp((Object)"TS", (Object)new Long(System.currentTimeMillis()));
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        gPacket.setBit(1, false);
        return gPacket;
    }

    public String getGroupName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"groupName");
    }

    public String getNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"nodeName");
    }

    public String getMasterHostPort() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"masterHostPort");
    }

    public Integer getReplicaPort() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp((Object)"replicaPort");
    }

    public String getClusterID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"clusterid");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public void sendReply(BrokerAddress brokerAddress, int n, String string, Object object) {
    }

    public String toString() {
        if (this.pkt == null) {
            return "[" + this.groupName + "[" + this.nodeName + ", " + this.masterHostPort + "]" + this.replicaPort + "]";
        }
        return "[" + this.getGroupName() + "[" + this.getNodeName() + ", " + this.getMasterHostPort() + "]" + this.getReplicaPort() + ", " + this.getTimestamp() + "]";
    }
}

