/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.LongTupleBinding;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigRecordStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private BDBStore parent = null;
    private Database db = null;
    private TupleBinding longBinding = null;

    protected ConfigRecordStore(BDBStore bDBStore) {
        this.parent = bDBStore;
        this.db = bDBStore.getConfigRecordDatabase();
        this.longBinding = new LongTupleBinding();
    }

    protected void storeConfigChangeRecord(Transaction transaction, long l, byte[] byArray) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.longBinding.objectToEntry((Object)l, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray);
            OperationStatus operationStatus = this.db.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B4083", String.valueOf(l) + ": Timestamp already exist");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            String string = this.br.getKString("B4083", String.valueOf(l) + ": " + exception.getMessage());
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(Transaction transaction, long l) throws BrokerException {
        ArrayList<ChangeRecordInfo> arrayList = new ArrayList<ChangeRecordInfo>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            Long l2 = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                l2 = (Long)this.longBinding.entryToObject(databaseEntry);
                if (l2 <= l) {
                    databaseEntry = new DatabaseEntry();
                    databaseEntry2 = new DatabaseEntry();
                    continue;
                }
                arrayList.add(new ChangeRecordInfo(databaseEntry2.getData(), l2));
            }
            cursor.close();
            ArrayList<ChangeRecordInfo> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4082") + "[" + l + "]";
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting cluster change records since timestamp " + l + " from store: " + exception.getMessage());
                }
            }
        }
    }

    public List<ChangeRecordInfo> getAllConfigRecords(Transaction transaction) throws BrokerException {
        ArrayList<ChangeRecordInfo> arrayList = new ArrayList<ChangeRecordInfo>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            Long l = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                l = (Long)this.longBinding.entryToObject(databaseEntry);
                arrayList.add(new ChangeRecordInfo(databaseEntry2.getData(), l));
            }
            cursor.close();
            ArrayList<ChangeRecordInfo> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4082");
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting cluster change records from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction transaction) throws BrokerException {
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            cursor.close();
        }
        catch (Exception exception) {
            String string = "Deleting all cluster change records failed";
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in deleting all cluster change records from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "ConfigRecordStore: closing with " + this.db.count() + " records");
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("dbCount", String.valueOf(this.db.count()));
        hashtable.put("dbConfig", this.db.getConfig().toString());
        return hashtable;
    }
}

