/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MessageEnumeration
implements Enumeration {
    Store store = null;
    Database msgdb = null;
    Packet nextPacket = null;
    Cursor cs = null;

    protected MessageEnumeration(Database database, Store store) throws BrokerException {
        this.msgdb = database;
        this.store = store;
        if (database != null) {
            try {
                this.cs = database.openCursor(null, null);
            }
            catch (Exception exception) {
                throw new BrokerException("Failed to open cursor for message enumeration of " + database.getDatabaseName());
            }
        }
    }

    public boolean hasMoreElements() {
        if (this.msgdb == null) {
            this.nextPacket = null;
            return false;
        }
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            if (this.cs.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.NOTFOUND) {
                return false;
            }
            this.nextPacket = DstMsgStore.parseMessage(databaseEntry2.getData());
        }
        catch (Throwable throwable) {
            this.nextPacket = null;
            Globals.getLogger().logStack(32, throwable.getMessage(), throwable);
            this.close();
        }
        return this.nextPacket != null;
    }

    public Object nextElement() {
        if (this.nextPacket == null) {
            throw new NoSuchElementException();
        }
        if (this.store.closed()) {
            this.close();
            throw new NoSuchElementException(Globals.getBrokerResources().getKString("B1341"));
        }
        return this.nextPacket;
    }

    public void cancel() {
        this.close();
    }

    public void close() {
        if (this.cs == null) {
            return;
        }
        try {
            this.cs.close();
        }
        catch (Exception exception) {
            Globals.getLogger().log(16, "XXX Failed to close cursor of message enumeration from " + this.msgdb.getDatabaseName() + ": " + exception.getMessage());
        }
    }
}

