/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

class ReplicationStateChangeListener
implements StateChangeListener {
    private BDBStore parent = null;
    private String nodeName = null;
    private String groupName = null;
    String master = null;
    int DEFAULT_INIT_WAIT_INTERVAL = 15000;

    public ReplicationStateChangeListener(BDBStore bDBStore, String string, String string2) {
        this.parent = bDBStore;
        this.nodeName = string;
        this.groupName = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitBecomeMaster(long l) throws Exception {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        if (l3 > (long)this.DEFAULT_INIT_WAIT_INTERVAL) {
            l3 = this.DEFAULT_INIT_WAIT_INTERVAL;
        }
        ReplicationStateChangeListener replicationStateChangeListener = this;
        synchronized (replicationStateChangeListener) {
            while (this.master == null) {
                Globals.getLogger().log(8, "Waiting for replication state change event ..");
                this.wait(l3);
                if (this.master != null) break;
                long l4 = System.currentTimeMillis();
                if (l4 >= l2) {
                    throw new BrokerException("Waiting for replication state change event timed out");
                }
                l3 = l2 - l4;
                if (l3 <= (long)this.DEFAULT_INIT_WAIT_INTERVAL) continue;
                l3 = this.DEFAULT_INIT_WAIT_INTERVAL;
            }
            if (this.master == null || !this.master.equals(this.nodeName)) {
                throw new BrokerException("Expected " + this.nodeName + " to be the replication master for replication group [" + this.groupName + "], but got master " + this.master);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChange(StateChangeEvent stateChangeEvent) {
        Logger logger = Globals.getLogger();
        ReplicatedEnvironment.State state = stateChangeEvent.getState();
        logger.log(8, "ReplicationStateChangeEvent(" + state + ") on [" + this.groupName + ", " + this.nodeName + "]");
        if (state == ReplicatedEnvironment.State.MASTER || state == ReplicatedEnvironment.State.REPLICA) {
            String string = stateChangeEvent.getMasterNodeName();
            logger.log(8, "Replication group [" + this.groupName + "] has master: " + string);
            ReplicationStateChangeListener replicationStateChangeListener = this;
            synchronized (replicationStateChangeListener) {
                this.master = string;
                this.notifyAll();
            }
        }
        if (state == ReplicatedEnvironment.State.REPLICA) {
            logger.log(8, "Becoming replica for replication group [" + this.groupName + "]");
        }
    }
}

