/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ExclusiveRequest;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.OperationNotAllowedException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;

public class MigrateStoreHandler
extends AdminCmdHandler {
    private static boolean DEBUG = MigrateStoreHandler.getDEBUG();
    public static final String MAX_WAIT_ADMIN_CLIENT_PROP = "imq.cluster.migratestore.shutdown.maxWaitAdminClient";
    private static final int DEFAULT_MAX_WAIT_ADMIN_CLIENT = 60;

    public MigrateStoreHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        block51: {
            boolean bl;
            Object object5;
            Object object2;
            ClusterManager clusterManager;
            Object object3;
            ClusterManager clusterManager2;
            BrokerStateHandler brokerStateHandler;
            String string;
            boolean bl2 = true;
            int n = 200;
            String string2 = "";
            if (DEBUG) {
                this.logger.log(8, this.getClass().getName() + ": " + "Request migrate this broker''s store: " + hashtable);
            }
            if ((string = (String)hashtable.get("JMQBrokerID")) != null) {
                this.logger.log(8, "B1394", (Object)string);
            } else {
                this.logger.log(8, "B1396");
            }
            HAMonitorService hAMonitorService = Globals.getHAMonitorService();
            if (Globals.getHAEnabled()) {
                n = 304;
                string2 = this.rb.getKString("B3285", MessageType.getString((int)98));
                this.logger.log(32, string2);
            } else if (hAMonitorService != null && hAMonitorService.inTakeover()) {
                n = 304;
                string2 = this.rb.getString("B3233");
                this.logger.log(32, this.getClass().getName() + ": " + string2);
            } else if (Globals.isJMSRAManagedBroker()) {
                n = 304;
                string2 = "Can not process migration store request because this broker's life cycle is JMSRA managed";
                this.logger.log(32, this.getClass().getName() + ": " + string2);
            } else if (string == null) {
                try {
                    string = this.getBrokerID();
                }
                catch (Throwable throwable) {
                    n = 304;
                    string2 = "Unable to get a connected broker to takeover this broker's store: " + throwable.getMessage();
                    if (throwable instanceof OperationNotAllowedException && ((OperationNotAllowedException)throwable).getOperation().equals(MessageType.getString((int)98))) {
                        this.logger.log(32, string2);
                    }
                    this.logger.logStack(32, string2, throwable);
                }
            }
            try {
                BrokerStateHandler.setExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
            }
            catch (Throwable throwable) {
                n = 412;
                if (throwable instanceof BrokerException) {
                    n = ((BrokerException)throwable).getStatusCode();
                }
                string2 = MessageType.getString((int)98) + ": " + Status.getString((int)n) + " - " + throwable.getMessage();
                this.logger.log(32, string2);
                n = 304;
            }
            try {
                Object object4;
                Long l = null;
                brokerStateHandler = Globals.getBrokerStateHandler();
                if (n == 200) {
                    try {
                        l = (Long)hashtable.get("JMQMigrateStoreSyncTimeout");
                        clusterManager2 = Globals.getClusterManager();
                        object3 = (BrokerMQAddress)clusterManager2.getMQAddress();
                        BrokerMQAddress brokerMQAddress = object4 = clusterManager2.getMasterBroker() == null ? null : (BrokerMQAddress)clusterManager2.getMasterBroker().getBrokerURL();
                        if (object3.equals(object4)) {
                            throw new BrokerException(this.rb.getKString("B3286", MessageType.getString((int)98)), 405);
                        }
                    }
                    catch (Throwable throwable) {
                        n = 412;
                        if (throwable instanceof BrokerException) {
                            n = ((BrokerException)throwable).getStatusCode();
                        }
                        string2 = MessageType.getString((int)98) + ": " + Status.getString((int)n) + " - " + throwable.getMessage();
                        this.logger.log(32, string2);
                        n = 304;
                    }
                }
                clusterManager2 = null;
                object3 = null;
                object4 = null;
                if (n == 200) {
                    try {
                        bl2 = false;
                        object4 = brokerStateHandler.takeoverME(string, l, iMQConnection);
                    }
                    catch (BrokerException brokerException) {
                        n = brokerException.getStatusCode();
                        if (n == 400 || n == 405 || n == 304 || n == 503 || n == 412) {
                            n = 412;
                            if (brokerException instanceof OperationNotAllowedException && ((OperationNotAllowedException)brokerException).getOperation().equals(MessageType.getString((int)98))) {
                                n = 304;
                                bl2 = true;
                            }
                            string2 = Globals.getBrokerResources().getKString("B3283", brokerException.getMessage());
                            if (bl2) {
                                this.logger.log(32, string2);
                            } else {
                                this.logger.logStack(32, string2, (Throwable)brokerException);
                            }
                        }
                        n = 417;
                        string2 = Globals.getBrokerResources().getKString("B3284", string, brokerException.getMessage());
                        this.logger.logStack(32, string2, (Throwable)brokerException);
                    }
                }
                if (n == 200) {
                    try {
                        Globals.getClusterBroadcast().stopClusterIO(false, true, null);
                    }
                    catch (Throwable throwable) {
                        this.logger.logStack(16, "Failed to stop cluster IO", throwable);
                    }
                }
                if (string2 != null) {
                    string2 = string2 + "[" + Status.getString((int)n) + "]";
                }
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                if (string != null) {
                    hashtable2.put("JMQBrokerID", string);
                }
                if (object4 != null) {
                    hashtable2.put("JMQMQAddress", object4);
                }
                Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setPacketType(5);
                MigrateStoreHandler.setProperties(packet2, 99, n, string2, hashtable2);
                this.logger.log(8, this.rb.getKString("B1398", MessageType.getString((int)99) + "[" + Status.getString((int)n) + "]"));
                clusterManager2 = this.parent.sendReply(iMQConnection, packet, packet2);
                object3 = Status.getString((int)n);
                Object var17_21 = null;
                clusterManager = clusterManager2;
                object2 = object3;
                if (bl2) break block51;
                if (iMQConnection instanceof IMQBasicConnection) {
                    object5 = (IMQBasicConnection)iMQConnection;
                    ((IMQBasicConnection)object5).flushControl(1000L);
                }
                try {
                    Globals.getServiceManager().stopNewConnections(0);
                }
                catch (Exception object5) {
                    this.logger.logStack(16, this.rb.getKString("B2250", ServiceType.getServiceTypeString((int)0), ((Throwable)object5).getMessage()), (Throwable)object5);
                }
                try {
                    Globals.getServiceManager().stopNewConnections(1);
                }
                catch (Exception object5) {
                    this.logger.logStack(16, this.rb.getKString("B2250", ServiceType.getServiceTypeString((int)1), ((Throwable)object5).getMessage()), (Throwable)object5);
                }
                BrokerStateHandler.shuttingDown = true;
                brokerStateHandler.prepareShutdown(false, true);
                this.waitForHandlersToComplete(20);
                if (clusterManager != null) break block54;
                this.logger.log(8, "B1093");
                brokerStateHandler.initiateShutdown("admin", 0L, false, 0, true);
                bl = true;
                Object var24_31 = null;
            }
            catch (Throwable throwable) {
                Object var24_34 = null;
                BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
                throw throwable;
            }
            BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
            {
                block54: {
                    return bl;
                }
                try {
                    object5 = this.rb.getKString("B1397", MessageType.getString((int)99) + "[" + (String)object2 + "]");
                    long l = (long)Globals.getConfig().getIntProperty(MAX_WAIT_ADMIN_CLIENT_PROP, 60) * 1000L;
                    Executors.newSingleThreadExecutor().execute(new Runnable((SysMessageID)clusterManager, l, (String)object5, brokerStateHandler){
                        final /* synthetic */ SysMessageID val$mid;
                        final /* synthetic */ long val$totalwait;
                        final /* synthetic */ String val$waitstr;
                        final /* synthetic */ BrokerStateHandler val$bsh;
                        {
                            this.val$mid = sysMessageID;
                            this.val$totalwait = l;
                            this.val$waitstr = string;
                            this.val$bsh = brokerStateHandler;
                        }

                        public void run() {
                            try {
                                PacketReference packetReference = Destination.get(this.val$mid);
                                long l = 0L;
                                while (packetReference != null && !packetReference.isInvalid() && !packetReference.isDestroyed() && packetReference.getDeliverCnt() > packetReference.getCompleteCnt() && l < this.val$totalwait) {
                                    Logger cfr_ignored_0 = MigrateStoreHandler.this.logger;
                                    MigrateStoreHandler.this.logger.log(8, this.val$waitstr);
                                    try {
                                        Thread.sleep(500L);
                                        l += 500L;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    packetReference = Destination.get(this.val$mid);
                                }
                                MigrateStoreHandler.this.logger.log(8, "B1093");
                                this.val$bsh.initiateShutdown("admin-migratestore-shutdown", 0L, false, 0, true);
                            }
                            catch (Throwable throwable) {
                                this.val$bsh.initiateShutdown("admin-migratestore-shutdown::[" + throwable.toString() + "]", 0L, false, 0, true);
                            }
                        }
                    });
                }
                catch (Throwable object5) {
                    brokerStateHandler.initiateShutdown("admin-migratestore-shutdown:[" + ((Throwable)object5).toString() + "]", 0L, false, 0, true);
                }
                break block51;
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    ClusterManager clusterManager3 = clusterManager2;
                    BrokerMQAddress brokerMQAddress = object3;
                    if (!bl2) {
                        Object object62;
                        block55: {
                            if (iMQConnection instanceof IMQBasicConnection) {
                                object62 = (IMQBasicConnection)iMQConnection;
                                ((IMQBasicConnection)object62).flushControl(1000L);
                            }
                            try {
                                Globals.getServiceManager().stopNewConnections(0);
                            }
                            catch (Exception object62) {
                                this.logger.logStack(16, this.rb.getKString("B2250", ServiceType.getServiceTypeString((int)0), ((Throwable)object62).getMessage()), (Throwable)object62);
                            }
                            try {
                                Globals.getServiceManager().stopNewConnections(1);
                            }
                            catch (Exception object62) {
                                this.logger.logStack(16, this.rb.getKString("B2250", ServiceType.getServiceTypeString((int)1), ((Throwable)object62).getMessage()), (Throwable)object62);
                            }
                            BrokerStateHandler.shuttingDown = true;
                            brokerStateHandler.prepareShutdown(false, true);
                            this.waitForHandlersToComplete(20);
                            if (clusterManager3 != null) break block55;
                            this.logger.log(8, "B1093");
                            brokerStateHandler.initiateShutdown("admin", 0L, false, 0, true);
                            boolean bl3 = true;
                            Object var24_32 = null;
                            BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
                            return bl3;
                        }
                        try {
                            object62 = this.rb.getKString("B1397", MessageType.getString((int)99) + "[" + (String)((Object)brokerMQAddress) + "]");
                            long l = (long)Globals.getConfig().getIntProperty(MAX_WAIT_ADMIN_CLIENT_PROP, 60) * 1000L;
                            Executors.newSingleThreadExecutor().execute(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (Throwable object62) {
                            brokerStateHandler.initiateShutdown("admin-migratestore-shutdown:[" + ((Throwable)object62).toString() + "]", 0L, false, 0, true);
                        }
                    }
                    throw throwable;
                }
            }
        }
        Object var24_33 = null;
        BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
        return true;
    }

    private String getBrokerID() throws Exception {
        BrokerMQAddress brokerMQAddress;
        BrokerAddress brokerAddress;
        String string = null;
        ClusterManager clusterManager = Globals.getClusterManager();
        ClusterBroadcast clusterBroadcast = Globals.getClusterBroadcast();
        String string22 = null;
        List<String> list = null;
        list = Globals.getStore().getMyReplicas();
        for (String string22 : list) {
            if (clusterBroadcast.lookupBrokerAddress(string22) == null) continue;
            string = string22;
        }
        if (string == null && (brokerAddress = clusterBroadcast.lookupBrokerAddress(brokerMQAddress = (BrokerMQAddress)clusterManager.getBrokerNextToMe())) != null && brokerAddress.getBrokerID() != null) {
            string = brokerAddress.getBrokerID();
        }
        if (string == null) {
            brokerMQAddress = null;
            brokerAddress = null;
            Iterator iterator = clusterManager.getActiveBrokers();
            while (iterator.hasNext()) {
                brokerMQAddress = (BrokerMQAddress)((ClusteredBroker)iterator.next()).getBrokerURL();
                brokerAddress = clusterBroadcast.lookupBrokerAddress(brokerMQAddress);
                if (brokerAddress == null || brokerAddress.getBrokerID() == null) continue;
                string = brokerAddress.getBrokerID();
            }
        }
        if (string == null) {
            throw new OperationNotAllowedException("No connected broker found in cluster", MessageType.getString((int)98));
        }
        return string;
    }
}

