/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLink;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterServiceListener;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.WarningTask;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterInfoInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;

public class ClusterImpl
implements Cluster,
ClusterListener {
    static boolean DEBUG = false;
    ClusterCallback cb = null;
    private boolean supportClusters = false;
    private int connLimit = 0;
    private Properties matchProps = null;
    protected boolean useGPackets = false;
    private BrokerAddressImpl self;
    private Map connectList;
    private HashMap brokerList;
    private boolean readyForBroadcast = false;
    private int flowControlState = 6;
    private String transport = null;
    private InetAddress listenHost = null;
    private int listenPort = 0;
    private ClusterServiceListener listener = null;
    private PingTimerTask pingTimer = null;
    private static final long DEFAULT_PING_INTERVAL = 60L;
    private long pingInterval = Globals.getConfig().getLongProperty("imq.cluster.ping.interval", 60L) * 1000L;
    private int tcpInbufsz = Globals.getConfig().getIntProperty("imq.cluster.tcp.inbufsz", 2048);
    private int sslInbufsz = Globals.getConfig().getIntProperty("imq.cluster.ssl.inbufsz", Globals.getConfig().getIntProperty("imq.cluster.tls.inbufsz", 2048));
    private int tcpOutbufsz = Globals.getConfig().getIntProperty("imq.cluster.tcp.outbufsz", 2048);
    private int sslOutbufsz = Globals.getConfig().getIntProperty("imq.cluster.ssl.outbufsz", Globals.getConfig().getIntProperty("imq.cluster.tls.outbufsz", 2048));
    private boolean tcpNodelay = Globals.getConfig().getBooleanProperty("imq.cluster.tcp.nodelay", true);
    private boolean sslNodelay = Globals.getConfig().getBooleanProperty("imq.cluster.ssl.nodelay", Globals.getConfig().getBooleanProperty("imq.cluster.tls.nodelay", true));
    private Object configServerLock = new Object();
    private BrokerAddressImpl configServer = null;
    private boolean configServerResolved = false;
    public static final String SERVICE_NAME = "cluster";
    public static final String SERVICE_TYPE = "CLUSTER";
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private TimerTask warningTask = null;
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 30;
    private static final String SHUTDOWN_TIMEOUT_PROP = "imq.cluster.shutdownTimeout";
    private ClusterManager clsmgr = Globals.getClusterManager();

    public ClusterImpl(int n) throws BrokerException {
        this.transport = this.clsmgr.getTransport();
        assert (this.transport != null);
        if (this.transport.equalsIgnoreCase("tls")) {
            this.transport = "ssl";
        }
        boolean bl = !Globals.getHAEnabled() && this.clsmgr.getConfigBrokerCount() == 0;
        this.listenPort = this.clsmgr.getClusterPort();
        String string = this.clsmgr.getClusterHost();
        try {
            this.listenHost = BrokerMQAddress.resolveBindAddress(string, true);
        }
        catch (LoopbackAddressException loopbackAddressException) {
            int n2 = bl ? 16 : 32;
            logger.log(n2, "B3153", (Object)"imq.cluster.hostname");
            if (bl) {
                throw loopbackAddressException;
            }
            Broker.getBroker().exit(1, br.getKString("B3153", "imq.cluster.hostname"), BrokerEvent.Type.FATAL_ERROR);
            throw loopbackAddressException;
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                logger.log(32, br.getKString("B3235", "imq.cluster.hostname", exception.getMessage()));
            } else {
                logger.logStack(32, br.getKString("B3235", "imq.cluster.hostname", exception.getMessage()), (Throwable)exception);
            }
            Broker.getBroker().exit(1, br.getString("B3235", "imq.cluster.hostname", exception.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            BrokerException brokerException = new BrokerException(exception.getMessage());
            brokerException.initCause(exception);
            throw brokerException;
        }
        try {
            BrokerMQAddress.checkLoopbackAddress(Globals.getPortMapper().getBindAddress(), Globals.getPortMapper().getHostname());
        }
        catch (LoopbackAddressException loopbackAddressException) {
            int n3 = bl ? 16 : 32;
            logger.log(n3, "B3236", (Object)"imq.portmapper.hostname", (Object)loopbackAddressException.getMessage());
            if (bl) {
                throw loopbackAddressException;
            }
            Broker.getBroker().exit(1, br.getString("B3236", "imq.portmapper.hostname", loopbackAddressException.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            throw loopbackAddressException;
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                logger.log(32, "B3236", (Object)"imq.portmapper.hostname", (Object)exception.getMessage());
            } else {
                logger.logStack(32, "B3236", (Object)"imq.portmapper.hostname", (Object)exception.getMessage(), (Throwable)exception);
            }
            Broker.getBroker().exit(1, br.getString("B3236", "imq.portmapper.hostname", exception.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            BrokerException brokerException = new BrokerException(exception.getMessage());
            brokerException.initCause(exception);
            throw brokerException;
        }
        try {
            this.self = new BrokerAddressImpl();
        }
        catch (LoopbackAddressException loopbackAddressException) {
            int n4 = bl ? 16 : 32;
            logger.log(n4, br.getKString("B3168", loopbackAddressException.getMessage()));
            if (bl) {
                throw loopbackAddressException;
            }
            Broker.getBroker().exit(1, br.getString("B3168", loopbackAddressException.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            throw loopbackAddressException;
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                logger.log(32, br.getKString("B3168", exception.getMessage()));
            } else {
                logger.logStack(32, br.getKString("B3168", exception.getMessage()), (Throwable)exception);
            }
            Broker.getBroker().exit(1, br.getString("B3168", exception.getMessage()), BrokerEvent.Type.FATAL_ERROR);
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            BrokerException brokerException = new BrokerException(exception.getMessage());
            brokerException.initCause(exception);
            throw brokerException;
        }
        LicenseBase licenseBase = Globals.getCurrentLicense(null);
        this.supportClusters = licenseBase.getBooleanProperty("imq.enable_cluster", false);
        this.connLimit = n;
        this.readyForBroadcast = false;
        ClusteredBroker clusteredBroker = this.clsmgr.getMasterBroker();
        this.initConfigServer(clusteredBroker);
        this.initBrokerList();
    }

    private void initConfigServer(ClusteredBroker clusteredBroker) throws BrokerException {
        if (clusteredBroker == null) {
            this.configServer = null;
            this.configServerResolved = true;
            return;
        }
        if (!this.supportClusters) {
            String string = br.getKString("B3123", Globals.getBrokerResources().getString("B0038"));
            logger.log(32, string);
            Broker.getBroker().exit(1, string, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException(string);
        }
        if (Globals.getHAEnabled()) {
            String string = br.getKString("B3196");
            logger.log(32, string);
            Broker.getBroker().exit(1, string, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException(string);
        }
        this.checkStoredLastConfigServer();
        try {
            this.configServer = new BrokerAddressImpl((BrokerMQAddress)clusteredBroker.getBrokerURL(), null, Globals.getHAEnabled(), clusteredBroker.getBrokerName());
        }
        catch (Exception exception) {
            this.configServer = null;
            this.configServerResolved = false;
            throw new BrokerException(exception.getMessage(), exception);
        }
        BrokerMQAddress brokerMQAddress = this.configServer.getMQAddress();
        if (brokerMQAddress.equals((Object)this.self.getMQAddress())) {
            this.configServer = this.self;
            this.configServerResolved = true;
            return;
        }
        this.configServerResolved = false;
    }

    private void checkStoredLastConfigServer() throws BrokerException {
        Store store = Globals.getStore();
        boolean bl = false;
        boolean bl2 = false;
        LoadException loadException = store.getLoadPropertyException();
        LoadException loadException2 = null;
        while (loadException != null) {
            Object object = loadException.getKey();
            if (object == null || !(object instanceof String)) {
                bl2 = true;
                loadException2 = loadException;
                loadException = loadException.getNextException();
                continue;
            }
            if (((String)object).equals("MessageBus.lastConfigServer")) {
                logger.log(32, "B3161", (Throwable)loadException);
                bl = true;
                break;
            }
            if (((String)object).equals("MessageBus.lastRefreshTime")) {
                logger.log(16, "B2100", (Throwable)loadException);
                try {
                    store.updateProperty("MessageBus.lastRefreshTime", new Long(-1L), false);
                }
                catch (BrokerException brokerException) {
                    logger.log(32, "B3162", (Throwable)brokerException);
                    bl = true;
                    break;
                }
            }
            loadException = loadException.getNextException();
        }
        if (bl2 && !bl) {
            try {
                if (store.getProperty("MessageBus.lastConfigServer") == null) {
                    logger.log(32, "B3161", (Throwable)loadException2);
                    bl = true;
                }
            }
            catch (BrokerException brokerException) {
                logger.log(32, brokerException.getMessage(), (Throwable)brokerException);
                logger.log(32, "B3161", (Throwable)loadException2);
                bl = true;
            }
        }
        if (bl) {
            logger.log(32, "B3161");
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3161"), BrokerEvent.Type.FATAL_ERROR);
        }
    }

    private void initBrokerList() throws BrokerException {
        Object object;
        this.connectList = Collections.synchronizedMap(new HashMap());
        BrokerMQAddress brokerMQAddress = this.self.getMQAddress();
        if (DEBUG) {
            logger.log(8, "ClusterImpl:initBrokerList. selfKey =" + (Object)((Object)brokerMQAddress));
        }
        ClusteredBroker clusteredBroker = null;
        BrokerAddressImpl brokerAddressImpl = null;
        BrokerLink brokerLink = null;
        Iterator iterator = this.clsmgr.getConfigBrokers();
        int n = 0;
        while (iterator.hasNext()) {
            clusteredBroker = (ClusteredBroker)iterator.next();
            try {
                brokerAddressImpl = new BrokerAddressImpl((BrokerMQAddress)clusteredBroker.getBrokerURL(), null, Globals.getHAEnabled(), clusteredBroker.getBrokerName());
            }
            catch (Exception exception) {
                throw new BrokerException(exception.getMessage(), exception);
            }
            object = brokerAddressImpl.getMQAddress();
            if (((BrokerMQAddress)((Object)object)).equals((Object)brokerMQAddress)) continue;
            brokerLink = new BrokerLink(this.self, brokerAddressImpl, this);
            brokerLink.setAutoConnect(true);
            this.connectList.put(object, brokerLink);
            ++n;
            if (!DEBUG) continue;
            logger.log(8, "ClusterImpl: Added to connectList: key=" + object + ", link=" + brokerLink + " (" + n + ")");
        }
        if (this.connectList.size() > 0 && !this.supportClusters) {
            object = br.getKString("B3123", Globals.getBrokerResources().getString("B0038"));
            logger.log(32, object);
            Broker.getBroker().exit(1, (String)object, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException((String)object);
        }
        if (this.connectList.size() > this.connLimit) {
            object = br.getKString("B3091", Integer.toString(this.connLimit + 1));
            logger.log(32, object);
            Broker.getBroker().exit(1, (String)object, BrokerEvent.Type.FATAL_ERROR);
            throw new BrokerException((String)object);
        }
        this.brokerList = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerLink searchBrokerList(BrokerMQAddress brokerMQAddress) {
        if (this.brokerList == null) {
            return null;
        }
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            for (BrokerAddressImpl brokerAddressImpl : this.brokerList.keySet()) {
                if (!brokerMQAddress.equals((Object)brokerAddressImpl.getMQAddress())) continue;
                return (BrokerLink)this.brokerList.get(brokerAddressImpl);
            }
            return null;
        }
    }

    protected String getTransport() {
        return this.transport;
    }

    protected boolean getTCPNodelay() {
        return this.tcpNodelay;
    }

    protected boolean getSSLNodelay() {
        return this.sslNodelay;
    }

    protected int getTCPInputBufferSize() {
        return this.tcpInbufsz;
    }

    protected int getTCPOutputBufferSize() {
        return this.tcpOutbufsz;
    }

    protected int getSSLInputBufferSize() {
        return this.sslInbufsz;
    }

    protected int getSSLOutputBufferSize() {
        return this.sslOutbufsz;
    }

    private void setListenHost(String string) throws Exception {
        if (DEBUG) {
            logger.log(4, "ClusterImpl: Changing the listening hostname to {0}", (Object)string);
        }
        if (!this.supportClusters) {
            return;
        }
        InetAddress inetAddress = this.listenHost;
        try {
            this.listenHost = BrokerMQAddress.resolveBindAddress(string, true);
            ClusterServiceListener clusterServiceListener = new ClusterServiceListener(this);
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = clusterServiceListener;
        }
        catch (Exception exception) {
            this.listenHost = inetAddress;
            throw exception;
        }
    }

    protected InetAddress getListenHost() {
        return this.listenHost;
    }

    private void setListenPort(int n) throws IOException {
        Object[] objectArray = new String[]{SERVICE_NAME, String.valueOf(n), String.valueOf(1), String.valueOf(1)};
        logger.log(8, "B1090", objectArray);
        if (!this.supportClusters) {
            return;
        }
        int n2 = this.listenPort;
        try {
            this.listenPort = n;
            ClusterServiceListener clusterServiceListener = new ClusterServiceListener(this);
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = clusterServiceListener;
        }
        catch (IOException iOException) {
            this.listenPort = n2;
            throw iOException;
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }

    protected boolean isConfigServerResolved() {
        return this.configServerResolved;
    }

    protected boolean waitForConfigSync() {
        if (this.cb == null) {
            return true;
        }
        return ((Protocol)this.cb).waitForConfigSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConfigServer(BrokerAddressImpl brokerAddressImpl) {
        Object object = this.configServerLock;
        synchronized (object) {
            if (this.configServerResolved) {
                return true;
            }
            if (this.configServer == null) {
                return false;
            }
            BrokerMQAddress brokerMQAddress = brokerAddressImpl.getMQAddress();
            if (brokerMQAddress.equals((Object)this.configServer.getMQAddress())) {
                this.configServer = brokerAddressImpl;
                this.configServerResolved = true;
                if (this.warningTask != null) {
                    this.warningTask.cancel();
                    this.warningTask = null;
                }
            }
            return this.configServerResolved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addBroker(BrokerAddressImpl brokerAddressImpl, BrokerLink brokerLink) {
        if (DEBUG) {
            logger.log(2, "ClusterImpl: Activating link = {0}", (Object)brokerLink);
        }
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink brokerLink2 = (BrokerLink)this.brokerList.get(brokerAddressImpl);
            if (brokerLink2 != null) {
                BrokerAddressImpl brokerAddressImpl2 = brokerLink2.getRemote();
                if (!brokerAddressImpl2.getMQAddress().equals((Object)brokerAddressImpl.getMQAddress())) {
                    Object[] objectArray = new String[]{brokerAddressImpl.toShortString(), brokerLink.toString(), brokerLink2.toString()};
                    logger.log(32, br.getKString("B3242", objectArray));
                    Broker.getBroker().exit(1, br.getString("B3242", objectArray), BrokerEvent.Type.FATAL_ERROR, null, false, true, false);
                }
                return false;
            }
            this.brokerList.put(brokerAddressImpl, brokerLink);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBroker(BrokerAddressImpl brokerAddressImpl, BrokerLink brokerLink) {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink brokerLink2 = (BrokerLink)this.brokerList.get(brokerAddressImpl);
            if (brokerLink2 != null && brokerLink2 != brokerLink) {
                return;
            }
            if (this.brokerList.remove(brokerAddressImpl) == null) {
                return;
            }
            this.brokerList.notify();
        }
        this.cb.removeBrokerInfo(brokerAddressImpl);
        if (DEBUG) {
            logger.log(2, "ClusterImpl: Removed link with = {0}", (Object)brokerAddressImpl);
        }
    }

    protected void handleBrokerLinkShutdown(BrokerAddressImpl brokerAddressImpl) {
        this.connectList.remove((Object)brokerAddressImpl.getMQAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptConnection(Socket socket, boolean bl) throws IOException {
        BrokerAddressImpl brokerAddressImpl = null;
        try {
            brokerAddressImpl = BrokerLink.consumeLinkInit(socket, null, this);
            if (brokerAddressImpl == null) {
                return;
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                logger.logStack(4, exception.getMessage(), (Throwable)exception);
            }
            socket.close();
            return;
        }
        BrokerMQAddress brokerMQAddress = brokerAddressImpl.getMQAddress();
        BrokerLink brokerLink = null;
        Object object = this.connectList;
        synchronized (object) {
            brokerLink = (BrokerLink)this.connectList.get((Object)brokerMQAddress);
            if (brokerLink != null && this.connectionInitiator(brokerAddressImpl)) {
                this.connectList.remove((Object)brokerMQAddress);
                brokerLink.shutdown();
                brokerLink = null;
            }
        }
        if (brokerLink != null) {
            brokerLink.acceptConnection(brokerAddressImpl, socket, bl);
            return;
        }
        object = new BrokerLink(this.self, brokerAddressImpl, this);
        ((BrokerLink)object).setAutoConnect(false);
        if (((BrokerLink)object).acceptConnection(brokerAddressImpl, socket, bl)) {
            ((Thread)object).start();
        }
    }

    protected Packet getLinkInitPkt() {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.self.getClusterVersion());
            dataOutputStream.writeUTF(this.self.getHostName());
            dataOutputStream.writeUTF(this.self.getInstanceName());
            dataOutputStream.writeInt(this.self.getPort());
            object2 = (BrokerAddressImpl)this.getConfiguredConfigServer();
            dataOutputStream.writeBoolean(object2 != null);
            if (object2 != null) {
                dataOutputStream.writeUTF(((BrokerAddressImpl)object2).getHostName());
                dataOutputStream.writeUTF(((BrokerAddressImpl)object2).getInstanceName());
                dataOutputStream.writeInt(((BrokerAddressImpl)object2).getPort());
            }
            dataOutputStream.writeInt(this.matchProps.size());
            object = this.matchProps.propertyNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(this.matchProps.getProperty(string));
            }
            dataOutputStream.writeBoolean(Globals.getHAEnabled());
            dataOutputStream.writeBoolean(this.self.getBrokerID() != null);
            if (this.self.getBrokerID() != null) {
                dataOutputStream.writeUTF(this.self.getBrokerID());
            }
            dataOutputStream.writeLong(this.self.getBrokerSessionUID().longValue());
            if (Globals.getHAEnabled()) {
                dataOutputStream.writeLong(this.self.getStoreSessionUID().longValue());
            } else {
                object = this.self.getStoreSessionUID();
                dataOutputStream.writeBoolean(object != null);
                if (object != null) {
                    dataOutputStream.writeLong(object.longValue());
                }
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = new Packet();
        ((Packet)object).setPacketType(4);
        ((Packet)object).setPacketBody((byte[])object2);
        ((Packet)object).setDestId(0);
        return object;
    }

    protected static LinkInfo processLinkInit(Packet packet) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        UID uID = null;
        UID uID2 = null;
        boolean bl = false;
        int n = 0;
        BrokerAddressImpl brokerAddressImpl = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(packet.getPacketBody());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n2 = dataInputStream.readInt();
        string = dataInputStream.readUTF();
        string2 = dataInputStream.readUTF();
        n = dataInputStream.readInt();
        BrokerAddressImpl brokerAddressImpl2 = null;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        int n3 = 0;
        bl2 = dataInputStream.readBoolean();
        if (bl2) {
            string4 = dataInputStream.readUTF();
            string5 = dataInputStream.readUTF();
            n3 = dataInputStream.readInt();
        }
        Properties properties = new Properties();
        int n4 = dataInputStream.readInt();
        for (int i = 0; i < n4; ++i) {
            String string6 = dataInputStream.readUTF();
            String string7 = dataInputStream.readUTF();
            properties.setProperty(string6, string7);
        }
        if (n2 >= 400) {
            bl = dataInputStream.readBoolean();
            if (dataInputStream.readBoolean()) {
                string3 = dataInputStream.readUTF();
            }
            uID = new UID(dataInputStream.readLong());
            if (bl) {
                uID2 = new UID(dataInputStream.readLong());
            } else {
                try {
                    if (dataInputStream.readBoolean()) {
                        uID2 = new UID(dataInputStream.readLong());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (bl2) {
            if (bl) {
                throw new BrokerException(br.getKString("B3196"));
            }
            brokerAddressImpl2 = new BrokerAddressImpl(string4, string5, n3, bl, null, null, null);
        }
        brokerAddressImpl = new BrokerAddressImpl(string, string2, n, bl, string3, uID, uID2);
        brokerAddressImpl.setClusterVersion(n2);
        return new LinkInfo(brokerAddressImpl, brokerAddressImpl2, properties);
    }

    private boolean connectionInitiator(BrokerAddressImpl brokerAddressImpl) {
        return this.self.getMQAddress().hashCode() > brokerAddressImpl.getMQAddress().hashCode();
    }

    protected Packet getBrokerInfoPkt() {
        Object object;
        BrokerInfo brokerInfo = this.cb.getBrokerInfo();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(brokerInfo);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = byteArrayOutputStream.toByteArray();
        Packet packet = new Packet();
        packet.setPacketType(3);
        packet.setPacketBody((byte[])object);
        packet.setDestId(0);
        return packet;
    }

    protected ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo brokerInfo) throws Exception {
        if (this.cb == null) {
            throw new BrokerException(br.getKString("B4241"), 503);
        }
        return this.cb.getBrokerInfoReply(brokerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerInfo receiveBrokerInfo(BrokerAddressImpl brokerAddressImpl, byte[] byArray, String string, BrokerLink brokerLink) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BrokerInfo brokerInfo = null;
        try {
            object = new ObjectInputStream(byteArrayInputStream);
            brokerInfo = (BrokerInfo)((ObjectInputStream)object).readObject();
            brokerInfo.setRealRemoteString(string);
        }
        catch (Exception exception) {
            logger.log(16, "B2068", (Object)brokerAddressImpl);
            if (brokerLink != null) {
                brokerLink.shutdown();
            }
            return null;
        }
        object = brokerInfo.getClusterProtocolVersion();
        if (object != null && (Integer)object >= 400) {
            return brokerInfo;
        }
        if (brokerLink != null) {
            brokerLink.handshakeSent();
        }
        int n = this.cb.addBrokerInfo(brokerInfo);
        if (n == 0) {
            return brokerInfo;
        }
        if (n == 1) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink2 = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink2 != null) {
                    brokerLink2.closeConn();
                }
            }
        }
        if (n == 2) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink3 = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink3 != null) {
                    brokerLink3.shutdown();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveBrokerInfoReply(BrokerAddressImpl brokerAddressImpl, GPacket gPacket, String string) {
        BrokerInfo brokerInfo = null;
        try {
            ClusterBrokerInfoReply clusterBrokerInfoReply = ClusterBrokerInfoReply.newInstance(gPacket);
            brokerInfo = clusterBrokerInfoReply.getBrokerInfo();
            brokerInfo.setRealRemoteString(string);
            if (DEBUG) {
                logger.log(4, "Received BROKER_INFO_REPLY from " + brokerAddressImpl);
            }
            if (!brokerInfo.getBrokerAddr().equals(brokerAddressImpl)) {
                logger.log(32, "B3100", (Object)("mismatched BROKER_INFO (" + brokerInfo.getBrokerAddr() + ") from " + brokerAddressImpl));
                throw new BrokerException("mismatched BROKER_INFO");
            }
            if (Globals.getHAEnabled() && clusterBrokerInfoReply.isTakingover()) {
                String string2 = br.getKString("B3186", brokerAddressImpl);
                BrokerException brokerException = new BrokerException(string2);
                logger.log(32, string2);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), string2, BrokerEvent.Type.RESTART, null, true, true, true);
                throw brokerException;
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            logger.logStack(32, exception.getMessage(), (Throwable)exception);
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink != null) {
                    brokerLink.shutdown();
                }
            }
            return;
        }
        int n = this.cb.addBrokerInfo(brokerInfo);
        if (n == 0) {
            return;
        }
        if (n == 1) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink != null) {
                    brokerLink.closeConn();
                }
            }
        }
        if (n == 2) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink != null) {
                    brokerLink.shutdown();
                }
            }
        }
    }

    protected GPacket getFirstInfoPacket() {
        if (!Globals.useSharedConfigRecord()) {
            return null;
        }
        ChangeRecordInfo changeRecordInfo = this.cb.getLastStoredChangeRecord();
        if (changeRecordInfo == null) {
            return null;
        }
        ClusterInfoInfo clusterInfoInfo = ClusterInfoInfo.newInstance();
        clusterInfoInfo.setLastStoredChangeRecord(changeRecordInfo);
        clusterInfoInfo.setIsFirstInfo(true);
        clusterInfoInfo.setBroadcast(false);
        return clusterInfoInfo.getGPacket();
    }

    protected void processFirstInfoPacket(GPacket gPacket, BrokerLink brokerLink) {
        try {
            if (!Globals.useSharedConfigRecord()) {
                throw new BrokerException("Unexpected " + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + " packet from " + brokerLink.getRemote());
            }
            ClusterInfoInfo clusterInfoInfo = ClusterInfoInfo.newInstance(gPacket);
            ChangeRecordInfo changeRecordInfo = clusterInfoInfo.getLastStoredChangeRecord();
            if (changeRecordInfo == null) {
                return;
            }
            logger.log(8, br.getKString("B1369", ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + "[(sharecc)" + changeRecordInfo.toString() + "]", brokerLink.getRemote()));
            this.cb.syncChangeRecordOnJoin(brokerLink.getRemote(), changeRecordInfo);
        }
        catch (Exception exception) {
            logger.logStack(32, exception.getMessage(), (Throwable)exception);
            if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() == 412) {
                brokerLink.shutdown();
                return;
            }
            brokerLink.closeConn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlowControl(BrokerAddressImpl brokerAddressImpl, boolean bl) {
        BrokerLink brokerLink = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
        }
        if (brokerLink != null) {
            brokerLink.setFlowControl(bl);
        }
    }

    protected Object receivePacket(BrokerAddressImpl brokerAddressImpl, Packet packet, String string, BrokerLink brokerLink) {
        BrokerInfo brokerInfo = null;
        if (this.cb == null) {
            return brokerInfo;
        }
        switch (packet.getPacketType()) {
            case 1: {
                this.cb.receiveUnicast(brokerAddressImpl, packet.getDestId(), packet.getPacketBody());
                break;
            }
            case 2: {
                this.cb.receiveBroadcast(brokerAddressImpl, packet.getDestId(), packet.getPacketBody());
                break;
            }
            case 3: {
                brokerInfo = this.receiveBrokerInfo(brokerAddressImpl, packet.getPacketBody(), string, brokerLink);
                break;
            }
            case 5: {
                this.setFlowControl(brokerAddressImpl, true);
                break;
            }
            case 6: {
                this.setFlowControl(brokerAddressImpl, false);
                break;
            }
            case 7: {
                if (!DEBUG) break;
                logger.log(4, "ClusterImpl: Received ping from : " + brokerAddressImpl);
                break;
            }
            default: {
                logger.log(16, "ClusterImpl: INTERNAL ERROR - Received Unknown packet from : " + brokerAddressImpl);
            }
        }
        return brokerInfo;
    }

    protected void receivePacket(BrokerAddressImpl brokerAddressImpl, GPacket gPacket, String string) {
        if (gPacket.getType() == 46) {
            this.receiveBrokerInfoReply(brokerAddressImpl, gPacket, string);
            return;
        }
        if (this.cb == null) {
            return;
        }
        if (gPacket.getBit(2)) {
            this.cb.receiveBroadcast(brokerAddressImpl, gPacket);
        } else {
            this.cb.receiveUnicast(brokerAddressImpl, gPacket);
        }
    }

    public void useGPackets(boolean bl) {
        this.useGPackets = bl;
    }

    public void setCallback(ClusterCallback clusterCallback) {
        this.cb = clusterCallback;
        this.self.setClusterVersion(clusterCallback.getHighestSupportedVersion());
    }

    public void setMatchProps(Properties properties) {
        this.matchProps = properties;
    }

    protected Properties getMatchProps() {
        return this.matchProps;
    }

    public BrokerAddress getSelfAddress() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAddress getConfigServer() throws BrokerException {
        Object object = this.configServerLock;
        synchronized (object) {
            if (!this.configServerResolved) {
                if (Globals.getConfig().getBooleanProperty("imq.cluster.masterbroker.enforce", true)) {
                    throw new BrokerException(Globals.getBrokerResources().getString("B4118", this.configServer == null ? "null" : this.configServer.toString()));
                }
                return null;
            }
            return this.configServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMasterBroker(BrokerAddress brokerAddress, BrokerAddress brokerAddress2) throws BrokerException {
        Object object = this.configServerLock;
        synchronized (object) {
            logger.log(8, br.getKString("B1381", this.configServer == null ? "null" : this.configServer.toString(), brokerAddress.toString()));
            if (this.configServer == null) {
                throw new BrokerException(br.getKString("B4333"), 412);
            }
            if (!brokerAddress2.equals(this.configServer)) {
                throw new BrokerException(br.getKString("B4337", brokerAddress2.toString(), this.configServer.toString()), 412);
            }
            BrokerAddressImpl brokerAddressImpl = this.configServer;
            this.configServer = (BrokerAddressImpl)brokerAddress;
            String string = brokerAddress.getMQAddress().getHostAddressNPort();
            String string2 = Globals.getConfig().getProperty("imq.cluster.masterbroker");
            Properties properties = new Properties();
            properties.put("imq.cluster.masterbroker", string);
            try {
                Globals.getConfig().updateProperties(properties, true);
            }
            catch (Exception exception) {
                String string3 = br.getKString("B3272", exception.getMessage());
                logger.logStack(32, string3, (Throwable)exception);
                try {
                    properties.put("imq.cluster.masterbroker", string2);
                }
                catch (Exception exception2) {
                    logger.log(32, br.getKString("B3273", exception2.getMessage()));
                    throw new BrokerException(string3, exception, 500);
                }
                this.configServer = brokerAddressImpl;
                throw new BrokerException(string3, exception, 412);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrokerAddress getConfiguredConfigServer() {
        Object object = this.configServerLock;
        synchronized (object) {
            return this.configServer;
        }
    }

    public void marshalBrokerAddress(BrokerAddress brokerAddress, GPacket gPacket) {
        ((BrokerAddressImpl)brokerAddress).writeBrokerAddress(gPacket);
    }

    public BrokerAddress unmarshalBrokerAddress(GPacket gPacket) throws Exception {
        return BrokerAddressImpl.readBrokerAddress(gPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (!this.supportClusters) {
            return;
        }
        this.clsmgr.addEventListener(this);
        Object[] objectArray = this.connectList;
        synchronized (this.connectList) {
            Collection collection = this.connectList.values();
            for (BrokerLink brokerLink : collection) {
                brokerLink.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.listener = new ClusterServiceListener(this);
            objectArray = new Object[]{SERVICE_NAME, this.getTransport() + " [ " + this.getServerSocketString() + " ]", new Integer(1), new Integer(1)};
            logger.log(8, "B1004", objectArray);
            if (Globals.getClusterID() != null) {
                logger.log(8, "B1229", (Object)Globals.getClusterID());
            }
            if (!this.configServerResolved) {
                this.warningTask = new WarningTask(this);
                Globals.getTimer().schedule(this.warningTask, 60000L, 180000L);
            }
            if (this.pingInterval <= 0L) {
                this.pingInterval = 60000L;
            }
            long l = this.pingInterval / 1000L;
            this.pingTimer = new PingTimerTask();
            logger.log(8, "B1228", (Object)new Long(l));
            Globals.getTimer().schedule((TimerTask)this.pingTimer, this.pingInterval, this.pingInterval);
            return;
        }
    }

    protected String getServerSocketString() {
        ClusterServiceListener clusterServiceListener = this.listener;
        if (clusterServiceListener != null) {
            return clusterServiceListener.getServerSocketString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl, BrokerAddress brokerAddress) {
        Object object;
        Cloneable cloneable;
        if (!this.supportClusters) {
            return;
        }
        if (this.listener != null && brokerAddress == null) {
            this.listener.shutdown();
        }
        if (this.brokerList == null) {
            return;
        }
        long l = Globals.getConfig().getIntProperty(SHUTDOWN_TIMEOUT_PROP, 30);
        long l2 = l * 1000L;
        long l3 = System.currentTimeMillis() + l2;
        int n = -1;
        try {
            n = Globals.getClusterBroadcast().getClusterVersion();
        }
        catch (Exception exception) {
            logger.log(4, "Unable to get cluster protocol version on cluster shutdown: " + exception.getMessage());
        }
        if (n >= 400 && !bl) {
            cloneable = this.brokerList;
            synchronized (cloneable) {
                while (this.brokerList.size() != 0 && (this.brokerList.size() != 1 || brokerAddress == null || this.brokerList.get(brokerAddress) == null)) {
                    logger.log(8, br.getKString("B1188", new Integer(this.brokerList.size())));
                    try {
                        this.brokerList.wait(l2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    long l4 = System.currentTimeMillis();
                    if (l4 >= l3) {
                        if (this.brokerList.size() <= 0) break;
                        logger.log(16, br.getKString("B2125"));
                        break;
                    }
                    l2 = l3 - l4;
                }
            }
        }
        cloneable = null;
        BrokerLink brokerLink = null;
        Map map = this.brokerList;
        synchronized (map) {
            object = this.brokerList.keySet().iterator();
            while (object.hasNext()) {
                cloneable = (BrokerAddress)object.next();
                if (brokerAddress != null && ((BrokerAddress)cloneable).equals(brokerAddress)) continue;
                brokerLink = (BrokerLink)this.brokerList.get(cloneable);
                logger.log(16, br.getKString("B2126", cloneable, br.getString("B0084")));
                brokerLink.shutdown();
                object.remove();
            }
        }
        map = this.connectList;
        synchronized (map) {
            object = this.connectList.values();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BrokerAddressImpl brokerAddressImpl;
                BrokerLink brokerLink2 = (BrokerLink)iterator.next();
                if (brokerAddress != null && (brokerAddressImpl = brokerLink2.getRemote()) != null && ((BrokerAddress)brokerAddressImpl).equals(brokerAddress)) continue;
                brokerLink2.shutdown();
            }
        }
        if (this.warningTask != null) {
            try {
                this.warningTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.warningTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLink(BrokerAddress brokerAddress, boolean bl) {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddress);
            if (brokerLink != null) {
                brokerLink.closeConn(bl);
            }
            this.brokerList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLink(String string, UID uID) {
        if (!Globals.getHAEnabled()) {
            return;
        }
        BrokerAddress brokerAddress2 = null;
        BrokerLink brokerLink = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            for (BrokerAddress brokerAddress2 : this.brokerList.keySet()) {
                brokerLink = (BrokerLink)this.brokerList.get(brokerAddress2);
                if (!brokerAddress2.getBrokerID().equals(string) || uID != null && !brokerAddress2.getStoreSessionUID().equals((Object)uID)) continue;
                logger.log(16, br.getKString("B2127", brokerAddress2));
                brokerLink.closeConn(false);
            }
        }
    }

    public boolean isReachable(BrokerAddress brokerAddress, int n) throws IOException {
        Class<?> clazz = null;
        Method method = null;
        try {
            clazz = Class.forName("java.net.InetAddress");
            method = clazz.getMethod("isReachable", Integer.TYPE);
            boolean bl = (Boolean)method.invoke((Object)((BrokerAddressImpl)brokerAddress).getHost(), new Integer(n * 1000));
            if (bl) {
                logger.log(8, br.getKString("B1244", brokerAddress, new Integer(n)));
            } else {
                logger.log(8, br.getKString("B1245", brokerAddress, new Integer(n)));
            }
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.logStack(16, classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (DEBUG) {
                logger.logStack(16, noSuchMethodException.getMessage(), (Throwable)noSuchMethodException);
            }
            return true;
        }
        catch (Exception exception) {
            logger.logStack(16, exception.getMessage(), (Throwable)exception);
            return true;
        }
    }

    public void waitClusterInit() {
        BrokerLink brokerLink = null;
        Object[] objectArray = this.connectList.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            brokerLink = (BrokerLink)objectArray[i];
            brokerLink.waitLinkInit();
        }
        this.readyForBroadcast = true;
    }

    public void sendFlowControlUpdate(BrokerAddressImpl brokerAddressImpl) throws IOException {
        if (this.flowControlState == 5) {
            this.sendFlowControlUpdate(brokerAddressImpl, this.flowControlState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFlowControlUpdate(BrokerAddressImpl brokerAddressImpl, int n) throws IOException {
        Packet packet = new Packet();
        packet.setPacketType(n);
        packet.setPacketBody(null);
        packet.setDestId(0);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            if (brokerAddressImpl != null) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                brokerLink.sendPacket(packet);
            } else {
                Collection collection = this.brokerList.values();
                for (BrokerLink brokerLink : collection) {
                    brokerLink.sendPacket(packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMessageFlow() throws IOException {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            this.flowControlState = 5;
        }
        this.sendFlowControlUpdate(null, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeMessageFlow() throws IOException {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            this.flowControlState = 6;
        }
        this.sendFlowControlUpdate(null, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingGPacket() throws Exception {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)33);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            for (BrokerLink brokerLink : collection) {
                if (!brokerLink.isIOActive()) {
                    try {
                        brokerLink.sendPacket(gPacket);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                brokerLink.clearIOActiveFlag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingPacket() throws Exception {
        Packet packet = new Packet();
        packet.setPacketType(7);
        packet.setPacketBody(null);
        packet.setDestId(0);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            for (BrokerLink brokerLink : collection) {
                if (!brokerLink.isIOActive()) {
                    try {
                        brokerLink.sendPacket(packet);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                brokerLink.clearIOActiveFlag();
            }
        }
    }

    public void unicast(BrokerAddress brokerAddress, GPacket gPacket) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        this.unicast(brokerAddress, gPacket, false, false);
    }

    public void unicastAndClose(BrokerAddress brokerAddress, GPacket gPacket) throws IOException {
        this.unicast(brokerAddress, gPacket, false, true);
    }

    public void unicast(BrokerAddress brokerAddress, GPacket gPacket, boolean bl) throws IOException {
        this.unicast(brokerAddress, gPacket, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unicast(BrokerAddress brokerAddress, GPacket gPacket, boolean bl, boolean bl2) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        if (brokerAddress.equals(this.self)) {
            if (this.cb != null) {
                this.cb.receiveUnicast(this.self, gPacket);
            }
            return;
        }
        BrokerLink brokerLink = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            brokerLink = (BrokerLink)this.brokerList.get(brokerAddress);
        }
        if (brokerLink == null) {
            throw new IOException(br.getString("B4205", brokerAddress.toString()));
        }
        gPacket.setBit(32, bl);
        brokerLink.sendPacket(gPacket, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(GPacket gPacket) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket broadcast on old cluster");
            Thread.dumpStack();
        }
        if (!this.readyForBroadcast) {
            this.waitClusterInit();
        }
        gPacket.setBit(2, true);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            for (BrokerLink brokerLink : collection) {
                brokerLink.sendPacket(gPacket);
            }
        }
    }

    public void unicast(BrokerAddress brokerAddress, int n, byte[] byArray) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet unicast on raptor cluster");
            Thread.dumpStack();
        }
        this.unicast(brokerAddress, n, byArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unicast(BrokerAddress brokerAddress, int n, byte[] byArray, boolean bl) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet unicast on raptor cluster");
            Thread.dumpStack();
        }
        if (brokerAddress.equals(this.self)) {
            if (this.cb != null) {
                this.cb.receiveUnicast(this.self, n, byArray);
            }
            return;
        }
        BrokerLink brokerLink = null;
        Object object = this.brokerList;
        synchronized (object) {
            brokerLink = (BrokerLink)this.brokerList.get(brokerAddress);
        }
        if (brokerLink == null) {
            throw new IOException("Packet send failed. Unreachable BrokerAddress : " + brokerAddress);
        }
        object = new Packet();
        ((Packet)object).setPacketType(1);
        ((Packet)object).setPacketBody(byArray);
        ((Packet)object).setDestId(n);
        ((Packet)object).setFlag(1, bl);
        brokerLink.sendPacket((Packet)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(int n, byte[] byArray) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet broadcast on raptor cluster");
            Thread.dumpStack();
        }
        if (!this.readyForBroadcast) {
            this.waitClusterInit();
        }
        Packet packet = new Packet();
        packet.setPacketType(2);
        packet.setPacketBody(byArray);
        packet.setDestId(n);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            for (BrokerLink brokerLink : collection) {
                brokerLink.sendPacket(packet);
            }
        }
    }

    public void reloadCluster() {
        try {
            this.clsmgr.reloadConfig();
        }
        catch (Exception exception) {
            logger.logStack(16, br.getKString("B2128"), (Throwable)exception);
        }
    }

    public void clusterPropertyChanged(String string, String string2) {
        if (string.equals("imq.cluster.port")) {
            try {
                this.setListenPort(Integer.valueOf(string2));
            }
            catch (IOException iOException) {
                logger.logStack(32, iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
        if (!clusteredBroker.isConfigBroker()) {
            if (DEBUG) {
                logger.log(8, "ClusterImpl:brokerAdded: Ignore dynamic broker " + clusteredBroker);
            }
            return;
        }
        BrokerMQAddress brokerMQAddress = (BrokerMQAddress)clusteredBroker.getBrokerURL();
        if (!brokerMQAddress.equals((Object)this.self.getMQAddress()) && !this.connectList.containsKey((Object)brokerMQAddress)) {
            if (this.connectList.size() > this.connLimit) {
                logger.log(32, "B3091", (Object)Integer.toString(this.connLimit + 1));
                return;
            }
            boolean bl = false;
            BrokerLink brokerLink = this.searchBrokerList(brokerMQAddress);
            if (brokerLink == null) {
                BrokerAddressImpl brokerAddressImpl = null;
                try {
                    brokerAddressImpl = new BrokerAddressImpl(brokerMQAddress, null, Globals.getHAEnabled(), clusteredBroker.getBrokerName());
                    brokerLink = new BrokerLink(this.self, brokerAddressImpl, this);
                    bl = true;
                }
                catch (Exception exception) {
                    logger.logStack(32, br.getKString("B2129", clusteredBroker), (Throwable)exception);
                    return;
                }
            }
            brokerLink.setAutoConnect(true);
            this.connectList.put(brokerMQAddress, brokerLink);
            if (DEBUG) {
                logger.log(8, "ClusterImpl: Added link to connectList - " + brokerLink);
            }
            if (bl) {
                brokerLink.start();
            }
            return;
        }
        if (DEBUG) {
            logger.log(8, "Broker link for " + (Object)((Object)brokerMQAddress) + " (" + clusteredBroker + ") already exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("self", this.self.toString());
        BrokerAddressImpl brokerAddressImpl = this.configServer;
        if (brokerAddressImpl != null) {
            hashtable.put("configServer[masterbroker]", brokerAddressImpl.toString());
            hashtable.put("configServerResolved", this.configServerResolved);
        }
        ArrayList arrayList = null;
        Map map = this.connectList;
        synchronized (map) {
            arrayList = new ArrayList(this.connectList.keySet());
        }
        hashtable.put("connectListCount", String.valueOf(arrayList.size()));
        for (BrokerMQAddress brokerMQAddress : arrayList) {
            BrokerLink brokerLink = (BrokerLink)this.connectList.get((Object)brokerMQAddress);
            if (brokerLink == null) continue;
            hashtable.put(brokerMQAddress.toString(), brokerLink.toString());
        }
        return hashtable;
    }

    public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
        if (!clusteredBroker.isConfigBroker()) {
            if (DEBUG) {
                logger.log(8, "ClusterImpl:brokerRemoved: Ignore dynamic broker " + clusteredBroker);
            }
            return;
        }
        BrokerMQAddress brokerMQAddress = (BrokerMQAddress)clusteredBroker.getBrokerURL();
        BrokerLink brokerLink = (BrokerLink)this.connectList.remove((Object)brokerMQAddress);
        if (brokerLink != null) {
            brokerLink.shutdown();
            if (DEBUG) {
                logger.log(8, "ClusterImpl: Removed link from connectList - " + brokerLink);
            }
            return;
        }
        if (DEBUG) {
            logger.log(8, "Broker link for " + (Object)((Object)brokerMQAddress) + " (" + clusteredBroker + ") not exist");
        }
    }

    public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
    }

    public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        ClusteredBroker clusteredBroker = this.clsmgr.getBroker(string);
        if (!(clusteredBroker instanceof HAClusteredBroker)) {
            return;
        }
        if (clusteredBroker.isLocalBroker()) {
            return;
        }
        if (BrokerStatus.getBrokerIsDown(n2)) {
            this.closeLink(clusteredBroker.getBrokerName(), (UID)object);
        }
    }

    public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
    }

    public void brokerVersionChanged(String string, int n, int n2) {
    }

    public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
    }

    private class PingTimerTask
    extends TimerTask {
        private PingTimerTask() {
        }

        public void run() {
            try {
                if (ClusterImpl.this.useGPackets) {
                    ClusterImpl.this.sendPingGPacket();
                } else {
                    ClusterImpl.this.sendPingPacket();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

