/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DestinationStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

class MsgStore {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = new ConcurrentHashMap(32);
    private BDBStore parent = null;
    private DestinationStore dstStore = null;

    protected MsgStore(BDBStore bDBStore, DestinationStore destinationStore) {
        this.parent = bDBStore;
        this.dstStore = destinationStore;
    }

    protected Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("dstMapSize", String.valueOf(this.dstMap.size()));
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            hashtable.put(dstMsgStore.getMyDestinationUID().toString(), dstMsgStore.getDebugState());
        }
        return hashtable;
    }

    protected void storeMessage(Transaction transaction, DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(transaction, destinationUID, true, true);
        dstMsgStore.storeMessage(transaction, packet, consumerUIDArray, nArray);
    }

    protected Packet getMessage(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getOpenDstMsgStore(destinationUID).getMessage(transaction, sysMessageID);
    }

    protected HashMap getMessageStorageInfo(Transaction transaction, DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(transaction, destinationUID, false, true);
        return DstMsgStore.getMessageStorageInfo(transaction, dstMsgStore);
    }

    protected void removeMessage(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        this.getOpenDstMsgStore(destinationUID).removeMessage(transaction, sysMessageID);
    }

    protected void moveMessage(Transaction transaction, Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        DstMsgStore dstMsgStore = this.getOpenDstMsgStore(destinationUID);
        if (dstMsgStore == null || !dstMsgStore.containsMessage(transaction, sysMessageID)) {
            String string = this.br.getKString("B3007", sysMessageID, destinationUID);
            this.logger.log(32, string);
            throw new BrokerException(string);
        }
        this.storeMessage(transaction, destinationUID2, packet, consumerUIDArray, nArray);
        this.removeMessage(transaction, destinationUID, packet.getSysMessageID());
    }

    protected boolean hasMessageBeenAcked(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getOpenDstMsgStore(destinationUID).hasMessageBeenAcked(transaction, sysMessageID);
    }

    protected void compactDestination(Transaction transaction, Destination destination) throws BrokerException {
    }

    protected void removeDestination(Transaction transaction, DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(transaction, destinationUID, false, true);
        this.dstMap.remove(destinationUID);
        DstMsgStore.removeDestination(transaction, destinationUID, dstMsgStore, this.parent);
    }

    protected Enumeration messageEnumeration(Transaction transaction, Destination destination) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(transaction, destination.getDestinationUID(), false, true);
        return DstMsgStore.messageEnumeration(dstMsgStore, this.parent);
    }

    protected void storeInterestStates(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        this.getOpenDstMsgStore(destinationUID).storeInterestStates(transaction, sysMessageID, consumerUIDArray, nArray);
    }

    protected void updateInterestState(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws BrokerException {
        this.getOpenDstMsgStore(destinationUID).updateInterestState(transaction, sysMessageID, consumerUID, n);
    }

    protected int getInterestState(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        return this.getOpenDstMsgStore(destinationUID).getInterestState(transaction, sysMessageID, consumerUID);
    }

    protected HashMap getInterestStates(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getOpenDstMsgStore(destinationUID).getInterestStates(transaction, sysMessageID);
    }

    protected ConsumerUID[] getUnAckedConsumerUIDs(Transaction transaction, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getOpenDstMsgStore(destinationUID).getUnAckedConsumerUIDs(transaction, sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        try {
            DstMsgStore dstMsgStore2 = null;
            for (DstMsgStore dstMsgStore2 : this.dstMap.values()) {
                dstMsgStore2.close();
            }
        }
        finally {
            this.dstMap.clear();
        }
    }

    private DstMsgStore getOpenDstMsgStore(DestinationUID destinationUID) throws BrokerException {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(destinationUID);
        if (dstMsgStore == null) {
            String string = this.br.getKString("B3013", destinationUID);
            this.logger.log(32, string);
            throw new DestinationNotFoundException(string);
        }
        return dstMsgStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DstMsgStore getDstMsgStore(Transaction transaction, DestinationUID destinationUID, boolean bl, boolean bl2) throws BrokerException {
        this.dstStore.checkDestinationExist(transaction, destinationUID);
        ConcurrentHashMap concurrentHashMap = this.dstMap;
        synchronized (concurrentHashMap) {
            DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(destinationUID);
            if (dstMsgStore == null && (bl || bl2)) {
                try {
                    dstMsgStore = new DstMsgStore(transaction, destinationUID, bl, this.parent);
                }
                catch (DatabaseNotFoundException databaseNotFoundException) {
                    return null;
                }
                this.dstMap.put(destinationUID, dstMsgStore);
            }
            return dstMsgStore;
        }
    }
}

