/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.generic.ProfileClientFactory;
import com.sun.jmx.remote.generic.SelectProfiles;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.HandshakeBeginMessage;
import javax.management.remote.message.HandshakeEndMessage;
import javax.management.remote.message.HandshakeErrorMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.VersionMessage;

public class AdminClient
implements ClientAdmin {
    private Map env = null;
    private String connectionId = null;
    private List profilesList = new ArrayList();
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "AdminClient");

    public AdminClient(Map env) {
        this.env = env != null ? env : Collections.EMPTY_MAP;
    }

    public MessageConnection connectionOpen(MessageConnection mc) throws IOException {
        boolean sendError = true;
        HandshakeErrorMessage error = null;
        try {
            String clientVersion;
            HandshakeBeginMessage begin = null;
            Message msg = mc.readMessage();
            if (msg instanceof HandshakeBeginMessage) {
                begin = (HandshakeBeginMessage)msg;
            } else if (msg instanceof HandshakeErrorMessage) {
                sendError = false;
                error = (HandshakeErrorMessage)msg;
                AdminClient.throwExceptionOnError(error);
            } else {
                throw new IOException("Unexpected message: " + msg.getClass().getName());
            }
            String serverProfiles = begin.getProfiles();
            String serverVersion = begin.getVersion();
            if (logger.traceOn()) {
                logger.trace("connectionOpen", ">>>>> Handshake Begin <<<<<");
                logger.trace("connectionOpen", "Server Supported Profiles [ " + serverProfiles + " ]");
                logger.trace("connectionOpen", "Server JMXMP Version [ " + serverVersion + " ]");
            }
            if (!(clientVersion = "1.0").equals(serverVersion)) {
                if (clientVersion.compareTo(serverVersion) > 0) {
                    throw new IOException("The client is already using the lowest JMXMP protocol version [" + clientVersion + "]");
                }
                VersionMessage cjmxmp = new VersionMessage(clientVersion);
                mc.writeMessage(cjmxmp);
                msg = mc.readMessage();
                if (msg instanceof VersionMessage) {
                    VersionMessage sjmxmp = (VersionMessage)msg;
                    if (!clientVersion.equals(sjmxmp.getVersion())) {
                        throw new IOException("Protocol version mismatch: Client [" + clientVersion + "] vs. Server [" + sjmxmp.getVersion() + "]");
                    }
                } else if (msg instanceof HandshakeErrorMessage) {
                    sendError = false;
                    error = (HandshakeErrorMessage)msg;
                    AdminClient.throwExceptionOnError(error);
                } else {
                    throw new IOException("Unexpected message: " + msg.getClass().getName());
                }
            }
            List profileList = this.selectProfiles(serverProfiles);
            Iterator i = profileList.iterator();
            while (i.hasNext()) {
                String profile = (String)i.next();
                ProfileClient p = ProfileClientFactory.createProfile(profile, this.env);
                if (logger.traceOn()) {
                    logger.trace("connectionOpen", ">>>>> Profile " + p.getClass().getName() + " <<<<<");
                }
                ProfileMessage pm = null;
                p.initialize(mc);
                while (!p.isComplete()) {
                    pm = p.produceMessage();
                    mc.writeMessage(pm);
                    msg = mc.readMessage();
                    if (msg instanceof ProfileMessage) {
                        p.consumeMessage((ProfileMessage)msg);
                        continue;
                    }
                    if (msg instanceof HandshakeErrorMessage) {
                        sendError = false;
                        error = (HandshakeErrorMessage)msg;
                        AdminClient.throwExceptionOnError(error);
                        continue;
                    }
                    throw new IOException("Unexpected message: " + msg.getClass().getName());
                }
                p.activate();
                this.profilesList.add(p);
            }
            Object ccontext = this.env.get("jmx.remote.context");
            HandshakeEndMessage cend = new HandshakeEndMessage(ccontext, null);
            if (logger.traceOn()) {
                logger.trace("connectionOpen", ">>>>> Handshake End <<<<<");
                logger.trace("connectionOpen", "Client Context Object [ " + ccontext + " ]");
            }
            mc.writeMessage(cend);
            HandshakeEndMessage send = null;
            msg = mc.readMessage();
            if (msg instanceof HandshakeEndMessage) {
                send = (HandshakeEndMessage)msg;
            } else if (msg instanceof HandshakeErrorMessage) {
                sendError = false;
                error = (HandshakeErrorMessage)msg;
                AdminClient.throwExceptionOnError(error);
            } else {
                throw new IOException("Unexpected message: " + msg.getClass().getName());
            }
            Object scontext = send.getContext();
            this.connectionId = send.getConnectionId();
            if (logger.traceOn()) {
                logger.trace("connectionOpen", "Server Context Object [ " + scontext + " ]");
                logger.trace("connectionOpen", "Server Connection Id [ " + this.connectionId + " ]");
            }
        }
        catch (Exception e) {
            block30: {
                if (sendError) {
                    try {
                        mc.writeMessage(new HandshakeErrorMessage(e.toString()));
                    }
                    catch (Exception hsem) {
                        if (!logger.debugOn()) break block30;
                        logger.debug("connectionOpen", "Could not send HandshakeErrorMessage to the server", hsem);
                    }
                }
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)EnvHelp.initCause(new IOException(e.getMessage()), e);
        }
        return mc;
    }

    public void connectionClosed(MessageConnection mc) {
        Iterator i = this.profilesList.iterator();
        while (i.hasNext()) {
            ProfileClient p = (ProfileClient)i.next();
            try {
                p.terminate();
            }
            catch (Exception e) {
                if (!logger.debugOn()) continue;
                logger.debug("connectionClosed", "Got an exception to terminate a ProfileClient: " + p.getName(), e);
            }
        }
        this.profilesList.clear();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    private List selectProfiles(String serverProfiles) throws Exception {
        boolean clientFlag;
        SelectProfiles profileSelector = (SelectProfiles)this.env.get("com.sun.jmx.remote.profile.selector");
        if (profileSelector != null) {
            profileSelector.selectProfiles(this.env, serverProfiles);
            String clientProfiles = (String)this.env.get("jmx.remote.profiles");
            if (clientProfiles == null) {
                return Collections.EMPTY_LIST;
            }
            StringTokenizer cst = new StringTokenizer(clientProfiles, " ");
            ArrayList<String> clientProfilesList = new ArrayList<String>(cst.countTokens());
            while (cst.hasMoreTokens()) {
                String clientToken = cst.nextToken();
                clientProfilesList.add(clientToken);
            }
            return clientProfilesList;
        }
        String clientProfiles = (String)this.env.get("jmx.remote.profiles");
        boolean serverFlag = serverProfiles == null || serverProfiles.equals("");
        boolean bl = clientFlag = clientProfiles == null || clientProfiles.equals("");
        if (serverFlag && clientFlag) {
            return Collections.EMPTY_LIST;
        }
        if (serverFlag) {
            throw new IOException("The server does not support any profile but the client requires one");
        }
        if (clientFlag) {
            throw new IOException("The client does not require any profile but the server mandates one");
        }
        StringTokenizer sst = new StringTokenizer(serverProfiles, " ");
        ArrayList<String> serverProfilesList = new ArrayList<String>(sst.countTokens());
        while (sst.hasMoreTokens()) {
            String serverToken = sst.nextToken();
            serverProfilesList.add(serverToken);
        }
        int serverProfilesListSize = serverProfilesList.size();
        StringTokenizer cst = new StringTokenizer(clientProfiles, " ");
        ArrayList<String> clientProfilesList = new ArrayList<String>(cst.countTokens());
        while (cst.hasMoreTokens()) {
            String clientToken = cst.nextToken();
            clientProfilesList.add(clientToken);
        }
        int clientProfilesListSize = clientProfilesList.size();
        if (serverProfilesListSize < clientProfilesListSize || !serverProfilesList.containsAll(clientProfilesList)) {
            throw new IOException("The server supported profiles " + serverProfilesList + " do not " + "match the client required profiles " + clientProfilesList + ".");
        }
        return clientProfilesList;
    }

    static void throwExceptionOnError(HandshakeErrorMessage error) throws IOException, SecurityException {
        String detail = error.getDetail();
        if (detail.startsWith("java.lang.SecurityException") || detail.startsWith("java.security.") || detail.startsWith("javax.net.ssl.") || detail.startsWith("javax.security.")) {
            throw new SecurityException(detail);
        }
        throw new IOException(detail);
    }
}

