// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
package org.apache.myfaces.trinidad.component;

import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.context.ComponentContextManager;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.SuspendedContextChanges;

/**
 *
 * <h4>Events:</h4>
 * <table border="1" width="100%" cellpadding="3" summary="">
 * <tr bgcolor="#CCCCFF" class="TableHeadingColor">
 * <th align="left">Type</th>
 * <th align="left">Phases</th>
 * <th align="left">Description</th>
 * </tr>
 * <tr class="TableRowColor">
 * <td valign="top"><code>org.apache.myfaces.trinidad.event.AttributeChangeEvent</code></td>
 * <td valign="top" nowrap>Invoke<br>Application<br>Apply<br>Request<br>Values</td>
 * <td valign="top">Event delivered to describe an attribute change.  Attribute change events are not delivered for any programmatic change to a property.  They are only delivered when a renderer changes a property without the application's specific request.  An example of an attribute change event might include the width of a column that supported client-side resizing.</td>
 * </tr>
 * </table>
 */
public class UIXDocument extends UIXComponentBase
{
  static public final FacesBean.Type TYPE = new FacesBean.Type(
    UIXComponentBase.TYPE);

  static public final String COMPONENT_FAMILY =
    "org.apache.myfaces.trinidad.Document";
  static public final String COMPONENT_TYPE =
    "org.apache.myfaces.trinidad.Document";

  /**
   * Construct an instance of the UIXDocument.
   */
  public UIXDocument()
  {
    super("org.apache.myfaces.trinidad.Document");
  }
    @Override
  public boolean visitTree(
    VisitContext  visitContext,
    VisitCallback callback)
  {
    ComponentContextManager ctxMgr = RequestContext.getCurrentInstance()
      .getComponentContextManager();
    FacesContext facesContext = visitContext.getFacesContext();

    // Suspend any current component context during a visit tree for re-entrant
    // component tree processing
    SuspendedContextChanges suspendedChanges = ctxMgr.suspend(facesContext);

    try
    {
      return super.visitTree(visitContext, callback);
    }
    finally
    {
      ctxMgr.resume(facesContext, suspendedChanges);
    }
  }

  @Override
  public boolean invokeOnComponent(
    FacesContext    facesContext,
    String          clientId,
    ContextCallback callback
    ) throws FacesException
  {
    ComponentContextManager ctxMgr = RequestContext.getCurrentInstance()
      .getComponentContextManager();

    // Suspend any current component context during an invoke on component call for re-entrant
    // component tree processing
    SuspendedContextChanges suspendedChanges = ctxMgr.suspend(facesContext);

    try
    {
      return super.invokeOnComponent(facesContext, clientId, callback);
    }
    finally
    {
      ctxMgr.resume(facesContext, suspendedChanges);
    }
  }

  @Override
  public String getFamily()
  {
    return COMPONENT_FAMILY;
  }

  @Override
  protected FacesBean.Type getBeanType()
  {
    return TYPE;
  }

  /**
   * Construct an instance of the UIXDocument.
   */
  protected UIXDocument(
    String rendererType
    )
  {
    super(rendererType);
  }

  static
  {
    TYPE.lockAndRegister("org.apache.myfaces.trinidad.Document","org.apache.myfaces.trinidad.Document");
  }
}
