/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class ChildArrayList
extends ArrayList<UIComponent> {
    private final UIComponent _parent;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ChildArrayList.class);
    private static final long serialVersionUID = 1L;

    public ChildArrayList(UIComponent parent) {
        this._parent = parent;
    }

    @Override
    public void add(int index, UIComponent element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(_LOG.getMessage("INDEX_SIZE", new Object[]{index, this.size()}));
        }
        UIComponent oldParent = element.getParent();
        if (oldParent != null) {
            int adjustedIndex = ChildArrayList.__removeFromParent(element, index);
            if (oldParent == this._parent) {
                index = adjustedIndex;
            }
        }
        super.add(index, element);
        element.setParent(this._parent);
    }

    @Override
    public boolean add(UIComponent element) {
        this.add(this.size(), element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends UIComponent> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends UIComponent> collection) {
        boolean changed = false;
        for (UIComponent uIComponent : collection) {
            if (uIComponent == null) {
                throw new NullPointerException();
            }
            this.add(index++, uIComponent);
            changed = true;
        }
        return changed;
    }

    @Override
    public UIComponent remove(int index) {
        UIComponent child = (UIComponent)super.remove(index);
        child.setParent(null);
        return child;
    }

    @Override
    public boolean remove(Object element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (!(element instanceof UIComponent)) {
            return false;
        }
        if (super.remove(element)) {
            UIComponent child = (UIComponent)element;
            child.setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = false;
        for (Object element : collection) {
            if (!this.remove(element)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public UIComponent set(int index, UIComponent element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        UIComponent child = element;
        UIComponent previous = (UIComponent)this.get(index);
        previous.setParent(null);
        child.setParent(this._parent);
        super.set(index, element);
        return previous;
    }

    static int __removeFromParent(UIComponent component, int index) {
        Collection facets;
        UIComponent parent = component.getParent();
        assert (parent != null);
        if (parent.getChildCount() > 0) {
            List children = parent.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (children.get(i) != component) continue;
                children.remove(i);
                if (index > i) {
                    --index;
                }
                return index;
            }
        }
        if ((facets = parent.getFacets().values()).contains(component)) {
            facets.remove(component);
            return index;
        }
        assert (false);
        return index;
    }
}

